/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateFieldDialog;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateOperation;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;

public class EncapsulateController
implements Controller {
    public static final int REPLACE_CLASS_FLAG = 1;
    public static final int REPLACE_SUB_CLASSES_FLAG = 2;
    public static final int REPLACE_OTHER_CLASSES_FLAG = 4;

    public boolean update(IdeAction action, Context context) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, true);
            if (sourceClass != null) {
                if (!sourceClass.isAnnotation() && !sourceClass.isEnum()) {
                    canHandle = true;
                }
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass) && !sourceSourceClass.isAnnotation() && !sourceSourceClass.isEnum()) {
                        canHandle = true;
                    }
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Element element;
        SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, true);
        if (sourceClass == null && (element = context.getElement()) instanceof JavaSourceNode) {
            JavaSourceNode javaSourceNode = (JavaSourceNode)element;
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            SourceClass sourceSourceClass = Patch.getMainClass(javaManager.getSourceFile(javaSourceNode.getURL()));
            if (Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                sourceClass = sourceSourceClass;
            }
        }
        if (sourceClass != null) {
            SourceFieldVariable fieldContext = null;
            SourceMethod methodContext = null;
            ElementAt elementAt = ElementAt.findElementAt(context);
            if (elementAt != null) {
                int elementType = elementAt.getElementType();
                switch (elementType) {
                    case 4: {
                        JavaField javaField = (JavaField)elementAt.getJavaElement();
                        fieldContext = (SourceFieldVariable)javaField.getSourceElement();
                        break;
                    }
                    case 3: {
                        JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                        methodContext = (SourceMethod)javaMethod.getSourceElement();
                        break;
                    }
                }
            }
            ArrayList<EncapsulatedField> fields = new ArrayList<EncapsulatedField>();
            Collection declaredFields = sourceClass.getDeclaredFields();
            for (JavaField javaField : declaredFields) {
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                if (sourceFieldVariable == null || sourceFieldVariable.getName() == null) continue;
                SourceTypeReference sourceType = sourceFieldVariable.getSourceType();
                JavaType resolvedType = javaField.getResolvedType();
                if (resolvedType == null) continue;
                String fieldName = javaField.getName();
                JavaMethod getter = null;
                if ("boolean".equals(sourceType.getName()) && (getter = EncapsulateController.getGetter(sourceClass, "is", fieldName, resolvedType)) == null) {
                    getter = EncapsulateController.getGetter(sourceClass, "has", fieldName, resolvedType);
                }
                if (getter == null) {
                    getter = EncapsulateController.getGetter(sourceClass, "get", fieldName, resolvedType);
                }
                JavaMethod setter = EncapsulateController.getSetter(sourceClass, fieldName, resolvedType);
                EncapsulatedField encapsulatedField = new EncapsulatedField(sourceFieldVariable);
                if (sourceFieldVariable.equals(fieldContext)) {
                    encapsulatedField.setIncluded(true);
                }
                if (getter != null) {
                    encapsulatedField.setGetterMethod(getter);
                    if (getter.equals((Object)methodContext)) {
                        encapsulatedField.setIncluded(true);
                    }
                }
                if (setter != null) {
                    encapsulatedField.setSetterMethod(setter);
                    if (setter.equals((Object)methodContext)) {
                        encapsulatedField.setIncluded(true);
                    }
                }
                fields.add(encapsulatedField);
            }
            if (fields.isEmpty()) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(322));
            } else {
                EncapsulatedField[] encapsulatedFields = fields.toArray(new EncapsulatedField[fields.size()]);
                EncapsulateFieldDialog dialog = new EncapsulateFieldDialog(context, encapsulatedFields);
                if (dialog.runDialog()) {
                    EncapsulateOperation operation = new EncapsulateOperation(context, encapsulatedFields);
                    operation.setMethodAccessibility(dialog.getMethodAccessibility());
                    operation.setFieldAcceessibility(dialog.getFieldAccessibility());
                    operation.setReplaceType(dialog.getReplaceType());
                    operation.setAddTasks(dialog.isAddTasksChecked());
                    operation.doSearch();
                    if (dialog.hasPreview()) {
                        PreviewLogPage.showUsages(operation);
                    } else {
                        operation.doRefactoring();
                    }
                }
            }
        }
        return true;
    }

    private static JavaMethod getGetter(SourceClass sourceClass, String prefix, String fieldName, JavaType javaType) {
        JavaType returnType;
        JavaMethod getter = null;
        String baseName = EncapsulateController.getBaseName(fieldName);
        String suffix = Character.toUpperCase(baseName.charAt(0)) + baseName.substring(1);
        String methodName = prefix + suffix;
        JavaMethod javaMethod = sourceClass.getMethod(methodName, new JavaType[0]);
        if (javaMethod != null && javaType.equals((Object)(returnType = javaMethod.getReturnType()))) {
            getter = javaMethod;
        }
        return getter;
    }

    private static JavaMethod getSetter(SourceClass sourceClass, String fieldName, JavaType javaType) {
        String baseName = EncapsulateController.getBaseName(fieldName);
        String suffix = Character.toUpperCase(baseName.charAt(0)) + baseName.substring(1);
        String methodName = "set" + suffix;
        JavaMethod getter = sourceClass.getMethod(methodName, new JavaType[]{javaType});
        return getter;
    }

    private static String getBaseName(String fieldName) {
        String defaultFieldPrefix = RefManagerImpl.getDefaultFieldPrefix();
        if (fieldName.startsWith(defaultFieldPrefix)) {
            int beginIndex = defaultFieldPrefix.length();
            fieldName = fieldName.substring(beginIndex);
        }
        return fieldName;
    }
}

