/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.RadioKeyController;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.oprs.encapsulate.FieldsTableModel;

public class EncapsulateFieldDialog
extends BaseDialog
implements VetoableChangeListener {
    private static final String PREFERENCE_KEY = "ENCAP_DEFAULTS";
    protected static final int PREF_TASKS = 1;
    protected static final int PREF_PREVIEW = 2;
    private final EncapsulatedField[] _fields;
    private JTable _table;
    private JRadioButton _methodPublic;
    private JRadioButton _methodProtected;
    private JRadioButton _methodPrivate;
    private JRadioButton _fieldUnchanged;
    private JRadioButton _fieldProtected;
    private JRadioButton _fieldPrivate;
    private JRadioButton _replaceAll;
    private JRadioButton _replaceExceptClass;
    private JCheckBox _preview;
    private JCheckBox _addTasks;

    public EncapsulateFieldDialog(Context context, EncapsulatedField[] fields) {
        super(PREFERENCE_KEY, context);
        this._fields = fields;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(374);
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._table;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    public void setDlg(JEWTDialog dlg) {
        super.setDlg(dlg);
        dlg.addVetoableChangeListener((VetoableChangeListener)this);
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.isAddTasksChecked());
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dencapsulatefields_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = null;
            boolean isValid = true;
            if (!this.hasFieldSelected()) {
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    private boolean hasFieldSelected() {
        boolean hasFieldSelected = false;
        int i = 0;
        while (!hasFieldSelected && i < this._fields.length) {
            EncapsulatedField field = this._fields[i];
            if (field.isIncluded()) {
                hasFieldSelected = true;
            }
            ++i;
        }
        return hasFieldSelected;
    }

    protected void init() {
        JLabel fieldsLabel = new JLabel();
        FieldsTableModel fieldsTableModel = new FieldsTableModel(this);
        this._table = new NiceTable((TableModel)fieldsTableModel);
        ResourceUtils.resLabel((JLabel)fieldsLabel, (Component)this._table, (String)RefactoringArb.getString(338));
        TableColumnModel columnModel = this._table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setMaxWidth(25);
        this._table.setAutoResizeMode(0);
        this.setInitialSelection();
        this.updateOnChanges(this._table);
        JPanel methodBox = new JPanel();
        methodBox.setLayout(new BoxLayout(methodBox, 1));
        methodBox.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(373)));
        ButtonGroup buttonGroup = new ButtonGroup();
        this._methodPublic = EncapsulateFieldDialog.createRadioButton(methodBox, buttonGroup, "&Public");
        this._methodProtected = EncapsulateFieldDialog.createRadioButton(methodBox, buttonGroup, "P&rotected");
        EncapsulateFieldDialog.createRadioButton(methodBox, buttonGroup, "Pac&kage Private");
        this._methodPrivate = EncapsulateFieldDialog.createRadioButton(methodBox, buttonGroup, "Pr&ivate");
        RadioKeyController.attach((ButtonGroup)buttonGroup);
        this._methodPublic.setSelected(true);
        JPanel fieldBox = new JPanel();
        fieldBox.setLayout(new BoxLayout(fieldBox, 1));
        fieldBox.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(233)));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this._fieldUnchanged = EncapsulateFieldDialog.createRadioButton(fieldBox, buttonGroup2, RefactoringArb.getString(346));
        this._fieldProtected = EncapsulateFieldDialog.createRadioButton(fieldBox, buttonGroup2, "Pr&otected");
        EncapsulateFieldDialog.createRadioButton(fieldBox, buttonGroup2, "Pa&ckage Private");
        this._fieldPrivate = EncapsulateFieldDialog.createRadioButton(fieldBox, buttonGroup2, "Priva&te");
        RadioKeyController.attach((ButtonGroup)buttonGroup2);
        this._fieldPrivate.setSelected(true);
        JPanel replaceBox = new JPanel();
        replaceBox.setLayout(new BoxLayout(replaceBox, 1));
        replaceBox.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(348)));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this._replaceAll = EncapsulateFieldDialog.createRadioButton(replaceBox, buttonGroup3, RefactoringArb.getString(297));
        EncapsulateFieldDialog.createRadioButton(replaceBox, buttonGroup3, RefactoringArb.getString(213));
        this._replaceExceptClass = EncapsulateFieldDialog.createRadioButton(replaceBox, buttonGroup3, RefactoringArb.getString(263));
        RadioKeyController.attach((ButtonGroup)buttonGroup3);
        this._replaceAll.setSelected(true);
        this._addTasks = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._addTasks, (String)RefactoringArb.getString(80));
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(41));
        JLabel message = new JLabel();
        message.setPreferredSize(fieldsLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)fieldsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)new JScrollPane(this._table), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)methodBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)fieldBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)replaceBox, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._addTasks, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        CopyableInteger settings = this.getSettings();
        this._addTasks.setSelected(settings.isBitSet(1));
        this._preview.setSelected(settings.isBitSet(2));
    }

    private void setInitialSelection() {
        if (this._fields.length > 0) {
            int bestSel = 0;
            int i = 0;
            while (i < this._fields.length) {
                EncapsulatedField field = this._fields[i];
                if (field.isIncluded()) {
                    bestSel = i;
                    break;
                }
                ++i;
            }
            this._table.changeSelection(bestSel, 0, false, false);
        }
    }

    private static JRadioButton createRadioButton(JPanel box, ButtonGroup buttonGroup, String label) {
        JRadioButton radioButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)radioButton, (String)label);
        buttonGroup.add(radioButton);
        box.add(radioButton);
        return radioButton;
    }

    EncapsulatedField[] getFields() {
        return this._fields;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
            TableCellEditor cellEditor = this._table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int i = 0;
            while (i < this._fields.length) {
                String newSetterName;
                String newGetterName;
                EncapsulatedField field = this._fields[i];
                if (field.isNeedsNewGetter() && !NamingUtil.isJavaIdentifier((String)(newGetterName = field.getNewGetterName()))) {
                    this._table.changeSelection(i, 2, false, false);
                    String message = MessageFormat.format(RefactoringArb.getString(253), newGetterName);
                    JOptionPane.showMessageDialog(this, message);
                    throw new PropertyVetoException("", evt);
                }
                if (field.isNeedsNewSetter() && !NamingUtil.isJavaIdentifier((String)(newSetterName = field.getNewSetterName()))) {
                    this._table.changeSelection(i, 3, false, false);
                    String message = MessageFormat.format(RefactoringArb.getString(253), newSetterName);
                    JOptionPane.showMessageDialog(this, message);
                    throw new PropertyVetoException("", evt);
                }
                ++i;
            }
        }
    }

    public int getMethodAccessibility() {
        return this._methodPublic.isSelected() ? 1 : (this._methodProtected.isSelected() ? 4 : (this._methodPrivate.isSelected() ? 2 : 0));
    }

    public int getFieldAccessibility() {
        return this._fieldUnchanged.isSelected() ? 1 : (this._fieldProtected.isSelected() ? 4 : (this._fieldPrivate.isSelected() ? 2 : 0));
    }

    public int getReplaceType() {
        if (this._replaceAll.isSelected()) {
            return 7;
        }
        if (this._replaceExceptClass.isSelected()) {
            return 6;
        }
        return 4;
    }

    public boolean isAddTasksChecked() {
        return this._addTasks.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

