/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;
import oracle.jdevimpl.refactoring.util.JavaLexerUtil;
import oracle.jdevimpl.refactoring.util.Visitor;

class EncapsulateOperation
implements UsageSource {
    private Context _context;
    private EncapsulatedField[] _encapsulatedFields;
    private int _methodAccessibility;
    private int _fieldAccessibility;
    private SourceClass _sourceClass;
    private int _replaceType;
    private boolean _addTasksChecked;
    private UsageModel _usageModel;
    private static final int USAGE_TYPE_LHS = 0;
    private static final int USAGE_TYPE_RHS = 1;
    private static final int USAGE_TYPE_FIELD_ACCESS_TYPE = 2;

    public EncapsulateOperation(Context context, EncapsulatedField[] encapsulatedFields) {
        this._context = context;
        this._encapsulatedFields = encapsulatedFields;
        SourceFieldVariable firstVariable = this._encapsulatedFields[0].getSourceFieldVariable();
        this._sourceClass = firstVariable.getEnclosingClass();
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doSearch() {
        this._usageModel = new UsageModel();
        URL url = this._sourceClass.getURL();
        Project definingProject = Util.getDefiningProject(this._context, url);
        this.searchFieldModifiers(definingProject);
        HashSet searchedURLs = new HashSet();
        HashSet dependentProjects = Util.getDependentProjects(this._context.getWorkspace(), this._context.getProject());
        for (Project project : dependentProjects) {
            this.searchAccesses(definingProject, project, searchedURLs);
        }
        return !this._usageModel.getUsageEntries().isEmpty();
    }

    public boolean doRefactoring() {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean ret = false;
        try {
            ArrayList usageEntries = this._usageModel.getUsageEntries();
            int i = 0;
            while (i < usageEntries.size()) {
                UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
                if (usageEntry.isIncluded()) {
                    Object userObject = usageEntry.getUserObject();
                    int usageType = usageEntry.getUsageType();
                    switch (usageType) {
                        case 0: 
                        case 1: {
                            FieldAccess fieldAccess = (FieldAccess)userObject;
                            SourceExpression sourceExpression = fieldAccess.getSourceExpression();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceExpression);
                            this.apply(fieldAccess);
                            break;
                        }
                        case 2: {
                            EncapsulatedField encapsulatedField = (EncapsulatedField)userObject;
                            SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFieldVariable);
                            sourceFieldVariable.removeModifiers(7);
                            sourceFieldVariable.addModifiers(this._fieldAccessibility);
                        }
                    }
                }
                ++i;
            }
            this.addMethods(refactoringCommandSupport);
            Context context = this.getContext();
            String shortTitle = this.getShortTitle();
            ret = refactoringCommandSupport.commit(context, shortTitle);
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    public Context getContext() {
        return this._context;
    }

    public String getLongTitle() {
        return RefactoringArb.getString(374);
    }

    public String getShortTitle() {
        return this.getLongTitle();
    }

    public UsageModel getUsageModel() {
        return this._usageModel;
    }

    private void searchAccesses(Project definingProject, Project project, HashSet searchedUrls) {
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<SourceFieldVariable> members = new ArrayList<SourceFieldVariable>();
        int i = 0;
        while (i < this._encapsulatedFields.length) {
            EncapsulatedField encapsulatedField = this._encapsulatedFields[i];
            if (encapsulatedField.isIncluded()) {
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                members.add(sourceFieldVariable);
                String fieldName = sourceFieldVariable.getName();
                fieldNames.add(fieldName);
            }
            ++i;
        }
        JavaMember[] javaMembers = members.toArray(new JavaMember[members.size()]);
        URL classUrl = this._sourceClass.getURL();
        if (project.equals((Object)definingProject) && !searchedUrls.contains(classUrl)) {
            this.getFieldAccesses(project, fieldNames, this._sourceClass.getOwningSourceFile(), this._usageModel);
            searchedUrls.add(classUrl);
        }
        if (this._addTasksChecked || BitField.isSet((int)this._replaceType, (int)4) || BitField.isSet((int)this._replaceType, (int)2)) {
            FindMemberUsages findMemberUsages = new FindMemberUsages(javaMembers);
            URL[] memberUsages = findMemberUsages.findMemberUsages(project);
            int j = 0;
            while (j < memberUsages.length) {
                URL url = memberUsages[j];
                if (!searchedUrls.contains(url)) {
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(url);
                    this.getFieldAccesses(project, fieldNames, sourceFile, this._usageModel);
                    searchedUrls.add(url);
                }
                ++j;
            }
        }
    }

    private void getFieldAccesses(Project project, HashSet fieldNames, SourceFile sourceFile, UsageModel usageModel) {
        1 visitor = new 1(this, project, usageModel, fieldNames);
        ((Visitor)visitor).visit((SourceElement)sourceFile);
    }

    private static boolean isAccessible(int accessibilityFlag, SourceClass invokedClass, SourceClass invokingClass) {
        boolean ret = true;
        switch (accessibilityFlag) {
            case 1: {
                break;
            }
            case 4: {
                if (invokedClass.isAssignableFrom((JavaType)invokingClass)) break;
                ret = false;
                break;
            }
            case 2: {
                if (Patch.contains((SourceElement)invokedClass, (SourceElement)invokingClass)) break;
                ret = false;
                break;
            }
            default: {
                if (invokedClass.getPackageName().equals(invokingClass.getPackageName())) break;
                ret = false;
                break;
            }
        }
        return ret;
    }

    private void apply(FieldAccess fieldAccess) {
        SourceExpression methodCallLhs;
        SourceExpression sourceExpression = fieldAccess.getSourceExpression();
        EncapsulatedField encapsulatedField = fieldAccess.getEncapsulatedField();
        SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
        SourceFactory factory = owningSourceFile.getFactory();
        if (sourceExpression.getSymbolKind() == 49) {
            SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceExpression;
            methodCallLhs = sourceDotExpression.getLhsOperand();
            methodCallLhs.removeSelf();
        } else {
            methodCallLhs = null;
        }
        switch (fieldAccess.getType()) {
            case 2: {
                String setterName = encapsulatedField.getNewSetterName();
                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression.getParent();
                SourceExpression rhs = sourceAssignmentExpression.getSecondOperand();
                rhs.removeSelf();
                SourceExpression[] argument = new SourceExpression[]{rhs};
                SourceListExpression argList = factory.createArgumentList(argument);
                SourceMethodCallExpression methodCall = factory.createMethodCall(methodCallLhs, setterName, argList);
                sourceAssignmentExpression.replaceSelf((SourceElement)methodCall);
                break;
            }
            case 1: {
                SourceMethodCallExpression methodCall = factory.createMethodCall(methodCallLhs, encapsulatedField.getNewGetterName(), null);
                sourceExpression.replaceSelf((SourceElement)methodCall);
                break;
            }
        }
        if (this._addTasksChecked) {
            switch (fieldAccess.getType()) {
                case 1: 
                case 2: {
                    SourceClass enclosingClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression);
                    if (EncapsulateOperation.isAccessible(this._methodAccessibility, this._sourceClass, enclosingClass)) break;
                    this.createTodoItem(sourceExpression);
                    break;
                }
                case 4: {
                    this.createTodoItem(sourceExpression);
                    break;
                }
            }
        }
    }

    private void createTodoItem(SourceExpression sourceExpression) {
    }

    private void searchFieldModifiers(Project project) {
        if (this._fieldAccessibility != 1) {
            int i = 0;
            while (i < this._encapsulatedFields.length) {
                SourceVariableDeclaration owningDeclaration;
                LexerToken keywordPosition;
                SourceFieldVariable sourceFieldVariable;
                int modifiers;
                EncapsulatedField encapsulatedField = this._encapsulatedFields[i];
                if (encapsulatedField.isIncluded() && (modifiers = (sourceFieldVariable = encapsulatedField.getSourceFieldVariable()).getModifiers() & 7) != this._fieldAccessibility && modifiers != 0 && (keywordPosition = JavaLexerUtil.findKeywordPosition((SourceElement)(owningDeclaration = sourceFieldVariable.getOwningDeclaration()), new short[]{128, 127, 126})) != null) {
                    SourceFile owningSourceFile = owningDeclaration.getOwningSourceFile();
                    URL url = owningSourceFile.getURL();
                    int from = keywordPosition.getStartOffset();
                    int to = keywordPosition.getEndOffset();
                    UsageEntry usageEntry = new UsageEntry(project, url, from, to - from, 2, 2);
                    usageEntry.setUserObject(encapsulatedField);
                    this._usageModel.addUsageEntry(usageEntry);
                }
                ++i;
            }
        }
    }

    private void addMethods(RefactoringCommandSupport refactoringCommandSupport) {
        SourceFile owningSourceFile = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
        SourceFactory factory = owningSourceFile.getFactory();
        SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
        int i = 0;
        while (i < this._encapsulatedFields.length) {
            EncapsulatedField encapsulatedField = this._encapsulatedFields[i];
            String baseFieldName = encapsulatedField.getBaseFieldName();
            if (encapsulatedField.isIncluded()) {
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                String fieldName = sourceFieldVariable.getName();
                SourceTypeReference fieldSourceType = sourceFieldVariable.getSourceType();
                if (encapsulatedField.isNeedsNewGetter()) {
                    SourceSimpleNameExpression sourceExpression = factory.createSimpleNameExpression(fieldName);
                    SourceReturnStatement returnStatement = factory.createReturnStatement((SourceExpression)sourceExpression);
                    SourceBlock block = factory.createBlock(new SourceElement[]{returnStatement});
                    SourceTypeReference returnType = (SourceTypeReference)fieldSourceType.cloneSelf(owningSourceFile);
                    SourceMethod getter = factory.createMethod(returnType, encapsulatedField.getNewGetterName(), factory.createFormalParameterList(), null, block);
                    getter.addModifiers(this._methodAccessibility);
                    if (sourceFieldVariable.isStatic()) {
                        getter.addModifiers(8);
                    }
                    getter.addSelf((SourceElement)sourceClassBody);
                }
                if (encapsulatedField.isNeedsNewSetter()) {
                    String parameterName = baseFieldName;
                    if (NamingUtil.isJavaKeyword((String)baseFieldName)) {
                        parameterName = parameterName.substring(0, 1);
                    }
                    String fieldExpression = fieldName.equals(baseFieldName) ? (sourceFieldVariable.isStatic() ? this._sourceClass.getName() + "." + fieldName : "this." + fieldName) : fieldName;
                    SourceTypeReference returnType = factory.createType((byte)9);
                    SourceExpression lhs = factory.createExpression(fieldExpression);
                    SourceSimpleNameExpression rhs = factory.createSimpleNameExpression(parameterName);
                    SourceAssignmentExpression assignment = factory.createAssignment(6, lhs, (SourceExpression)rhs);
                    SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)assignment);
                    SourceBlock block = factory.createBlock(new SourceElement[]{expressionStatement});
                    SourceFormalParameterList formalParameterList = factory.createFormalParameterList();
                    SourceTypeReference paramType = (SourceTypeReference)fieldSourceType.cloneSelf(owningSourceFile);
                    SourceLocalVariable param = factory.createLocalVariable(paramType, parameterName);
                    param.addSelf((SourceElement)formalParameterList);
                    SourceMethod setter = factory.createMethod(returnType, encapsulatedField.getNewSetterName(), formalParameterList, null, block);
                    setter.setModifiers(this._methodAccessibility);
                    if (sourceFieldVariable.isStatic()) {
                        setter.addModifiers(8);
                    }
                    setter.addSelf((SourceElement)sourceClassBody);
                }
            }
            ++i;
        }
    }

    public void setMethodAccessibility(int methodAccessibility) {
        this._methodAccessibility = methodAccessibility;
    }

    public void setFieldAcceessibility(int fieldAccessibility) {
        this._fieldAccessibility = fieldAccessibility;
    }

    public void setReplaceType(int replaceType) {
        this._replaceType = replaceType;
    }

    public void setAddTasks(boolean addTasksChecked) {
        this._addTasksChecked = addTasksChecked;
    }

    static EncapsulatedField[] ra$_encapsulatedFields(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._encapsulatedFields;
    }

    static boolean ra$_addTasksChecked(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._addTasksChecked;
    }

    static int ra$_fieldAccessibility(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._fieldAccessibility;
    }

    static SourceClass ra$_sourceClass(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._sourceClass;
    }

    static boolean maS$isAccessible(int n, SourceClass sourceClass, SourceClass sourceClass2) {
        return EncapsulateOperation.isAccessible(n, sourceClass, sourceClass2);
    }

    static int ra$_replaceType(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._replaceType;
    }

    final class 1
    extends Visitor {
        private boolean _replaceUsages;
        private SourceClass _currentClass;
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ UsageModel v$usageModel;
        private final /* synthetic */ HashSet v$fieldNames;
        final /* synthetic */ EncapsulateOperation this$0;

        public void visit(SourceElement sourceElement) {
            int nodeID = sourceElement.getSymbolKind();
            switch (nodeID) {
                case 3: {
                    SourceClass sourceClass = (SourceClass)sourceElement;
                    boolean replaceUsages = BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)4);
                    if (replaceUsages && !BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)1) && EncapsulateOperation.ra$_sourceClass(this.this$0).equals((Object)sourceElement)) {
                        replaceUsages = false;
                    }
                    if (replaceUsages && !BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)2) && EncapsulateOperation.ra$_sourceClass(this.this$0).isAssignableFrom((JavaType)sourceClass)) {
                        replaceUsages = false;
                    }
                    if (!replaceUsages && !EncapsulateOperation.ra$_addTasksChecked(this.this$0)) break;
                    boolean oldReplaceUsages = this._replaceUsages;
                    this._replaceUsages = replaceUsages;
                    SourceClass oldCurrentClass = this._currentClass;
                    this._currentClass = sourceClass;
                    this.visitChildren(sourceElement);
                    this._replaceUsages = oldReplaceUsages;
                    this._currentClass = oldCurrentClass;
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    boolean visitMethod = true;
                    int i = 0;
                    while (visitMethod && i < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                        EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[i];
                        if (this.isSameMethod(encapsulatedField.getGetterMethod(), sourceMethod)) {
                            visitMethod = false;
                        } else if (this.isSameMethod(encapsulatedField.getSetterMethod(), sourceMethod)) {
                            visitMethod = false;
                        }
                        ++i;
                    }
                    if (!visitMethod) break;
                    this.visitChildren((SourceElement)sourceMethod);
                    break;
                }
                case 48: {
                    String text;
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement;
                    Object lhsIsField = null;
                    SourceExpression assignmentLhs = sourceAssignmentExpression.getFirstOperand();
                    if (assignmentLhs != null && (text = assignmentLhs.getText()) != null) {
                        int i = 0;
                        while (lhsIsField == null && i < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                            JavaHasType resolvedObject;
                            SourceFieldVariable sourceFieldVariable;
                            String variableName;
                            EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[i];
                            if (encapsulatedField.isIncluded() && text.endsWith(variableName = (sourceFieldVariable = encapsulatedField.getSourceFieldVariable()).getName()) && sourceFieldVariable.equals(resolvedObject = assignmentLhs.getResolvedObject())) {
                                UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)assignmentLhs, 0, 2);
                                int type = -1;
                                if (this._replaceUsages) {
                                    type = 2;
                                } else if (EncapsulateOperation.ra$_addTasksChecked(this.this$0) && !EncapsulateOperation.maS$isAccessible(EncapsulateOperation.ra$_fieldAccessibility(this.this$0), EncapsulateOperation.ra$_sourceClass(this.this$0), this._currentClass)) {
                                    type = 4;
                                }
                                if (type != -1) {
                                    FieldAccess fieldAccess = new FieldAccess(encapsulatedField, assignmentLhs, type);
                                    usageEntry.setUserObject(fieldAccess);
                                    this.v$usageModel.addUsageEntry(usageEntry);
                                }
                            }
                            ++i;
                        }
                    }
                    this.visit((SourceElement)sourceAssignmentExpression.getSecondOperand());
                    break;
                }
                default: {
                    super.visit(sourceElement);
                    break;
                }
            }
        }

        private boolean isSameMethod(JavaMethod thisJavaMethod, SourceMethod thatMethod) {
            SourceElement sourceMethod;
            String javaMethodName;
            return thisJavaMethod != null && (javaMethodName = thisJavaMethod.getName()).equals(thatMethod.getName()) && thisJavaMethod.equals((Object)(sourceMethod = thisJavaMethod.getSourceElement()));
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            this.checkFieldRead((SourceExpression)sourceSimpleNameExpression);
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            this.checkFieldRead((SourceExpression)sourceDotExpression);
        }

        private void checkFieldRead(SourceExpression sourceExpression) {
            JavaHasType resolvedObject;
            String name = ((SourceHasName)sourceExpression).getName();
            if (this.v$fieldNames.contains(name) && (resolvedObject = sourceExpression.getResolvedObject()) != null) {
                int i = 0;
                while (i < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                    EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[i];
                    if (encapsulatedField.isIncluded() && encapsulatedField.getSourceFieldVariable().equals(resolvedObject)) {
                        int type = -1;
                        if (this._replaceUsages) {
                            type = 1;
                        } else if (EncapsulateOperation.ra$_addTasksChecked(this.this$0) && !EncapsulateOperation.maS$isAccessible(EncapsulateOperation.ra$_fieldAccessibility(this.this$0), EncapsulateOperation.ra$_sourceClass(this.this$0), this._currentClass)) {
                            type = 4;
                        }
                        if (type != -1) {
                            FieldAccess fieldAccess = new FieldAccess(encapsulatedField, sourceExpression, type);
                            UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)sourceExpression, 1, 2);
                            usageEntry.setUserObject(fieldAccess);
                            this.v$usageModel.addUsageEntry(usageEntry);
                        }
                    }
                    ++i;
                }
            }
        }

        public 1(EncapsulateOperation encapsulateOperation, Project project, UsageModel usageModel, HashSet hashSet) {
            this.v$fieldNames = hashSet;
            this.v$usageModel = usageModel;
            this.v$project = project;
            this.this$0 = encapsulateOperation;
        }
    }

    private static class FieldAccess {
        public static final int TYPE_GETTER = 1;
        public static final int TYPE_SETTER = 2;
        public static final int TYPE_ILL_ACCESS = 4;
        private EncapsulatedField _encapsulatedField;
        private SourceExpression _sourceExpression;
        private int _type;

        public FieldAccess(EncapsulatedField encapsulatedField, SourceExpression sourceExpression, int type) {
            this._encapsulatedField = encapsulatedField;
            this._type = type;
            this._sourceExpression = sourceExpression;
        }

        public EncapsulatedField getEncapsulatedField() {
            return this._encapsulatedField;
        }

        public int getType() {
            return this._type;
        }

        public SourceExpression getSourceExpression() {
            return this._sourceExpression;
        }
    }
}

