/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.refactoring.RefManagerImpl;

public class EncapsulatedField {
    private SourceFieldVariable _sourceFieldVariable;
    private boolean _included;
    private String _newGetterName;
    private boolean _encapsulateClassGetters;
    private JavaMethod _getterMethod;
    private String _newSetterName;
    private boolean _encapsulateClassSetters;
    private JavaMethod _setterMethod;

    private void $init$() {
        this._encapsulateClassGetters = true;
        this._encapsulateClassSetters = true;
    }

    public EncapsulatedField(SourceFieldVariable sourceFieldVariable) {
        this.$init$();
        this._sourceFieldVariable = sourceFieldVariable;
    }

    public boolean isIncluded() {
        return this._included;
    }

    public void setIncluded(boolean included) {
        this._included = included;
    }

    public boolean isEncapsulateClassGetters() {
        return this._encapsulateClassGetters;
    }

    public void setEncapsulateClassGetters(boolean encapsulateClassGetters) {
        this._encapsulateClassGetters = encapsulateClassGetters;
    }

    public boolean isEncapsulateClassSetters() {
        return this._encapsulateClassSetters;
    }

    public void setEncapsulateClassSetters(boolean encapsulateClassSetters) {
        this._encapsulateClassSetters = encapsulateClassSetters;
    }

    public JavaMethod getGetterMethod() {
        return this._getterMethod;
    }

    public void setGetterMethod(JavaMethod getterMethod) {
        this._getterMethod = getterMethod;
    }

    public boolean isNeedsNewGetter() {
        boolean ret = false;
        if (this.isIncluded()) {
            JavaMethod getterMethod = this.getGetterMethod();
            if (getterMethod == null) {
                ret = true;
            } else {
                String getterMethodName;
                String newGetterName = this.getNewGetterName();
                if (ModelUtil.hasLength((String)newGetterName) && !(getterMethodName = getterMethod.getName()).equals(newGetterName)) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public String getNewGetterName() {
        if (this._newGetterName == null) {
            this._newGetterName = this.getDefaultGetterName();
        }
        return this._newGetterName;
    }

    public void setNewGetterName(String newGetterName) {
        this._newGetterName = newGetterName;
    }

    public boolean isNeedsNewSetter() {
        boolean ret = false;
        if (this.isIncluded()) {
            JavaMethod setterMethod = this.getSetterMethod();
            if (setterMethod == null) {
                if (!this._sourceFieldVariable.isFinal()) {
                    ret = true;
                }
            } else {
                String setterMethodName;
                String newSetterName = this.getNewSetterName();
                if (ModelUtil.hasLength((String)newSetterName) && !(setterMethodName = setterMethod.getName()).equals(newSetterName)) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public String getNewSetterName() {
        if (this._newSetterName == null) {
            this._newSetterName = this.getDefaultSetterName();
        }
        return this._newSetterName;
    }

    public void setNewSetterName(String newSetterName) {
        this._newSetterName = newSetterName;
    }

    public JavaMethod getSetterMethod() {
        return this._setterMethod;
    }

    public void setSetterMethod(JavaMethod setterMethod) {
        this._setterMethod = setterMethod;
    }

    public SourceFieldVariable getSourceFieldVariable() {
        return this._sourceFieldVariable;
    }

    public void setSourceFieldVariable(SourceFieldVariable sourceFieldVariable) {
        this._sourceFieldVariable = sourceFieldVariable;
    }

    private String getDefaultGetterName() {
        String baseFieldName = this.getBaseFieldName();
        String typeName = this._sourceFieldVariable.getSourceType().getName();
        String prefix = "boolean".equals(typeName) ? (EncapsulatedField.isPrefixed(baseFieldName, "has") ? "" : "is") : "get";
        return prefix + EncapsulatedField.upperifyFirstLetter(baseFieldName);
    }

    private String getDefaultSetterName() {
        String baseFieldName = this.getBaseFieldName();
        return "set" + EncapsulatedField.upperifyFirstLetter(baseFieldName);
    }

    private static String upperifyFirstLetter(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    String getBaseFieldName() {
        SourceTypeReference sourceType;
        String sourceTypeName;
        String defaultFieldPrefix;
        String fieldName = this._sourceFieldVariable.getName();
        if (fieldName.startsWith(defaultFieldPrefix = RefManagerImpl.getDefaultFieldPrefix())) {
            fieldName = fieldName.substring(defaultFieldPrefix.length());
        }
        if ((sourceTypeName = (sourceType = this._sourceFieldVariable.getSourceType()).getName()) != null && "boolean".equals(sourceTypeName) && EncapsulatedField.isPrefixed(fieldName, "is")) {
            fieldName = Character.toLowerCase(fieldName.charAt(2)) + fieldName.substring(3);
        }
        return fieldName;
    }

    private static boolean isPrefixed(String fieldName, String prefix) {
        char nextChar;
        boolean isSuffixed = false;
        if (fieldName.startsWith(prefix) && fieldName.length() > prefix.length() && Character.isUpperCase(nextChar = fieldName.charAt(prefix.length())) && Character.isJavaIdentifierPart(nextChar)) {
            isSuffixed = true;
        }
        return isSuffixed;
    }
}

