/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import javax.swing.table.AbstractTableModel;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateFieldDialog;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;

class FieldsTableModel
extends AbstractTableModel {
    public static final int COL_INCLUDE = 0;
    public static final int COL_FIELD = 1;
    public static final int COL_GETTER = 2;
    public static final int COL_SETTER = 3;
    private EncapsulateFieldDialog _encapsulateFieldDialog;

    public FieldsTableModel(EncapsulateFieldDialog encapsulateFieldDialog) {
        this._encapsulateFieldDialog = encapsulateFieldDialog;
    }

    public int getRowCount() {
        return this._encapsulateFieldDialog.getFields().length;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return RefactoringArb.getString(57);
            }
            case 2: {
                return RefactoringArb.getString(118);
            }
            case 3: {
                return RefactoringArb.getString(365);
            }
        }
        return null;
    }

    public Object getValueAt(int row, int column) {
        EncapsulatedField field = this._encapsulateFieldDialog.getFields()[row];
        switch (column) {
            case 0: {
                return field.isIncluded();
            }
            case 1: {
                return field.getSourceFieldVariable().getName();
            }
            case 2: {
                return field.getNewGetterName();
            }
            case 3: {
                SourceFieldVariable sourceFieldVariable = field.getSourceFieldVariable();
                if (sourceFieldVariable.isFinal()) {
                    return "";
                }
                return field.getNewSetterName();
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int row, int column) {
        EncapsulatedField field = this._encapsulateFieldDialog.getFields()[row];
        switch (column) {
            case 0: {
                field.setIncluded(Boolean.TRUE.equals(aValue));
                this.fireTableCellUpdated(row, 0);
                break;
            }
            case 2: {
                field.setNewGetterName(aValue.toString());
                field.setIncluded(true);
                this.fireTableCellUpdated(row, 2);
                break;
            }
            case 3: {
                field.setNewSetterName(aValue.toString());
                field.setIncluded(true);
                this.fireTableCellUpdated(row, 3);
                break;
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                EncapsulatedField[] fields = this._encapsulateFieldDialog.getFields();
                EncapsulatedField field = fields[row];
                SourceFieldVariable sourceFieldVariable = field.getSourceFieldVariable();
                if (sourceFieldVariable.isFinal()) break;
                return true;
            }
        }
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }
}

