/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractMethod;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.extractMethod.ExtractMethodDialog;
import oracle.jdevimpl.refactoring.oprs.extractMethod.ParameterEntry;
import oracle.jdevimpl.refactoring.oprs.extractMethod.ParametersModel;
import oracle.jdevimpl.refactoring.oprs.extractMethod.Var;
import oracle.jdevimpl.refactoring.util.RichBuffer;
import oracle.jdevimpl.refactoring.util.SourceFormatUtilities;
import oracle.jdevimpl.refactoring.util.Visitor;

public class ExtractMethodController
implements Controller {
    private static final int RES_OK = 0;
    private static final int RES_BAD_SELECTION = 1;
    private static final int RES_TOO_MUCH_EXITS = 2;
    private static final int RES_TOO_MUCH_VARS = 3;
    private static final int RES_ERR_RESOLVE = 4;
    private static final int RES_ABORT = 5;
    private static final int ETYPE_NOK = 0;
    private static final int ETYPE_BLOCK = 1;
    private static final int ETYPE_EXPR = 2;
    private static final int TARG_SUCC = 10;
    private static final int TARG_PRED = 11;
    private static final int TARG_EXITS = 12;
    private static final int TARG_DEFAULT_PRESENT = 13;
    private static final int VARIABLE_STATES = 14;
    private static final int STATE_UNUSED = 0;
    private static final int STATE_DECLARED = 1;
    private static final int STATE_READ = 2;
    private static final int STATE_WRITE = 3;
    private static final int STATE_READ_WRITE = 4;
    private static final int STATE_WRITE_READ = 5;
    private int _result;
    private int _ostart;
    private int _oend;
    private CodeEditor _codeEditor;
    private ArrayList _vars;
    private boolean _useInstanceObject;
    private SourceElement _outerMethod;
    private boolean _isMethodStatic;
    private boolean _isNewMethodStatic;
    private HashSet _thrownExceptions;
    private HashSet _innerExits;
    private HashSet _usedFieldIdentifiers;
    private JavaType _returnType;
    private boolean _isExpression;
    private boolean _isExpressionUsed;
    private String _newMethodName;

    private void $init$() {
        this._useInstanceObject = false;
        this._thrownExceptions = new HashSet();
        this._innerExits = new HashSet();
        this._usedFieldIdentifiers = new HashSet();
    }

    boolean isInBlock(SourceElement el) {
        return this.isInBlock(el.getStartOffset());
    }

    boolean isInBlock(int off) {
        return off >= this._ostart && off <= this._oend;
    }

    static VarStates getVarStates(SourceElement pos) {
        return (VarStates)pos.getBinding(14);
    }

    static int getVarState(Var var, SourceElement pos) {
        VarStates states = ExtractMethodController.getVarStates(pos);
        if (states == null) {
            return 0;
        }
        return states.getVarState(var);
    }

    static void setVarState(Var var, SourceElement pos, int state) {
        VarStates states = ExtractMethodController.getVarStates(pos);
        if (states == null) {
            states = new VarStates();
            pos.setBinding((NodeBinding)states);
        }
        states.setVarState(var, state);
    }

    static void setInside(SourceElement pos) {
        VarStates states = ExtractMethodController.getVarStates(pos);
        if (states == null) {
            states = new VarStates();
            pos.setBinding((NodeBinding)states);
        }
        states.isInside = true;
    }

    static void printVarState(SourceElement pos) {
        VarStates states = (VarStates)pos.getBinding(14);
        if (states != null) {
            System.out.print(states);
        }
    }

    static void saveDeclared(Var v, SourceElement pos) {
        ExtractMethodController.setVarState(v, pos, 1);
    }

    static void saveReadFrom(Var v, SourceElement pos) {
        int curState = ExtractMethodController.getVarState(v, pos);
        int newState = 0;
        if (curState == 0) {
            newState = 2;
        } else if (curState == 3) {
            newState = 5;
        }
        if (newState != 0) {
            ExtractMethodController.setVarState(v, pos, newState);
        }
    }

    static void saveWriteTo(Var v, SourceElement pos) {
        int curState = ExtractMethodController.getVarState(v, pos);
        int newState = 0;
        if (curState == 0) {
            newState = 3;
        } else if (curState == 2) {
            newState = 4;
        }
        if (newState != 0) {
            ExtractMethodController.setVarState(v, pos, newState);
        }
    }

    private static Targets getGroup(int type, SourceElement el) {
        Targets t = (Targets)el.getBinding(type);
        if (t == null) {
            t = new Targets(type);
            el.setBinding((NodeBinding)t);
        }
        return t;
    }

    private static Iterator getElementGroup(int type, SourceElement el) {
        Targets t = ExtractMethodController.getGroup(type, el);
        return t.getTargets();
    }

    private static SourceElement getUniqueElement(int type, SourceElement el) {
        Targets t = ExtractMethodController.getGroup(type, el);
        return t.getUniqueElement();
    }

    private static void addElementToGroup(int type, SourceElement el, Object o) {
        Targets t = ExtractMethodController.getGroup(type, el);
        t.addTarget(o);
    }

    private static Iterator getElementPredecessor(SourceElement el) {
        return ExtractMethodController.getElementGroup(11, el);
    }

    private static SourceElement getUniquePredecessor(SourceElement el) {
        return ExtractMethodController.getUniqueElement(11, el);
    }

    private static Iterator getElementExits(SourceElement el) {
        return ExtractMethodController.getElementGroup(12, el);
    }

    private static void addExit(SourceElement el, Object o) {
        ExtractMethodController.addElementToGroup(12, el, o);
    }

    private static void addExits(SourceElement el, Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            ExtractMethodController.addElementToGroup(12, el, it.next());
        }
    }

    private static void addPredecessor(SourceElement el, Object o) {
        ExtractMethodController.addElementToGroup(11, el, o);
    }

    private static void addPredecessors(SourceElement el, Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            ExtractMethodController.addPredecessor(el, it.next());
        }
    }

    private ArrayList addNaturalOrderCollection(SourceElement first, Collection col) {
        ArrayList al = new ArrayList(2);
        al.add(first);
        if (col != null) {
            for (SourceElement child : col) {
                ExtractMethodController.addPredecessors(child, al);
                al = this.parseElementSuccessors(child);
            }
        }
        return al;
    }

    private ArrayList addNaturalOrderCollection(ArrayList al, Collection col) {
        if (col != null) {
            for (SourceElement child : col) {
                ExtractMethodController.addPredecessors(child, al);
                al = this.parseElementSuccessors(child);
            }
        }
        return al;
    }

    private ArrayList addAndParse(SourceElement el, Collection col) {
        ExtractMethodController.addPredecessors(el, col);
        return this.parseElementSuccessors(el);
    }

    private ArrayList simpleAdd(SourceElement el) {
        ArrayList al = new ArrayList(1);
        al.add(el);
        for (SourceElement child : el.getChildren()) {
            ExtractMethodController.addPredecessors(child, al);
            al = this.simpleAdd(child);
        }
        return al;
    }

    private ArrayList parseElementSuccessors(SourceElement el) {
        int type = el.getSymbolKind();
        switch (type) {
            case 3: {
                return this.simpleAdd(el);
            }
            case 48: {
                SourceAssignmentExpression exp = (SourceAssignmentExpression)el;
                ArrayList al = new ArrayList(1);
                al.add(el);
                al = this.addAndParse((SourceElement)exp.getSecondOperand(), al);
                al = this.addAndParse((SourceElement)exp.getFirstOperand(), al);
                return al;
            }
            case 30: {
                SourceElement e = el;
                int tp = e.getSymbolKind();
                while (e != null && tp != 45 && tp != 38 && tp != 33 && tp != 41) {
                    e = e.getParent();
                    tp = e.getSymbolKind();
                }
                if (e != null) {
                    ExtractMethodController.addExit(e, el);
                }
                return new ArrayList(1);
            }
            case 23: {
                SourceElement e = el;
                int tp = e.getSymbolKind();
                while (e != null && tp != 41) {
                    e = e.getParent();
                    tp = e.getSymbolKind();
                }
                if (e != null) {
                    SourceSwitchStatement st = (SourceSwitchStatement)e;
                    SourceExpression ctrl = st.getControlExpression();
                    Iterator it = ExtractMethodController.getElementExits((SourceElement)ctrl);
                    while (it.hasNext()) {
                        ExtractMethodController.addPredecessor(el, it.next());
                    }
                    SourceSwitchLabel label = (SourceSwitchLabel)el;
                    if (label.getExpression() == null) {
                        ExtractMethodController.getGroup(13, (SourceElement)st);
                    }
                }
                return this.addNaturalOrderCollection(el, (Collection)el.getChildren());
            }
            case 40: {
                SourceReturnStatement st = (SourceReturnStatement)el;
                ArrayList al = new ArrayList();
                al.add(el);
                SourceExpression arg = st.getExpression();
                if (arg != null) {
                    al = this.addAndParse((SourceElement)arg, al);
                }
                ExtractMethodController.addExits(this._outerMethod, al);
                return new ArrayList(1);
            }
            case 41: {
                SourceSwitchStatement st = (SourceSwitchStatement)el;
                ArrayList al = new ArrayList(1);
                al.add(el);
                SourceExpression ctrl = st.getControlExpression();
                ArrayList exitcond = this.addAndParse((SourceElement)ctrl, al);
                ExtractMethodController.addExits((SourceElement)ctrl, exitcond);
                al = this.addNaturalOrderCollection(new ArrayList(0), (Collection)el.getChildren());
                Iterator it = ExtractMethodController.getElementExits(el);
                while (it.hasNext()) {
                    al.add(it.next());
                }
                if (el.getBinding(13) == null) {
                    al.addAll(exitcond);
                }
                return al;
            }
            case 39: {
                SourceIfStatement st = (SourceIfStatement)el;
                SourceExpression ctrl = st.getControlExpression();
                SourceStatement yesblock = st.getPrimaryClause();
                SourceStatement noblock = st.getEndClause();
                ArrayList al = this.processConditionalExpression(el, ctrl, (SourceElement)yesblock, (SourceElement)noblock);
                return al;
            }
            case 56: {
                SourceQuestionExpression st = (SourceQuestionExpression)el;
                SourceExpression ctrl = st.getFirstOperand();
                SourceExpression yesblock = st.getSecondOperand();
                SourceExpression noblock = st.getThirdOperand();
                ArrayList al = this.processConditionalExpression(el, ctrl, (SourceElement)yesblock, (SourceElement)noblock);
                return al;
            }
            case 45: {
                ArrayList al = new ArrayList(1);
                al.add(el);
                SourceWhileStatement wst = (SourceWhileStatement)el;
                SourceExpression ctrl = wst.getControlExpression();
                SourceStatement body = wst.getPrimaryClause();
                al = this.addAndParse((SourceElement)ctrl, al);
                ArrayList al2 = this.addAndParse((SourceElement)body, al);
                ExtractMethodController.addPredecessors((SourceElement)ctrl, al2);
                return al;
            }
            case 33: {
                ArrayList al = new ArrayList(1);
                al.add(el);
                SourceDoStatement wst = (SourceDoStatement)el;
                SourceExpression ctrl = wst.getControlExpression();
                SourceStatement body = wst.getPrimaryClause();
                al = this.addAndParse((SourceElement)body, al);
                ArrayList al2 = this.addAndParse((SourceElement)ctrl, al);
                ExtractMethodController.addPredecessors((SourceElement)body, al2);
                Iterator it = ExtractMethodController.getElementExits(el);
                while (it.hasNext()) {
                    al2.add(it.next());
                }
                it = ExtractMethodController.getElementExits(el);
                while (it.hasNext()) {
                    al2.add(it.next());
                }
                return al2;
            }
            case 38: {
                List iter;
                ArrayList condexit;
                SourceExpression test;
                SourceForStatement wst = (SourceForStatement)el;
                ArrayList al = new ArrayList(1);
                switch (wst.getForType()) {
                    case 0: {
                        al = this.addNaturalOrderCollection(el, (Collection)wst.getForInitializations());
                        break;
                    }
                    case 1: 
                    case 2: {
                        al.add(wst.getForVariableDeclaration());
                        al = this.addNaturalOrderCollection(el, (Collection)al);
                        break;
                    }
                }
                if (wst.getForType() == 2) {
                    test = wst.getForCollection();
                    al = condexit = this.addAndParse((SourceElement)test, al);
                } else {
                    test = wst.getForConditional();
                    if (test == null) {
                        condexit = new ArrayList(1);
                    } else {
                        al = condexit = this.addAndParse((SourceElement)test, al);
                    }
                }
                SourceStatement body = wst.getPrimaryClause();
                if (body != null) {
                    al = this.addAndParse((SourceElement)body, al);
                }
                if ((iter = wst.getForUpdates()) != null && !iter.isEmpty()) {
                    SourceElement sse = (SourceElement)iter.iterator().next();
                    al = this.addAndParse(sse.getParent(), al);
                }
                if (test == null) {
                    if (body != null) {
                        ExtractMethodController.addPredecessors((SourceElement)body, al);
                    }
                } else {
                    ExtractMethodController.addPredecessors((SourceElement)test, al);
                }
                Iterator it = ExtractMethodController.getElementExits(el);
                while (it.hasNext()) {
                    condexit.add(it.next());
                }
                return condexit;
            }
            case 44: {
                ArrayList<SourceElement> entry = new ArrayList<SourceElement>(1);
                entry.add(el);
                ArrayList exits = new ArrayList(2);
                SourceTryStatement tr = (SourceTryStatement)el;
                SourceStatement body = tr.getPrimaryClause();
                ArrayList exitBody = this.addAndParse((SourceElement)body, entry);
                SourceFinallyClause finalclause = tr.getFinallyClause();
                for (SourceElement cb : tr.getCatchClauses()) {
                    ExtractMethodController.addPredecessors(cb, entry);
                    ArrayList exitcatch = this.addAndParse(cb, exitBody);
                    if (finalclause != null) {
                        ExtractMethodController.addPredecessors((SourceElement)finalclause, exitcatch);
                        continue;
                    }
                    exits.addAll(exitcatch);
                }
                if (finalclause != null) {
                    ExtractMethodController.addPredecessors((SourceElement)finalclause, entry);
                    exits = this.addAndParse((SourceElement)finalclause, exitBody);
                } else {
                    exits.addAll(exitBody);
                }
                return exits;
            }
            case 50: {
                SourceInfixExpression exp = (SourceInfixExpression)el;
                int opcode = exp.getOperatorCode();
                switch (opcode) {
                    case 3: 
                    case 43: {
                        ArrayList curexit = new ArrayList(4);
                        ArrayList al = new ArrayList(1);
                        al.add(el);
                        for (SourceElement e : el.getChildren()) {
                            al = this.addAndParse(e, al);
                            curexit.addAll(al);
                        }
                        return curexit;
                    }
                }
            }
        }
        return this.addNaturalOrderCollection(el, (Collection)el.getChildren());
    }

    private ArrayList processConditionalExpression(SourceElement el, SourceExpression ctrl, SourceElement yesblock, SourceElement noblock) {
        ArrayList<SourceElement> al = new ArrayList<SourceElement>(1);
        al.add(el);
        ArrayList exitcond = this.addAndParse((SourceElement)ctrl, al);
        al.clear();
        al.addAll(this.addAndParse(yesblock, exitcond));
        if (noblock != null && noblock != yesblock) {
            al.addAll(this.addAndParse(noblock, exitcond));
        } else {
            al.addAll(exitcond);
        }
        return al;
    }

    private static void clearBindings(SourceElement el) {
        el.clearBinding(10);
        el.clearBinding(11);
        el.clearBinding(12);
        el.clearBinding(13);
        el.clearBinding(14);
        for (SourceElement e : el.getChildren()) {
            ExtractMethodController.clearBindings(e);
        }
    }

    private static boolean recCheckWrites(HashSet recControl, boolean check, boolean pos, Var v, SourceElement el) {
        while (true) {
            int acc;
            if (recControl.contains(el)) {
                return false;
            }
            VarStates states = ExtractMethodController.getVarStates(el);
            if (check && states != null && ((acc = states.getVarState(v)) == 3 || acc == 4)) {
                return states.isInside == pos;
            }
            SourceElement pred = ExtractMethodController.getUniquePredecessor(el);
            if (pred == null) break;
            el = pred;
            check = true;
        }
        if (check) {
            recControl.add(el);
        }
        Iterator preds = ExtractMethodController.getElementPredecessor(el);
        while (preds.hasNext()) {
            SourceElement e = (SourceElement)preds.next();
            if (!ExtractMethodController.recCheckWrites(recControl, true, pos, v, e)) continue;
            return true;
        }
        return false;
    }

    private static void checkElementFlag(VarStates states, Var v, SourceElement el) {
        HashSet recControl;
        int acc;
        HashSet recControl2;
        int acc2;
        if (!(v.isAttr(8) || states.isInside || (acc2 = states.getVarState(v)) != 2 && acc2 != 4 || !ExtractMethodController.recCheckWrites(recControl2 = new HashSet(), false, true, v, el))) {
            v.setAttr(8);
        }
        if (!v.isAttr(4) && states.isInside && ((acc = states.getVarState(v)) == 2 || acc == 4) && ExtractMethodController.recCheckWrites(recControl = new HashSet(), false, false, v, el)) {
            v.setAttr(20);
        }
    }

    private static void adjustFlags(SourceElement el) {
        Var v;
        VarStates states = ExtractMethodController.getVarStates(el);
        if (states != null && (v = states.getVar()).isAttr(2)) {
            ExtractMethodController.checkElementFlag(states, v, el);
        }
        for (SourceElement e : el.getChildren()) {
            ExtractMethodController.adjustFlags(e);
        }
    }

    private static void collectAdjustableElements(ArrayList al, SourceElement el) {
        int type;
        VarStates states = ExtractMethodController.getVarStates(el);
        if (states != null && states.isInside && ((type = el.getSymbolKind()) == 20 || type == 57)) {
            al.add(el);
        }
        for (SourceElement e : el.getChildren()) {
            ExtractMethodController.collectAdjustableElements(al, e);
        }
    }

    private void collectExitElements(SourceElement el) {
        if (!this.isInBlock(el)) {
            Iterator pr = ExtractMethodController.getElementPredecessor(el);
            while (pr.hasNext()) {
                SourceElement e = (SourceElement)pr.next();
                if (!this.isInBlock(e)) continue;
                this._innerExits.add(el);
                break;
            }
        }
        for (SourceElement e : el.getChildren()) {
            this.collectExitElements(e);
        }
    }

    private static int elemType(SourceElement el) {
        int nid = el.getSymbolKind();
        if (nid == 2) {
            return 1;
        }
        if (nid >= 46 && nid <= 62 && nid != 51) {
            return 2;
        }
        return 0;
    }

    private static SourceElement findContainerElement(SourceElement el1, SourceElement el2) {
        if (el1 == el2) {
            if (el1 == null) {
                return null;
            }
            int nid = el1.getSymbolKind();
            if (nid >= 46 && nid <= 62) {
                if (nid == 51) {
                    ListExpr lexp = (ListExpr)el1;
                    if (lexp.getOperandCount() > 1) {
                        return null;
                    }
                    return lexp.getFirstOperand();
                }
                return el1;
            }
        }
        HashSet<SourceElement> parents = new HashSet<SourceElement>(5);
        while (el1 != null) {
            int id;
            if (ExtractMethodController.elemType(el1) != 0) {
                parents.add((SourceElement)el1);
            }
            el1 = (id = el1.getSymbolKind()) == 2 ? null : el1.getParent();
        }
        if (el2.getSymbolKind() == 2) {
            el2 = el2.getParent();
        }
        while (el2 != null) {
            if (parents.contains(el2)) {
                return el2;
            }
            int id = el2.getSymbolKind();
            el2 = id == 2 ? null : el2.getParent();
        }
        return null;
    }

    private static SourceElement findContainerMethod(SourceElement el) {
        while (el != null) {
            int id = el.getSymbolKind();
            switch (id) {
                case 5: 
                case 6: 
                case 19: {
                    return el;
                }
            }
            el = el.getParent();
        }
        return null;
    }

    private static ArrayList getSelectedElements(SourceElement el, int start, int end) {
        ArrayList<SourceElement> al = new ArrayList<SourceElement>();
        if (el.getSymbolKind() == 55 || ExtractMethodController.elemType(el) == 2 && el.getStartOffset() >= start && el.getEndOffset() <= end) {
            al.add(el);
        } else {
            for (SourceElement cel : el.getChildren(196608)) {
                int st = cel.getStartOffset();
                int en = cel.getEndOffset();
                int id = cel.getSymbolKind();
                if (en < start || st > end || id == 51) continue;
                if (id == 23 || id == 30) {
                    return null;
                }
                al.add(cel);
            }
        }
        return al;
    }

    private static SourceElement findElementBetween(SourceElement el, int start, int end, boolean first) {
        int lStart = el.getStartOffset();
        int lEnd = el.getEndOffset();
        if (lEnd < start || lStart > end) {
            return null;
        }
        if (start <= lStart && lEnd <= end) {
            return el;
        }
        SourceElement res = null;
        Iterator it = el.getChildren(196608).iterator();
        while (it.hasNext()) {
            SourceElement cel = ExtractMethodController.findElementBetween((SourceElement)it.next(), start, end, first);
            if (cel == null) continue;
            if (first) {
                return cel;
            }
            res = cel;
        }
        return res;
    }

    private static String getBaseType(JavaHasType tp) {
        JavaType rtp = tp.getResolvedType();
        if (rtp.isArray()) {
            return rtp.getComponentType().getQualifiedName();
        }
        if (rtp.isPrimitive()) {
            return "";
        }
        return rtp.getQualifiedName();
    }

    private void generateMethodText(Var exitVar, String body, SourceFile sourceFile, JavaManager javaManager) {
        String indentString = Util.getIndentString();
        String fqReturnType = "";
        StringBuffer sb = new StringBuffer();
        sb.append("private ");
        if (this._isNewMethodStatic) {
            sb.append("static ");
        }
        if (this._returnType != null) {
            String refType;
            fqReturnType = ExtractMethodController.getBaseType((JavaHasType)this._returnType);
            if (fqReturnType.equals(refType = this._returnType.getName())) {
                fqReturnType = "";
            }
            sb.append(refType);
            sb.append(" ");
        } else if (exitVar == null) {
            sb.append("void ");
        } else {
            String refType;
            JavaHasType ltpe = exitVar.getJavaType();
            fqReturnType = ExtractMethodController.getBaseType(ltpe);
            if (fqReturnType.equals(refType = exitVar.getType())) {
                fqReturnType = "";
            }
            sb.append(refType);
            sb.append(" ");
        }
        sb.append(this._newMethodName);
        boolean isfirst = true;
        sb.append("(");
        int i = 0;
        while (i < this._vars.size()) {
            Var v = (Var)this._vars.get(i);
            if (v.isAttr(16)) {
                if (!isfirst) {
                    sb.append(", ");
                }
                if (v.isFinal()) {
                    sb.append("final ");
                }
                sb.append(v.getType());
                sb.append(' ');
                sb.append(v.getNewName());
                isfirst = false;
            }
            ++i;
        }
        sb.append(")");
        if (this._thrownExceptions.size() != 0) {
            sb.append(" throws ");
            isfirst = true;
            for (JavaType tp : this._thrownExceptions) {
                if (!isfirst) {
                    sb.append(", ");
                }
                isfirst = false;
                sb.append(tp.getName());
            }
        }
        sb.append("\n{\n");
        int i2 = 0;
        while (i2 < this._vars.size()) {
            Var v = (Var)this._vars.get(i2);
            if (v.isAttr(4) && !v.isAttr(16) && !this.isInBlock(v.getOffset())) {
                sb.append(indentString);
                sb.append(v.getType());
                sb.append(' ');
                sb.append(v.getNewName());
                sb.append(" = ; // TODO type initialisation here\n");
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this._vars.size()) {
            Var v = (Var)this._vars.get(i3);
            if (!v.isAttr(4) && !this.isInBlock(v.getOffset())) {
                sb.append(indentString);
                sb.append(v.getType());
                sb.append(' ');
                sb.append(v.getNewName());
                sb.append(";\n");
            }
            ++i3;
        }
        int endOfHeaderOffset = sb.length();
        sb.append(body);
        sb.append("\n");
        int endOfBodyOffset = sb.length();
        if (exitVar != null) {
            sb.append(indentString);
            sb.append("return ");
            sb.append(exitVar.getNewName());
            sb.append(";\n");
        }
        sb.append("}");
        String methodText = sb.toString();
        sb = new StringBuffer();
        if (!this._isExpressionUsed) {
            if (this._returnType != null && !this._isExpression) {
                sb.append("return ");
            } else if (exitVar != null) {
                if (this.isInBlock(exitVar.getOffset())) {
                    if (exitVar.isFinal()) {
                        sb.append("final ");
                    }
                    sb.append(exitVar.getType());
                    sb.append(" ");
                }
                sb.append(exitVar.getName());
                sb.append(" = ");
            }
        }
        sb.append(this._newMethodName);
        isfirst = true;
        sb.append("(");
        int i4 = 0;
        while (i4 < this._vars.size()) {
            Var v = (Var)this._vars.get(i4);
            if (v.isAttr(16)) {
                if (!isfirst) {
                    sb.append(", ");
                }
                sb.append(v.getName());
                isfirst = false;
            }
            ++i4;
        }
        sb.append(")");
        if (!this._isExpression) {
            sb.append(";");
        }
        BasicEditorPane bep = this._codeEditor.getFocusedEditorPane();
        int iposi = -1;
        if (fqReturnType.length() != 0) {
            String toImport = fqReturnType;
            HashSet needImports = new HashSet(1);
            HashSet conflictImport = new HashSet();
            String[] needed = new String[1];
            int ind = fqReturnType.indexOf(60);
            if (ind != -1) {
                toImport = fqReturnType.substring(0, ind);
            }
            needed[0] = toImport;
            iposi = RichBuffer.getAddedImports((BasicDocument)bep.getDocument(), needed, sourceFile, needImports, conflictImport);
            if (needImports.size() != 0) {
                fqReturnType = "import " + (String)needImports.iterator().next() + ";\n";
            } else {
                iposi = -1;
            }
        }
        UndoableEditCommand icommand = new UndoableEditCommand(RefactoringArb.getString(236), this._codeEditor.getContext());
        icommand.setSelection(this._outerMethod.getEndOffset(), this._outerMethod.getEndOffset());
        BasicDocument doc = (BasicDocument)bep.getDocument();
        TextBuffer buffer = doc.getTextBuffer();
        char[] barray = ("\n\n" + methodText).toCharArray();
        int ioffset = this._outerMethod.getEndOffset();
        if (!MakeWritableHelper.makeWritable(new URL[]{sourceFile.getURL()})) {
            Assert.println((String)("Unable to make " + sourceFile.getURL() + " writable."));
            return;
        }
        UndoableEdit uEdit = buffer.insert(ioffset, barray);
        icommand.addEdit(uEdit);
        sourceFile = javaManager.getSourceFile(buffer);
        SourceTransaction rtransac = sourceFile.beginTransaction();
        try {
            Formatting.reformatRegion((SourceFile)sourceFile, (int)(ioffset + endOfBodyOffset), (int)(ioffset + barray.length));
            Formatting.reformatRegion((SourceFile)sourceFile, (int)ioffset, (int)(ioffset + endOfHeaderOffset));
            UndoableEdit rcommand = rtransac.commit();
            icommand.addEdit(rcommand);
            uEdit = buffer.remove(this._ostart, this._oend - this._ostart);
            icommand.addEdit(uEdit);
            int ofend = this._ostart + sb.length();
            uEdit = buffer.insert(this._ostart, sb.toString().toCharArray());
            icommand.addEdit(uEdit);
            if (iposi != -1) {
                uEdit = buffer.insert(iposi, fqReturnType.toCharArray());
                ofend += fqReturnType.length();
                icommand.addEdit(uEdit);
            }
            icommand.setSelection(ofend, 0);
            try {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                commandProcessor.invoke((Command)icommand);
            }
            catch (Exception e) {
                FeedbackManager.reportException((String)"Command processor exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            rtransac.abort();
            FeedbackManager.reportException((Throwable)e);
        }
    }

    private static String adjustVariableNames(ArrayList adjustableElements, String body, int stoff) {
        int postext = stoff;
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < adjustableElements.size()) {
            SourceElement el = (SourceElement)adjustableElements.get(i);
            Var v = ExtractMethodController.getVarStates(el).getVar();
            int len = el.getStartOffset() - postext;
            if (len >= 0) {
                if (len > 0) {
                    sb.append(body.substring(pos, pos + len));
                    pos += len;
                    postext += len;
                }
                sb.append(v.getNewName());
                len = el.getEndOffset() - el.getStartOffset();
                postext += len;
                pos += len;
            }
            ++i;
        }
        if (pos < body.length()) {
            sb.append(body.substring(pos));
        }
        return sb.toString();
    }

    public SourceClass getSourceClass() {
        if (this._outerMethod instanceof JavaMethod) {
            JavaMethod m = (JavaMethod)this._outerMethod;
            return (SourceClass)m.getOwningClass();
        }
        if (this._outerMethod instanceof SourceClassInitializer) {
            SourceClassInitializer si = (SourceClassInitializer)this._outerMethod;
            return si.getEnclosingClass();
        }
        return null;
    }

    public boolean isIdentifierUsedInBlock(String s) {
        return this._usedFieldIdentifiers.contains(s);
    }

    private void doExtract(Context context) {
        this._result = 0;
        View view = context.getView();
        if (view instanceof CodeEditor) {
            this._codeEditor = (CodeEditor)view;
            Project project = context.getProject();
            if (project != null) {
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                URL url = context.getNode().getURL();
                SourceFile sourceFile = javaManager.getSourceFile(url);
                int selectionStart = this._codeEditor.getSelectionStart();
                int selectionEnd = this._codeEditor.getSelectionEnd();
                SourceElement fromElement = ExtractMethodController.findElementBetween((SourceElement)sourceFile, selectionStart, selectionEnd, true);
                SourceElement toElement = ExtractMethodController.findElementBetween((SourceElement)sourceFile, selectionStart, selectionEnd, false);
                SourceElement baseBlock = ExtractMethodController.findContainerElement(fromElement, toElement);
                ArrayList selection = null;
                if (baseBlock != null) {
                    selection = ExtractMethodController.getSelectedElements(baseBlock, selectionStart, selectionEnd);
                }
                if (selection != null && selection.size() > 0) {
                    this._ostart = ((SourceElement)selection.get(0)).getStartOffset();
                    this._oend = ((SourceElement)selection.get(selection.size() - 1)).getEndOffset();
                    this._codeEditor.setSelectionStart(this._ostart);
                    this._codeEditor.setSelectionEnd(this._oend);
                    if (ExtractMethodController.elemType(baseBlock) == 2) {
                        SourceExpression exp = (SourceExpression)baseBlock;
                        this._returnType = exp.getSymbolKind() == 55 ? ((SourceNewClassExpression)exp).getSourceType().getResolvedType() : exp.getResolvedType();
                        this._isExpression = true;
                        this._isExpressionUsed = true;
                        if (selection.size() == 1) {
                            SourceElement parent = exp.getParent();
                            int parenttype = parent.getSymbolKind();
                            switch (parenttype) {
                                case 48: {
                                    SourceAssignmentExpression sexp = (SourceAssignmentExpression)parent;
                                    SourceExpression lhs = sexp.getFirstOperand();
                                    if (lhs != exp) break;
                                    this._result = 1;
                                    break;
                                }
                                case 36: {
                                    this._isExpressionUsed = false;
                                    break;
                                }
                                case 51: {
                                    SourceElement greatParent = parent.getParent();
                                    if (greatParent.getSymbolKind() != 38) break;
                                    this._isExpressionUsed = false;
                                    break;
                                }
                            }
                        }
                    }
                    if (this._result == 0) {
                        sourceFile.compile();
                    }
                    BlockVisitor bv = new BlockVisitor();
                    if (this._result == 0) {
                        this._outerMethod = ExtractMethodController.findContainerMethod(baseBlock);
                    }
                    Iterator it = null;
                    int returnsInBlock = 0;
                    if (this._result == 0 && this._outerMethod != null) {
                        this._isMethodStatic = this._outerMethod.getSymbolKind() != 5 ? ((JavaMethod)this._outerMethod).isStatic() : true;
                        this._isNewMethodStatic = this._isMethodStatic;
                        ExtractMethodController.clearBindings(this._outerMethod);
                        this.parseElementSuccessors(this._outerMethod);
                        it = ExtractMethodController.getElementExits(this._outerMethod);
                        while (it.hasNext()) {
                            SourceElement e = (SourceElement)it.next();
                            if (!this.isInBlock(e)) continue;
                            ++returnsInBlock;
                        }
                        bv.visit(this._outerMethod);
                    } else {
                        this._result = 1;
                    }
                    ArrayList parsedvars = null;
                    Var exitVar = null;
                    if (this._result == 0) {
                        ExtractMethodController.adjustFlags(this._outerMethod);
                        parsedvars = bv.getVars();
                        this._vars = new ArrayList();
                        exitVar = null;
                        this._innerExits = new HashSet(2);
                        this.collectExitElements(this._outerMethod);
                        int innerExits = this._innerExits.size();
                        if (innerExits == 0) {
                            if (!this._isExpression) {
                                this._returnType = null;
                                if (this._outerMethod.getSymbolKind() != 5) {
                                    JavaMethod m = (JavaMethod)this._outerMethod;
                                    this._returnType = m.getReturnType();
                                    if (this._returnType != null && this._returnType.getRawName().equals("void")) {
                                        this._returnType = null;
                                    }
                                }
                            }
                        } else if (returnsInBlock != 0) {
                            this._result = 2;
                        }
                    }
                    if (this._result == 0) {
                        int i = 0;
                        while (i < parsedvars.size()) {
                            Var v = (Var)parsedvars.get(i);
                            if (v.isAttr(2)) {
                                this._vars.add(v);
                                if (v.isAttr(8)) {
                                    if (this._isExpressionUsed || exitVar != null) {
                                        this._result = 3;
                                    } else {
                                        exitVar = v;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    if (this._result == 0 && exitVar != null && this._innerExits.size() != 0) {
                        it = this._innerExits.iterator();
                        while (!exitVar.isAttr(16) && it.hasNext()) {
                            HashSet recControl = new HashSet();
                            SourceElement cel = (SourceElement)it.next();
                            if (!ExtractMethodController.recCheckWrites(recControl, false, false, exitVar, cel)) continue;
                            exitVar.setAttr(20);
                        }
                    }
                    if (this._result == 0) {
                        ExtractMethodDialog extractMethodDialog = new ExtractMethodDialog(context);
                        ParametersModel model = extractMethodDialog.getModel();
                        model.setController(this);
                        ArrayList<Var> offArgs = new ArrayList<Var>();
                        int i = 0;
                        while (i < this._vars.size()) {
                            Var v = (Var)this._vars.get(i);
                            if (v.isAttr(16)) {
                                model.addParameter(v, v.getName());
                            } else {
                                this._usedFieldIdentifiers.add(v.getName());
                                offArgs.add(v);
                            }
                            ++i;
                        }
                        if (this._isMethodStatic) {
                            extractMethodDialog.setStatic(false, true);
                        } else {
                            extractMethodDialog.setStatic(this._useInstanceObject ^ true, false);
                        }
                        if (extractMethodDialog.runDialog()) {
                            int rowCount = model.getRowCount();
                            int i2 = 0;
                            while (i2 < rowCount) {
                                ParameterEntry entry = model.getEntry(i2);
                                Var var = (Var)entry.getParam();
                                var.setNewName(entry.getName());
                                if (!entry.isIncluded()) {
                                    var.clearAttr(16);
                                }
                                offArgs.add(var);
                                ++i2;
                            }
                            this._vars = offArgs;
                            this._newMethodName = extractMethodDialog.getName();
                            this._isNewMethodStatic = extractMethodDialog.isStatic();
                        } else {
                            this._result = 5;
                        }
                    }
                    if (this._result == 0) {
                        ArrayList adjustableElements = new ArrayList();
                        ExtractMethodController.collectAdjustableElements(adjustableElements, this._outerMethod);
                        this.sortArrayListElements(adjustableElements);
                        try {
                            String oldIdent = SourceFormatUtilities.getIndentation(this._codeEditor, this._ostart);
                            String body = this._codeEditor.getText(this._ostart, this._oend - this._ostart);
                            body = ExtractMethodController.adjustVariableNames(adjustableElements, body, this._ostart);
                            if (this._isExpression) {
                                body = this._isExpressionUsed && this._returnType.getName() != "void" ? "return " + body + ';' : body + ';';
                            }
                            BasicEditorPane editor = this._codeEditor.getFocusedEditorPane();
                            String newIndent = SourceFormatUtilities.getIndentation(this._codeEditor, this._outerMethod.getStartOffset());
                            int indentSize = (Integer)editor.getProperty("indent-size");
                            body = SourceFormatUtilities.reIndent(editor, body, oldIdent, newIndent + "                    ".substring(0, indentSize));
                            this.generateMethodText(exitVar, body, sourceFile, javaManager);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (this._outerMethod != null) {
                        ExtractMethodController.clearBindings(this._outerMethod);
                    }
                } else {
                    this._result = 1;
                }
                switch (this._result) {
                    case 0: 
                    case 5: {
                        break;
                    }
                    case 1: {
                        Util.showRefactoringErrorMessage(311, 87);
                        break;
                    }
                    case 3: {
                        Util.showRefactoringErrorMessage(311, 364);
                        break;
                    }
                    case 2: {
                        Util.showRefactoringErrorMessage(311, 69);
                        break;
                    }
                    case 4: {
                        Util.showRefactoringErrorMessage(311, 32);
                        break;
                    }
                }
            }
        }
    }

    private void sortArrayListElements(ArrayList adjustableElements) {
        boolean notDone;
        int lim = adjustableElements.size() - 1;
        do {
            notDone = false;
            int i = 0;
            while (i < lim) {
                SourceElement el1 = (SourceElement)adjustableElements.get(i);
                SourceElement el2 = (SourceElement)adjustableElements.get(i + 1);
                if (el2.getStartOffset() < el1.getStartOffset()) {
                    notDone = true;
                    adjustableElements.set(i, el2);
                    adjustableElements.set(i + 1, el1);
                }
                ++i;
            }
            --lim;
        } while (notDone);
    }

    public boolean update(IdeAction action, Context context) {
        Project project;
        JavaManager javaManager;
        SourceFile sourceFile;
        CodeEditor codeEditor;
        URL url;
        View view;
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (view = context.getView()) instanceof CodeEditor && Util.canRefactor(context, url = context.getNode().getURL()) && (codeEditor = (CodeEditor)view).hasSelectedText() && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)(project = context.getProject()))).getSourceFile(url)) != null) {
            canHandle = true;
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        ExtractMethodController ctrl = new ExtractMethodController();
        ctrl.doExtract(context);
        return true;
    }

    public ExtractMethodController() {
        this.$init$();
    }

    static HashSet ra$_usedFieldIdentifiers(ExtractMethodController extractMethodController) {
        return extractMethodController._usedFieldIdentifiers;
    }

    static boolean ra$_useInstanceObject(ExtractMethodController extractMethodController) {
        return extractMethodController._useInstanceObject;
    }

    static void wa$_useInstanceObject(ExtractMethodController extractMethodController, boolean bl) {
        extractMethodController._useInstanceObject = bl;
    }

    static HashSet ra$_thrownExceptions(ExtractMethodController extractMethodController) {
        return extractMethodController._thrownExceptions;
    }

    static void wa$_result(ExtractMethodController extractMethodController, int n) {
        extractMethodController._result = n;
    }

    class BlockVisitor
    extends Visitor {
        ArrayList _vars = new ArrayList();
        HashMap _varMap = new HashMap();

        BlockVisitor() {
        }

        boolean exceptionHaveToBeDeclared(JavaType tp) {
            while (tp != null) {
                String name = tp.getQualifiedName();
                if (name.equals("java.lang.Error") || name.equals("java.lang.RuntimeException")) {
                    return false;
                }
                tp = tp.getSuperclass();
            }
            return true;
        }

        public ArrayList getVars() {
            return this._vars;
        }

        void writeTo(Var v, SourceElement pos) {
            ExtractMethodController.saveWriteTo(v, pos);
            if (ExtractMethodController.this.isInBlock(pos)) {
                v.setAttr(2);
                ExtractMethodController.setInside(pos);
            }
        }

        void declared(Var v, SourceElement pos) {
            ExtractMethodController.saveDeclared(v, pos);
            if (ExtractMethodController.this.isInBlock(pos)) {
                v.setAttr(2);
                ExtractMethodController.setInside(pos);
            }
        }

        void readFrom(Var v, SourceElement pos) {
            ExtractMethodController.saveReadFrom(v, pos);
            if (ExtractMethodController.this.isInBlock(pos)) {
                v.setAttr(2);
                ExtractMethodController.setInside(pos);
            }
        }

        protected void whenEnterFormalParameter(SourceVariable sourceVariable) {
            Var var = new Var(sourceVariable);
            var.setAttr(1);
            this._vars.add(var);
            this._varMap.put(sourceVariable, var);
            this.writeTo(var, (SourceElement)sourceVariable);
        }

        protected void whenEnterLocalVariable(SourceLocalVariable slv) {
            Var var = new Var((SourceVariable)slv);
            this._vars.add(var);
            this._varMap.put(slv, var);
            if (slv.getContainedElements().length > 1) {
                this.writeTo(var, (SourceElement)slv);
            } else if (ExtractMethodController.this.isInBlock((SourceElement)slv)) {
                var.setAttr(2);
            }
        }

        SourceElement findCatch(SourceElement el, JavaType tp) {
            while (true) {
                int type = el.getSymbolKind();
                switch (type) {
                    case 31: 
                    case 37: {
                        el = el.getParent();
                        break;
                    }
                    case 44: {
                        SourceTryStatement tr = (SourceTryStatement)el;
                        for (SourceCatchClause sc : tr.getCatchClauses()) {
                            JavaType catched = sc.getCatchVariable().getSourceType().getResolvedType();
                            if (!catched.isAssignableFrom(tp)) continue;
                            return sc;
                        }
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 19: {
                        return el;
                    }
                }
                el = el.getParent();
            }
        }

        protected void whenEnterThrowStatement(SourceThrowStatement thr) {
            SourceExpression exp;
            JavaType tth;
            if (ExtractMethodController.this.isInBlock((SourceElement)thr) && !ExtractMethodController.this.isInBlock(this.findCatch((SourceElement)thr, tth = (exp = thr.getExpression()).getResolvedType())) && this.exceptionHaveToBeDeclared(tth)) {
                ExtractMethodController.ra$_thrownExceptions(ExtractMethodController.this).add(tth);
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression creat) {
            if (ExtractMethodController.this.isInBlock((SourceElement)creat)) {
                JavaType clazz = creat.getResolvedType();
                if (clazz != null) {
                    if (clazz.isInterface()) {
                        return;
                    }
                    JavaMethod jm = creat.getResolvedMethod();
                    if (jm != null) {
                        for (JavaType tth : jm.getExceptions()) {
                            if (ExtractMethodController.this.isInBlock(this.findCatch((SourceElement)creat, tth)) || !this.exceptionHaveToBeDeclared(tth)) continue;
                            ExtractMethodController.ra$_thrownExceptions(ExtractMethodController.this).add(tth);
                        }
                        return;
                    }
                }
                ExtractMethodController.wa$_result(ExtractMethodController.this, 4);
                this.cancel();
            }
        }

        protected void whenEnterName(SourceName sourceName) {
            Var v;
            SourceElement def = sourceName.getParent();
            if (ExtractMethodController.this.isInBlock((SourceElement)sourceName) && def.getSymbolKind() == 53) {
                SourceMethodCallExpression sm = (SourceMethodCallExpression)def;
                JavaMethod jm = sm.getResolvedMethod();
                if (jm != null) {
                    if (!jm.isStatic()) {
                        ExtractMethodController.wa$_useInstanceObject(ExtractMethodController.this, true);
                    }
                    for (JavaType tth : jm.getExceptions()) {
                        if (ExtractMethodController.this.isInBlock(this.findCatch((SourceElement)sm, tth)) || !this.exceptionHaveToBeDeclared(tth)) continue;
                        ExtractMethodController.ra$_thrownExceptions(ExtractMethodController.this).add(tth);
                    }
                } else {
                    ExtractMethodController.wa$_result(ExtractMethodController.this, 4);
                    this.cancel();
                }
            }
            if ((v = (Var)this._varMap.get(def)) != null) {
                SourceForStatement wst;
                SourceElement granGranParent;
                SourceElement granParent = def.getParent();
                if (granParent != null && (granGranParent = granParent.getParent()).getSymbolKind() == 38 && (wst = (SourceForStatement)granGranParent).getForType() == 2) {
                    this.writeTo(v, (SourceElement)sourceName);
                    return;
                }
                this.declared(v, (SourceElement)sourceName);
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression exp) {
            block16: {
                Var v;
                JavaHasType temp;
                block18: {
                    block17: {
                        JavaField fl;
                        temp = exp.getResolvedObject();
                        if (temp == null) break block16;
                        if (temp.getElementKind() == 5 && ExtractMethodController.this.isInBlock((SourceElement)exp)) {
                            ExtractMethodController.ra$_usedFieldIdentifiers(ExtractMethodController.this).add(exp.getName());
                        }
                        if (ExtractMethodController.ra$_useInstanceObject(ExtractMethodController.this) || temp.getElementKind() != 5) break block17;
                        if (!ExtractMethodController.this.isInBlock((SourceElement)exp) || (fl = (JavaField)temp).isStatic()) break block16;
                        ExtractMethodController.wa$_useInstanceObject(ExtractMethodController.this, true);
                        break block16;
                    }
                    if (ExtractMethodController.ra$_useInstanceObject(ExtractMethodController.this) || temp.getElementKind() != 14) break block18;
                    if (!ExtractMethodController.this.isInBlock((SourceElement)exp)) break block16;
                    ExtractMethodController.wa$_useInstanceObject(ExtractMethodController.this, true);
                    break block16;
                }
                SourceElement def = temp.getSourceElement();
                if (def != null && (v = (Var)this._varMap.get(def)) != null) {
                    SourceElement parent = exp.getParent();
                    int ptype = parent.getSymbolKind();
                    block0 : switch (ptype) {
                        case 48: {
                            SourceAssignmentExpression expr = (SourceAssignmentExpression)parent;
                            int oper = expr.getOperatorCode();
                            switch (oper) {
                                case 6: {
                                    if (expr.getFirstOperand() == exp) {
                                        this.writeTo(v, (SourceElement)exp);
                                        break;
                                    }
                                    this.readFrom(v, (SourceElement)exp);
                                    break;
                                }
                                case 2: 
                                case 57: {
                                    this.readFrom(v, (SourceElement)exp);
                                    if (expr.getFirstOperand() != exp) break block0;
                                    this.writeTo(v, (SourceElement)exp);
                                    break;
                                }
                                default: {
                                    this.readFrom(v, (SourceElement)exp);
                                    break;
                                }
                            }
                            break;
                        }
                        case 60: {
                            SourceUnaryExpression expr = (SourceUnaryExpression)parent;
                            int oper = expr.getOperatorCode();
                            switch (oper) {
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: {
                                    this.readFrom(v, (SourceElement)exp);
                                    this.writeTo(v, (SourceElement)exp);
                                    break block0;
                                }
                            }
                            this.readFrom(v, (SourceElement)exp);
                            break;
                        }
                        case 47: {
                            this.readFrom(v, (SourceElement)exp);
                            break;
                        }
                        case 49: 
                        case 51: 
                        case 53: {
                            this.readFrom(v, (SourceElement)exp);
                            break;
                        }
                        default: {
                            this.readFrom(v, (SourceElement)exp);
                            break;
                        }
                    }
                }
            }
        }
    }

    static class VarStates
    implements NodeBinding {
        private Var _var;
        private int _state;
        boolean isInside;

        public int getVarState(Var var) {
            if (var == this._var) {
                return this._state;
            }
            return 0;
        }

        public Var getVar() {
            return this._var;
        }

        public void setVarState(Var var, int state) {
            this._var = var;
            this._state = state;
        }

        public int getBindingType() {
            return 14;
        }

        public String NameFromState(int st) {
            switch (st) {
                case 0: {
                    return "U";
                }
                case 1: {
                    return "D";
                }
                case 2: {
                    return "R";
                }
                case 3: {
                    return "W";
                }
                case 4: {
                    return "RW";
                }
                case 5: {
                    return "WR";
                }
            }
            return "X";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.isInside) {
                sb.append(" I ");
            } else {
                sb.append("   ");
            }
            sb.append(" " + this._var + ":" + this.NameFromState(this._state));
            return sb.toString();
        }
    }

    static class Targets
    implements NodeBinding {
        private int _type;
        private HashSet _targets;

        public Targets(int type) {
            this._type = type;
            this._targets = new HashSet(2);
        }

        public void addTarget(Object o) {
            this._targets.add(o);
        }

        public Iterator getTargets() {
            return this._targets.iterator();
        }

        public SourceElement getUniqueElement() {
            if (this._targets.size() == 1) {
                return (SourceElement)this.getTargets().next();
            }
            return null;
        }

        public int getBindingType() {
            return this._type;
        }
    }
}

