/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.criteria.ExtractInterfaceCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceDialog;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeController;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class ExtractInterfaceController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    public static boolean canExtract(Context context, SourceClass sourceClass) {
        return ExtractInterfaceController.handle(context, sourceClass, false);
    }

    private boolean handle(Context context, boolean doit) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            if (sourceClass != null) {
                canHandle = ExtractInterfaceController.handle(context, sourceClass, doit);
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                        canHandle = ExtractInterfaceController.handle(context, sourceSourceClass, doit);
                    }
                }
            }
        }
        return canHandle;
    }

    private static boolean handle(Context context, SourceClass sourceClass, boolean doit) {
        SourceFile containingSourceFile;
        URL url;
        boolean ret = false;
        if (sourceClass != null && !sourceClass.isAnnotation() && Util.canRefactor(context, url = (containingSourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            ret = true;
            if (doit) {
                if (!sourceClass.isAnonymous()) {
                    if (ExtractInterfaceController.hasMembers(sourceClass)) {
                        ExtractInterfaceController.whenExtract(context, sourceClass);
                    } else {
                        Util.showRefactoringErrorMessage(RefactoringArb.getString(198), RefactoringArb.getString(243));
                    }
                } else {
                    Util.showRefactoringErrorMessage(RefactoringArb.getString(198), RefactoringArb.getString(281));
                }
            }
        }
        return ret;
    }

    public static void whenExtract(Context context, SourceClass sourceClass) {
        boolean tryAgain;
        ExtractInterfaceDialog extractInterfaceDialog = new ExtractInterfaceDialog(context, sourceClass);
        do {
            String fqClassName;
            Project project;
            JavaManager javaManager;
            SourceClass itfaceSourceClass;
            boolean replaceUsages;
            tryAgain = false;
            if (!extractInterfaceDialog.runDialog()) continue;
            String interfaceName = extractInterfaceDialog.getTypeName();
            String pkgName = extractInterfaceDialog.getPackage();
            JavaType[] selectedInterfaces = extractInterfaceDialog.getSelectedInterfaces();
            SourceMethod[] selectedMethods = extractInterfaceDialog.getSelectedMethods();
            SourceFieldVariable[] selectedFields = extractInterfaceDialog.getSelectedFields();
            boolean hasExtractedInterface = false;
            try {
                hasExtractedInterface = ExtractInterfaceController.extractInterface(context, sourceClass, pkgName, interfaceName, selectedInterfaces, selectedMethods, selectedFields);
            }
            catch (AbortedOperationException e) {
                tryAgain = true;
            }
            if (!hasExtractedInterface || !(replaceUsages = extractInterfaceDialog.hasReplaceUsages()) || (itfaceSourceClass = (javaManager = JavaManager.getJavaManager((Project)(project = context.getProject()))).getSourceClass(fqClassName = Util.getFqClassName(pkgName, interfaceName))) == null) continue;
            boolean preview = extractInterfaceDialog.hasPreview();
            UseSupertypeController.whenUseSupertype(context, sourceClass, itfaceSourceClass, preview);
        } while (tryAgain);
    }

    public static boolean extractInterface(Context context, SourceClass sourceClass, String pkgName, String interfaceName, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields) {
        boolean ret = false;
        ClassDescription sourceClassDescription = ClassDescription.createClassDescription((JavaClass)sourceClass);
        ExtractInterfaceCriteria criteria = new ExtractInterfaceCriteria(sourceClassDescription, pkgName, interfaceName, selectedInterfaces, selectedMethods, selectedFields);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        if (searchOperation.runRefactoring(false)) {
            ret = true;
        }
        return ret;
    }

    private static boolean hasMembers(SourceClass sourceClass) {
        List sourceMethods = sourceClass.getSourceMethods();
        for (SourceMethod sourceMethod : sourceMethods) {
            if (!ExtractInterfaceController.isExtractableMethod(sourceMethod)) continue;
            return true;
        }
        Collection declaredFields = sourceClass.getDeclaredFields();
        for (JavaField javaField : declaredFields) {
            SourceFieldVariable sourceFieldVariable;
            SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)javaField.getSourceElement();
            if (sourceMemberVariable.isEnumConstant() || !ExtractInterfaceController.isExtractableField(sourceFieldVariable = (SourceFieldVariable)sourceMemberVariable)) continue;
            return true;
        }
        return false;
    }

    static boolean isExtractableMethod(SourceMethod sourceMethod) {
        return sourceMethod.isPublic() && !sourceMethod.isStatic();
    }

    static boolean isExtractableField(SourceFieldVariable sourceField) {
        return sourceField.isPublic() && sourceField.isStatic() && sourceField.isFinal() && sourceField.getInitializer() != null;
    }
}

