/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceController;

public class ExtractInterfaceDialog
extends BaseDialog
implements ActionListener,
TreeCellCheckedListener {
    public static final String SETTINGS_KEY = "PREF_EXTRACT_INTERFACE";
    private static final int PREF_REPLACE_USAGES = 1;
    private static final int PREF_PREVIEW = 2;
    private JMutableTreeNode _root;
    private JCheckBox _previewCheckbox;
    private JCheckBox _replaceUsagesCheckbox;
    private final SourceClass _sourceClass;
    private JTextField _extractToPkg;
    private JTextField _extractToItfc;
    private CustomJTree _customJTree;
    private HashSet _declaredClasses;

    public ExtractInterfaceDialog(Context context, SourceClass sourceClass) {
        super(SETTINGS_KEY, context);
        this._sourceClass = sourceClass;
        this._declaredClasses = new HashSet();
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        List list = SourceElementAsList.asList((SourceElement)sourceClassBody, (int[])new int[]{3});
        int i = 0;
        while (i < list.size()) {
            SourceClass subClass = (SourceClass)list.get(i);
            if (!subClass.isStatic() && !subClass.isAnonymous()) {
                this._declaredClasses.add(subClass);
            }
            ++i;
        }
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(198);
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dextractinterface_html";
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.hasReplaceUsages());
        settings.setBit(2, this.hasPreview());
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    private void init() {
        CopyableInteger settings = this.getSettings();
        JLabel extractToPkgLabel = new JLabel();
        String pkgName = this._sourceClass.getPackageName();
        this._extractToPkg = new JTextField(pkgName);
        this.updateOnChanges(this._extractToPkg);
        ResourceUtils.resLabel((JLabel)extractToPkgLabel, (Component)this._extractToPkg, (String)RefactoringArb.getString(280));
        ClassPickerFactory.attach(this._extractToPkg, this.getContext(), 26);
        JLabel extractToItfcLabel = new JLabel();
        this._extractToItfc = new JTextField();
        this.updateOnChanges(this._extractToItfc);
        ResourceUtils.resLabel((JLabel)extractToItfcLabel, (Component)this._extractToItfc, (String)RefactoringArb.getString(220));
        this._root = this.createRoot();
        JLabel methodsLabel = new JLabel();
        this._customJTree = new CustomJTree(this._root);
        this._customJTree.setRootVisible(false);
        this._customJTree.setShowsRootHandles(false);
        this._customJTree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this._customJTree.enableToolTips(true);
        this._customJTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this.updateOnTreeCellChecked(this._customJTree);
        ResourceUtils.resLabel((JLabel)methodsLabel, (Component)this._customJTree, (String)RefactoringArb.getString(175));
        JScrollPane scrollPane = new JScrollPane((Component)this._customJTree);
        this._replaceUsagesCheckbox = new JCheckBox();
        this._replaceUsagesCheckbox.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._replaceUsagesCheckbox, (String)RefactoringArb.getString(110));
        this._replaceUsagesCheckbox.setSelected(settings.isBitSet(1));
        this._previewCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._previewCheckbox, (String)RefactoringArb.getString(2));
        this._previewCheckbox.setSelected(settings.isBitSet(2));
        JLabel message = new JLabel();
        message.setPreferredSize(extractToItfcLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)extractToPkgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._extractToPkg, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)extractToItfcLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._extractToItfc, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)methodsLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 1, insets, 0, 0));
        this.add((Component)this._replaceUsagesCheckbox, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._previewCheckbox, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 10, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        this.setPreferredSize(new Dimension(300, 350));
        this.whenReplaceUsagesChanges();
    }

    private JMutableTreeNode createRoot() {
        JMutableTreeNode root = new JMutableTreeNode("root");
        Icon interfaceIcon = OracleIcons.getIcon((String)"interface.png");
        Icon methodIcon = OracleIcons.getIcon((String)"method.png");
        Icon fieldIcon = OracleIcons.getIcon((String)"field.png");
        List sourceInterfaces = this._sourceClass.getSourceInterfaces();
        ArrayList<JavaType> resolvedTypes = new ArrayList<JavaType>();
        for (SourceTypeReference sourceType : sourceInterfaces) {
            JavaType resolvedType = sourceType.getResolvedType();
            if (resolvedType == null) continue;
            resolvedTypes.add(resolvedType);
        }
        Collections.sort(resolvedTypes, new 1());
        for (JavaType javaType : resolvedTypes) {
            String interfaceShortName = javaType.getName();
            MyCellData treeCellData = new MyCellData(javaType, interfaceIcon, interfaceShortName, true);
            treeCellData.setCheckBoxState(false);
            JMutableTreeNode mutableTreeNode = new JMutableTreeNode((JTreeCellData)treeCellData);
            root.add((MutableTreeNode)mutableTreeNode);
        }
        ArrayList methods = new ArrayList(this._sourceClass.getSourceMethods());
        Collections.sort(methods, new 2());
        for (SourceMethod sourceMethod : methods) {
            if (!ExtractInterfaceController.isExtractableMethod(sourceMethod)) continue;
            String fullMethodName = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false);
            MyCellData treeCellData = new MyCellData(sourceMethod, methodIcon, fullMethodName, true);
            treeCellData.setCheckBoxState(false);
            JMutableTreeNode mutableTreeNode = new JMutableTreeNode((JTreeCellData)treeCellData);
            root.add((MutableTreeNode)mutableTreeNode);
        }
        Collection declaredFields = this._sourceClass.getDeclaredFields();
        ArrayList fields = new ArrayList(declaredFields);
        Collections.sort(fields, new 3());
        for (SourceFieldVariable sourceField : fields) {
            if (!ExtractInterfaceController.isExtractableField(sourceField)) continue;
            String name = sourceField.getName();
            MyCellData treeCellData = new MyCellData(sourceField, fieldIcon, name, true);
            treeCellData.setCheckBoxState(false);
            JMutableTreeNode mutableTreeNode = new JMutableTreeNode((JTreeCellData)treeCellData);
            root.add((MutableTreeNode)mutableTreeNode);
        }
        return root;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = null;
            boolean isValid = true;
            String interfaceName = this.getTypeName();
            String pkgName = this.getPackage();
            String fqInterfaceName = this.getFQInterfaceName();
            if (interfaceName.length() == 0) {
                isValid = false;
            } else if (interfaceName.endsWith(".")) {
                isValid = false;
            } else if (pkgName.endsWith(".")) {
                isValid = false;
            } else if (pkgName.length() == 0) {
                message = RefactoringArb.getString(149);
                isValid = false;
            } else if (!NamingUtil.isPackageIdentifier((String)pkgName)) {
                message = RefactoringArb.getString(149);
                isValid = false;
            } else if (!NamingUtil.isJavaIdentifier((String)interfaceName)) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (interfaceName.lastIndexOf(36) >= 0) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)interfaceName)) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (this.isClassAlreadyPresent(fqInterfaceName)) {
                message = MessageFormat.format(RefactoringArb.getString(196), interfaceName);
                isValid = false;
            } else {
                SourceFieldVariable[] selectedFields = this.getSelectedFields();
                int i = 0;
                while (message == null && i < selectedFields.length) {
                    SourceFieldVariable selectedField = selectedFields[i];
                    SourceTypeReference fieldSourceType = selectedField.getSourceType();
                    List typeElements = SourceElementAsList.asList((SourceElement)fieldSourceType, (int[])new int[]{27});
                    String referedName = this.searchReference(typeElements);
                    if (referedName == null) {
                        SourceExpression initializer = selectedField.getInitializer();
                        List intializerElements = SourceElementAsList.asList((SourceElement)initializer, (int[])new int[]{27});
                        referedName = this.searchReference(intializerElements);
                    }
                    if (referedName != null) {
                        message = MessageFormat.format(RefactoringArb.getString(176), selectedField.getName(), referedName);
                    }
                    ++i;
                }
                SourceMethod[] selectedMethods = this.getSelectedMethods();
                int i2 = 0;
                while (message == null && i2 < selectedMethods.length) {
                    String refName;
                    SourceMethod selectedMethod = selectedMethods[i2];
                    List methodElements = SourceElementAsList.asList((SourceElement)selectedMethod, (int[])new int[]{27});
                    SourceBlock methodBody = selectedMethod.getBlock();
                    if (methodBody != null) {
                        List blockElements = SourceElementAsList.asList((SourceElement)methodBody);
                        methodElements.removeAll(blockElements);
                    }
                    if ((refName = this.searchReference(methodElements)) != null) {
                        message = MessageFormat.format(RefactoringArb.getString(230), Util.getFullMethodName((JavaMethod)selectedMethod, false, false, false), refName);
                    }
                    ++i2;
                }
                if (message != null) {
                    isValid = false;
                } else if (Util.hasUpperCase(pkgName)) {
                    message = RefactoringArb.getString(21);
                } else if (!Character.isUpperCase(interfaceName.charAt(0))) {
                    message = RefactoringArb.getString(37);
                }
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    private String searchReference(List elements) {
        int j = 0;
        while (j < elements.size()) {
            SourceTypeReference sourceType = (SourceTypeReference)elements.get(j);
            JavaType resolvedType = sourceType.getResolvedType();
            if (resolvedType != null && this._declaredClasses.contains(resolvedType)) {
                return resolvedType.getQualifiedName();
            }
            ++j;
        }
        return null;
    }

    public String getTypeName() {
        return this._extractToItfc.getText();
    }

    public String getPackage() {
        return this._extractToPkg.getText();
    }

    public String getFQInterfaceName() {
        return this.getPackage() + "." + this.getTypeName();
    }

    public SourceMethod[] getSelectedMethods() {
        ArrayList methods = this.getSelectedElements(SourceMethod.class);
        return methods.toArray(new SourceMethod[methods.size()]);
    }

    public SourceFieldVariable[] getSelectedFields() {
        ArrayList methods = this.getSelectedElements(SourceFieldVariable.class);
        return methods.toArray(new SourceFieldVariable[methods.size()]);
    }

    public JavaType[] getSelectedInterfaces() {
        ArrayList itfaces = this.getSelectedElements(JavaType.class);
        return itfaces.toArray(new JavaType[itfaces.size()]);
    }

    private ArrayList getSelectedElements(Class cls) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int childCount = this._root.getChildCount();
        int i = 0;
        while (i < childCount) {
            Object userObject;
            JMutableTreeNode mutableTreeNode = (JMutableTreeNode)this._root.getChildAt(i);
            MyCellData myCellData = (MyCellData)mutableTreeNode.getModel();
            if (myCellData.getCheckBoxState().isTrue() && cls.isInstance(userObject = myCellData.getUserObject())) {
                ret.add(userObject);
            }
            ++i;
        }
        return ret;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._extractToItfc;
    }

    private boolean isClassAlreadyPresent(String fqInterfaceName) {
        Context context = this.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceClass newClass = javaManager.getSourceClass(fqInterfaceName);
        return newClass != null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._replaceUsagesCheckbox) {
            this.whenReplaceUsagesChanges();
        }
    }

    private void whenReplaceUsagesChanges() {
        boolean hasReplaceUsages = this.hasReplaceUsages();
        this._previewCheckbox.setEnabled(hasReplaceUsages);
    }

    public boolean hasReplaceUsages() {
        return this._replaceUsagesCheckbox.isSelected();
    }

    public boolean hasPreview() {
        return this._previewCheckbox.isSelected();
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.whenTreeChecked(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.whenTreeChecked(e, false);
    }

    private void whenTreeChecked(TreeCellCheckedEvent e, boolean interfaceSelected) {
        JMutableTreeNode source = (JMutableTreeNode)e.getSource();
        MyCellData cellData = (MyCellData)source.getModel();
        Object userObject = cellData.getUserObject();
        if (userObject instanceof JavaType) {
            JavaType javaType = (JavaType)userObject;
            this.selectInterfaceMethods(javaType, interfaceSelected);
        }
    }

    private void selectInterfaceMethods(JavaType javaType, boolean interfaceSelected) {
        Collection declaredMethods = javaType.getDeclaredMethods();
        for (JavaMethod javaMethod : declaredMethods) {
            String signature = javaMethod.getSignature();
            Enumeration children = this._root.children();
            while (children.hasMoreElements()) {
                String signature_i;
                JMutableTreeNode treeNode = (JMutableTreeNode)children.nextElement();
                MyCellData myCellData = (MyCellData)treeNode.getModel();
                Object userObject_i = myCellData.getUserObject();
                if (!(userObject_i instanceof SourceMethod)) continue;
                SourceMethod sourceMethod_i = (SourceMethod)userObject_i;
                if (!javaMethod.getName().equals(sourceMethod_i.getName()) || !signature.equals(signature_i = sourceMethod_i.getSignature())) continue;
                myCellData.setEnabled(interfaceSelected ^ true);
                myCellData.setCheckBoxState(interfaceSelected);
            }
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            JavaType jotTypeInfo1 = (JavaType)o1;
            JavaType jotTypeInfo2 = (JavaType)o2;
            return jotTypeInfo1.getName().compareTo(jotTypeInfo2.getName());
        }
    }

    final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SourceMethod sourceMethod1 = (SourceMethod)o1;
            SourceMethod sourceMethod2 = (SourceMethod)o2;
            return sourceMethod1.getName().compareTo(sourceMethod2.getName());
        }
    }

    final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SourceFieldVariable sourceField1 = (SourceFieldVariable)o1;
            SourceFieldVariable sourceField2 = (SourceFieldVariable)o2;
            return sourceField1.getName().compareTo(sourceField2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyCellData
    extends JTreeCellData {
        public MyCellData(JavaType sourceType, Icon icon, String text, boolean hasCheckBox) {
            super(icon, text, hasCheckBox);
            this.setUserObject(sourceType);
        }

        public MyCellData(SourceMethod sourceMethod, Icon icon, String text, boolean hasCheckBox) {
            super(icon, text, hasCheckBox);
            this.setUserObject(sourceMethod);
        }

        public MyCellData(SourceFieldVariable sourceField, Icon icon, String text, boolean hasCheckBox) {
            super(icon, text, hasCheckBox);
            this.setUserObject(sourceField);
        }
    }
}

