/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.ExtractInterfaceCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class ExtractInterfaceURLHandler
extends URLRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483534: {
                ExtractInterfaceCriteria criteria = (ExtractInterfaceCriteria)searchCriteria;
                ClassDescription sourceClassDescription = criteria.getSourceClassDescription();
                String fqClassName = sourceClassDescription.getQualifiedName();
                ret = ExtractInterfaceURLHandler.getIncludedProjects(searchOperation, fqClassName);
                break;
            }
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet<URL> ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483534: {
                ExtractInterfaceCriteria criteria = (ExtractInterfaceCriteria)searchCriteria;
                URL url = this.getSourceUrl(criteria, project);
                if (url == null) break;
                ret = new HashSet<URL>(1);
                ret.add(url);
                break;
            }
        }
        return ret;
    }

    private URL getSourceUrl(ExtractInterfaceCriteria criteria, Project project) {
        SourceClass sourceClass;
        JavaManager javaManager;
        URL url = null;
        ClassDescription sourceClassDescription = criteria.getSourceClassDescription();
        JavaClass javaClass = sourceClassDescription.getJavaClass((JavaProvider)(javaManager = JavaManager.getJavaManager((Project)project)));
        if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
            SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
            url = owningSourceFile.getURL();
        }
        return url;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        return null;
    }

    public Node[] getAffectedNodes(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        Node[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        ExtractInterfaceCriteria criteria = (ExtractInterfaceCriteria)searchCriteria;
        URL sourceUrl = this.getSourceUrl(criteria, project);
        if (sourceUrl != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)sourceUrl);
                ret = new Node[]{node};
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        ExtractInterfaceCriteria criteria = (ExtractInterfaceCriteria)searchCriteria;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        ClassDescription sourceClassDescription = criteria.getSourceClassDescription();
        JavaClass javaClass = sourceClassDescription.getJavaClass((JavaProvider)javaManager);
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        Context context = searchOperation.getContext();
        JavaType[] selectedInterfaces = criteria.getSelectedInterfaces((JavaProvider)javaManager);
        SourceFieldVariable[] selectedFields = criteria.getSelectedFields((JavaProvider)javaManager);
        SourceMethod[] selectedMethods = criteria.getSelectedMethods((JavaProvider)javaManager);
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceClass itfaceSourceClass = ExtractInterfaceURLHandler.createInterface(context, refactoringCommandSupport, selectedInterfaces, selectedMethods, selectedFields, criteria.getPkgName(), criteria.getInterfaceName());
            refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
            List sourceInterfaces = sourceClass.getSourceInterfaces();
            ArrayList<SourceTypeReference> itfaceSourceTypesToRemove = new ArrayList<SourceTypeReference>();
            int i = 0;
            while (i < sourceInterfaces.size()) {
                SourceTypeReference sourceType = (SourceTypeReference)sourceInterfaces.get(i);
                JavaType resolvedType = sourceType.getResolvedType();
                if (resolvedType != null) {
                    int j = 0;
                    while (j < selectedInterfaces.length) {
                        JavaType selectedInterface = selectedInterfaces[j];
                        if (resolvedType.equals((Object)selectedInterface)) {
                            itfaceSourceTypesToRemove.add(sourceType);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < itfaceSourceTypesToRemove.size()) {
                SourceTypeReference sourceType = (SourceTypeReference)itfaceSourceTypesToRemove.get(i2);
                sourceType.removeSelf();
                ++i2;
            }
            SourceFile owningFile = sourceClass.getOwningSourceFile();
            SourceFactory subFactory = owningFile.getFactory();
            String itfaceFqName = itfaceSourceClass.getQualifiedName();
            SourceTypeReference itfaceSourceType = subFactory.createType(itfaceFqName);
            sourceInterfaces.add(itfaceSourceType);
            int i3 = 0;
            while (i3 < selectedFields.length) {
                SourceFieldVariable selectedField = selectedFields[i3];
                selectedField.removeSelf();
                ++i3;
            }
            int i4 = 0;
            while (i4 < selectedMethods.length) {
                SourceMethod selectedMethod = selectedMethods[i4];
                if (selectedMethod.isAbstract()) {
                    selectedMethod.removeSelf();
                }
                ++i4;
            }
            refactoringCommandSupport.setOpenCreatedFiles(true);
            ret = refactoringCommandSupport.commit(context, RefactoringArb.getString(75));
        }
        catch (AbortedOperationException e) {
            refactoringCommandSupport.abort();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private static SourceClass createInterface(Context context, RefactoringCommandSupport refactoringCommandSupport, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields, String pkgName, String interfaceName) {
        SourceInterfacesClause superClause;
        SourceFile sourceFile = refactoringCommandSupport.createSourceFile(context, pkgName, interfaceName);
        SourceFactory factory = sourceFile.getFactory();
        sourceFile.setPackageName(pkgName);
        if (selectedInterfaces.length > 0) {
            SourceTypeReference[] superItfaces = new SourceTypeReference[selectedInterfaces.length];
            int i = 0;
            while (i < selectedInterfaces.length) {
                JavaType selectedInterface = selectedInterfaces[i];
                superItfaces[i] = factory.createType(selectedInterface.getQualifiedName());
                ++i;
            }
            superClause = factory.createInterfacesClause(superItfaces);
        } else {
            superClause = null;
        }
        SourceMember[] sourceMembers = new SourceMember[selectedFields.length + selectedMethods.length];
        Arrays.sort(selectedFields, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        int i = 0;
        while (i < selectedFields.length) {
            String typeName;
            SourceFieldVariable variable = selectedFields[i];
            JavaType resolvedType = variable.getResolvedType();
            if (resolvedType == null) {
                SourceTypeReference sourceType = variable.getSourceType();
                typeName = sourceType.getName();
            } else {
                typeName = resolvedType.getQualifiedName();
            }
            SourceExpression initializer = variable.getInitializer();
            SourceExpression initializerExpression = initializer == null ? null : (SourceExpression)initializer.cloneSelf(sourceFile);
            SourceTypeReference fieldType = factory.createType(typeName);
            SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(24, fieldType, variable.getName(), initializerExpression);
            sourceMembers[i] = fieldDeclaration;
            ++i;
        }
        Arrays.sort(selectedMethods, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        int i2 = 0;
        while (i2 < selectedMethods.length) {
            SourceMethod selectedMethod = selectedMethods[i2];
            SourceMethod dupMethod = (SourceMethod)selectedMethod.cloneSelf(sourceFile);
            SourceBlock methodBlock = dupMethod.getBlock();
            if (methodBlock != null) {
                methodBlock.removeSelf();
            }
            dupMethod.removeModifiers(1047);
            dupMethod.addModifiers(1);
            sourceMembers[selectedFields.length + i2] = dupMethod;
            ++i2;
        }
        SourceClassBody classBody = factory.createClassBody(sourceMembers);
        SourceClass itface = factory.createClass(1, interfaceName, null, null, superClause, classBody);
        itface.addModifiers(1);
        itface.addSelf((SourceElement)sourceFile);
        return itface;
    }
}

