/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.inline;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.RadioKeyController;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.inline.InlineConstantCommand;
import oracle.jdevimpl.refactoring.oprs.inline.InlineMethodOperation;
import oracle.jdevimpl.refactoring.oprs.inline.InlineVariableCommand;

public class InlineController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        ElementAt elementAt;
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && Util.canRefactor(context) && (elementAt = ElementAt.findElementAt(context)) != null) {
            int type = elementAt.getElementType();
            switch (type) {
                case 5: {
                    SourceLocalVariable sourceLocalVariable;
                    SourceExpression initializer;
                    SourceElement sourceElement = elementAt.getSourceElement();
                    if (sourceElement.getSymbolKind() != 17 || (initializer = (sourceLocalVariable = (SourceLocalVariable)elementAt.getSourceElement()).getInitializer()) == null) break;
                    SourceFile sourceFile = sourceElement.getOwningSourceFile();
                    URL url = sourceFile.getURL();
                    canHandle = Util.canRefactor(url);
                    break;
                }
                case 4: {
                    SourceExpression initializer;
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                    if (sourceFieldVariable == null || !sourceFieldVariable.isStatic() || !sourceFieldVariable.isFinal() || (initializer = sourceFieldVariable.getInitializer()) == null || !InlineController.isConstant((SourceElement)initializer) || !Util.canRefactor((SourceElement)sourceFieldVariable)) break;
                    canHandle = true;
                    break;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    if (sourceMethod == null || !Util.canRefactor((SourceElement)sourceMethod)) break;
                    canHandle = true;
                    break;
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    private static boolean isConstant(SourceElement expression) {
        boolean ret = true;
        List children = expression.getChildren();
        if (children.size() == 0) {
            if (expression.getSymbolKind() != 52) {
                ret = false;
            }
        } else {
            int i = 0;
            while (ret && i < children.size()) {
                SourceElement child = (SourceElement)children.get(i);
                if (!InlineController.isConstant(child)) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            int type = elementAt.getElementType();
            block0 : switch (type) {
                case 5: {
                    SourceElement sourceElement = elementAt.getSourceElement();
                    if (sourceElement.getSymbolKind() != 17) break;
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)elementAt.getSourceElement();
                    SourceExpression contextExpression = InlineController.getUpdatedExpression(elementAt);
                    if (contextExpression != null) {
                        switch (InlineController.ask()) {
                            case 0: {
                                break block0;
                            }
                            case 1: {
                                InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable, contextExpression);
                                InlineController.invoke(inlineVariableCommand);
                                break block0;
                            }
                            case 2: {
                                InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable);
                                InlineController.invoke(inlineVariableCommand);
                                break block0;
                            }
                        }
                        break;
                    }
                    InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable);
                    InlineController.invoke(inlineVariableCommand);
                    break;
                }
                case 4: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                    SourceExpression contextExpression = InlineController.getUpdatedExpression(elementAt);
                    if (contextExpression != null) {
                        switch (InlineController.ask()) {
                            case 0: {
                                break block0;
                            }
                            case 1: {
                                InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable, contextExpression);
                                InlineController.invoke(inlineConstantCommand);
                                break block0;
                            }
                            case 2: {
                                InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable);
                                InlineController.invoke(inlineConstantCommand);
                                break block0;
                            }
                        }
                        break;
                    }
                    InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable);
                    InlineController.invoke(inlineConstantCommand);
                    break;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    String message = null;
                    if (sourceMethod != null) {
                        if (sourceMethod.getReturnType() != null) {
                            if (!sourceMethod.isAbstract()) {
                                SourceBlock block = sourceMethod.getBlock();
                                if (!InlineController.isReturnInMiddle((SourceElement)block)) {
                                    if (!this.hasRefToSuper(block)) {
                                        SourceMethodCallExpression methodCallExpression = this.getMethodCallExpression(elementAt);
                                        this.whenInlineMethod(context, sourceMethod, methodCallExpression);
                                    }
                                } else {
                                    message = RefactoringArb.getString(39);
                                }
                            } else {
                                message = RefactoringArb.getString(33);
                            }
                        } else {
                            message = RefactoringArb.getString(47);
                        }
                    }
                    if (message == null) break;
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)RefactoringArb.getString(248), null);
                    break;
                }
            }
        }
        return true;
    }

    private boolean hasRefToSuper(SourceBlock block) {
        ArrayList simpleNames = InlineMethodOperation.getMethodElements((SourceElement)block, (byte)57, new ArrayList());
        int i = 0;
        while (i < simpleNames.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)simpleNames.get(i);
            if ("super".equals(sourceSimpleNameExpression.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isReturnInMiddle(SourceElement sourceElement) {
        List children = sourceElement.getChildren();
        int childrenSize = children.size();
        int i = childrenSize - 2;
        while (i >= 0) {
            SourceElement childElement = (SourceElement)children.get(i);
            if (InlineController.containsReturnFromThis(childElement)) {
                return true;
            }
            --i;
        }
        SourceElement lastChild = (SourceElement)children.get(childrenSize - 1);
        if (lastChild != null) {
            switch (lastChild.getSymbolKind()) {
                case 39: {
                    SourceIfStatement sourceIfStatement = (SourceIfStatement)lastChild;
                    SourceStatement primaryClause = sourceIfStatement.getPrimaryClause();
                    SourceElseClause elseClause = sourceIfStatement.getElseClause();
                    return InlineController.isReturnInMiddle((SourceElement)primaryClause) || elseClause != null && InlineController.isReturnInMiddle((SourceElement)elseClause);
                }
                case 33: 
                case 38: 
                case 41: 
                case 45: {
                    return InlineController.containsReturnFromThis(lastChild);
                }
            }
        }
        return false;
    }

    private static boolean containsReturnFromThis(SourceElement sourceElement) {
        int symbolKind = sourceElement.getSymbolKind();
        switch (symbolKind) {
            case 3: {
                return false;
            }
            case 40: {
                return true;
            }
        }
        List children = sourceElement.getChildren();
        int i = 0;
        while (i < children.size()) {
            SourceElement childElement = (SourceElement)children.get(i);
            if (InlineController.containsReturnFromThis(childElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SourceMethodCallExpression getMethodCallExpression(ElementAt elementAt) {
        SourceElement sourceContext = elementAt.getSourceContext();
        while (sourceContext != null) {
            switch (sourceContext.getSymbolKind()) {
                case 19: {
                    return null;
                }
                case 53: {
                    return (SourceMethodCallExpression)sourceContext;
                }
            }
            sourceContext = sourceContext.getParent();
        }
        return null;
    }

    private static SourceExpression getUpdatedExpression(ElementAt elementAt) {
        SourceElement sourceElement = elementAt.getSourceContext();
        while (sourceElement != null && sourceElement.getSymbolKind() != 4) {
            if (sourceElement instanceof SourceExpression) {
                SourceExpression sourceExpression = (SourceExpression)sourceElement;
                return sourceExpression;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private static int ask() {
        JRadioButton changeThis = new JRadioButton(RefactoringArb.getString(274));
        changeThis.setSelected(true);
        JRadioButton changeAll = new JRadioButton(RefactoringArb.getString(95));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(changeThis);
        buttonGroup.add(changeAll);
        RadioKeyController.attach((ButtonGroup)buttonGroup);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)changeThis, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)changeAll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(351), 3);
        dialog.setContent((Component)panel);
        if (dialog.runDialog()) {
            if (changeThis.isSelected()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private static void invoke(Command command) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            commandProcessor.invoke(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void whenInlineMethod(Context context, SourceMethod sourceMethod, SourceMethodCallExpression sourceMethodCallExpression) {
        int ret = sourceMethodCallExpression != null ? InlineController.ask() : 2;
        switch (ret) {
            case 0: {
                break;
            }
            case 1: {
                InlineMethodOperation inlineMethodOperation = new InlineMethodOperation();
                inlineMethodOperation.whenInlineMethod(context, sourceMethod, new SourceMethodCallExpression[]{sourceMethodCallExpression});
                break;
            }
            case 2: {
                InlineMethodOperation inlineMethodOperation = new InlineMethodOperation();
                inlineMethodOperation.whenInlineMethod(context, sourceMethod);
                break;
            }
        }
    }
}

