/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.inline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class InlineMethodOperation {
    private ArrayList _derefThis;
    private ArrayList _derefFieldAccess;
    private ArrayList _derefMethodCall;

    private void $init$() {
        this._derefThis = new ArrayList();
        this._derefFieldAccess = new ArrayList();
        this._derefMethodCall = new ArrayList();
    }

    public void whenInlineMethod(Context context, SourceMethod sourceMethod) {
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)sourceMethod);
        ArrayList methodDeclarations = new ArrayList();
        ArrayList sourceInvokeExpressions = new ArrayList();
        FindMemberUsages.FillListsUsageListener usageListener = new FindMemberUsages.FillListsUsageListener(methodDeclarations, sourceInvokeExpressions, null);
        findMemberUsages.findMemberUsages(context.getProject(), usageListener);
        SourceMethodCallExpression[] sourceMethodCallExpressions = sourceInvokeExpressions.toArray(new SourceMethodCallExpression[sourceInvokeExpressions.size()]);
        this.inlineMethods(context, sourceMethod, sourceMethodCallExpressions, true);
    }

    void whenInlineMethod(Context context, SourceMethod sourceMethod, SourceMethodCallExpression[] sourceMethodCallExpressions) {
        this.inlineMethods(context, sourceMethod, sourceMethodCallExpressions, false);
    }

    private void inlineMethods(Context context, SourceMethod sourceMethod, SourceMethodCallExpression[] sourceMethodCallExpressions, boolean removeMethod) {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceFile methodSourceFile = sourceMethod.getOwningSourceFile();
            SourceFactory methodFactory = methodSourceFile.getFactory();
            SourceBlock originalBlock = sourceMethod.getBlock();
            int i = 0;
            while (i < sourceMethodCallExpressions.length) {
                SourceElement lastElement;
                SourceMethodCallExpression sourceMethodCallExpression = sourceMethodCallExpressions[i];
                HashSet variablesInScope = this.getDeclaredVariablesNameInScope((SourceElement)sourceMethodCallExpression);
                SourceFile callSourceFile = sourceMethodCallExpression.getOwningSourceFile();
                boolean isSameFile = callSourceFile.equals(methodSourceFile);
                SourceBlock methodBlock = (SourceBlock)originalBlock.cloneSelf(methodSourceFile);
                SourceReturnStatement lastReturnStatement = null;
                List children = methodBlock.getChildren();
                int childCount = children.size();
                if (childCount > 0 && (lastElement = (SourceElement)children.get(childCount - 1)).getSymbolKind() == 40) {
                    lastReturnStatement = (SourceReturnStatement)lastElement;
                }
                refactoringCommandSupport.beginTransaction((SourceElement)callSourceFile);
                SourceTransaction methodTransaction = null;
                if (!isSameFile) {
                    methodTransaction = methodSourceFile.beginTransaction();
                }
                try {
                    boolean shouldDeref;
                    SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
                    boolean bl = shouldDeref = lhsOperand != null;
                    if (shouldDeref) {
                        this.collectDerefElements(methodBlock);
                    }
                    List sourceParameters = sourceMethod.getSourceParameters();
                    int argumentCount = sourceMethodCallExpression.getArgumentCount();
                    String[] tempVarNames = new String[argumentCount];
                    int j = 0;
                    while (j < argumentCount) {
                        SourceExpression replaceWithExpression;
                        SourceExpression argumentAt = sourceMethodCallExpression.getArgumentAt(j);
                        SourceVariable param = (SourceVariable)sourceParameters.get(j);
                        String paramName = param.getName();
                        switch (argumentAt.getSymbolKind()) {
                            case 52: 
                            case 57: {
                                replaceWithExpression = argumentAt;
                                break;
                            }
                            default: {
                                String newVariableName = this.getNewVariableName(variablesInScope, paramName);
                                String newParamName = newVariableName != null ? newVariableName : paramName;
                                tempVarNames[j] = newParamName;
                                replaceWithExpression = methodFactory.createSimpleNameExpression(newParamName);
                                break;
                            }
                        }
                        if (replaceWithExpression != null) {
                            this.replaceVariableName(methodBlock, methodSourceFile, paramName, replaceWithExpression);
                        }
                        ++j;
                    }
                    this.replaceVariableUsages(variablesInScope, sourceMethod.getOwningClass(), methodSourceFile, methodFactory, (SourceElement)methodBlock);
                    if (shouldDeref) {
                        this.dereferenceInstAccesses(methodSourceFile, lhsOperand);
                    }
                    SourceFactory callFactory = callSourceFile.getFactory();
                    SourceElement methodCallStmt = Util.getStatementLevelElement((SourceElement)sourceMethodCallExpression);
                    int j2 = 0;
                    while (j2 < tempVarNames.length) {
                        String tempVarName = tempVarNames[j2];
                        if (tempVarName != null) {
                            SourceVariable param = (SourceVariable)sourceParameters.get(j2);
                            SourceTypeReference paramSourceType = param.getSourceType();
                            SourceTypeReference tempVarSourceType = (SourceTypeReference)paramSourceType.cloneSelf(callSourceFile);
                            SourceExpression argumentAt = (SourceExpression)sourceMethodCallExpression.getArgumentAt(j2).cloneSelf(callSourceFile);
                            SourceLocalVariableDeclaration localVariableDeclaration = callFactory.createLocalVariableDeclaration(tempVarSourceType, tempVarName, argumentAt);
                            localVariableDeclaration.addSelfBefore(methodCallStmt);
                        }
                        ++j2;
                    }
                    String returnedVarName = null;
                    boolean insertBefore = true;
                    SourceElement methodCallParent = sourceMethodCallExpression.getParent();
                    int methodCallParentKind = methodCallParent.getSymbolKind();
                    if (lastReturnStatement == null) {
                        switch (methodCallParentKind) {
                            case 36: {
                                this.removeReturnStmts(methodFactory, methodBlock);
                                break;
                            }
                            case 17: {
                                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)methodCallParent;
                                String lhsText = sourceLocalVariable.getName();
                                this.replaceReturnStmtWithAssignment(methodBlock, methodFactory, lhsText, methodSourceFile);
                                insertBefore = false;
                                break;
                            }
                            case 48: {
                                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)methodCallParent;
                                SourceExpression firstOperand = sourceAssignmentExpression.getFirstOperand();
                                String lhsText = firstOperand.getText();
                                this.replaceReturnStmtWithAssignment(methodBlock, methodFactory, lhsText, methodSourceFile);
                                break;
                            }
                            default: {
                                String newVariableName;
                                returnedVarName = sourceMethod.getName();
                                if (returnedVarName.startsWith("get") && returnedVarName.length() > 4) {
                                    char c = returnedVarName.charAt(3);
                                    returnedVarName = Character.toLowerCase(c) + returnedVarName.substring(4);
                                }
                                if ((newVariableName = this.getNewVariableName(variablesInScope, returnedVarName)) != null) {
                                    returnedVarName = newVariableName;
                                }
                                SourceTypeReference paramSourceType = sourceMethod.getSourceReturnType();
                                SourceTypeReference tempVarSourceType = (SourceTypeReference)paramSourceType.cloneSelf(callSourceFile);
                                SourceLocalVariableDeclaration localVariableDeclaration = callFactory.createLocalVariableDeclaration(tempVarSourceType, returnedVarName);
                                localVariableDeclaration.addSelfBefore(methodCallStmt);
                                this.replaceReturnStmtWithAssignment(methodBlock, methodFactory, returnedVarName, methodSourceFile);
                                break;
                            }
                        }
                    } else {
                        switch (methodCallParentKind) {
                            case 36: {
                                this.removeReturnStmts(methodFactory, methodBlock);
                                break;
                            }
                            default: {
                                SourceExpression expression = lastReturnStatement.getExpression();
                                if (expression == null) break;
                                SourceElement dupExpression = expression.cloneSelf(callSourceFile);
                                sourceMethodCallExpression.replaceSelf(dupExpression);
                                lastReturnStatement.removeSelf();
                                break;
                            }
                        }
                    }
                    Object inlinedBlock = !isSameFile ? methodBlock.cloneSelf(callSourceFile) : methodBlock;
                    List inlinedStmtList = inlinedBlock.getChildren();
                    SourceElement[] inlinedStmts = inlinedStmtList.toArray(new SourceElement[inlinedStmtList.size()]);
                    if (insertBefore) {
                        int j3 = 0;
                        while (j3 < inlinedStmts.length) {
                            SourceElement inlinedStmt = inlinedStmts[j3];
                            SourceElement inlinedStmtClone = inlinedStmt.cloneSelf(callSourceFile);
                            inlinedStmtClone.addSelfBefore(methodCallStmt);
                            ++j3;
                        }
                    } else {
                        int j4 = inlinedStmtList.size() - 1;
                        while (j4 >= 0) {
                            SourceElement inlinedStmt = (SourceElement)inlinedStmtList.get(j4);
                            SourceElement inlinedStmtClone = inlinedStmt.cloneSelf(callSourceFile);
                            inlinedStmtClone.addSelfAfter(methodCallStmt);
                            --j4;
                        }
                    }
                    if (lastReturnStatement == null) {
                        switch (methodCallParentKind) {
                            case 36: 
                            case 48: {
                                methodCallStmt.removeSelf();
                                break;
                            }
                            case 17: {
                                sourceMethodCallExpression.removeSelf();
                                break;
                            }
                            default: {
                                SourceSimpleNameExpression simpleNameExpression = callFactory.createSimpleNameExpression(returnedVarName);
                                sourceMethodCallExpression.replaceSelf((SourceElement)simpleNameExpression);
                                break;
                            }
                        }
                    } else {
                        switch (methodCallParentKind) {
                            case 36: {
                                methodCallStmt.removeSelf();
                                break;
                            }
                        }
                    }
                }
                finally {
                    if (methodTransaction != null) {
                        methodTransaction.abort();
                    }
                }
                ++i;
            }
            if (removeMethod) {
                refactoringCommandSupport.beginTransaction((SourceElement)sourceMethod);
                sourceMethod.removeSelf();
            }
            refactoringCommandSupport.commit(context, RefactoringArb.getString(248));
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private void collectDerefElements(SourceBlock methodBlock) {
        ArrayList sourceSimpleNameExpressions = InlineMethodOperation.getMethodElements((SourceElement)methodBlock, (byte)57, new ArrayList());
        ArrayList sourceMethodCallExpressions = InlineMethodOperation.getMethodElements((SourceElement)methodBlock, (byte)53, new ArrayList());
        int i = 0;
        while (i < sourceSimpleNameExpressions.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceSimpleNameExpressions.get(i);
            String expressionName = sourceSimpleNameExpression.getName();
            if ("this".equals(expressionName)) {
                this._derefThis.add(sourceSimpleNameExpression);
            } else {
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                if (resolvedObject != null && resolvedObject.getElementKind() == 5) {
                    this._derefFieldAccess.add(sourceSimpleNameExpression);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sourceMethodCallExpressions.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceMethodCallExpressions.get(i2);
            if (sourceMethodCallExpression.getLhsOperand() == null) {
                boolean isStatic = false;
                JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                if (resolvedMethod != null) {
                    isStatic = resolvedMethod.isStatic();
                }
                if (!isStatic) {
                    this._derefMethodCall.add(sourceMethodCallExpression);
                }
            }
            ++i2;
        }
    }

    private void dereferenceInstAccesses(SourceFile sourceFile, SourceExpression lhsOperand) {
        SourceFactory callFactory = sourceFile.getFactory();
        int i = 0;
        while (i < this._derefThis.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)this._derefThis.get(i);
            SourceElement newLhs = lhsOperand.cloneSelf(sourceFile);
            sourceSimpleNameExpression.replaceSelf(newLhs);
            ++i;
        }
        int i2 = 0;
        while (i2 < this._derefFieldAccess.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)this._derefFieldAccess.get(i2);
            SourceExpression newLhs = (SourceExpression)lhsOperand.cloneSelf(sourceFile);
            String name = sourceSimpleNameExpression.getName();
            SourceDotExpression dotExpression = callFactory.createDotReference(newLhs, name);
            sourceSimpleNameExpression.replaceSelf((SourceElement)dotExpression);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this._derefMethodCall.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)this._derefMethodCall.get(i3);
            SourceExpression newLhs = (SourceExpression)lhsOperand.cloneSelf(sourceFile);
            sourceMethodCallExpression.setLhsOperand(newLhs);
            ++i3;
        }
    }

    private void removeReturnStmts(SourceFactory methodFactory, SourceBlock methodBlock) {
        ArrayList returnStmts = InlineMethodOperation.getMethodElements((SourceElement)methodBlock, (byte)40, new ArrayList());
        int i = 0;
        while (i < returnStmts.size()) {
            SourceReturnStatement sourceReturnStatement = (SourceReturnStatement)returnStmts.get(i);
            SourceExpression sourceExpression = sourceReturnStatement.getExpression();
            this.unreturn(methodFactory, sourceReturnStatement, (SourceElement)sourceExpression);
            sourceReturnStatement.removeSelf();
            ++i;
        }
    }

    private void unreturn(SourceFactory methodFactory, SourceReturnStatement sourceReturnStatement, SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 53: 
            case 55: {
                SourceExpression sourceExpression = (SourceExpression)sourceElement;
                SourceExpression sourceExpressionClone = (SourceExpression)sourceExpression.cloneSelf(sourceExpression.getOwningSourceFile());
                SourceExpressionStatement expressionStatement = methodFactory.createExpressionStatement(sourceExpressionClone);
                expressionStatement.addSelfAfter((SourceElement)sourceReturnStatement);
                break;
            }
            default: {
                List children = sourceElement.getChildren();
                int i = children.size() - 1;
                while (i >= 0) {
                    SourceElement element = (SourceElement)children.get(i);
                    this.unreturn(methodFactory, sourceReturnStatement, element);
                    --i;
                }
                break block0;
            }
        }
    }

    private void replaceReturnStmtWithAssignment(SourceBlock methodBlock, SourceFactory methodFactory, String lhsText, SourceFile sourceFile) {
        ArrayList returnStmts = InlineMethodOperation.getMethodElements((SourceElement)methodBlock, (byte)40, new ArrayList());
        int i = 0;
        while (i < returnStmts.size()) {
            SourceReturnStatement sourceReturnStatement = (SourceReturnStatement)returnStmts.get(i);
            SourceExpression rhs = sourceReturnStatement.getExpression();
            SourceExpression rhsClone = (SourceExpression)rhs.cloneSelf(sourceFile);
            SourceExpression lhs = methodFactory.createExpression(lhsText);
            SourceAssignmentExpression assignment = methodFactory.createAssignment(6, lhs, rhsClone);
            SourceExpressionStatement assigmentStmt = methodFactory.createExpressionStatement((SourceExpression)assignment);
            sourceReturnStatement.replaceSelf((SourceElement)assigmentStmt);
            ++i;
        }
    }

    static ArrayList getMethodElements(SourceElement sourceElement, byte symbolKind, ArrayList list) {
        int symbolKind_i = sourceElement.getSymbolKind();
        if (symbolKind_i != 3) {
            if (symbolKind_i == symbolKind) {
                list.add(sourceElement);
            }
            List children = sourceElement.getChildren();
            int i = 0;
            while (i < children.size()) {
                SourceElement child = (SourceElement)children.get(i);
                InlineMethodOperation.getMethodElements(child, symbolKind, list);
                ++i;
            }
        }
        return list;
    }

    private void replaceVariableUsages(HashSet variablesInScope, JavaClass methodOwningClass, SourceFile methodSourceFile, SourceFactory methodSourceFactory, SourceElement parent) {
        switch (parent.getSymbolKind()) {
            case 13: 
            case 17: {
                SourceBlock owningBlock;
                SourceVariable sourceVariable = (SourceVariable)parent;
                String name = sourceVariable.getName();
                String newVariableName = this.getNewVariableName(variablesInScope, name);
                if (newVariableName == null) break;
                sourceVariable.setName(newVariableName);
                if (sourceVariable instanceof SourceLocalVariable) {
                    SourceLocalVariable localVariable = (SourceLocalVariable)sourceVariable;
                    owningBlock = localVariable.getOwningBlock();
                } else {
                    SourceFormalParameter parameter = (SourceFormalParameter)sourceVariable;
                    owningBlock = parameter.getOwningBlock();
                }
                SourceSimpleNameExpression newExpression = methodSourceFactory.createSimpleNameExpression(newVariableName);
                this.replaceVariableName(owningBlock, methodSourceFile, name, (SourceExpression)newExpression);
                break;
            }
            case 3: {
                break;
            }
            case 57: {
                SourceSimpleNameExpression name = (SourceSimpleNameExpression)parent;
                if (!"this".equals(name.getName())) break;
                SourceSimpleNameExpression clsExpr = methodSourceFactory.createSimpleNameExpression(methodOwningClass.getName());
                SourceDotExpression dotExpr = methodSourceFactory.createDotReference((SourceExpression)clsExpr, "this");
                name.replaceSelf((SourceElement)dotExpr);
                break;
            }
            default: {
                List children = parent.getChildren();
                int i = 0;
                while (i < children.size()) {
                    SourceElement childElement = (SourceElement)children.get(i);
                    this.replaceVariableUsages(variablesInScope, methodOwningClass, methodSourceFile, methodSourceFactory, childElement);
                    ++i;
                }
                break block0;
            }
        }
    }

    private void replaceVariableName(SourceBlock block, SourceFile methodSourceFile, String oldName, SourceExpression newExpression) {
        List list = SourceElementAsList.asList((SourceElement)block, (int[])new int[]{57});
        int i = 0;
        while (i < list.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(i);
            if (oldName.equals(sourceSimpleNameExpression.getName())) {
                SourceElement exprClone = newExpression.cloneSelf(methodSourceFile);
                sourceSimpleNameExpression.replaceSelf(exprClone);
            }
            ++i;
        }
    }

    private String getNewVariableName(HashSet variablesInScope, String paramName) {
        if (paramName != null && variablesInScope.contains(paramName)) {
            int i = 1;
            while (true) {
                String ret;
                if (!variablesInScope.contains(ret = paramName + i)) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    private HashSet getDeclaredVariablesNameInScope(SourceElement sourceElement) {
        HashSet<String> ret = new HashSet<String>();
        boolean done = false;
        while (!done) {
            switch (sourceElement.getSymbolKind()) {
                case 4: {
                    done = true;
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    List sourceParameters = sourceMethod.getSourceParameters();
                    int i = 0;
                    while (i < sourceParameters.size()) {
                        SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
                        String variableName = sourceVariable.getName();
                        ret.add(variableName);
                        ++i;
                    }
                    return ret;
                }
                case 2: {
                    List children = sourceElement.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        SourceElement childElement = (SourceElement)children.get(i);
                        if (childElement.getSymbolKind() == 18) {
                            SourceLocalVariableDeclaration sourceLocalsDeclaration = (SourceLocalVariableDeclaration)childElement;
                            List variables = sourceLocalsDeclaration.getVariables();
                            int j = 0;
                            while (j < variables.size()) {
                                SourceVariable sourceVariable = (SourceVariable)variables.get(j);
                                String variableName = sourceVariable.getName();
                                ret.add(variableName);
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 38: {
                    SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                    SourceLocalVariableDeclaration sourceLocalsDeclaration = sourceForStatement.getForVariableDeclaration();
                    List variables = sourceLocalsDeclaration.getVariables();
                    int j = 0;
                    while (j < variables.size()) {
                        SourceVariable sourceVariable = (SourceVariable)variables.get(j);
                        String variableName = sourceVariable.getName();
                        ret.add(variableName);
                        ++j;
                    }
                    break;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return ret;
    }

    public InlineMethodOperation() {
        this.$init$();
    }
}

