/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.inline;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.Visitor;

public class InlineVariableCommand
extends Command {
    private static final int CMD_ID = Ide.findOrCreateCmdID((String)InlineVariableCommand.class.getName());
    private SourceLocalVariable _sourceLocalVariable;
    private SourceExpression _expression;
    private UndoableEdit _undoableEdit;

    public InlineVariableCommand(Context context, SourceLocalVariable sourceLocalVariable, SourceExpression expression) {
        super(CMD_ID, 0);
        this._sourceLocalVariable = sourceLocalVariable;
        this._expression = expression;
        this.setContext(context);
    }

    public InlineVariableCommand(Context context, SourceLocalVariable sourceLocalVariable) {
        this(context, sourceLocalVariable, null);
    }

    public String getName() {
        return RefactoringArb.getString(165);
    }

    public int doit() throws Exception {
        if (this._undoableEdit == null) {
            this._undoableEdit = this.inline();
            this._sourceLocalVariable = null;
            this._expression = null;
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    public int undo() throws Exception {
        this._undoableEdit.undo();
        return 0;
    }

    private UndoableEdit inline() {
        UndoableEdit ret = null;
        SourceFile owningFile = this._sourceLocalVariable.getOwningSourceFile();
        SourceTransaction sourceTransaction = owningFile.beginTransaction();
        try {
            boolean removeDeclaration;
            String name = this._sourceLocalVariable.getName();
            SourceExpression initializer = this._sourceLocalVariable.getInitializer();
            ArrayList usages = new ArrayList();
            1 visitor = new 1(this, name, usages);
            SourceBlock scope = this._sourceLocalVariable.getOwningBlock();
            visitor.visit((SourceElement)scope);
            if (this._expression == null) {
                int i = 0;
                while (i < usages.size()) {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)usages.get(i);
                    SourceElement dupExpression = initializer.cloneSelf(owningFile);
                    this.inlineElement((SourceElement)sourceSimpleNameExpression, dupExpression);
                    ++i;
                }
                removeDeclaration = true;
            } else {
                int i = 0;
                while (i < usages.size()) {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)usages.get(i);
                    if (sourceSimpleNameExpression.equals(this._expression)) {
                        SourceElement dupExpression = initializer.cloneSelf(owningFile);
                        this.inlineElement((SourceElement)sourceSimpleNameExpression, dupExpression);
                    }
                    ++i;
                }
                boolean bl = removeDeclaration = usages.size() == 1;
            }
            if (removeDeclaration) {
                this._sourceLocalVariable.removeSelf();
            }
            ret = sourceTransaction.commit();
        }
        catch (Exception e) {
            sourceTransaction.rollback();
            e.printStackTrace();
        }
        return ret;
    }

    private void inlineElement(SourceElement oldElement, SourceElement newElement) {
        SourceElement parent = oldElement.getParent();
        if (parent.getSymbolKind() == 50 && newElement.getSymbolKind() == 50) {
            SourceInfixExpression infixExpr = (SourceInfixExpression)parent;
            SourceInfixExpression subInfixExpr = (SourceInfixExpression)newElement;
            int code = infixExpr.getOperatorCode();
            if (code == subInfixExpr.getOperatorCode()) {
                SourceFile file = oldElement.getOwningSourceFile();
                SourceFactory factory = file.getFactory();
                List oldOperands = infixExpr.getOperands();
                List subOperands = subInfixExpr.getOperands();
                ArrayList<SourceExpression> newOperands = new ArrayList<SourceExpression>();
                for (SourceExpression oldOperand : oldOperands) {
                    if (oldOperand.equals(oldElement)) {
                        for (SourceExpression subOperand : subOperands) {
                            newOperands.add((SourceExpression)subOperand.cloneSelf(file));
                        }
                        continue;
                    }
                    newOperands.add((SourceExpression)oldOperand.cloneSelf(file));
                }
                SourceInfixExpression newInfixExpression = factory.createInfixExpression(code, newOperands.toArray(new SourceExpression[0]));
                infixExpr.replaceSelf((SourceElement)newInfixExpression);
                return;
            }
        }
        oldElement.replaceSelf(newElement);
    }

    private SourceInfixExpression partOfInfixExpr(SourceElement element) {
        SourceElement parent = element.getParent();
        while (parent != null && parent.getSymbolKind() != 2) {
            if (parent.getSymbolKind() == 50) {
                return (SourceInfixExpression)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    static SourceLocalVariable ra$_sourceLocalVariable(InlineVariableCommand inlineVariableCommand) {
        return inlineVariableCommand._sourceLocalVariable;
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ String v$name;
        private final /* synthetic */ ArrayList v$usages;
        final /* synthetic */ InlineVariableCommand this$0;

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject;
            String exprName = sourceSimpleNameExpression.getName();
            if (this.v$name.equals(exprName) && (resolvedObject = sourceSimpleNameExpression.getResolvedObject()).equals(InlineVariableCommand.ra$_sourceLocalVariable(this.this$0))) {
                this.v$usages.add(sourceSimpleNameExpression);
            }
        }

        public 1(InlineVariableCommand inlineVariableCommand, String string, ArrayList arrayList) {
            this.v$usages = arrayList;
            this.v$name = string;
            this.this$0 = inlineVariableCommand;
        }
    }
}

