/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.SourceElementComparator;

public abstract class IntroduceController
implements Controller {
    protected abstract void replaceExpression(Context var1, SourceExpression var2);

    protected abstract void replaceVariable(Context var1, SourceVariable var2);

    protected boolean isOKtoReplaceVariable() {
        return true;
    }

    public final boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handleEvent(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        this.handleEvent(context, true);
        return true;
    }

    private final boolean handleEvent(Context context, boolean doit) {
        View view;
        JavaNode javaNode;
        URL url;
        Node node;
        Project project;
        boolean ret = false;
        if (context != null && context.getWorkspace() != null && (project = context.getProject()) != null && (node = context.getNode()) instanceof JavaNode && Util.canRefactor(url = (javaNode = (JavaNode)node).getURL()) && (view = context.getView()) instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            ret = this.handleEvent(context, codeEditor, javaNode, doit);
        }
        return ret;
    }

    private boolean handleEvent(Context context, CodeEditor codeEditor, JavaNode javaNode, boolean doit) {
        boolean ret = false;
        Project project = context.getProject();
        int caretPosition = codeEditor.getCaretPosition();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        if (javaManager != null) {
            int cursorAt;
            SourceElement elementAt;
            int selectionEnd;
            URL url = javaNode.getURL();
            SourceFile sourceFile = javaManager.getSourceFile(url);
            int selectionStart = codeEditor.getSelectionStart();
            if (selectionStart == (selectionEnd = codeEditor.getSelectionEnd())) {
                elementAt = Patch.getElementAt((SourceElement)sourceFile, caretPosition);
                cursorAt = selectionStart;
            } else {
                SourceElement elementAtStart = Patch.getElementAt((SourceElement)sourceFile, selectionStart);
                SourceElement elementAtEnd = Patch.getElementAt((SourceElement)sourceFile, selectionEnd);
                elementAt = IntroduceController.getCommonParent(elementAtStart, elementAtEnd);
                if (doit && elementAt != null) {
                    codeEditor.setSelectionStart(elementAt.getStartOffset());
                    codeEditor.setSelectionEnd(elementAt.getEndOffset());
                }
                cursorAt = -1;
            }
            if (elementAt != null) {
                ret = this.whenIntroduce(context, elementAt, doit, cursorAt);
            }
        }
        return ret;
    }

    private static SourceElement getCommonParent(SourceElement leftElement, SourceElement rightElement) {
        HashSet<SourceElement> leftParents = new HashSet<SourceElement>();
        SourceElement parent = leftElement;
        while (parent != null) {
            leftParents.add(parent);
            parent = parent.getParent();
        }
        SourceElement parent2 = rightElement;
        while (parent2 != null) {
            if (leftParents.contains(parent2)) {
                return parent2;
            }
            parent2 = parent2.getParent();
        }
        return null;
    }

    protected boolean whenIntroduce(Context context, SourceElement sourceElement, boolean doit, int cursorAt) {
        SourceElement annotationParent = Util.getAncestorOfKind(1, sourceElement);
        if (annotationParent == null) {
            while (sourceElement != null) {
                int symbolKind = sourceElement.getSymbolKind();
                if (46 <= symbolKind && symbolKind < 62 && symbolKind != 51 && symbolKind != 61) {
                    boolean ret = false;
                    SourceExpression sourceExpression = (SourceExpression)sourceElement;
                    SourceExpression bestExpression = this.getBestExpression(sourceExpression, cursorAt);
                    if (this.isAcceptableExpression(bestExpression)) {
                        ret = true;
                        if (doit) {
                            this.replaceExpression(context, bestExpression);
                        }
                    }
                    return ret;
                }
                if (symbolKind == 36) {
                    SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceElement;
                    boolean ret = false;
                    SourceExpression expression = sourceExpressionStatement.getExpression();
                    if (this.isAcceptableExpression(expression)) {
                        ret = true;
                        if (doit) {
                            this.replaceExpression(context, expression);
                        }
                    }
                    return ret;
                }
                if (symbolKind == 17) {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement;
                    boolean ret = false;
                    if (!this.declaredInStatement(sourceLocalVariable.getOwningDeclaration())) {
                        ret = true;
                        if (doit) {
                            this.replaceVariable(context, (SourceVariable)sourceLocalVariable);
                        } else {
                            ret = this.isOKtoReplaceVariable();
                        }
                    }
                    return ret;
                }
                if (symbolKind == 18) {
                    boolean ret = false;
                    SourceLocalVariableDeclaration sourceLocalsDeclaration = (SourceLocalVariableDeclaration)sourceElement;
                    List variables = sourceLocalsDeclaration.getVariables();
                    if (variables.size() == 1 && !this.dependsOnStatement((SourceElement)sourceLocalsDeclaration)) {
                        ret = true;
                        if (doit) {
                            SourceVariable sourceVariable = (SourceVariable)variables.get(0);
                            this.replaceVariable(context, sourceVariable);
                        } else {
                            ret = this.isOKtoReplaceVariable();
                        }
                    }
                    return ret;
                }
                if (symbolKind == 13) {
                    SourceFormalParameter sourceFormalParameter = (SourceFormalParameter)sourceElement;
                    if (doit) {
                        this.replaceVariable(context, (SourceVariable)sourceFormalParameter);
                    }
                    return true;
                }
                if (symbolKind == 19 || symbolKind == 6 || symbolKind == 3) break;
                sourceElement = sourceElement.getParent();
            }
            if (doit) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(177));
            }
        }
        return false;
    }

    private SourceExpression getBestExpression(SourceExpression sourceExpression, int cursorAt) {
        SourceExpression parentExpression;
        SourceExpression betterExpression;
        SourceElement parent = sourceExpression.getParent();
        if (parent.getStartOffset() == cursorAt && parent instanceof SourceExpression && (betterExpression = this.getBestExpression(parentExpression = (SourceExpression)parent, cursorAt)) != null) {
            return betterExpression;
        }
        if (this.isAcceptableExpression(sourceExpression)) {
            return sourceExpression;
        }
        return null;
    }

    private boolean isAcceptableExpression(SourceExpression sourceExpression) {
        String qualifiedName;
        JavaType resolvedType;
        JavaElement compiledObject;
        boolean ret = false;
        if (!(sourceExpression == null || this.dependsOnStatement((SourceElement)sourceExpression) || (compiledObject = sourceExpression.getCompiledObject()) != null && compiledObject.getElementKind() == 3 || (resolvedType = sourceExpression.getResolvedType()) == null || "void".equals(qualifiedName = resolvedType.getQualifiedName()))) {
            ret = true;
        }
        return ret;
    }

    private boolean declaredInStatement(SourceVariableDeclaration owningDeclaration) {
        boolean ret = false;
        SourceElement parent = owningDeclaration.getParent();
        int symbolKind = parent.getSymbolKind();
        switch (symbolKind) {
            case 31: 
            case 38: {
                ret = true;
            }
        }
        return ret;
    }

    private boolean dependsOnStatement(SourceElement sourceElement) {
        SourceElement statementAncestor = Util.getAncestorOfClass(SourceStatement.class, sourceElement);
        if (statementAncestor != null) {
            List simpleNames = SourceElementAsList.asList((SourceElement)sourceElement, (int)57);
            int i = 0;
            while (i < simpleNames.size()) {
                SourceVariable sourceLocalVariable;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)simpleNames.get(i);
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                if (resolvedObject != null && resolvedObject.getElementKind() == 7 && (sourceLocalVariable = (SourceVariable)resolvedObject.getSourceElement()) != null && Patch.contains(statementAncestor, (SourceElement)sourceLocalVariable) && !Patch.contains(sourceElement, (SourceElement)sourceLocalVariable)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static SourceElement getInsertBeforeElement(SourceExpression[] replacableExpressions) {
        SourceExpression parent = replacableExpressions[0];
        while (parent != null) {
            if (parent.getSymbolKind() == 2) {
                boolean containsAll = true;
                int i = 1;
                while (containsAll && i < replacableExpressions.length) {
                    SourceExpression replacableExpression = replacableExpressions[i];
                    if (!Patch.contains((SourceElement)parent, (SourceElement)replacableExpression)) {
                        containsAll = false;
                    }
                    ++i;
                }
                if (containsAll) {
                    List children = parent.getChildren();
                    int i2 = 0;
                    while (i2 < children.size()) {
                        SourceElement insertBefore = (SourceElement)children.get(i2);
                        int j = 0;
                        while (j < replacableExpressions.length) {
                            SourceExpression replacableExpression = replacableExpressions[j];
                            if (Patch.contains(insertBefore, (SourceElement)replacableExpression)) {
                                return insertBefore;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    static boolean dependsOnLocal(SourceElement sourceElement) {
        List list = SourceElementAsList.asList((SourceElement)sourceElement, (int[])new int[]{57});
        int i = 0;
        while (i < list.size()) {
            int elementKind;
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(i);
            JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
            if (resolvedObject != null && (elementKind = resolvedObject.getElementKind()) == 7) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static final SourceExpression[] getReplacableExpressions(SourceExpression sourceExpression) {
        SourceExpression[] replacableExpressions;
        SourceElement expressionParent = sourceExpression.getParent();
        if (expressionParent instanceof SourceExpressionStatement) {
            replacableExpressions = new SourceExpression[]{sourceExpression};
        } else {
            SourceElementComparator sourceElementComparator = new SourceElementComparator();
            SourceElement scope = Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceExpression);
            sourceElementComparator.findDuplicates(sourceExpression, scope);
            replacableExpressions = sourceElementComparator.getDuplicates();
        }
        return replacableExpressions;
    }
}

