/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public final class IntroduceDataMemberDialog
extends IntroduceDialog
implements ActionListener {
    public static final int ASSIGN_IN_METHOD = 1;
    public static final int ASSIGN_IN_DECL = 2;
    public static final int ASSIGN_IN_CTOR = 3;
    private static final int PREF_ASSIGN_IN_METHOD = 1;
    private static final int PREF_ASSIGN_IN_DECL = 2;
    private static final int PREF_ASSIGN_IN_CTOR = 4;
    private final boolean _constant;
    public static final String PREFERENCE_KEY = "INTRODUCE_FIELD_PREFS";
    private JComboBox _nameComponent;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;
    private JRadioButton _radioMethod;
    private JRadioButton _radioDecl;
    private JRadioButton _radioCtor;
    private boolean _userHasChangedAssignment;

    public IntroduceDataMemberDialog(Context context, SourceElement expression, boolean isConstant, SourceElement[] replacableExpressions) {
        super(PREFERENCE_KEY, context, expression, replacableExpressions);
        this._constant = isConstant;
    }

    protected void init() {
        JPanel assignPanel;
        CopyableInteger settings = this.getSettings();
        JLabel nameLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(275));
        ComboBoxEditor editor = this._nameComponent.getEditor();
        JTextField nameTextField = (JTextField)editor.getEditorComponent();
        Document document = nameTextField.getDocument();
        document.addDocumentListener(new 1());
        int occurenceCount = this.getOccurenceCount();
        if (occurenceCount > 1) {
            this._replaceAll = new JCheckBox();
            String label = RefactoringArb.getString(100);
            String formatedText = MessageFormat.format(label, Integer.toString(occurenceCount));
            ResourceUtils.resButton((AbstractButton)this._replaceAll, (String)formatedText);
        }
        JComboBox typeComponent = this.createTypeComponent();
        JLabel typeLabel = null;
        if (typeComponent != null) {
            typeLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)typeLabel, (Component)typeComponent, (String)RefactoringArb.getString(178));
        }
        SourceMember parentMember = (SourceMember)Util.getAncestorOfClass(SourceMember.class, this._sourceElement);
        boolean isStatic = BitField.isSet((int)parentMember.getModifiers(), (int)8);
        SourceClass enclosingClass = parentMember.getEnclosingClass();
        boolean isAnonymous = enclosingClass.isAnonymous();
        if (!this._constant) {
            boolean isInConstructorCall = Util.isInCallToConstructor(this._sourceElement);
            boolean dependsOnLocal = IntroduceController.dependsOnLocal(this._sourceElement);
            boolean hasConstructors = this.hasConstructors();
            boolean isInFieldInitializer = Util.getAncestorOfClass(SourceFieldVariable.class, this._sourceElement) != null;
            boolean canAssignInMethod = !isInConstructorCall && !isInFieldInitializer;
            boolean canAssignInDecl = !dependsOnLocal;
            boolean canAssignInCtor = hasConstructors && !isAnonymous && !dependsOnLocal && !isStatic && !isInFieldInitializer;
            assignPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            assignPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(122)));
            ButtonGroup buttonGroup = new ButtonGroup();
            String assMtdLabel = RefactoringArb.getString(191);
            this._radioMethod = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._radioMethod, (String)assMtdLabel);
            this._radioMethod.setEnabled(canAssignInMethod);
            buttonGroup.add(this._radioMethod);
            assignPanel.add(this._radioMethod);
            this._radioMethod.addActionListener(this);
            String assDeclLabel = RefactoringArb.getString(66);
            this._radioDecl = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._radioDecl, (String)assDeclLabel);
            this._radioDecl.setEnabled(canAssignInDecl);
            buttonGroup.add(this._radioDecl);
            assignPanel.add(this._radioDecl);
            this._radioDecl.addActionListener(this);
            String assCtorLabel = RefactoringArb.getString(154);
            this._radioCtor = new JRadioButton();
            this._radioCtor.setEnabled(canAssignInCtor);
            ResourceUtils.resButton((AbstractButton)this._radioCtor, (String)assCtorLabel);
            buttonGroup.add(this._radioCtor);
            assignPanel.add(this._radioCtor);
            this._radioCtor.addActionListener(this);
            if (canAssignInDecl && settings.isBitSet(2)) {
                this._radioDecl.setSelected(true);
            } else if (canAssignInCtor && settings.isBitSet(4)) {
                this._radioCtor.setSelected(true);
            } else if (canAssignInMethod && settings.isBitSet(1)) {
                this._radioMethod.setSelected(true);
            }
            if (buttonGroup.getSelection() == null) {
                if (this._radioMethod.isEnabled()) {
                    this._radioMethod.setSelected(true);
                } else if (this._radioDecl.isEnabled()) {
                    this._radioDecl.setSelected(true);
                } else if (this._radioCtor.isEnabled()) {
                    this._radioCtor.setSelected(true);
                }
            }
        } else {
            assignPanel = null;
        }
        JLabel message = new JLabel();
        message.setPreferredSize(nameLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        if (typeComponent != null) {
            this.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this.add((Component)typeComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        if (this._replaceAll != null) {
            this.add((Component)this._replaceAll, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        if (assignPanel != null) {
            this.add((Component)assignPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    private boolean hasConstructors() {
        SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, this._sourceElement.getParent());
        Collection declaredConstructors = sourceClass.getDeclaredConstructors();
        return declaredConstructors.isEmpty() ^ true;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected String getHelpTopicID() {
        return this._constant ? "f1_jrf_dintroduceconst_html" : "f1_jrf_dintroducefield_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String fieldName = this.getFieldName();
            NameValidation nameValidation = NameValidation.validateFieldName(fieldName, this._constant, this._sourceElement);
            String message = nameValidation.getMessage();
            boolean isValid = nameValidation.isValid();
            if (this.getAssignPlacement() == 0) {
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getTitle() {
        return this._constant ? RefactoringArb.getString(56) : RefactoringArb.getString(326);
    }

    protected int getDefaultPreferences() {
        return 1;
    }

    protected void updateSettings(CopyableInteger settings) {
        if (this._userHasChangedAssignment) {
            int assignPlacement = this.getAssignPlacement();
            settings.setBit(1, assignPlacement == 1);
            settings.setBit(2, assignPlacement == 2);
            settings.setBit(4, assignPlacement == 3);
        }
    }

    protected void fillSuggestedNames() {
        JavaType selectedJavaType = this.getSelectedJavaType();
        JavaType componentType = selectedJavaType.isArray() ? selectedJavaType.getComponentType() : selectedJavaType;
        String rawName = componentType.getRawName();
        List<String> names = this._constant ? VariableNaming.suggestConstantNames(this._sourceElement, rawName) : VariableNaming.suggestFieldNames(this._sourceElement, rawName);
        String preferredName = names.isEmpty() ? "" : names.get(0).toString();
        boolean userChangedName = this._userChangedName;
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object currentName = editor.getItem();
        this._nameModel.removeAllElements();
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            this._nameModel.addElement((Object)name);
            ++i;
        }
        Object newName = userChangedName ? currentName : preferredName;
        editor.setItem(newName);
        this._userChangedName = userChangedName;
    }

    public String getFieldName() {
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object item = editor.getItem();
        return item.toString();
    }

    public int getAssignPlacement() {
        if (!this._constant) {
            return this._radioMethod.isSelected() ? 1 : (this._radioDecl.isSelected() ? 2 : 3);
        }
        return 2;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._radioMethod || source == this._radioDecl || source == this._radioCtor) {
            this._userHasChangedAssignment = true;
        }
    }

    static void wa$_userChangedName(IntroduceDataMemberDialog introduceDataMemberDialog, boolean bl) {
        introduceDataMemberDialog._userChangedName = bl;
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }

        public void removeUpdate(DocumentEvent e) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }

        public void changedUpdate(DocumentEvent e) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }
    }
}

