/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import oracle.ide.Context;
import oracle.ide.model.Displayable;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.util.ExpressionUtil;

abstract class IntroduceDialog
extends BaseDialog
implements ItemListener {
    private final int _occurenceCount;
    protected JCheckBox _replaceAll;
    private ArrayList _validTypes;
    private JComboBox _typeComponent;
    protected final SourceElement _sourceElement;
    private JavaType _selectedType;
    private static String _boundFqTypeName = null;

    protected abstract void fillSuggestedNames();

    protected abstract void init();

    IntroduceDialog(String preferenceKey, Context context, SourceElement sourceElement, SourceElement[] replacableExpressions) {
        super(preferenceKey, context);
        this._sourceElement = sourceElement;
        this._occurenceCount = replacableExpressions == null ? 0 : replacableExpressions.length;
    }

    public final boolean runDialog() {
        this.init();
        return super.runDialog();
    }

    protected final JComboBox createTypeComponent() {
        this._typeComponent = null;
        ArrayList validTypes = this.getValidTypes();
        int validTypeSize = validTypes.size();
        switch (validTypeSize) {
            case 0: {
                this._selectedType = null;
                break;
            }
            case 1: {
                this._selectedType = (JavaType)validTypes.get(0);
                break;
            }
            default: {
                JavaType[] items = new JavaType[validTypeSize];
                int i = 0;
                while (i < validTypeSize) {
                    JavaType validType = (JavaType)validTypes.get(i);
                    items[i] = new DisplaybleAdapter(validType, null);
                    ++i;
                }
                JComboBox<JavaType> comboBox = new JComboBox<JavaType>(items);
                comboBox.addItemListener(this);
                comboBox.setSelectedIndex(0);
                this._typeComponent = comboBox;
                this._selectedType = items[0];
                break;
            }
        }
        return this._typeComponent;
    }

    private static ArrayList getValidTypes(SourceExpression expression) {
        ArrayList<JavaType> validTypes = new ArrayList<JavaType>();
        JavaType resolvedType = expression.getResolvedType();
        boolean isRecognizedType = true;
        if (resolvedType != null) {
            String qualifiedName;
            JavaType baseComponentType;
            if (resolvedType.isArray() && (baseComponentType = resolvedType.getBaseComponentType()).isPrimitive() && "null".equals(qualifiedName = baseComponentType.getQualifiedName())) {
                isRecognizedType = false;
            }
        } else {
            isRecognizedType = false;
        }
        if (isRecognizedType) {
            validTypes.add(0, resolvedType);
            if (!resolvedType.isArray()) {
                JavaType expectedType = ExpressionUtil.getExpectedType(expression);
                Set resolvedHierarchy = resolvedType.getHierarchy();
                validTypes.addAll(resolvedHierarchy);
                if (expectedType != null) {
                    SourceElement parent = expression.getParent();
                    while (!(parent instanceof JavaClass)) {
                        parent = parent.getParent();
                    }
                    JavaClass invokingClass = (JavaClass)parent;
                    String invokingPackageName = invokingClass.getPackageName();
                    int i = validTypes.size() - 1;
                    while (i >= 0) {
                        JavaType validType = (JavaType)validTypes.get(i);
                        boolean isValidType = false;
                        boolean isAssignableFrom = expectedType.isAssignableFrom(validType);
                        if (isAssignableFrom) {
                            if (validType.isPublic()) {
                                isValidType = true;
                            } else if (validType.isPackagePrivate()) {
                                if (invokingPackageName.equals(validType.getPackageName())) {
                                    isValidType = true;
                                }
                            } else if (validType.isProtected()) {
                                if (validType.isAssignableFrom((JavaType)invokingClass)) {
                                    isValidType = true;
                                } else if (invokingPackageName.equals(validType.getPackageName())) {
                                    isValidType = true;
                                }
                            }
                        }
                        if (!isValidType) {
                            validTypes.remove(i);
                        }
                        --i;
                    }
                }
            }
        } else {
            JavaType expectedType = ExpressionUtil.getExpectedType(expression);
            if (expectedType != null) {
                validTypes.add(expectedType);
            }
        }
        return validTypes;
    }

    private static ArrayList getValidTypes(Context context, SourceExpression expression) {
        ArrayList<JavaType> validTypes = new ArrayList<JavaType>();
        JavaType resolvedType = IntroduceDialog.getResolvedType(expression);
        boolean isRecognizedType = true;
        if (resolvedType != null) {
            JavaClass javaClass;
            JavaElement javaElement;
            if (resolvedType.isArray()) {
                String qualifiedName;
                JavaType baseComponentType = resolvedType.getBaseComponentType();
                if (baseComponentType.isPrimitive() && "null".equals(qualifiedName = baseComponentType.getQualifiedName())) {
                    isRecognizedType = false;
                }
            } else if (resolvedType instanceof JavaTypeVariable && (javaElement = resolvedType.getOwner()) instanceof JavaClass && !(javaClass = (JavaClass)javaElement).getResolvedType().hasActualTypeArguments()) {
                resolvedType = CommonUtilities.getTypeErasure((JavaTypeVariable)((JavaTypeVariable)resolvedType));
            }
        } else {
            isRecognizedType = false;
        }
        if (isRecognizedType) {
            validTypes.add(0, resolvedType);
            if (!resolvedType.isArray()) {
                JavaType expectedType = ExpressionUtil.getExpectedType(expression);
                Set resolvedHierarchy = resolvedType.getHierarchy();
                validTypes.addAll(resolvedHierarchy);
                if (expectedType != null) {
                    SourceElement parent = expression.getParent();
                    while (!(parent instanceof JavaClass)) {
                        parent = parent.getParent();
                    }
                    JavaClass invokingClass = (JavaClass)parent;
                    String invokingPackageName = invokingClass.getPackageName();
                    int i = validTypes.size() - 1;
                    while (i >= 0) {
                        JavaType validType = (JavaType)validTypes.get(i);
                        boolean isValidType = false;
                        boolean isAssignableFrom = expectedType.isAssignableFrom(validType);
                        if (isAssignableFrom) {
                            if (validType.isPublic()) {
                                isValidType = true;
                            } else if (validType.isPackagePrivate()) {
                                if (invokingPackageName.equals(validType.getPackageName())) {
                                    isValidType = true;
                                }
                            } else if (validType.isProtected()) {
                                if (validType.isAssignableFrom((JavaType)invokingClass)) {
                                    isValidType = true;
                                } else if (invokingPackageName.equals(validType.getPackageName())) {
                                    isValidType = true;
                                }
                            }
                        } else if (expression.getParent().getSymbolKind() == 59) {
                            isValidType = true;
                        }
                        if (!isValidType) {
                            validTypes.remove(i);
                        }
                        --i;
                    }
                }
            }
        } else {
            JavaType expectedType = ExpressionUtil.getExpectedType(expression);
            if (expectedType != null) {
                validTypes.add(expectedType);
            }
        }
        return validTypes;
    }

    private ArrayList getValidTypes() {
        return this._validTypes;
    }

    private void setValidTypes(ArrayList validTypes) {
        this._validTypes = validTypes;
    }

    public final void setValidTypesFromExpression(SourceExpression expression) {
        _boundFqTypeName = null;
        ArrayList validTypes = IntroduceDialog.getValidTypes(expression);
        this.setValidTypes(validTypes);
    }

    public final void setValidTypesFromExpression(Context context, SourceExpression expression) {
        _boundFqTypeName = null;
        ArrayList validTypes = IntroduceDialog.getValidTypes(context, expression);
        this.setValidTypes(validTypes);
    }

    protected final int getOccurenceCount() {
        return this._occurenceCount;
    }

    public final void itemStateChanged(ItemEvent e) {
        this.fillSuggestedNames();
    }

    final boolean isReplaceAll() {
        return this._replaceAll != null && this._replaceAll.isSelected();
    }

    protected JavaType getSelectedJavaType() {
        JavaType ret = this._typeComponent != null ? (JavaType)this._typeComponent.getSelectedItem() : this._selectedType;
        return ret;
    }

    protected String getSelectedTypeName() {
        String ret;
        if (this._typeComponent != null) {
            JavaType selectedItem = (JavaType)this._typeComponent.getSelectedItem();
            ret = selectedItem.getQualifiedName();
        } else {
            ret = this._selectedType == null ? "java.lang.Object" : (_boundFqTypeName != null ? _boundFqTypeName : this._selectedType.getQualifiedName());
        }
        return ret;
    }

    private static JavaType getResolvedType(SourceExpression expression) {
        SourceNewClassExpression newClassExpr;
        SourceTypeReference typeRef;
        if (expression.getSymbolKind() == 55 && (typeRef = (newClassExpr = (SourceNewClassExpression)expression).getSourceType()) != null) {
            return typeRef.getResolvedType();
        }
        return expression.getResolvedType();
    }

    private class DisplaybleAdapter
    extends AbstractType
    implements Displayable {
        private JavaType _type;

        private DisplaybleAdapter(JavaType type) {
            this._type = type;
        }

        public String getShortLabel() {
            return null;
        }

        public String getLongLabel() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public String toString() {
            return this._type.getQualifiedName();
        }

        public int getElementKind() {
            return this._type.getElementKind();
        }

        public String getName() {
            return null;
        }

        public String getQualifiedName() {
            return this._type.getQualifiedName();
        }

        public String getVMName() {
            return this._type.getVMName();
        }

        public String getDescriptor() {
            return this._type.getDescriptor();
        }

        public String getUniqueIdentifier() {
            return this._type.getUniqueIdentifier();
        }

        public JavaClass getTypeErasure() {
            return this._type.getTypeErasure();
        }

        public String getTypeSignature() {
            return this._type.getTypeSignature();
        }

        public JavaFile getFile() {
            return this._type.getFile();
        }

        DisplaybleAdapter(JavaType javaType, 1 var3_3) {
            this(javaType);
        }

        public final class 1 {
        }
    }
}

