/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDataMemberDialog;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceFieldFromParamDialog;
import oracle.jdevimpl.refactoring.util.SourceElementComparator;
import oracle.jdevimpl.refactoring.util.Visitor;

public final class IntroduceFieldController
extends IntroduceController {
    private final boolean _isConstant;
    private final String _operationName;

    public IntroduceFieldController(boolean isConstant) {
        this._isConstant = isConstant;
        this._operationName = this._isConstant ? RefactoringArb.getString(11) : RefactoringArb.getString(127);
    }

    protected void replaceExpression(Context context, SourceExpression sourceExpression) {
        SourceSimpleNameExpression sourceSimpleNameExpression;
        JavaHasType resolvedObject;
        SourceElement simpleNameElement;
        SourceFormalParameter parameter = null;
        if (sourceExpression.getSymbolKind() == 57 && (simpleNameElement = (resolvedObject = (sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression).getResolvedObject()).getSourceElement()) != null && simpleNameElement.getSymbolKind() == 13) {
            parameter = (SourceFormalParameter)simpleNameElement;
        }
        if (parameter != null) {
            this.introduceFromParameter(context, parameter, sourceExpression);
        } else if (!this._isConstant || IntroduceFieldController.isConstantExpression(sourceExpression)) {
            SourceExpression[] replacableExpressions = IntroduceFieldController.findDuplicates(sourceExpression);
            IntroduceDataMemberDialog dialog = new IntroduceDataMemberDialog(context, (SourceElement)sourceExpression, this._isConstant, (SourceElement[])replacableExpressions);
            dialog.setValidTypesFromExpression(sourceExpression);
            if (dialog.runDialog()) {
                String fieldName = dialog.getFieldName();
                String dataType = dialog.getSelectedTypeName();
                int assignPlacement = dialog.getAssignPlacement();
                boolean isStaticContext = Util.isStaticContext(sourceExpression);
                SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
                SourceFactory factory = owningSourceFile.getFactory();
                SourceClass owningClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression);
                RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                try {
                    switch (assignPlacement) {
                        case 3: {
                            this.createField(factory, owningClass, dataType, fieldName, null, isStaticContext);
                            this.addInitializerToCtors(factory, owningClass, fieldName, sourceExpression);
                            break;
                        }
                        case 2: {
                            this.createField(factory, owningClass, dataType, fieldName, sourceExpression, isStaticContext);
                            break;
                        }
                        case 1: {
                            this.createField(factory, owningClass, dataType, fieldName, null, isStaticContext);
                            SourceExpressionStatement expressionStatement = IntroduceFieldController.needsPrefix((SourceElement)sourceExpression, fieldName) ? IntroduceFieldController.createFieldAssigment(factory, "this." + fieldName, sourceExpression) : IntroduceFieldController.createFieldAssigment(factory, fieldName, sourceExpression);
                            SourceElement insertBeforeElement = dialog.isReplaceAll() ? IntroduceFieldController.getInsertBeforeElement(replacableExpressions) : Util.getStatementLevelElement((SourceElement)sourceExpression);
                            expressionStatement.addSelfBefore(insertBeforeElement);
                            break;
                        }
                    }
                    if (dialog.isReplaceAll()) {
                        int i = 0;
                        while (i < replacableExpressions.length) {
                            SourceExpression replacableExpression = replacableExpressions[i];
                            this.replaceExpressionWithFieldAccess(replacableExpression, fieldName, factory);
                            ++i;
                        }
                    } else {
                        this.replaceExpressionWithFieldAccess(sourceExpression, fieldName, factory);
                    }
                    refactoringCommandSupport.commit(context, this._operationName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    refactoringCommandSupport.abort();
                }
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(235));
        }
    }

    private void replaceExpressionWithFieldAccess(SourceExpression sourceExpression, String fieldName, SourceFactory factory) {
        Object fieldAccessExpression = IntroduceFieldController.needsPrefix((SourceElement)sourceExpression, fieldName) ? factory.createExpression("this." + fieldName) : factory.createSimpleNameExpression(fieldName);
        sourceExpression.replaceSelf((SourceElement)fieldAccessExpression);
    }

    private static SourceExpression[] findDuplicates(SourceExpression sourceExpression) {
        SourceExpression[] duplicates;
        int i;
        SourceElement scope = Util.getAncestorOfClass(SourceMember.class, (SourceElement)sourceExpression);
        boolean isInMethod = false;
        if (scope != null && ((i = scope.getSymbolKind()) == 19 || i == 6)) {
            isInMethod = true;
        }
        if (isInMethod) {
            SourceElementComparator sourceElementComparator = new SourceElementComparator();
            sourceElementComparator.findDuplicates(sourceExpression, scope);
            duplicates = sourceElementComparator.getDuplicates();
        } else {
            duplicates = new SourceExpression[]{sourceExpression};
        }
        return duplicates;
    }

    protected void replaceVariable(Context context, SourceVariable sourceVariable) {
        if (sourceVariable.getSymbolKind() == 13) {
            this.introduceFromParameter(context, (SourceFormalParameter)sourceVariable, null);
        } else {
            this.introduceFromInitialiser(context, sourceVariable);
        }
    }

    private void introduceFromInitialiser(Context context, SourceVariable sourceVariable) {
        if (this.isValidOperation(sourceVariable)) {
            SourceExpression sourceExpression = sourceVariable.getInitializer();
            IntroduceDataMemberDialog dialog = new IntroduceDataMemberDialog(context, (SourceElement)sourceExpression, this._isConstant, new SourceElement[0]);
            dialog.setValidTypesFromExpression(context, sourceExpression);
            if (dialog.runDialog()) {
                String fieldName = dialog.getFieldName();
                String dataType = dialog.getSelectedTypeName();
                int assignPlacement = dialog.getAssignPlacement();
                boolean isStaticContext = Util.isStaticContext(sourceExpression);
                SourceFile owningSourceFile = sourceVariable.getOwningSourceFile();
                SourceFactory factory = owningSourceFile.getFactory();
                SourceClass owningClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceVariable);
                RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                try {
                    refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                    ArrayList usages = this.getUsages(sourceVariable, fieldName);
                    switch (assignPlacement) {
                        case 3: {
                            this.createField(factory, owningClass, dataType, fieldName, null, isStaticContext);
                            IntroduceFieldController.replaceVariableInstances(factory, usages, fieldName);
                            this.addInitializerToCtors(factory, owningClass, fieldName, sourceExpression);
                            sourceVariable.removeSelf();
                            break;
                        }
                        case 2: {
                            this.createField(factory, owningClass, dataType, fieldName, sourceExpression, isStaticContext);
                            sourceVariable.removeSelf();
                            IntroduceFieldController.replaceVariableInstances(factory, usages, fieldName);
                            break;
                        }
                        case 1: {
                            this.createField(factory, owningClass, dataType, fieldName, null, isStaticContext);
                            IntroduceFieldController.replaceVariableInstances(factory, usages, fieldName);
                            SourceExpressionStatement expressionStatement = this.needsPrefix(sourceVariable, fieldName) ? IntroduceFieldController.createFieldAssigment(factory, "this." + fieldName, sourceExpression) : IntroduceFieldController.createFieldAssigment(factory, fieldName, sourceExpression);
                            SourceVariableDeclaration owningDeclaration = sourceVariable.getOwningDeclaration();
                            if (owningDeclaration.getVariables().size() > 1) {
                                expressionStatement.addSelfAfter((SourceElement)owningDeclaration);
                                sourceVariable.removeSelf();
                                break;
                            }
                            owningDeclaration.replaceSelf((SourceElement)expressionStatement);
                            break;
                        }
                    }
                    refactoringCommandSupport.commit(context, this._operationName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    refactoringCommandSupport.abort();
                }
            }
        }
    }

    private boolean isValidOperation(SourceVariable sourceVariable) {
        String errorMessage = null;
        SourceExpression initializer = sourceVariable.getInitializer();
        if (initializer == null) {
            errorMessage = RefactoringArb.getString(355);
        } else if (this._isConstant) {
            if (!IntroduceFieldController.isConstantExpression(initializer)) {
                errorMessage = RefactoringArb.getString(235);
            } else if (this.isAssigned(sourceVariable)) {
                errorMessage = RefactoringArb.getString(257);
            }
        }
        if (errorMessage == null) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errorMessage);
        return false;
    }

    private boolean isAssigned(SourceVariable sourceVariable) {
        SourceVariableDeclaration owningDeclaration = sourceVariable.getOwningDeclaration();
        SourceElement scope = owningDeclaration.getParent();
        List list = SourceElementAsList.asList((SourceElement)scope, (int[])new int[]{53, 27, 57});
        int i = 0;
        while (i < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(i);
            switch (sourceElement.getSymbolKind()) {
                case 48: {
                    JavaHasType resolvedObject;
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement;
                    SourceExpression firstOperand = sourceAssignmentExpression.getFirstOperand();
                    if (firstOperand == null || firstOperand.getSymbolKind() != 57) break;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)firstOperand;
                    if (!sourceVariable.getName().equals(sourceSimpleNameExpression.getName()) || !sourceVariable.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) break;
                    return true;
                }
                case 60: {
                    SourceUnaryExpression sourceUnaryExpression = (SourceUnaryExpression)sourceElement;
                    int operatorCode = sourceUnaryExpression.getOperatorCode();
                    switch (operatorCode) {
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: {
                            return true;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        return false;
    }

    private ArrayList getUsages(SourceVariable sourceVariable, String fieldName) {
        ArrayList ret = new ArrayList();
        SourceVariableDeclaration owningDeclaration = sourceVariable.getOwningDeclaration();
        SourceElement scope = owningDeclaration.getParent();
        String variableName = sourceVariable.getName();
        1 visitor = new 1(this, sourceVariable, fieldName, variableName, ret);
        ((Visitor)visitor).visit(scope);
        return ret;
    }

    private static SourceExpressionStatement createFieldAssigment(SourceFactory factory, String fieldName, SourceExpression sourceExpression) {
        SourceExpression lhs = factory.createExpression(fieldName);
        SourceExpression rhs = (SourceExpression)sourceExpression.cloneSelf(sourceExpression.getOwningSourceFile());
        SourceAssignmentExpression assignment = factory.createAssignment(6, lhs, rhs);
        SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)assignment);
        return expressionStatement;
    }

    private void addInitializerToCtors(SourceFactory factory, SourceClass owningClass, String fieldName, SourceExpression sourceExpression) {
        boolean hasCtor = false;
        List declaredConstructors = owningClass.getSourceConstructors();
        for (SourceMethod sourceMethod : declaredConstructors) {
            if (sourceMethod == null || IntroduceFieldController.ctorCallsThis(sourceMethod)) continue;
            SourceExpressionStatement fieldAssigmentExpression = IntroduceFieldController.createFieldAssigment(factory, fieldName, sourceExpression);
            if (Patch.contains((SourceElement)sourceMethod, (SourceElement)sourceExpression)) {
                SourceElement statementLevelElement = Util.getStatementLevelElement((SourceElement)sourceExpression);
                fieldAssigmentExpression.addSelfBefore(statementLevelElement);
            } else {
                fieldAssigmentExpression.addSelf((SourceElement)sourceMethod.getBlock());
            }
            hasCtor = true;
        }
        if (!hasCtor) {
            SourceExpressionStatement fieldAssigmentExpression = IntroduceFieldController.createFieldAssigment(factory, fieldName, sourceExpression);
            SourceBlock block = factory.createBlock(new SourceElement[]{fieldAssigmentExpression});
            SourceMethod constructor = factory.createConstructor(null, null, block);
            constructor.addModifiers(1);
            constructor.addSelf((SourceElement)owningClass);
        }
    }

    private static boolean ctorCallsThis(SourceMethod sourceMethod) {
        try {
            SourceBlock sourceBlock = sourceMethod.getBlock();
            SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceBlock.getChildren().get(0);
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceExpressionStatement.getChildren().get(0);
            JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
            if (resolvedMethod.isConstructor()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private static void replaceVariableInstances(SourceFactory factory, ArrayList usages, String fieldName) {
        int i = 0;
        while (i < usages.size()) {
            Pair pair = (Pair)usages.get(i);
            SourceSimpleNameExpression oldExpression = (SourceSimpleNameExpression)pair.first;
            boolean needsPrefix = (Boolean)pair.second;
            if (needsPrefix) {
                SourceSimpleNameExpression thisExpr = factory.createSimpleNameExpression("this");
                SourceDotExpression newExpression = factory.createDotReference((SourceExpression)thisExpr, fieldName);
                oldExpression.replaceSelf((SourceElement)newExpression);
            } else {
                oldExpression.setName(fieldName);
            }
            ++i;
        }
    }

    private boolean needsPrefix(SourceVariable sourceVariable, String fieldName) {
        if (fieldName.equals(sourceVariable.getName())) {
            return false;
        }
        return IntroduceFieldController.needsPrefix((SourceElement)sourceVariable.getOwningDeclaration(), fieldName);
    }

    private static boolean needsPrefix(SourceElement sourceElement, String fieldName) {
        while (sourceElement != null) {
            int symbolKind = sourceElement.getSymbolKind();
            switch (symbolKind) {
                case 4: {
                    return false;
                }
                case 2: {
                    SourceBlock sourceBlock = (SourceBlock)sourceElement;
                    Collection localVariables = sourceBlock.getLocalVariables();
                    for (SourceLocalVariable sourceLocalVariable : localVariables) {
                        if (!fieldName.equals(sourceLocalVariable.getName())) continue;
                        return true;
                    }
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
                    List sourceParameters = formalParameterList.getSourceParameters();
                    int i = 0;
                    while (i < sourceParameters.size()) {
                        SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
                        String paramName = sourceVariable.getName();
                        if (fieldName.equals(paramName)) {
                            return true;
                        }
                        ++i;
                    }
                    break;
                }
                case 38: {
                    SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                    List forVariables = sourceForStatement.getForVariables();
                    int i = 0;
                    while (i < forVariables.size()) {
                        SourceLocalVariable variable = (SourceLocalVariable)forVariables.get(i);
                        if (fieldName.equals(variable.getName())) {
                            return true;
                        }
                        ++i;
                    }
                    break;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return false;
    }

    private void createField(SourceFactory factory, SourceClass sourceClass, String dataType, String fieldName, SourceExpression fieldInitializer, boolean isStaticContext) {
        SourceFieldDeclaration fieldDeclaration = this.createField(factory, dataType, fieldName, fieldInitializer, isStaticContext);
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        fieldDeclaration.addSelf((SourceElement)sourceClassBody);
    }

    private SourceFieldDeclaration createField(SourceFactory factory, String dataType, String fieldName, SourceExpression fieldInitializer, boolean isStaticContext) {
        SourceTypeReference sourceType = factory.createType(dataType);
        if (fieldInitializer != null) {
            fieldInitializer = (SourceExpression)fieldInitializer.cloneSelf(fieldInitializer.getOwningSourceFile());
        }
        int modifiers = this._isConstant ? 26 : 2 | (isStaticContext ? 8 : 0);
        SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(modifiers, sourceType, fieldName, fieldInitializer);
        return fieldDeclaration;
    }

    private static boolean isConstantExpression(SourceExpression sourceExpression) {
        List list = SourceElementAsList.asList((SourceElement)sourceExpression, (int[])new int[]{57, 53});
        int i = 0;
        while (i < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(i);
            block0 : switch (sourceElement.getSymbolKind()) {
                case 57: {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                    if (resolvedObject == null) break;
                    switch (resolvedObject.getElementKind()) {
                        case 7: {
                            return false;
                        }
                        case 5: {
                            JavaField javaField = (JavaField)resolvedObject;
                            if (javaField.isStatic() && javaField.isFinal()) break block0;
                            return false;
                        }
                    }
                    break;
                }
                case 53: {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (resolvedMethod == null || resolvedMethod.isStatic()) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void introduceFromParameter(Context context, SourceFormalParameter sourceLocalVariable, SourceExpression introducedFromExpression) {
        IntroduceFieldFromParamDialog dialog = new IntroduceFieldFromParamDialog(context, sourceLocalVariable, this._isConstant);
        if (dialog.runDialog()) {
            String fieldType = dialog.getFieldType();
            String fieldName = dialog.getFieldName();
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                SourceFile owningSourceFile = sourceLocalVariable.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                SourceFactory factory = owningSourceFile.getFactory();
                SourceMethod owningMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceLocalVariable);
                JavaClass owningClass = owningMethod.getOwningClass();
                SourceClass owningSourceClass = (SourceClass)owningClass.getSourceElement();
                this.createField(factory, owningSourceClass, fieldType, fieldName, null, owningMethod.isStatic());
                SourceExpression variableAccessExpression = factory.createExpression(sourceLocalVariable.getName());
                List variables = SourceElementAsList.asList((SourceElement)owningMethod, SourceVariable.class);
                SourceExpressionStatement fieldAssigment = SourceElementAsList.filterNamedElements((List)variables, (String)fieldName).isEmpty() ? IntroduceFieldController.createFieldAssigment(factory, fieldName, variableAccessExpression) : IntroduceFieldController.createFieldAssigment(factory, "this." + fieldName, variableAccessExpression);
                SourceBlock block = owningMethod.getBlock();
                SourceElement reference = null;
                boolean insertBefore = false;
                if (introducedFromExpression == null) {
                    List sourceParameters = owningMethod.getSourceParameters();
                    int paramPos = sourceParameters.indexOf(sourceLocalVariable);
                    List assignments = SourceElementAsList.asList((SourceElement)block, (int)48);
                    int i = paramPos - 1;
                    while (reference == null && i >= 0) {
                        SourceVariable sourceLocalVariable_i = (SourceVariable)sourceParameters.get(i);
                        reference = this.getAssignmentPos(assignments, sourceLocalVariable_i);
                        --i;
                    }
                    if (reference == null) {
                        insertBefore = true;
                        int i2 = paramPos + 1;
                        while (reference == null && i2 < sourceParameters.size()) {
                            SourceVariable sourceLocalVariable_i = (SourceVariable)sourceParameters.get(i2);
                            reference = this.getAssignmentPos(assignments, sourceLocalVariable_i);
                            ++i2;
                        }
                        if (reference == null) {
                            List children = block.getChildren();
                            int i3 = 0;
                            while (reference == null && i3 < children.size()) {
                                SourceElement child = (SourceElement)children.get(i3);
                                if (!this.isCallToThisOrSuper(child)) {
                                    reference = child;
                                }
                                ++i3;
                            }
                        }
                    }
                } else {
                    reference = Util.getStatementLevelElement((SourceElement)introducedFromExpression);
                    insertBefore = true;
                    if (this.isCallToThisOrSuper(reference)) {
                        insertBefore = false;
                    }
                }
                if (reference == null) {
                    fieldAssigment.addSelf((SourceElement)block);
                } else {
                    fieldAssigment.addSelf(reference, insertBefore);
                }
                refactoringCommandSupport.commit(context, this._operationName);
            }
            catch (Exception e) {
                e.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
    }

    private boolean isCallToThisOrSuper(SourceElement sourceElement) {
        if (sourceElement != null) {
            SourceMethodCallExpression sourceMethodCallExpression;
            String methodName;
            if (sourceElement.getSymbolKind() == 36) {
                SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceElement;
                sourceElement = sourceExpressionStatement.getExpression();
            }
            if (sourceElement.getSymbolKind() == 53 && ("this".equals(methodName = (sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement).getName()) || "super".equals(methodName))) {
                return true;
            }
        }
        return false;
    }

    private SourceStatement getAssignmentPos(List sourceAssignmentExpressions, SourceVariable sourceLocalVariable) {
        String variableName = sourceLocalVariable.getName();
        int i = 0;
        while (i < sourceAssignmentExpressions.size()) {
            SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceAssignmentExpressions.get(i);
            SourceExpression secondOperand = sourceAssignmentExpression.getSecondOperand();
            List simpleNames = SourceElementAsList.asList((SourceElement)secondOperand, (int)57);
            int j = 0;
            while (j < simpleNames.size()) {
                JavaHasType resolvedObject;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)simpleNames.get(j);
                if (variableName.equals(sourceSimpleNameExpression.getName()) && sourceLocalVariable.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
                    SourceStatement ret = (SourceStatement)Util.getAncestorOfClass(SourceStatement.class, (SourceElement)sourceAssignmentExpression);
                    return ret;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    static boolean mav$needsPrefix(IntroduceFieldController introduceFieldController, SourceVariable sourceVariable, String string) {
        return introduceFieldController.needsPrefix(sourceVariable, string);
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ SourceVariable v$sourceVariable;
        private final /* synthetic */ String v$fieldName;
        boolean _needsPrefix;
        private final /* synthetic */ String v$variableName;
        private final /* synthetic */ ArrayList v$ret;
        final /* synthetic */ IntroduceFieldController this$0;

        private void $init$() {
            this._needsPrefix = IntroduceFieldController.mav$needsPrefix(this.this$0, this.v$sourceVariable, this.v$fieldName);
        }

        public void visit(SourceElement sourceElement) {
            boolean neededPrefix = this._needsPrefix;
            if (!neededPrefix) {
                int symbolKind = sourceElement.getSymbolKind();
                switch (symbolKind) {
                    case 2: {
                        SourceBlock sourceBlock = (SourceBlock)sourceElement;
                        Collection localVariables = sourceBlock.getLocalVariables();
                        for (SourceLocalVariable sourceLocalVariable : localVariables) {
                            if (!this.v$fieldName.equals(sourceLocalVariable.getName())) continue;
                            this._needsPrefix = true;
                        }
                        break;
                    }
                    case 19: {
                        SourceMethod sourceMethod = (SourceMethod)sourceElement;
                        SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
                        List sourceParameters = formalParameterList.getSourceParameters();
                        int i = 0;
                        while (i < sourceParameters.size()) {
                            SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
                            String paramName = sourceVariable.getName();
                            if (this.v$fieldName.equals(paramName)) {
                                this._needsPrefix = true;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 38: {
                        SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                        List forVariables = sourceForStatement.getForVariables();
                        int i = 0;
                        while (i < forVariables.size()) {
                            SourceLocalVariable variable = (SourceLocalVariable)forVariables.get(i);
                            if (this.v$fieldName.equals(variable.getName())) {
                                this._needsPrefix = true;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
            super.visit(sourceElement);
            this._needsPrefix = neededPrefix;
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject;
            String expressionName = sourceSimpleNameExpression.getName();
            if (this.v$variableName.equals(expressionName) && this.v$sourceVariable.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
                Boolean needsPrefix = this._needsPrefix;
                Pair o = new Pair((Object)sourceSimpleNameExpression, (Object)needsPrefix);
                this.v$ret.add(o);
            }
        }

        public 1(IntroduceFieldController introduceFieldController, SourceVariable sourceVariable, String string, String string2, ArrayList arrayList) {
            this.v$ret = arrayList;
            this.v$variableName = string2;
            this.v$fieldName = string;
            this.v$sourceVariable = sourceVariable;
            this.this$0 = introduceFieldController;
            this.$init$();
        }
    }
}

