/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class IntroduceFieldFromParamDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "INTRO_FIELD_FROM_PARAM_PREF";
    private SourceFormalParameter _sourceLocalVariable;
    private boolean _constant;
    private JComboBox _typeCombo;
    private JComboBox _nameComponent;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;

    private void $init$() {
        this._constant = false;
    }

    public IntroduceFieldFromParamDialog(Context context, SourceFormalParameter sourceLocalVariable, boolean isConstant) {
        super(PREFERENCE_KEY, context);
        this.$init$();
        this._sourceLocalVariable = sourceLocalVariable;
        this._constant = isConstant;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(326);
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    private void init() {
        JLabel typeLabel = new JLabel();
        this._typeCombo = new JComboBox(this.buidTypeModel());
        ResourceUtils.resLabel((JLabel)typeLabel, (Component)this._typeCombo, (String)RefactoringArb.getString(178));
        this._typeCombo.addItemListener(new 1());
        this._typeCombo.setSelectedIndex(0);
        JLabel nameLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(275));
        ComboBoxEditor editor = this._nameComponent.getEditor();
        JTextField nameTextField = (JTextField)editor.getEditorComponent();
        Document document = nameTextField.getDocument();
        document.addDocumentListener(new 2());
        JLabel message = new JLabel();
        message.setPreferredSize(typeLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._typeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    private void fillSuggestedNames() {
        String typeName = (String)this._typeCombo.getSelectedItem();
        List<String> names = this._constant ? VariableNaming.suggestConstantNames((SourceElement)this._sourceLocalVariable, typeName) : VariableNaming.suggestFieldNames((SourceElement)this._sourceLocalVariable, typeName);
        String preferredName = names.isEmpty() ? "" : names.get(0).toString();
        boolean userChangedName = this._userChangedName;
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object currentName = editor.getItem();
        this._nameModel.removeAllElements();
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            this._nameModel.addElement((Object)name);
            ++i;
        }
        Object newName = userChangedName ? currentName : preferredName;
        editor.setItem(newName);
        this._userChangedName = userChangedName;
    }

    private ComboBoxModel buidTypeModel() {
        DefaultComboBoxModel<String> ret = new DefaultComboBoxModel<String>();
        JavaType resolvedType = this._sourceLocalVariable.getResolvedType();
        if (resolvedType != null) {
            ret.addElement(resolvedType.getQualifiedName());
            Set hierarchy = resolvedType.getHierarchy();
            for (JavaClass javaClass : hierarchy) {
                String qualifiedName = javaClass.getQualifiedName();
                ret.addElement(qualifiedName);
            }
        }
        if (ret.getSize() == 0) {
            ret.addElement("java.lang.Object");
        }
        return ret;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String fieldName = this.getFieldName();
            NameValidation nameValidation = NameValidation.validateFieldName(fieldName, this._constant, (SourceElement)this._sourceLocalVariable);
            this.setMessage(nameValidation.getMessage(), nameValidation.isValid());
            this.setOKButtonEnabled(nameValidation.isValid());
        }
    }

    protected String getHelpTopicID() {
        return this._constant ? "f1_jrf_dintroduceconst_html" : "f1_jrf_dintroducefield_html";
    }

    public String getFieldName() {
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object item = editor.getItem();
        return item.toString();
    }

    public String getFieldType() {
        return this._typeCombo.getSelectedItem().toString();
    }

    static void mav$fillSuggestedNames(IntroduceFieldFromParamDialog introduceFieldFromParamDialog) {
        introduceFieldFromParamDialog.fillSuggestedNames();
    }

    static void wa$_userChangedName(IntroduceFieldFromParamDialog introduceFieldFromParamDialog, boolean bl) {
        introduceFieldFromParamDialog._userChangedName = bl;
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            IntroduceFieldFromParamDialog.mav$fillSuggestedNames(IntroduceFieldFromParamDialog.this);
        }
    }

    final class 2
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }

        public void removeUpdate(DocumentEvent e) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }

        public void changedUpdate(DocumentEvent e) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }
    }
}

