/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.RadioKeyController;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceParameterDialog;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;
import oracle.jdevimpl.refactoring.util.IdenticalElementComparator;

public final class IntroduceParameterController
extends IntroduceController {
    private static final String OPR_TITLE = RefactoringArb.getString(79);

    protected final void replaceExpression(Context context, SourceExpression sourceExpression) {
        this.replace(context, null, sourceExpression);
    }

    protected final void replaceVariable(Context context, SourceVariable sourceVariable) {
        SourceExpression initializer = sourceVariable.getInitializer();
        if (initializer != null) {
            this.replace(context, sourceVariable, initializer);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(357), OPR_TITLE, 0);
        }
    }

    protected boolean whenIntroduce(Context context, SourceElement sourceElement, boolean doit, int cursorAt) {
        boolean ret = false;
        SourceMember sourceMember = (SourceMember)Util.getAncestorOfClass(SourceMember.class, sourceElement);
        if (sourceMember instanceof SourceMethod) {
            ret = super.whenIntroduce(context, sourceElement, doit, cursorAt);
        }
        return ret;
    }

    private void replace(Context context, SourceVariable sourceVariable, SourceExpression sourceExpression) {
        if (IntroduceParameterController.canIntroduce(context)) {
            SourceMethod sourceMethod = IntroduceParameterController.getChangedMethod(sourceExpression);
            SourceExpression[] replacableExpressions = sourceVariable == null ? IntroduceParameterController.getReplacableExpressions(sourceExpression) : new SourceExpression[]{sourceExpression};
            IntroduceParameterDialog dialog = new IntroduceParameterDialog(context, sourceExpression, (SourceElement[])replacableExpressions);
            dialog.setValidTypesFromExpression(sourceExpression);
            if (dialog.runDialog()) {
                SourceExpression[] sourceExpressionArray;
                String parameterName = dialog.getVariableName();
                boolean replaceAll = dialog.isReplaceAll();
                if (replaceAll) {
                    sourceExpressionArray = replacableExpressions;
                } else {
                    SourceExpression[] sourceExpressionArray2 = new SourceExpression[1];
                    sourceExpressionArray = sourceExpressionArray2;
                    sourceExpressionArray2[0] = sourceExpression;
                }
                SourceExpression[] expressionsToReplace = sourceExpressionArray;
                RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                try {
                    this.replaceUsages(sourceExpression, context, refactoringCommandSupport, dialog.isFinal(), dialog.getSelectedTypeName(), parameterName, sourceMethod);
                    if (sourceVariable == null) {
                        IntroduceParameterController.replaceExpressionsWithParameter(refactoringCommandSupport, expressionsToReplace, parameterName);
                    } else {
                        this.replaceVariableWithParameter(refactoringCommandSupport, sourceMethod, sourceVariable, parameterName);
                    }
                    refactoringCommandSupport.commit(context, OPR_TITLE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    refactoringCommandSupport.abort();
                }
            }
        }
    }

    private static SourceMethod getChangedMethod(SourceExpression sourceExpression) {
        SourceMethod ret = null;
        SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceExpression);
        if (sourceMethod.isConstructor()) {
            ret = sourceMethod;
        } else {
            JavaClass owningClass = sourceMethod.getOwningClass();
            Set hierarchy = owningClass.getHierarchy();
            ArrayList<Object> declaringTypes = new ArrayList<Object>();
            String methodName = sourceMethod.getName();
            JavaType[] parameterTypes = sourceMethod.getParameterTypes();
            for (JavaClass javaClass : hierarchy) {
                JavaMethod superMethod;
                if (owningClass.equals((Object)javaClass) || (superMethod = javaClass.getDeclaredMethod(methodName, parameterTypes)) == null) continue;
                boolean isPresent = false;
                Iterator itTypes = declaringTypes.iterator();
                while (!isPresent && itTypes.hasNext()) {
                    JavaClass decClass = (JavaClass)itTypes.next();
                    if (decClass.isAssignableFrom((JavaType)javaClass)) {
                        isPresent = true;
                        continue;
                    }
                    if (!javaClass.isAssignableFrom((JavaType)decClass)) continue;
                    declaringTypes.remove(decClass);
                    declaringTypes.add(javaClass);
                    isPresent = true;
                }
                if (isPresent) continue;
                declaringTypes.add(superMethod);
            }
            switch (declaringTypes.size()) {
                case 0: {
                    ret = sourceMethod;
                    break;
                }
                case 1: {
                    JavaMethod superMethod = (JavaMethod)declaringTypes.get(0);
                    String owningSuperClassName = superMethod.getOwningClass().getQualifiedName();
                    SourceMethod superSourceMethod = (SourceMethod)superMethod.getSourceElement();
                    if (superSourceMethod != null && Util.canRefactor((SourceElement)superSourceMethod)) {
                        String text1 = MessageFormat.format(RefactoringArb.getString(31), owningSuperClassName);
                        String text2 = MessageFormat.format(RefactoringArb.getString(51), owningSuperClassName);
                        String text3 = MessageFormat.format(RefactoringArb.getString(211), owningClass.getQualifiedName());
                        JLabel label = new JLabel(text1);
                        JRadioButton changeSuper = new JRadioButton();
                        ResourceUtils.resButton((AbstractButton)changeSuper, (String)text2);
                        JRadioButton changeThis = new JRadioButton();
                        ResourceUtils.resButton((AbstractButton)changeThis, (String)text3);
                        ButtonGroup buttonGroup = new ButtonGroup();
                        buttonGroup.add(changeSuper);
                        buttonGroup.add(changeThis);
                        changeSuper.setSelected(true);
                        RadioKeyController.attach((ButtonGroup)buttonGroup);
                        Box box = new Box(1);
                        box.add(label);
                        box.add(changeSuper);
                        box.add(changeThis);
                        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(79), 3);
                        dialog.setInitialFocus((Component)changeSuper);
                        if (!dialog.runDialog()) break;
                        if (changeSuper.isSelected()) {
                            ret = superSourceMethod;
                            break;
                        }
                        ret = sourceMethod;
                        break;
                    }
                    String message = MessageFormat.format(RefactoringArb.getString(329), owningSuperClassName, sourceMethod.getOwningClass().getQualifiedName());
                    int cont = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, RefactoringArb.getString(79), 2, 3);
                    if (cont != 0) break;
                    ret = sourceMethod;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(25));
                    break;
                }
            }
        }
        return ret;
    }

    private static boolean canIntroduce(Context context) {
        String message = null;
        SourceExpression sourceExpression = IntroduceParameterController.getSourceExpression(context);
        if (sourceExpression != null) {
            if (IntroduceParameterController.isValidType(sourceExpression)) {
                if (IntroduceParameterController.dependsOnLocal((SourceElement)sourceExpression)) {
                    message = RefactoringArb.getString(145);
                }
            } else {
                message = RefactoringArb.getString(283);
            }
        }
        if (message == null) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, RefactoringArb.getString(301), 1);
        return false;
    }

    private void replaceUsages(SourceExpression expression, Context context, RefactoringCommandSupport refactoringCommandSupport, boolean isFinal, String fqTypeName, String parameterName, SourceMethod sourceMethod) {
        UsageModel usageModel = new UsageModel();
        Project project = context.getProject();
        JavaMember[] members = new JavaMember[]{sourceMethod};
        FindMemberUsages findMemberUsages = new FindMemberUsages(members);
        findMemberUsages.findMemberUsages(project, new 1(this, project, usageModel));
        ArrayList usageEntries = usageModel.getUsageEntries();
        int i = 0;
        while (i < usageEntries.size()) {
            UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                SourceElement sourceElement = (SourceElement)usageEntry.getUserObject();
                switch (sourceElement.getSymbolKind()) {
                    case 6: 
                    case 19: {
                        SourceMethod sourceMethodDeclaration = (SourceMethod)sourceElement;
                        IntroduceParameterController.addParamDecl(refactoringCommandSupport, sourceMethodDeclaration, fqTypeName, isFinal, parameterName);
                        break;
                    }
                    case 53: 
                    case 55: {
                        SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                        SourceListExpression argumentList = sourceInvokeExpression.getArgumentList();
                        SourceFile owningSourceFile = sourceInvokeExpression.getOwningSourceFile();
                        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                        SourceExpression clonedExpression = (SourceExpression)expression.cloneSelf(owningSourceFile);
                        clonedExpression.addSelf((SourceElement)argumentList);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void replaceVariableWithParameter(RefactoringCommandSupport refactoringCommandSupport, SourceMethod sourceMethod, SourceVariable sourceVariable, String parameterName) {
        SourceFile owningSourceFile = sourceMethod.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
        SourceVariableDeclaration owningDeclaration = sourceVariable.getOwningDeclaration();
        SourceElement scope = owningDeclaration.getParent();
        List list = SourceElementAsList.asList((SourceElement)scope, (int[])new int[]{57});
        int i = 0;
        while (i < list.size()) {
            JavaHasType resolvedObject;
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(i);
            if (sourceVariable.getName().equals(sourceSimpleNameExpression.getName()) && sourceVariable.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
                sourceSimpleNameExpression.setName(parameterName);
            }
            ++i;
        }
        sourceVariable.removeSelf();
    }

    private static void replaceExpressionsWithParameter(RefactoringCommandSupport refactoringCommandSupport, SourceExpression[] expressions, String variableName) {
        SourceExpression firstExpression = expressions[0];
        SourceFile owningSourceFile = firstExpression.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
        int i = 0;
        while (i < expressions.length) {
            SourceExpression expression = expressions[i];
            SourceElement expressionParent = expression.getParent();
            if (expressionParent instanceof SourceExpressionStatement) {
                expressionParent.removeSelf();
            } else {
                SourceFactory factory = owningSourceFile.getFactory();
                SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(variableName);
                expression.replaceSelf((SourceElement)simpleNameExpression);
            }
            ++i;
        }
    }

    private static void addParamDecl(RefactoringCommandSupport refactoringCommandSupport, SourceMethod sourceMethod, String fqTypeName, boolean isFinal, String parameterName) {
        SourceFile sourceFile = sourceMethod.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceFactory factory = sourceFile.getFactory();
        SourceLocalVariable localVariable = factory.createLocalVariable(factory.createType(fqTypeName), parameterName);
        SourceFormalParameter parameter = factory.createFormalParameter(localVariable);
        parameter.addModifiers(isFinal ? 16 : 0);
        SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
        parameter.addSelf((SourceElement)formalParameterList);
    }

    private static SourceExpression getSourceExpression(Context context) {
        SourceExpression ret = null;
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            TextNode textNode;
            SourceExpression sourceExpression;
            int fromPosition;
            int toPosition;
            CodeEditor codeEditor = (CodeEditor)view;
            if (!codeEditor.hasSelectedText()) {
                fromPosition = toPosition = codeEditor.getCaretPosition();
            } else {
                fromPosition = codeEditor.getSelectionStart();
                toPosition = codeEditor.getSelectionEnd();
            }
            Node node = context.getNode();
            if (node instanceof TextNode && (sourceExpression = IntroduceParameterController.getAssignableExpression(project, textNode = (TextNode)node, fromPosition, toPosition)) != null) {
                if ("super".equals(sourceExpression.getText())) {
                    sourceExpression = (SourceExpression)sourceExpression.getParent();
                }
                if (Util.getAncestorOfClass(SourceBlock.class, (SourceElement)sourceExpression) != null && IntroduceParameterController.isAssignable(sourceExpression)) {
                    ret = sourceExpression;
                }
            }
        }
        return ret;
    }

    private static boolean isAssignable(SourceExpression expression) {
        SourceAssignmentExpression sourceAssignmentExpression;
        SourceExpression lhsExpression;
        boolean ret = true;
        SourceElement parent = expression.getParent();
        while (parent.getSymbolKind() == 61) {
            parent = parent.getParent();
        }
        if (parent.getSymbolKind() == 48 && Patch.contains((SourceElement)(lhsExpression = (sourceAssignmentExpression = (SourceAssignmentExpression)parent).getFirstOperand()), (SourceElement)expression)) {
            ret = false;
        }
        return ret;
    }

    private static boolean isValidType(SourceExpression sourceExpression) {
        String resolvedTypeName;
        JavaType resolvedType = sourceExpression.getResolvedType();
        return resolvedType != null && (resolvedTypeName = resolvedType.getName()) != null && !"void".equals(resolvedTypeName);
    }

    private static SourceExpression getAssignableExpression(Project project, TextNode textNode, int fromPosition, int toPosition) {
        SourceFile sourceFile;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        URL nodeURL = textNode.getURL();
        if (nodeURL != null && (sourceFile = javaManager.getSourceFile(nodeURL)) != null) {
            SourceElement commonParent;
            SourceElement leftElement = sourceFile.getElementAt(fromPosition);
            if (fromPosition != toPosition) {
                SourceElement rightElement = sourceFile.getElementAt(toPosition);
                commonParent = IntroduceParameterController.getCommonParent(leftElement, rightElement);
            } else {
                commonParent = leftElement;
            }
            if (commonParent != null) {
                int nodeID = commonParent.getSymbolKind();
                if (nodeID == 36) {
                    SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)commonParent;
                    SourceElement[] containedElements = sourceExpressionStatement.getContainedElements();
                    if (containedElements[0] instanceof SourceExpression) {
                        SourceExpression expression = (SourceExpression)containedElements[0];
                        return IntroduceParameterController.getParentAssignableExpression((SourceElement)expression);
                    }
                } else {
                    SourceName variableNameElement;
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)Util.getAncestorOfClass(SourceLocalVariable.class, commonParent);
                    if (sourceLocalVariable != null && commonParent.equals(variableNameElement = sourceLocalVariable.getNameElement())) {
                        SourceExpression initializer = sourceLocalVariable.getInitializer();
                        return IntroduceParameterController.getParentAssignableExpression((SourceElement)initializer);
                    }
                    return IntroduceParameterController.getParentAssignableExpression(commonParent);
                }
            }
        }
        return null;
    }

    private static SourceExpression getParentAssignableExpression(SourceElement sourceElement) {
        SourceElement parent = sourceElement;
        while (parent != null) {
            SourceExpression sourceExpression;
            JavaType resolvedType;
            if (parent instanceof SourceStatement) {
                return null;
            }
            if (parent instanceof SourceExpression && (resolvedType = (sourceExpression = (SourceExpression)parent).getResolvedType()) != null) {
                switch (sourceExpression.getSymbolKind()) {
                    case 49: 
                    case 57: {
                        int elementKind;
                        JavaHasType resolvedObject = sourceExpression.getResolvedObject();
                        if (resolvedObject == null || (elementKind = resolvedObject.getElementKind()) == 3) break;
                        return sourceExpression;
                    }
                    case 58: {
                        break;
                    }
                    default: {
                        return sourceExpression;
                    }
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static SourceElement getCommonParent(SourceElement leftElement, SourceElement rightElement) {
        HashSet<SourceElement> leftParents = new HashSet<SourceElement>();
        SourceElement parent = leftElement;
        while (parent != null) {
            leftParents.add(parent);
            parent = parent.getParent();
        }
        SourceElement parent2 = rightElement;
        while (parent2 != null) {
            if (leftParents.contains(parent2)) {
                return parent2;
            }
            parent2 = parent2.getParent();
        }
        return null;
    }

    protected static String getIndentAtOffset(TextBuffer textBuffer, int offset) {
        LineMap lineMap = textBuffer.getLineMap();
        int line = lineMap.getLineFromOffset(offset);
        return IntroduceParameterController.getIndentAtLine(textBuffer, line);
    }

    private static String getIndentAtLine(TextBuffer textBuffer, int line) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStartOffset = lineMap.getLineStartOffset(line);
        int lineEndOffset = lineMap.getLineEndOffset(line);
        String lineText = textBuffer.getString(lineStartOffset, lineEndOffset - lineStartOffset);
        int lastWhiteSpace = 0;
        while (lastWhiteSpace < lineText.length() && Character.isWhitespace(lineText.charAt(lastWhiteSpace))) {
            ++lastWhiteSpace;
        }
        String indent = lineText.substring(0, lastWhiteSpace);
        return indent;
    }

    protected static final SourceElement[] findOccurences(SourceExpression sourceExpression) {
        SourceExpression scope = sourceExpression;
        SourceElement parent = sourceExpression.getParent();
        while (parent != null && parent.getSymbolKind() != 4) {
            scope = parent;
            parent = parent.getParent();
        }
        SourceElement[] occurrences = IdenticalElementComparator.find((SourceElement)sourceExpression, (SourceElement)scope);
        return occurrences;
    }

    final class 1
    extends FindMemberUsages.JotUsageListener {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ UsageModel v$usageModel;
        final /* synthetic */ IntroduceParameterController this$0;

        public void whenMethodDeclaration(SourceMethod sourceMethod) {
            UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)sourceMethod, 0, 2);
            usageEntry.setUserObject(sourceMethod);
            this.v$usageModel.addUsageEntry(usageEntry);
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
            UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)sourceInvokeExpression, 0, 2);
            usageEntry.setUserObject(sourceInvokeExpression);
            this.v$usageModel.addUsageEntry(usageEntry);
        }

        public 1(IntroduceParameterController introduceParameterController, Project project, UsageModel usageModel) {
            this.v$usageModel = usageModel;
            this.v$project = project;
            this.this$0 = introduceParameterController;
        }
    }
}

