/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceLocalVariableDialog;

public final class IntroduceVariableController
extends IntroduceController {
    protected boolean whenIntroduce(Context context, SourceElement sourceElement, boolean doit, int cursorAt) {
        boolean ret = false;
        if (Util.getAncestorOfClass(SourceMember.class, sourceElement) instanceof SourceMethod) {
            ret = super.whenIntroduce(context, sourceElement, doit, cursorAt);
        }
        return ret;
    }

    protected final void replaceExpression(Context context, SourceExpression sourceExpression) {
        SourceExpression[] replacableExpressions = IntroduceVariableController.getReplacableExpressions(sourceExpression);
        IntroduceLocalVariableDialog dialog = new IntroduceLocalVariableDialog(context, sourceExpression, (SourceElement[])replacableExpressions);
        dialog.setValidTypesFromExpression(context, sourceExpression);
        if (dialog.runDialog()) {
            boolean isFinal = dialog.isFinal();
            String fqTypeName = dialog.getSelectedTypeName();
            String variableName = dialog.getVariableName();
            SourceExpression[] replace = dialog.isReplaceAll() ? replacableExpressions : new SourceExpression[]{sourceExpression};
            IntroduceVariableController.doIntroduceVariable(context, isFinal, fqTypeName, variableName, replace);
        }
    }

    protected final void replaceVariable(Context context, SourceVariable sourceVariable) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(36));
    }

    protected final boolean isOKtoReplaceVariable() {
        return false;
    }

    private static void doIntroduceVariable(Context context, boolean isFinal, String fqTypeName, String variableName, SourceExpression[] replacableExpressions) {
        RefactoringCommandSupport commandSupport = new RefactoringCommandSupport();
        try {
            CodeEditor codeEditor;
            int caretPosition = -1;
            View view = context.getView();
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
                caretPosition = codeEditor.getCaretPosition();
            } else {
                codeEditor = null;
            }
            SourceExpression sourceExpression = replacableExpressions[0];
            SourceFile sourceFile = sourceExpression.getOwningSourceFile();
            commandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory factory = sourceFile.getFactory();
            SourceExpression initializer = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
            SourceLocalVariableDeclaration localVariableDeclaration = factory.createLocalVariableDeclaration(isFinal ? 16 : 0, factory.createType(fqTypeName), variableName, initializer);
            SourceElement parent = sourceExpression.getParent();
            if (parent instanceof SourceExpressionStatement) {
                if (Patch.contains(parent, caretPosition)) {
                    commandSupport.repositionCaret(codeEditor, (SourceElement)localVariableDeclaration, true);
                }
                parent.replaceSelf((SourceElement)localVariableDeclaration);
            } else {
                SourceElement insertBeforeElement = IntroduceVariableController.getInsertBeforeElement(replacableExpressions);
                localVariableDeclaration.addSelfBefore(insertBeforeElement);
                int i = 0;
                while (i < replacableExpressions.length) {
                    SourceExpression replacableExpression = replacableExpressions[i];
                    SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(variableName);
                    parent = replacableExpression.getParent();
                    if (parent instanceof WrapperExpr) {
                        switch (parent.getParent().getSymbolKind()) {
                            case 33: 
                            case 39: 
                            case 41: 
                            case 42: 
                            case 45: {
                                break;
                            }
                            default: {
                                replacableExpression = (SourceExpression)parent;
                                break;
                            }
                        }
                    }
                    if (Patch.contains((SourceElement)replacableExpression, caretPosition)) {
                        commandSupport.repositionCaret(codeEditor, (SourceElement)simpleNameExpression, true);
                    }
                    replacableExpression.replaceSelf((SourceElement)simpleNameExpression);
                    ++i;
                }
            }
            commandSupport.commit(context, RefactoringArb.getString(301));
        }
        catch (Exception e) {
            e.printStackTrace();
            commandSupport.abort();
        }
    }
}

