/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDialog;

public abstract class IntroduceVariableDialog
extends IntroduceDialog {
    private static final int PREF_FINAL = 1;
    private JComboBox _nameComponent;
    private JCheckBox _finalCheckbox;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;

    protected abstract String getTitle();

    protected abstract String getPreferenceKey();

    IntroduceVariableDialog(String preferenceKey, Context context, SourceExpression expression, SourceElement[] replacableExpressions) {
        super(preferenceKey, context, (SourceElement)expression, replacableExpressions);
    }

    protected final JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected final void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String variableName = this.getVariableName();
            if (variableName != null) {
                if (variableName.length() == 0) {
                    isValid = false;
                } else {
                    String canIntroduceVariable = IntroduceVariableDialog.canIntroduceVariable(this._sourceElement, variableName);
                    if (canIntroduceVariable != null) {
                        message = canIntroduceVariable;
                        isValid = false;
                    } else if (Character.isUpperCase(variableName.charAt(0))) {
                        message = RefactoringArb.getString(142);
                    }
                }
                this.setMessage(message, isValid);
                this.setOKButtonEnabled(isValid);
            }
        }
    }

    private static String canIntroduceVariable(SourceElement sourceElement, String variableName) {
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else if (NamingUtil.isJavaReservedWord((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else if (!VariableNaming.canIntroduceVariable(sourceElement, variableName)) {
            message = MessageFormat.format(RefactoringArb.getString(163), variableName);
        }
        return message;
    }

    protected final void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.isFinal());
    }

    protected final void init() {
        this.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(275));
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Component editorComponent = editor.getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField nameTextField = (JTextField)editorComponent;
            Document document = nameTextField.getDocument();
            document.addDocumentListener(new 1());
        }
        JComboBox typeComponent = this.createTypeComponent();
        JLabel typeLabel = null;
        if (typeComponent != null) {
            typeLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)typeLabel, (Component)typeComponent, (String)RefactoringArb.getString(178));
        }
        this._finalCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._finalCheckbox, (String)RefactoringArb.getString(244));
        int occurenceCount = this.getOccurenceCount();
        if (occurenceCount > 1) {
            this._replaceAll = new JCheckBox();
            String label = RefactoringArb.getString(100);
            String formatedText = MessageFormat.format(label, Integer.toString(occurenceCount));
            ResourceUtils.resButton((AbstractButton)this._replaceAll, (String)formatedText);
        }
        JLabel message = new JLabel();
        message.setPreferredSize(this._finalCheckbox.getPreferredSize());
        this.setMessageLabel(message);
        CopyableInteger data = this.getSettings();
        boolean preferFinal = data.isBitSet(1);
        this._finalCheckbox.setSelected(preferFinal);
        Insets insets = new Insets(2, 2, 2, 2);
        if (typeComponent != null) {
            this.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this.add((Component)typeComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._finalCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        if (this._replaceAll != null) {
            this.add((Component)this._replaceAll, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        }
        this.add((Component)message, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    protected final void fillSuggestedNames() {
        JavaType selectedJavaType = this.getSelectedJavaType();
        JavaType componentType = selectedJavaType.isArray() ? selectedJavaType.getComponentType() : selectedJavaType;
        String typeName = componentType.getRawName();
        List names = this.getVariableNames(typeName);
        String preferredName = names.isEmpty() ? "" : names.get(0).toString();
        boolean userChangedName = this._userChangedName;
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object currentName = editor.getItem();
        this._nameModel.removeAllElements();
        int i = 0;
        while (i < names.size()) {
            Object name = names.get(i);
            this._nameModel.addElement(name);
            ++i;
        }
        Object newName = userChangedName ? currentName : preferredName;
        editor.setItem(newName);
        this._userChangedName = userChangedName;
    }

    protected abstract List getVariableNames(String var1);

    public final String getVariableName() {
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object item = editor.getItem();
        return item.toString();
    }

    public final boolean isFinal() {
        return this._finalCheckbox.isSelected();
    }

    static void wa$_userChangedName(IntroduceVariableDialog introduceVariableDialog, boolean bl) {
        introduceVariableDialog._userChangedName = bl;
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }

        public void removeUpdate(DocumentEvent e) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }

        public void changedUpdate(DocumentEvent e) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }
    }
}

