/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

class MakeStaticCommand {
    private Context _context;
    private SourceMethod _sourceMethod;
    private String _parameterName;
    private boolean _parameterIsFinal;

    public MakeStaticCommand(Context context, SourceMethod sourceMethod, String parameterName) {
        this._context = context;
        this._sourceMethod = sourceMethod;
        this._parameterName = parameterName;
    }

    public MakeStaticCommand(Context context, SourceMethod sourceMethod, String parameterName, boolean parameterIsFinal) {
        this._context = context;
        this._sourceMethod = sourceMethod;
        this._parameterName = parameterName;
        this._parameterIsFinal = parameterIsFinal;
    }

    public Context getContext() {
        return this._context;
    }

    public boolean doRefactoring() {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean ret = false;
        try {
            Collection affectedProjects = this.getAffectedProjects();
            JavaMember[] membersToSearch = new JavaMember[]{this._sourceMethod};
            for (Project project : affectedProjects) {
                this.adaptCallers(project, membersToSearch, refactoringCommandSupport);
            }
            this.adaptMethod(refactoringCommandSupport);
            refactoringCommandSupport.commit(this.getContext(), RefactoringArb.getString(340));
            ret = true;
        }
        catch (AbortedOperationException e) {
            refactoringCommandSupport.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private Collection getAffectedProjects() {
        Context context = this.getContext();
        SourceFile sourceFile = this._sourceMethod.getOwningSourceFile();
        URL url = sourceFile.getURL();
        Project definingProject = Util.getDefiningProject(context, url);
        HashSet dependentProjects = Util.getDependentProjects(context.getWorkspace(), definingProject);
        return dependentProjects;
    }

    private void adaptMethod(RefactoringCommandSupport refactoringCommandSupport) {
        refactoringCommandSupport.beginTransaction((SourceElement)this._sourceMethod);
        if (this._parameterName != null) {
            JavaClass owningClass = this._sourceMethod.getOwningClass();
            List methodCalls = SourceElementAsList.asList((SourceElement)this._sourceMethod, (int)53);
            List simpleNames = SourceElementAsList.asList((SourceElement)this._sourceMethod, (int)57);
            SourceFactory factory = this._sourceMethod.getOwningSourceFile().getFactory();
            SourceTypeReference sourceType = factory.createType(owningClass.getQualifiedName());
            SourceLocalVariable sourceLocalVariable = factory.createLocalVariable(sourceType, this._parameterName);
            SourceFormalParameter sourceFormalParameter = factory.createFormalParameter(sourceLocalVariable);
            if (this._parameterIsFinal) {
                sourceFormalParameter.setModifiers(16);
            }
            SourceFormalParameterList formalParameterList = this._sourceMethod.getFormalParameterList();
            sourceFormalParameter.addSelf((SourceElement)formalParameterList);
            int i = 0;
            while (i < methodCalls.size()) {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)methodCalls.get(i);
                SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
                if (lhsOperand == null) {
                    List children = sourceMethodCallExpression.getChildren();
                    SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(this._parameterName);
                    children.add(0, simpleNameExpression);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < simpleNames.size()) {
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)simpleNames.get(i2);
                String text = sourceSimpleNameExpression.getText();
                if ("this".equals(text) || "super".equals(text)) {
                    SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(this._parameterName);
                    sourceSimpleNameExpression.replaceSelf((SourceElement)simpleNameExpression);
                } else {
                    JavaField javaField;
                    int elementKind;
                    JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                    if (resolvedObject != null && (elementKind = resolvedObject.getElementKind()) == 5 && !(javaField = (JavaField)resolvedObject).isStatic()) {
                        SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(this._parameterName);
                        SourceDotExpression dotExpression = factory.createDotReference((SourceExpression)simpleNameExpression, text);
                        sourceSimpleNameExpression.replaceSelf((SourceElement)dotExpression);
                    }
                }
                ++i2;
            }
        }
        this._sourceMethod.addModifiers(8);
    }

    private void adaptCallers(Project project, JavaMember[] membersToSearch, RefactoringCommandSupport refactoringCommandSupport) {
        ArrayList methodUsages = new ArrayList();
        ArrayList methodDeclarations = new ArrayList();
        FindMemberUsages findMemberUsages = new FindMemberUsages(membersToSearch);
        findMemberUsages.findMemberUsages(project, new FindMemberUsages.FillListsUsageListener(methodDeclarations, methodUsages, null));
        methodDeclarations.removeAll(Arrays.asList(membersToSearch));
        if (methodDeclarations.isEmpty()) {
            int i = 0;
            while (i < methodUsages.size()) {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)methodUsages.get(i);
                this.adaptMethodCall(sourceMethodCallExpression, refactoringCommandSupport);
                ++i;
            }
        } else {
            SourceMethod firstOverriddenMethod = (SourceMethod)methodDeclarations.get(0);
            JavaClass owningClass = firstOverriddenMethod.getOwningClass();
            String qualifiedName = owningClass.getQualifiedName();
            String message = MessageFormat.format(RefactoringArb.getString(188), qualifiedName);
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)RefactoringArb.getString(340), null);
            throw new AbortedOperationException();
        }
    }

    private void adaptMethodCall(SourceMethodCallExpression sourceMethodCallExpression, RefactoringCommandSupport refactoringCommandSupport) {
        JavaClass methodClass = this._sourceMethod.getOwningClass();
        boolean isThisOrSuper = false;
        refactoringCommandSupport.beginTransaction((SourceElement)sourceMethodCallExpression);
        SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
        if (lhsOperand != null) {
            SourceSimpleNameExpression sourceSimpleNameExpression;
            String text;
            if (lhsOperand.getSymbolKind() == 57 && ("this".equals(text = (sourceSimpleNameExpression = (SourceSimpleNameExpression)lhsOperand).getText()) || "super".equals(text))) {
                isThisOrSuper = true;
            }
            if (isThisOrSuper) {
                lhsOperand.removeSelf();
            } else {
                boolean shouldQualifyCall = true;
                SourceMember owningMember = (SourceMember)Util.getAncestorOfClass(SourceMember.class, (SourceElement)sourceMethodCallExpression);
                JavaClass calledFromClass = owningMember.getOwningClass();
                if (methodClass.equals((Object)calledFromClass)) {
                    shouldQualifyCall = false;
                }
                if (shouldQualifyCall) {
                    SourceFile owningFile = sourceMethodCallExpression.getOwningSourceFile();
                    SourceFactory factory = owningFile.getFactory();
                    String qualifiedName = methodClass.getQualifiedName();
                    SourceExpression sourceExpression = factory.createExpression(qualifiedName);
                    lhsOperand.replaceSelf((SourceElement)sourceExpression);
                } else {
                    lhsOperand.removeSelf();
                }
                if (this._parameterName != null) {
                    SourceListExpression argumentList = sourceMethodCallExpression.getArgumentList();
                    lhsOperand.addSelf((SourceElement)argumentList);
                }
            }
        } else if (this._parameterName != null) {
            SourceFile owningFile = sourceMethodCallExpression.getOwningSourceFile();
            SourceFactory factory = owningFile.getFactory();
            SourceSimpleNameExpression sourceSimpleNameExpression = Patch.contains((SourceElement)this._sourceMethod, (SourceElement)sourceMethodCallExpression) ? factory.createSimpleNameExpression(this._parameterName) : factory.createSimpleNameExpression("this");
            SourceListExpression argumentList = sourceMethodCallExpression.getArgumentList();
            sourceSimpleNameExpression.addSelf((SourceElement)argumentList);
        }
    }
}

