/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeFieldStaticFailedDialog;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticCommand;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticDialog;
import oracle.jdevimpl.refactoring.oprs.makestatic.NonStaticFieldUsageSource;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;

public class MakeStaticController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        ElementAt elementAt;
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    canHandle = MakeStaticController.handle(context, javaMethod, doit);
                    break;
                }
                case 4: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    canHandle = MakeStaticController.handle(context, javaField, doit);
                    break;
                }
            }
        }
        return canHandle;
    }

    public static boolean handle(Context context, JavaField javaField, boolean doit) {
        boolean canHandle = false;
        SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
        if (sourceFieldVariable != null && !sourceFieldVariable.isStatic() && Util.canRefactor((SourceElement)sourceFieldVariable)) {
            canHandle = true;
            if (doit) {
                MakeStaticController.whenHandle(context, sourceFieldVariable);
            }
        }
        return canHandle;
    }

    public static boolean handle(Context context, JavaMethod javaMethod, boolean doit) {
        boolean canHandle = false;
        SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
        if (sourceMethod != null && !sourceMethod.isStatic() && (canHandle = Util.canRefactor((SourceElement)sourceMethod)) && doit) {
            MakeStaticController.whenHandle(context, javaMethod);
        }
        return canHandle;
    }

    private static void whenHandle(Context context, JavaMethod javaMethod) {
        String message = null;
        if (javaMethod.isStatic()) {
            message = RefactoringArb.getString(43);
        } else if (javaMethod.isAbstract()) {
            message = RefactoringArb.getString(1);
        } else {
            JavaClass owningClass = javaMethod.getOwningClass();
            if (owningClass.getOwningClass() != null) {
                message = RefactoringArb.getString(206);
            } else {
                String inheritedName = MakeStaticController.getInheritedName(javaMethod);
                if (inheritedName == null) {
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    String parameterName = null;
                    boolean parameterIsFinal = false;
                    boolean isCanceled = false;
                    if (MakeStaticController.hasSelfUsages(sourceMethod)) {
                        MakeStaticDialog dialog = MakeStaticController.runDialog(context, sourceMethod);
                        if (dialog != null) {
                            parameterName = dialog.getVariableName();
                            parameterIsFinal = dialog.isFinal();
                            isCanceled = false;
                        } else {
                            isCanceled = true;
                        }
                    }
                    if (!isCanceled) {
                        MakeStaticCommand makeStaticCommand = new MakeStaticCommand(context, sourceMethod, parameterName, parameterIsFinal);
                        makeStaticCommand.doRefactoring();
                    }
                } else {
                    message = MessageFormat.format(RefactoringArb.getString(123), inheritedName);
                }
            }
        }
        if (message != null) {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            JOptionPane.showMessageDialog((Component)mainWindow, message);
        }
    }

    private static String getParameterName(Context context, SourceMethod sourceMethod) {
        MakeStaticDialog dialog = new MakeStaticDialog(context, sourceMethod);
        if (dialog.runDialog()) {
            return dialog.getVariableName();
        }
        return null;
    }

    private static boolean hasSelfUsages(SourceMethod sourceMethod) {
        List list = SourceElementAsList.asList((SourceElement)sourceMethod, (int[])new int[]{53, 57});
        int i = 0;
        while (i < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(i);
            switch (sourceElement.getSymbolKind()) {
                case 53: {
                    JavaMethod resolvedMethod;
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
                    if (lhsOperand != null || (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()).isStatic()) break;
                    return true;
                }
                case 57: {
                    JavaField javaField;
                    int elementKind;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    String text = sourceSimpleNameExpression.getText();
                    if ("this".equals(text) || "super".equals(text)) {
                        return true;
                    }
                    JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                    if (resolvedObject == null || (elementKind = resolvedObject.getElementKind()) != 5 || (javaField = (JavaField)resolvedObject).isStatic()) break;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String getInheritedName(JavaMethod javaMethod) {
        JavaMethod superMethod;
        JavaClass owningClass = javaMethod.getOwningClass();
        String name = javaMethod.getName();
        JavaType[] parameterTypes = javaMethod.getParameterTypes();
        JavaType parent = owningClass.getSuperclass();
        if (parent != null && (superMethod = parent.getMethod(name, parameterTypes)) != null) {
            JavaClass declaredClass = superMethod.getOwningClass();
            return declaredClass.getQualifiedName();
        }
        Collection interfaces = owningClass.getInterfaces();
        for (JavaType javaType : interfaces) {
            JavaMethod superMethod2 = javaType.getMethod(name, parameterTypes);
            if (superMethod2 == null) continue;
            JavaClass declaredClass = superMethod2.getOwningClass();
            return declaredClass.getQualifiedName();
        }
        return null;
    }

    private static void whenHandle(Context context, SourceFieldVariable sourceFieldVariable) {
        String message = null;
        JavaClass owningClass = sourceFieldVariable.getOwningClass();
        if (owningClass.getOwningClass() != null && !sourceFieldVariable.isFinal()) {
            message = RefactoringArb.getString(206);
        } else {
            NonStaticFieldUsageSource nonStaticFieldUsageSource = new NonStaticFieldUsageSource(context, sourceFieldVariable);
            if (nonStaticFieldUsageSource.doSearch()) {
                UsageModel nonStaticUsageModel = nonStaticFieldUsageSource.getUsageModel();
                if (nonStaticUsageModel.getUsageEntries().isEmpty()) {
                    nonStaticFieldUsageSource.doRefactoring();
                } else {
                    String fqClassName = owningClass.getQualifiedName();
                    String fieldName = sourceFieldVariable.getName();
                    MakeFieldStaticFailedDialog makeFieldStaticFailedDialog = new MakeFieldStaticFailedDialog(fqClassName + "." + fieldName);
                    if (makeFieldStaticFailedDialog.runDialog()) {
                        if (makeFieldStaticFailedDialog.isIgnorePressed()) {
                            nonStaticFieldUsageSource.doRefactoring();
                        } else {
                            PreviewLogPage.showUsages(nonStaticFieldUsageSource);
                        }
                    }
                }
            }
        }
        if (message != null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)RefactoringArb.getString(340), null);
        }
    }

    private static MakeStaticDialog runDialog(Context context, SourceMethod sourceMethod) {
        MakeStaticDialog dialog = new MakeStaticDialog(context, sourceMethod);
        if (dialog.runDialog()) {
            return dialog;
        }
        return null;
    }
}

