/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;

public class MakeStaticDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MAKE_STATIC_DEFAULTS";
    protected static final int PREF_FINAL = 1;
    private JComboBox _nameComponent;
    private JCheckBox _finalCheckbox;
    private DefaultListComboBoxModel _nameModel;
    private SourceMethod _sourceMethod;

    protected String getTitle() {
        return RefactoringArb.getString(340);
    }

    public MakeStaticDialog(Context context, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        this.init();
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmakestatic_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String variableName = this.getVariableName();
            if (variableName != null) {
                if (variableName.length() == 0) {
                    isValid = false;
                } else {
                    String canIntroduceVariable = MakeStaticDialog.canIntroduceVariable((SourceElement)this._sourceMethod, variableName);
                    if (canIntroduceVariable != null) {
                        message = canIntroduceVariable;
                        isValid = false;
                    } else if (Character.isUpperCase(variableName.charAt(0))) {
                        message = RefactoringArb.getString(142);
                    }
                }
                this.setMessage(message, isValid);
                this.setOKButtonEnabled(isValid);
            }
        }
    }

    private static String canIntroduceVariable(SourceElement sourceElement, String variableName) {
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else if (NamingUtil.isJavaReservedWord((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else if (!VariableNaming.canIntroduceVariable(sourceElement, variableName)) {
            message = MessageFormat.format(RefactoringArb.getString(163), variableName);
        }
        return message;
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.isFinal());
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(275));
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Component editorComponent = editor.getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField nameTextField = (JTextField)editorComponent;
            this.updateOnChanges(nameTextField);
        }
        this._finalCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._finalCheckbox, (String)RefactoringArb.getString(244));
        JLabel message = new JLabel();
        message.setPreferredSize(this._finalCheckbox.getPreferredSize());
        this.setMessageLabel(message);
        CopyableInteger data = this.getSettings();
        boolean preferFinal = data.isBitSet(1);
        this._finalCheckbox.setSelected(preferFinal);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._finalCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    protected void fillSuggestedNames() {
        JavaClass owningClass = this._sourceMethod.getOwningClass();
        String typeName = owningClass.getName();
        List<String> names = VariableNaming.suggestNamesFromCamelWord(typeName);
        this._nameModel.removeAllElements();
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            this._nameModel.addElement((Object)name);
            ++i;
        }
    }

    public String getVariableName() {
        ComboBoxEditor editor = this._nameComponent.getEditor();
        Object item = editor.getItem();
        return item.toString();
    }

    public boolean isFinal() {
        return this._finalCheckbox.isSelected();
    }
}

