/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

class NonStaticFieldUsageSource
implements UsageSource {
    private Context _context;
    private SourceFieldVariable _sourceFieldVariable;
    private UsageModel _nonStaticUsageModel;
    private UsageModel _staticUsageModel;

    public NonStaticFieldUsageSource(Context context, SourceFieldVariable sourceFieldVariable) {
        this._context = context;
        this._sourceFieldVariable = sourceFieldVariable;
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doRefactoring() {
        boolean ret = false;
        JavaClass owningClass = this._sourceFieldVariable.getOwningClass();
        String fqClassName = owningClass.getQualifiedName();
        String fieldName = this._sourceFieldVariable.getName();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            refactoringCommandSupport.beginTransaction((SourceElement)this._sourceFieldVariable);
            this._sourceFieldVariable.addModifiers(8);
            UsageModel usageModel = this._staticUsageModel;
            ArrayList usageEntries = usageModel.getUsageEntries();
            int i = 0;
            while (i < usageEntries.size()) {
                SourceDotExpression dotExpression;
                SourceExpression sourceExpression;
                UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
                if (usageEntry.isIncluded() && (sourceExpression = (SourceExpression)usageEntry.getUserObject()).getSymbolKind() == 49 && !this.contains((SourceElement)(dotExpression = (SourceDotExpression)sourceExpression), (byte)53)) {
                    SourceFile owningSourceFile = dotExpression.getOwningSourceFile();
                    refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                    SourceFactory factory = owningSourceFile.getFactory();
                    SourceExpression newExpression = factory.createExpression(fqClassName + "." + fieldName);
                    dotExpression.replaceSelf((SourceElement)newExpression);
                }
                ++i;
            }
            refactoringCommandSupport.commit(this._context, RefactoringArb.getString(360));
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    public boolean doSearch() {
        SourceFile owningSourceFile = this._sourceFieldVariable.getOwningSourceFile();
        URL url = owningSourceFile.getURL();
        Project definingProject = Util.getDefiningProject(this._context, url);
        HashSet dependentProjects = Util.getDependentProjects(this._context.getWorkspace(), definingProject);
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)this._sourceFieldVariable);
        UsageModel nonStaticUsageModel = new UsageModel();
        UsageModel staticUsageModel = new UsageModel();
        for (Project dependentProject : dependentProjects) {
            ArrayList fieldAccesses = new ArrayList();
            findMemberUsages.findMemberUsages(dependentProject, new FindMemberUsages.FillListsUsageListener(null, null, fieldAccesses));
            int i = 0;
            while (i < fieldAccesses.size()) {
                SourceExpression sourceExpression = (SourceExpression)fieldAccesses.get(i);
                UsageEntry usageEntry = new UsageEntry(dependentProject, (SourceElement)sourceExpression, 0, 2);
                usageEntry.setUserObject(sourceExpression);
                UsageModel usageModel = Util.isStaticContext(sourceExpression) ? staticUsageModel : nonStaticUsageModel;
                usageModel.addUsageEntry(usageEntry);
                ++i;
            }
        }
        this.setUsageModel(nonStaticUsageModel);
        this.setStaticUsageModel(staticUsageModel);
        return true;
    }

    private void setUsageModel(UsageModel usageModel) {
        this._nonStaticUsageModel = usageModel;
    }

    public UsageModel getUsageModel() {
        return this._nonStaticUsageModel;
    }

    public Context getContext() {
        return this._context;
    }

    public String getShortTitle() {
        return RefactoringArb.getString(360);
    }

    public String getLongTitle() {
        return MessageFormat.format(RefactoringArb.getString(306), this._sourceFieldVariable.getOwningClass().getQualifiedName() + "." + this._sourceFieldVariable.getName());
    }

    private void setStaticUsageModel(UsageModel staticUsageModel) {
        this._staticUsageModel = staticUsageModel;
    }

    public UsageModel getStaticUsageModel() {
        return this._staticUsageModel;
    }

    private boolean contains(SourceElement sourceElement, byte symbolKind) {
        if (sourceElement.getSymbolKind() == symbolKind) {
            return true;
        }
        List children = sourceElement.getChildren();
        int i = 0;
        while (i < children.size()) {
            SourceElement childElement = (SourceElement)children.get(i);
            if (this.contains(childElement, symbolKind)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

