/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;

public abstract class CellDocumentListener
implements DocumentListener {
    private JavaProvider _provider;
    private CallerContext _callerContext;
    private Color _defaultColor;
    private JTextField _textField;
    private SourceFile _owningFile;

    public CellDocumentListener(SourceMethod sourceMethod) {
        this._owningFile = sourceMethod.getOwningSourceFile();
        this._provider = this._owningFile.getProvider();
        this._callerContext = CallerContext.createContext((SourceElement)sourceMethod);
        this._defaultColor = UIManager.getLookAndFeelDefaults().getColor("TextField.foreground");
    }

    public JavaProvider getProvider() {
        return this._provider;
    }

    public CallerContext getCallerContext() {
        return this._callerContext;
    }

    public SourceFile getOwningFile() {
        return this._owningFile;
    }

    public void attachToEditor(TableCellEditor tableCellEditor) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
        this._textField = (JTextField)defaultCellEditor.getComponent();
        Document document = this._textField.getDocument();
        document.removeDocumentListener(this);
        document.addDocumentListener(this);
    }

    public void detachFromEditor(TableCellEditor tableCellEditor) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
        this._textField = (JTextField)defaultCellEditor.getComponent();
        Document document = this._textField.getDocument();
        document.removeDocumentListener(this);
    }

    public void changedUpdate(DocumentEvent e) {
        this.whenChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.whenChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.whenChanged();
    }

    private void whenChanged() {
        String value = this._textField.getText();
        boolean isValid = this.isValid(value);
        if (isValid) {
            this._textField.setForeground(this._defaultColor);
        } else {
            this._textField.setForeground(Color.RED);
        }
    }

    protected abstract boolean isValid(String var1);
}

