/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.todo.ToDoManager;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigDialog;

public final class MetSigController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        ElementAt elementAt;
        boolean ret = false;
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    canHandle = MetSigController.canHandle(context, sourceMethod);
                    ret = true;
                    break;
                }
            }
        }
        action.setEnabled(canHandle);
        return ret;
    }

    public static boolean canHandle(Context context, SourceMethod sourceMethod) {
        boolean ret = false;
        if (context != null && sourceMethod != null) {
            ret = true;
        }
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 3: {
                    SourceMethod realMethod;
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    if (sourceMethod != null && (realMethod = MetSigController.confirmSourceMethod(sourceMethod)) != null) {
                        MetSigController.whenHandle(context, realMethod);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void whenHandle(Context context, SourceMethod sourceMethod) {
        MetSigDialog metSigDialog = new MetSigDialog(context, sourceMethod);
        if (metSigDialog.runDialog()) {
            ChangeMethodCriteria changeMethodCriteria = metSigDialog.getOperation();
            MetSigController.changeMethod(context, changeMethodCriteria);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SourceMethod confirmSourceMethod(SourceMethod sourceMethod) {
        JavaClass owningClass;
        JavaClass definingType = owningClass = sourceMethod.getOwningClass();
        String methodName = sourceMethod.getName();
        JavaType[] parameterTypes = Patch.getParameterTypes((JavaMethod)sourceMethod);
        JavaClass superType = owningClass;
        while (superType != null) {
            JavaMethod superMethod = superType.getDeclaredMethod(methodName, parameterTypes);
            if (superMethod != null) {
                if (!Util.canRefactor(superType.getSourceElement())) return MetSigController.confirmWhenCannotRefactor(sourceMethod, (JavaType)superType);
                if (definingType != null) {
                    if (!definingType.isAssignableFrom((JavaType)superType)) {
                        if (!superType.isAssignableFrom((JavaType)definingType)) return MetSigController.confirmWhenMoreThanTwo(sourceMethod, (JavaType)definingType, (JavaType)superType);
                        definingType = superType;
                    }
                } else {
                    definingType = superType;
                }
            }
            ArrayList itfaces = MetSigController.getDeclaringInterfaces((JavaType)superType, methodName, parameterTypes);
            int i = 0;
            while (i < itfaces.size()) {
                JavaType itface = (JavaType)itfaces.get(i);
                if (!Util.canRefactor(itface.getSourceElement())) return MetSigController.confirmWhenCannotRefactor(sourceMethod, itface);
                if (definingType != null) {
                    if (!definingType.isAssignableFrom(itface)) {
                        if (!itface.isAssignableFrom((JavaType)definingType)) return MetSigController.confirmWhenMoreThanTwo(sourceMethod, (JavaType)definingType, itface);
                        definingType = itface;
                    }
                } else {
                    definingType = itface;
                }
                ++i;
            }
            superType = superType.getSuperclass();
        }
        if (definingType == owningClass) return sourceMethod;
        return MetSigController.confirmSourceMethod(sourceMethod, (JavaType)owningClass, (JavaType)definingType);
    }

    private static SourceMethod confirmWhenCannotRefactor(SourceMethod sourceMethod, JavaType superType) {
        String reason = MessageFormat.format(RefactoringArb.getString(68), superType.getQualifiedName());
        return MetSigController.confirmWhenProblem(sourceMethod, reason);
    }

    private static SourceMethod confirmWhenMoreThanTwo(SourceMethod sourceMethod, JavaType superType_1, JavaType superType_2) {
        String reason = MessageFormat.format(RefactoringArb.getString(222), superType_1.getQualifiedName(), superType_2.getQualifiedName());
        return MetSigController.confirmWhenProblem(sourceMethod, reason);
    }

    private static SourceMethod confirmWhenProblem(SourceMethod sourceMethod, String reason) {
        JavaClass owningClass = sourceMethod.getOwningClass();
        String question = MessageFormat.format(RefactoringArb.getString(215), reason, owningClass.getQualifiedName());
        int dlgRet = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), question, RefactoringArb.getString(101), 2, 3);
        if (dlgRet == 0) {
            return sourceMethod;
        }
        return null;
    }

    private static SourceMethod confirmSourceMethod(SourceMethod sourceMethod, JavaType javaType_1, JavaType javaType_2) {
        SourceMethod ret;
        String fullMethodName = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false);
        String qualifiedName_2 = javaType_2.getQualifiedName();
        String text = MessageFormat.format(RefactoringArb.getString(134), fullMethodName, qualifiedName_2);
        JLabel questionLabel = new JLabel(text);
        ButtonGroup buttonGroup = new ButtonGroup();
        String qualifiedName = javaType_1.getQualifiedName();
        String label = MessageFormat.format(RefactoringArb.getString(320), qualifiedName);
        JRadioButton onlyThisButton = new JRadioButton(label);
        onlyThisButton.setSelected(true);
        buttonGroup.add(onlyThisButton);
        JRadioButton superButton = new JRadioButton(RefactoringArb.getString(44));
        buttonGroup.add(superButton);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)questionLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)onlyThisButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)superButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        1 action = new 1(onlyThisButton, superButton);
        JRadioButton button = onlyThisButton;
        int i = 0;
        while (i < 2) {
            InputMap inputMap = button.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(38, 0), action);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), action);
            ActionMap actionMap = button.getActionMap();
            actionMap.put(action, action);
            button = superButton;
            ++i;
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_jrf_aabbcc_html");
        JEWTDialog dlg = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(101), 7);
        dlg.setContent((Component)panel);
        dlg.setResizable(false);
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            JavaType javaType = onlyThisButton.isSelected() ? javaType_1 : javaType_2;
            JavaMethod declaredMethod = javaType.getDeclaredMethod(sourceMethod.getName(), Patch.getParameterTypes((JavaMethod)sourceMethod));
            ret = (SourceMethod)declaredMethod.getSourceElement();
        } else {
            ret = null;
        }
        return ret;
    }

    private static ArrayList getDeclaringInterfaces(JavaType javaType, String methodName, JavaType[] parameterTypes) {
        ArrayList<JavaType> ret = new ArrayList<JavaType>(1);
        Collection interfaces = javaType.getInterfaces();
        for (JavaType javaInterface : interfaces) {
            ArrayList superDeclaring = MetSigController.getDeclaringInterfaces(javaInterface, methodName, parameterTypes);
            if (superDeclaring.isEmpty()) {
                JavaMethod interfaceMethod = javaInterface.getDeclaredMethod(methodName, parameterTypes);
                if (interfaceMethod == null) continue;
                ret.add(javaInterface);
                continue;
            }
            ret.addAll(superDeclaring);
        }
        return ret;
    }

    public static boolean changeMethod(Context context, ChangeMethodCriteria criteria) {
        2 searchOperation = new 2(context, criteria, criteria);
        Util.setOperationHints((SearchOperationImpl)searchOperation, (JavaMember)criteria.getSourceMethod(), false);
        if (criteria.isSafeRefactoring()) {
            return searchOperation.runSafeRefactoring();
        }
        return searchOperation.runRefactoring(criteria.isPreview());
    }

    static final class 1
    extends AbstractAction {
        private final /* synthetic */ JRadioButton v$onlyThisButton;
        private final /* synthetic */ JRadioButton v$superButton;

        public void actionPerformed(ActionEvent e) {
            JRadioButton button = this.v$onlyThisButton.isSelected() ? this.v$superButton : this.v$onlyThisButton;
            button.setSelected(true);
            button.requestFocus();
        }

        public 1(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
            this.v$superButton = jRadioButton2;
            this.v$onlyThisButton = jRadioButton;
        }
    }

    static final class 2
    extends SearchOperationImpl {
        private final /* synthetic */ ChangeMethodCriteria v$criteria;

        protected void applyResults() throws Exception {
            ToDoManager toDoManager;
            super.applyResults();
            Object hasTasks = this.getProperty("HAS_TASKS");
            if ((this.v$criteria.isUseTasks() || hasTasks != null) && (toDoManager = ToDoManager.getToDoManager()) != null) {
                toDoManager.setWindowVisible(true);
            }
        }

        public 2(Context context, SearchCriteria searchCriteria, ChangeMethodCriteria changeMethodCriteria) {
            this.v$criteria = changeMethodCriteria;
            super(context, searchCriteria);
        }
    }
}

