/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MetParam;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigTableModel;
import oracle.jdevimpl.refactoring.oprs.metsig.ParamTable;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MetSigDialog
extends BaseDialog
implements ActionListener,
ListSelectionListener,
VetoableChangeListener {
    private static final String PREFERENCE_KEY = "PREF_METSIG";
    private static int PREF_ADD_TASKS = 1;
    private static int PREF_PREVIEW = 2;
    private SourceMethod _sourceMethod;
    private JTextField _nameField;
    private JTextField _typeField;
    private JButton _typeBrowse;
    private JComboBox _accessField;
    private JTable _paramTable;
    private JButton _moveUp;
    private JButton _moveDown;
    private JButton _add;
    private JButton _remove;
    private MetSigTableModel _paramTableModel;
    private JavaProvider _javaProvider;
    private CallerContext _callerContext;
    private JCheckBox _addTasks;
    private JCheckBox _preview;
    private boolean _replace;

    public MetSigDialog(Context context, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        SourceFile owningFile = this._sourceMethod.getOwningSourceFile();
        this._javaProvider = owningFile.getProvider();
        this._callerContext = CallerContext.createContext((SourceElement)this._sourceMethod);
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(600, 400));
        Insets insets = new Insets(2, 2, 2, 2);
        JLabel nameLabel = new JLabel();
        this._nameField = new JTextField();
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameField, (String)RefactoringArb.getString(289));
        this.updateOnChanges(this._nameField);
        JLabel typeLabel = new JLabel();
        this._typeField = new JTextField();
        ResourceUtils.resLabel((JLabel)typeLabel, (Component)this._typeField, (String)RefactoringArb.getString(3));
        this.updateOnChanges(this._typeField);
        this._typeBrowse = new JButton("...");
        this._typeBrowse.addActionListener(this);
        JLabel accessLabel = new JLabel();
        this._accessField = new JComboBox<String>(new String[]{"public", "protected", "package private", "private"});
        ResourceUtils.resLabel((JLabel)accessLabel, (Component)this._accessField, (String)RefactoringArb.getString(308));
        this.updateOnChanges(this._accessField);
        String methodName = this._sourceMethod.getName();
        this._nameField.setText(methodName);
        SourceTypeReference sourceReturnType = this._sourceMethod.getSourceReturnType();
        JavaType resolvedType = sourceReturnType.getResolvedType();
        String typeValue = resolvedType == null ? sourceReturnType.getName() : resolvedType.getQualifiedName();
        this._typeField.setText(typeValue);
        this._accessField.setSelectedIndex(this._sourceMethod.isProtected() ? 1 : (this._sourceMethod.isPackagePrivate() ? 2 : (this._sourceMethod.isPrivate() ? 3 : 0)));
        this._paramTableModel = new MetSigTableModel();
        this._paramTableModel.setMethod(this._sourceMethod);
        this._paramTable = new ParamTable(this._sourceMethod, this._paramTableModel);
        this._paramTable.getSelectionModel().addListSelectionListener(this);
        this._moveUp = new JButton();
        this._moveUp.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._moveUp, (String)RefactoringArb.getString(245));
        this._moveDown = new JButton();
        this._moveDown.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._moveDown, (String)RefactoringArb.getString(5));
        this._add = new JButton();
        this._add.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._add, (String)RefactoringArb.getString(258));
        this._remove = new JButton();
        this._remove.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._remove, (String)RefactoringArb.getString(199));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RefactoringArb.getString(136));
        paramPanel.setBorder(titledBorder);
        JScrollPane scrollPane = new JScrollPane(this._paramTable);
        paramPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 17, 1, insets, 0, 0));
        paramPanel.add((Component)this._moveUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        paramPanel.add((Component)this._moveDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        paramPanel.add((Component)this._add, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        paramPanel.add((Component)this._remove, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        if (this._paramTableModel.getRowCount() > 0) {
            this.setSelectedRow(0);
        }
        this._paramTableModel.addTableModelListener(new 1());
        this._addTasks = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._addTasks, (String)RefactoringArb.getString(353));
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(41));
        JLabel message = new JLabel();
        message.setPreferredSize(this._nameField.getPreferredSize());
        this.setMessageLabel(message);
        this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)typeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._typeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._typeBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        JavaClass owningClass = this._sourceMethod.getOwningClass();
        if (!owningClass.isInterface()) {
            this.add((Component)accessLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)this._accessField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        }
        this.add((Component)paramPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._addTasks, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 3, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        this.setDefaults();
        this.updateButtons();
    }

    private void setDefaults() {
        CopyableInteger settings = this.getSettings();
        this._addTasks.setSelected(settings.isBitSet(PREF_ADD_TASKS));
        this._preview.setSelected(settings.isBitSet(PREF_PREVIEW));
    }

    protected JComponent getDefaultFocusedComponent() {
        int rowCount = this._paramTable.getRowCount();
        if (rowCount == 0) {
            return this._nameField;
        }
        return this._paramTable;
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(PREF_ADD_TASKS, this._addTasks.isSelected());
        settings.setBit(PREF_PREVIEW, this._preview.isSelected());
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dchangemethod_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(101);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            boolean changed = false;
            String methodName = this._nameField.getText();
            changed = this._sourceMethod.getName().equals(methodName) ^ true;
            NameValidation nameValidation = NameValidation.validateMethodName(methodName, true);
            String accessibility = this._accessField.getSelectedItem().toString();
            if ("public".equals(accessibility)) {
                changed = !changed ? this._sourceMethod.isPublic() ^ true : true;
            } else if ("private".equals(accessibility)) {
                changed = !changed ? this._sourceMethod.isPrivate() ^ true : true;
            } else if ("protected".equals(accessibility)) {
                changed = !changed ? this._sourceMethod.isProtected() ^ true : true;
            } else if ("prackage private".equals(accessibility)) {
                changed = !changed ? this._sourceMethod.isPackagePrivate() ^ true : true;
            }
            boolean isValid = nameValidation.isValid();
            String message = nameValidation.getMessage();
            if (isValid) {
                int rowCount = this._paramTableModel.getRowCount();
                Collection sourceParameters = this._sourceMethod.getParameters();
                changed = !changed ? sourceParameters.size() != rowCount : true;
                JavaVariable[] params = null;
                if (!sourceParameters.isEmpty()) {
                    params = sourceParameters.toArray(new JavaVariable[0]);
                }
                int i = 0;
                while (isValid && i < rowCount) {
                    String name_i = this._paramTableModel.getStringAt(i, 1);
                    changed = !changed ? params != null && !params[i].getName().equals(name_i) : true;
                    String type_i = this._paramTableModel.getStringAt(i, 0);
                    changed = !changed ? params != null && !params[i].getUnresolvedType().getSimplifiedName().equals(type_i) : true;
                    int j = i + 1;
                    while (isValid && j < rowCount) {
                        String name_j = this._paramTableModel.getStringAt(j, 1);
                        if (name_i.equals(name_j)) {
                            isValid = false;
                            message = RefactoringArb.getString(26) + name_j;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (isValid) {
                String newType = this._typeField.getText();
                changed = !changed ? this._sourceMethod.getSourceReturnType().getName().equals(newType) ^ true : true;
                SourceFile owningSourceFile = this._sourceMethod.getOwningSourceFile();
                if (!MetSigDialog.isValidTypeName(newType, owningSourceFile)) {
                    isValid = false;
                }
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(changed && isValid);
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean canClose;
        if (evt.getPropertyName().equals("closed") && Boolean.TRUE.equals(evt.getNewValue()) && !(canClose = this.canClose())) {
            throw new PropertyVetoException("", evt);
        }
    }

    public void setDlg(JEWTDialog dlg) {
        super.setDlg(dlg);
        dlg.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private boolean canClose() {
        boolean ret;
        SourceFile owningSourceFile;
        String newType;
        this.stopEditing();
        JComponent errorComponent = null;
        String errorMessage = null;
        int editParamRow = -1;
        int editParamColumn = -1;
        String newMethodName = this._nameField.getText();
        if (!NamingUtil.isJavaIdentifier((String)newMethodName)) {
            errorMessage = RefactoringArb.getString(128);
            errorComponent = this._nameField;
        }
        if (errorMessage == null && !MetSigDialog.isValidTypeName(newType = this._typeField.getText(), owningSourceFile = this._sourceMethod.getOwningSourceFile())) {
            errorMessage = RefactoringArb.getString(157);
            errorComponent = this._typeField;
        }
        String[] typeNames = null;
        if (errorMessage == null) {
            int rowCount = this._paramTableModel.getRowCount();
            typeNames = new String[rowCount];
            int i = 0;
            while (errorMessage == null && i < rowCount) {
                Pair invalidData = this.isValidParameterRow(i);
                if (invalidData != null) {
                    this.setSelectedRow(i);
                    errorMessage = invalidData.first.toString();
                    editParamRow = i;
                    editParamColumn = (Integer)invalidData.second;
                    errorComponent = this._paramTable;
                } else {
                    typeNames[i] = this._paramTableModel.getStringAt(i, 0);
                }
                ++i;
            }
        }
        JavaMethod methodWithSameSig = null;
        if (errorMessage == null) {
            SourceClass enclosingClass;
            JavaMethod javaMethod;
            boolean allValidTypes = true;
            JavaType[] types = new JavaType[typeNames.length];
            int i = 0;
            while (allValidTypes && i < typeNames.length) {
                String typeName = typeNames[i];
                JavaType javaType = MetSigDialog.resolveType(this._javaProvider, this._callerContext, typeName);
                if (javaType != null) {
                    types[i] = javaType;
                } else {
                    allValidTypes = false;
                }
                ++i;
            }
            if (allValidTypes && (javaMethod = (enclosingClass = this._sourceMethod.getEnclosingClass()).getMethod(newMethodName, types)) != null && !this._sourceMethod.equals((Object)javaMethod) && this._sourceMethod.isStatic() == javaMethod.isStatic()) {
                methodWithSameSig = javaMethod;
            }
        }
        if (errorMessage != null) {
            ret = false;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)errorMessage, (String)this.getTitle(), null);
            JTextField componentToFocus = errorComponent;
            int epr = editParamRow;
            int epc = editParamColumn;
            SwingUtilities.invokeLater(new 2(this, componentToFocus, epr, epc));
        } else {
            ret = true;
            if (methodWithSameSig != null) {
                String message = MessageFormat.format(RefactoringArb.getString(350), Util.getFullMethodName(methodWithSameSig, true, true, false), Util.getFullMethodName((JavaMethod)this._sourceMethod, true, false, false), Util.getFullMethodName(methodWithSameSig, true, false, false));
                boolean replace = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)this.getTitle(), (String)"f1_jrf_dchangemethodreplace_html", (boolean)true);
                if (replace) {
                    this._replace = true;
                } else {
                    ret = false;
                }
            }
        }
        return ret;
    }

    static JavaType resolveType(JavaProvider javaProvider, CallerContext callerContext, String typeName) {
        int pos;
        String trimmedType = typeName.replaceAll("[\\[\\]]", "");
        JavaType javaType = callerContext.resolveTypeName(trimmedType);
        int dimension = 0;
        while ((pos = typeName.indexOf(91)) != -1) {
            typeName = typeName.substring(pos + 1);
            ++dimension;
        }
        JavaType ret = javaProvider.getArrayType(javaType, dimension);
        return ret;
    }

    static boolean isValidTypeName(String typeName, SourceFile sourceFile) {
        if ("".equals(typeName)) {
            return false;
        }
        SourceFactory factory = sourceFile.getFactory();
        SourceTypeReference sourceTypeReference = factory.createTypeFromText(typeName);
        return sourceTypeReference != null && sourceTypeReference.getResolvedType() != null;
    }

    private Pair isValidParameterRow(int i) {
        SourceFile owningSourceFile;
        String newName = this._paramTableModel.getStringAt(i, 1);
        if (!NamingUtil.isJavaIdentifier((String)newName)) {
            return new Pair((Object)RefactoringArb.getString(89), (Object)new Integer(1));
        }
        String newType = this._paramTableModel.getStringAt(i, 0);
        if (!MetSigDialog.isValidTypeName(newType, owningSourceFile = this._sourceMethod.getOwningSourceFile())) {
            if (newType.indexOf(46) == -1) {
                return new Pair((Object)"Invalid parameter type: requires fully qualified name.", (Object)new Integer(0));
            }
            return new Pair((Object)RefactoringArb.getString(89), (Object)new Integer(0));
        }
        SourceVariable sourceVariable = this._paramTableModel.getVariableAt(i);
        if (sourceVariable == null) {
            String defaultValue = this._paramTableModel.getStringAt(i, 2);
            if (!this.isValidDefaultValue(defaultValue)) {
                String message = MessageFormat.format(RefactoringArb.getString(316), newName);
                return new Pair((Object)message, (Object)new Integer(2));
            }
            if (!ModelUtil.hasLength((String)defaultValue)) {
                String message = MessageFormat.format(RefactoringArb.getString(296), newName);
                return new Pair((Object)message, (Object)new Integer(2));
            }
            SourceFactory factory = owningSourceFile.getFactory();
            SourceExpression sourceExpression = factory.createExpression(defaultValue);
            if (sourceExpression == null) {
                String message = MessageFormat.format(RefactoringArb.getString(316), newName);
                return new Pair((Object)message, (Object)new Integer(2));
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._typeBrowse) {
            this.whenBrowse();
        } else if (source == this._moveUp) {
            this.whenMoveUp();
        } else if (source == this._moveDown) {
            this.whenMoveDown();
        } else if (source == this._add) {
            this.whenAdd();
        } else if (source == this._remove) {
            this.whenRemove();
        }
    }

    private void whenBrowse() {
        String initialType = this._typeField.getText();
        String trimmedType = initialType.replaceAll("[\\[\\]]", "");
        JavaType javaType = this._callerContext.resolveTypeName(trimmedType);
        String fqTypeName = javaType != null ? javaType.getQualifiedName() : initialType;
        String[] newType = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.getContext().getProject(), 2, false, null, fqTypeName);
        if (newType != null && newType.length == 1) {
            this._typeField.setText(newType[0]);
        }
    }

    private void whenMoveUp() {
        int selectedRow = this._paramTable.getSelectedRow();
        this.stopEditing();
        this._paramTableModel.moveRow(selectedRow, selectedRow, selectedRow - 1);
        this.setSelectedRow(selectedRow - 1);
    }

    private void whenMoveDown() {
        int selectedRow = this._paramTable.getSelectedRow();
        this.stopEditing();
        this._paramTableModel.moveRow(selectedRow, selectedRow, selectedRow + 1);
        this.setSelectedRow(selectedRow + 1);
    }

    private void stopEditing() {
        TableCellEditor cellEditor = this._paramTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private void whenAdd() {
        boolean hasEmptyRow = false;
        int rowCount = this._paramTableModel.getRowCount();
        int i = 0;
        while (!hasEmptyRow && i < rowCount) {
            if (this._paramTableModel.getStringAt(i, 1).length() == 0 || this._paramTableModel.getStringAt(i, 0).length() == 0) {
                this.setSelectedRow(i);
                hasEmptyRow = true;
            }
            ++i;
        }
        if (!hasEmptyRow) {
            int selectedRow = this._paramTable.getSelectedRow();
            this._paramTableModel.addRow(selectedRow + 1);
            this.setSelectedRow(selectedRow + 1);
            this._paramTable.requestFocus();
            this._paramTable.editCellAt(selectedRow + 1, 0);
        }
    }

    private void whenRemove() {
        int selectedRow = this._paramTable.getSelectedRow();
        SourceVariable removedVariable = this._paramTableModel.getVariableAt(selectedRow);
        boolean canRemove = true;
        if (removedVariable != null && MetSigDialog.isUsed((SourceElement)this._sourceMethod, removedVariable)) {
            int confirm = JOptionPane.showConfirmDialog(this, RefactoringArb.getString(321), RefactoringArb.getString(101), 0, 3);
            boolean bl = canRemove = confirm == 0;
        }
        if (canRemove) {
            this._paramTableModel.removeRow(selectedRow);
            if (selectedRow <= this._paramTableModel.getRowCount()) {
                --selectedRow;
            }
            if (selectedRow >= 0) {
                this.setSelectedRow(selectedRow);
            }
        }
    }

    private static boolean isUsed(SourceElement sourceElement, SourceVariable removedVariable) {
        SourceExpression sourceExpression;
        JavaHasType resolvedObject;
        if (sourceElement instanceof SourceExpression && removedVariable.equals(resolvedObject = (sourceExpression = (SourceExpression)sourceElement).getResolvedObject())) {
            return true;
        }
        List children = sourceElement.getChildren();
        int i = 0;
        while (i < children.size()) {
            SourceElement childElement = (SourceElement)children.get(i);
            if (MetSigDialog.isUsed(childElement, removedVariable)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setSelectedRow(int selectedRow) {
        ListSelectionModel selectionModel = this._paramTable.getSelectionModel();
        selectionModel.setSelectionInterval(selectedRow, selectedRow);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    private void updateButtons() {
        int row = this._paramTable.getSelectedRow();
        this._moveUp.setEnabled(row > 0);
        this._moveDown.setEnabled(0 <= row && row < this._paramTableModel.getRowCount() - 1);
        this._remove.setEnabled(row >= 0);
    }

    public ChangeMethodCriteria getOperation() {
        ArrayList<MetParam> metParams = new ArrayList<MetParam>();
        int rowCount = this._paramTableModel.getRowCount();
        ArrayList parameters = new ArrayList(this._sourceMethod.getParameters());
        int row = 0;
        while (row < rowCount) {
            SourceVariable sourceVariable = this._paramTableModel.getVariableAt(row);
            String tableTypeName = this._paramTableModel.getStringAt(row, 0);
            String tableParamName = this._paramTableModel.getStringAt(row, 1);
            if (sourceVariable != null) {
                int oldPosition = parameters.indexOf(sourceVariable);
                SourceTypeReference variableSourceType = sourceVariable.getSourceType();
                String newType = !ChangeMethodCriteria.isSameType(variableSourceType, tableTypeName) ? tableTypeName : null;
                String oldVariableName = sourceVariable.getName();
                String newName = oldVariableName.equals(tableParamName) ? null : tableParamName;
                MetParam metParam = new MetParam(oldPosition, newType, newName, null);
                metParams.add(metParam);
            } else if (tableParamName.length() != 0) {
                String defaultValue = this._paramTableModel.getStringAt(row, 2);
                SourceFactory factory = this._sourceMethod.getOwningSourceFile().getFactory();
                SourceTypeReference typeRef = factory.createTypeFromText(tableTypeName);
                JavaType type = typeRef.getResolvedType();
                MetParam metParam = new MetParam(-1, type.getQualifiedName(), tableParamName, defaultValue);
                metParams.add(metParam);
            }
            ++row;
        }
        MetParam[] params = metParams.toArray(new MetParam[metParams.size()]);
        ChangeMethodCriteria ret = new ChangeMethodCriteria(this._sourceMethod, params);
        String newMethodName = this._nameField.getText();
        ret.setNewMethodName(newMethodName);
        String newTypeName = this._typeField.getText();
        ret.setNewReturnType(newTypeName);
        String accessibility = this._accessField.getSelectedItem().toString();
        int accessibilityModifier = accessibility.equals("public") ? 1 : (accessibility.equals("protected") ? 4 : (accessibility.equals("private") ? 2 : 0));
        ret.setAccessibility(accessibilityModifier);
        ret.setUseTaks(this._addTasks.isSelected());
        ret.setPreview(this._preview.isSelected());
        ret.setUseExistingMethod(this._replace);
        return ret;
    }

    private boolean isValidDefaultValue(String defaultValue) {
        if (defaultValue == null || defaultValue.length() == 0) {
            return true;
        }
        int start = 0;
        int end = defaultValue.length() - 1;
        return (defaultValue.charAt(start) != '\"' || defaultValue.charAt(end) == '\"') && (defaultValue.charAt(start) == '\"' || defaultValue.charAt(end) != '\"');
    }

    static JTable ra$_paramTable(MetSigDialog metSigDialog) {
        return metSigDialog._paramTable;
    }

    final class 1
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            MetSigDialog.this.updateOKButton();
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ JComponent v$componentToFocus;
        private final /* synthetic */ int v$epr;
        private final /* synthetic */ int v$epc;
        final /* synthetic */ MetSigDialog this$0;

        public void run() {
            this.v$componentToFocus.requestFocus();
            if (this.v$epr != -1) {
                MetSigDialog.ra$_paramTable(this.this$0).editCellAt(this.v$epr, this.v$epc);
            }
        }

        public 2(MetSigDialog metSigDialog, JComponent jComponent, int n, int n2) {
            this.v$epc = n2;
            this.v$epr = n;
            this.v$componentToFocus = jComponent;
            this.this$0 = metSigDialog;
        }
    }
}

