/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.resource.RefactoringArb;

public class MetSigTableModel
extends DefaultTableModel {
    public static final int COL_TYPE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_DEFAULT = 2;
    private static final int PAIR_COLUMN = 0;

    public MetSigTableModel() {
        this.addColumn(RefactoringArb.getString(173));
        this.addColumn(RefactoringArb.getString(218));
        this.addColumn(RefactoringArb.getString(209));
    }

    public void setMethod(SourceMethod sourceMethod) {
        List sourceParameters = sourceMethod.getSourceParameters();
        for (SourceVariable sourceVariable : sourceParameters) {
            SourceTypeReference sourceType = sourceVariable.getSourceType();
            JavaType resolvedType = sourceType.getResolvedType();
            String typeName = resolvedType == null ? sourceType.getName() : resolvedType.getQualifiedName();
            String parameterName = sourceVariable.getName();
            Object[] rowData = new Object[]{new Pair((Object)typeName, (Object)sourceVariable), parameterName, null};
            this.addRow(rowData);
        }
    }

    public void addRow(int row) {
        Object[] rowData = new Object[]{new Pair((Object)"", null), "", null};
        this.insertRow(row, rowData);
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (column == 0) {
            Pair pair = (Pair)this.getValueAt(row, 0);
            pair.first = aValue;
        } else {
            super.setValueAt(aValue, row, column);
        }
    }

    public SourceVariable getVariableAt(int row) {
        Pair pair = (Pair)this.getValueAt(row, 0);
        return (SourceVariable)pair.second;
    }

    public String getStringAt(int row, int column) {
        String ret;
        Object value = this.getValueAt(row, column);
        if (column == 0) {
            Pair pair = (Pair)value;
            ret = (String)pair.first;
        } else {
            ret = (String)value;
        }
        return ret;
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            SourceVariable sourceVariable = this.getVariableAt(row);
            return sourceVariable == null;
        }
        return true;
    }
}

