/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MetParam;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.Scope;
import oracle.jdevimpl.refactoring.util.ExpressionUtil;
import oracle.jdevimpl.refactoring.util.Visitor;

public class MetSigUrlHandler
extends URLRefactoringHandler {
    private static final int USAGE_TYPE_CALL = 1;
    private static final int USAGE_TYPE_DECLARATION = 2;
    static final String HAS_TASKS = "HAS_TASKS";

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        if (searchType == -2147483532) {
            ChangeMethodCriteria changeMethodCriteria = (ChangeMethodCriteria)criteria;
            Context context = searchOperation.getContext();
            SourceMethod sourceMethod = changeMethodCriteria.getSourceMethod();
            JavaClass owningClass = sourceMethod.getOwningClass();
            if (owningClass != null) {
                if (sourceMethod.isPrivate() || owningClass.isPrivate()) {
                    ret = new Project[]{context.getProject()};
                } else {
                    String qualifiedName = owningClass.getQualifiedName();
                    ret = MetSigUrlHandler.getIncludedProjects(context, Scope.DUMMY_SCOPE, qualifiedName);
                }
            }
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet ret = null;
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        if (searchType == -2147483532) {
            ChangeMethodCriteria changeMethodCriteria = (ChangeMethodCriteria)criteria;
            SourceMethod sourceMethod = changeMethodCriteria.getSourceMethod();
            String methodName = sourceMethod.getName();
            ret = JavaURLHelper.getJavaURLsContaining(searchOperation, project, methodName, false, false, progressIndicator);
        }
        return ret;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        if (searchType == -2147483532) {
            ChangeMethodCriteria changeMethodCriteria = (ChangeMethodCriteria)criteria;
            SourceMethod changedSourceMethod = changeMethodCriteria.getSourceMethod();
            String methodName = changedSourceMethod.getName();
            usageModel = new UsageModel();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            int i = 0;
            while (i < urls.length) {
                URL url = urls[i];
                String step = UsageArb.format(7, urls.length - i);
                progressIndicator.setProgressStepText(step);
                SourceFile sourceFile = javaManager.getSourceFile(url);
                List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{53, 19});
                int j = 0;
                while (j < sourceElements.size()) {
                    SourceElement sourceElement = (SourceElement)sourceElements.get(j);
                    switch (sourceElement.getSymbolKind()) {
                        case 53: {
                            JavaMethod resolvedMethod;
                            String name;
                            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                            SourceName nameElement = sourceMethodCallExpression.getNameElement();
                            if (nameElement == null || !methodName.equals(name = nameElement.getName()) || !changedSourceMethod.equals((Object)(resolvedMethod = sourceMethodCallExpression.getResolvedMethod())) && (resolvedMethod == null || !resolvedMethod.getOverriddenMethods().contains(changedSourceMethod))) break;
                            usageModel.addUsageEntry(new SourceElementEntry(project, (SourceElement)nameElement, 1));
                            break;
                        }
                        case 19: {
                            String name;
                            SourceMethod sourceMethod;
                            SourceName nameElement;
                            if (changeMethodCriteria.isUseExistingMethod() || (nameElement = (sourceMethod = (SourceMethod)sourceElement).getNameElement()) == null || !methodName.equals(name = nameElement.getName()) || !changedSourceMethod.equals((Object)sourceMethod) && (!sourceMethod.hasSubsignatureOf((JavaMethod)changedSourceMethod) || !sourceMethod.getOverriddenMethods().contains(changedSourceMethod))) break;
                            SourceElementEntry usageEntry = new SourceElementEntry(project, (SourceElement)nameElement, 2);
                            usageModel.addUsageEntry(usageEntry);
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return usageModel;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.setSearchOperation(searchOperation);
        try {
            ChangeMethodCriteria changeMethodCriteria = (ChangeMethodCriteria)searchOperation.getCriteria();
            JavaType newResolvedType = null;
            String newReturnType = changeMethodCriteria.getNewReturnType();
            if (newReturnType != null) {
                SourceMethod changedSourceMethod = changeMethodCriteria.getSourceMethod();
                CallerContext context = CallerContext.createContext((SourceElement)changedSourceMethod);
                SourceFile owningSourceFile = changedSourceMethod.getOwningSourceFile();
                SourceFactory factory = owningSourceFile.getFactory();
                SourceTypeReference newSourceTypeReference = factory.createType(newReturnType);
                if (newSourceTypeReference != null) {
                    newSourceTypeReference.setContext(context);
                    newResolvedType = newSourceTypeReference.getResolvedType();
                }
            }
            ArrayList usageEntries = usageModel.getUsageEntries();
            int i = 0;
            while (i < usageEntries.size()) {
                SourceElementEntry sourceElementEntry = (SourceElementEntry)usageEntries.get(i);
                if (sourceElementEntry.isIncluded()) {
                    int usageType = sourceElementEntry.getUsageType();
                    SourceElement sourceElement = sourceElementEntry.getSourceElement();
                    switch (usageType) {
                        case 1: {
                            SourceElement parent;
                            SourceName sourceName = (SourceName)sourceElement;
                            if (sourceName == null || !((parent = sourceName.getParent()) instanceof SourceMethodCallExpression)) break;
                            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)parent;
                            MetSigUrlHandler.changeMethodCall(searchOperation, changeMethodCriteria, refactoringCommandSupport, (SourceInvokeExpression)sourceMethodCallExpression, newResolvedType);
                            break;
                        }
                        case 2: {
                            SourceName sourceName = (SourceName)sourceElement;
                            if (sourceName == null) break;
                            SourceMethod sourceMethod = (SourceMethod)sourceName.getParent();
                            MetSigUrlHandler.changeMethodDeclaration(changeMethodCriteria, refactoringCommandSupport, sourceMethod, newResolvedType);
                            break;
                        }
                    }
                }
                ++i;
            }
            ret = refactoringCommandSupport.commit(searchOperation.getContext(), "Change Method");
        }
        catch (Exception e) {
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private static void changeMethodCall(SearchOperation searchOperation, ChangeMethodCriteria changeMethodCriteria, RefactoringCommandSupport refactoringCommandSupport, SourceInvokeExpression sourceInvokeExpression, JavaType newSourceTypeReference) {
        String newMethodName;
        JavaType expectedType;
        refactoringCommandSupport.beginTransaction((SourceElement)sourceInvokeExpression);
        if (newSourceTypeReference != null && (expectedType = ExpressionUtil.getExpectedType((SourceExpression)sourceInvokeExpression)) != null && !expectedType.isAssignableFrom(newSourceTypeReference)) {
            MetSigUrlHandler.createTodoItem(searchOperation, refactoringCommandSupport, changeMethodCriteria, (SourceElement)sourceInvokeExpression, RefactoringArb.getString(265));
        }
        if ((newMethodName = changeMethodCriteria.getNewMethodName()) != null) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceInvokeExpression;
            refactoringCommandSupport.beginTransaction((SourceElement)sourceMethodCallExpression);
            sourceMethodCallExpression.setName(newMethodName);
        }
        if (changeMethodCriteria.isParamOrderChanged()) {
            refactoringCommandSupport.beginTransaction((SourceElement)sourceInvokeExpression);
            MetParam[] params = changeMethodCriteria.getParams();
            SourceExpression[] newArgs = new SourceExpression[params.length];
            SourceListExpression argumentList = sourceInvokeExpression.getArgumentList();
            List arguments = argumentList.getChildren();
            ArrayList<SourceExpression> newExpressions = new ArrayList<SourceExpression>();
            int i = 0;
            while (i < params.length) {
                SourceExpression sourceExpression;
                MetParam param = params[i];
                int oldPosition = param.getOldPosition();
                if (oldPosition >= 0) {
                    sourceExpression = (SourceExpression)arguments.get(oldPosition);
                } else {
                    String defaultValue = param.getDefaultValue();
                    SourceFile owningFile = sourceInvokeExpression.getOwningSourceFile();
                    SourceFactory factory = owningFile.getFactory();
                    sourceExpression = factory.createExpression(defaultValue);
                    newExpressions.add(sourceExpression);
                }
                newArgs[i] = sourceExpression;
                ++i;
            }
            arguments.clear();
            int i2 = 0;
            while (i2 < newArgs.length) {
                SourceExpression newArg = newArgs[i2];
                arguments.add(newArg);
                ++i2;
            }
            int i3 = 0;
            while (i3 < newExpressions.size()) {
                SourceExpression sourceExpression = (SourceExpression)newExpressions.get(i3);
                JavaType resolvedType = sourceExpression.getResolvedType();
                if (resolvedType == null) {
                    MetSigUrlHandler.createTodoItem(searchOperation, refactoringCommandSupport, changeMethodCriteria, (SourceElement)sourceInvokeExpression, RefactoringArb.getString(343));
                }
                ++i3;
            }
        }
        if (!MetSigUrlHandler.isAccessible(changeMethodCriteria, sourceInvokeExpression)) {
            MetSigUrlHandler.createTodoItem(searchOperation, refactoringCommandSupport, changeMethodCriteria, (SourceElement)sourceInvokeExpression, RefactoringArb.getString(330));
        }
    }

    private static void changeMethodDeclaration(ChangeMethodCriteria changeMethodCriteria, RefactoringCommandSupport refactoringCommandSupport, SourceMethod sourceMethod, JavaType newSourceTypeReference) {
        Integer newModifiers;
        String newName;
        SourceFile owningFile = sourceMethod.getOwningSourceFile();
        SourceFactory factory = owningFile.getFactory();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceMethod);
        List sourceParameters = sourceMethod.getSourceParameters();
        MetParam[] params = changeMethodCriteria.getParams();
        int i = 0;
        while (i < params.length) {
            int oldPosition;
            MetParam param = params[i];
            if (param.isNameChanged() && (oldPosition = param.getOldPosition()) >= 0) {
                SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(oldPosition);
                String oldName = sourceVariable.getName();
                String newName2 = param.getNewName();
                1 visitor = new 1(oldName, sourceVariable, newName2, factory);
                visitor.visit((SourceElement)sourceMethod);
            }
            ++i;
        }
        if (changeMethodCriteria.areParamsChanged()) {
            List sourceParameters2 = sourceMethod.getSourceParameters();
            MetParam[] params2 = changeMethodCriteria.getParams();
            SourceVariable[] newSourceVariables = new SourceVariable[params2.length];
            int i2 = 0;
            while (i2 < params2.length) {
                SourceVariable sourceVariable;
                MetParam metParam = params2[i2];
                int oldPosition = metParam.getOldPosition();
                if (oldPosition >= 0) {
                    sourceVariable = (SourceVariable)sourceParameters2.get(oldPosition);
                    if (metParam.isNameChanged()) {
                        String newName3 = metParam.getNewName();
                        sourceVariable.setName(newName3);
                    }
                    if (metParam.isTypeChanged()) {
                        String newType = metParam.getNewType();
                        SourceTypeReference sourceType = factory.createType(newType);
                        sourceVariable.setSourceType(sourceType);
                    }
                } else {
                    String newType = metParam.getNewType();
                    SourceTypeReference sourceType = factory.createType(newType);
                    String newName4 = metParam.getNewName();
                    sourceVariable = factory.createLocalVariable(sourceType, newName4);
                }
                newSourceVariables[i2] = sourceVariable;
                ++i2;
            }
            SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
            List children = formalParameterList.getChildren();
            children.removeAll(sourceParameters2);
            int i3 = 0;
            while (i3 < newSourceVariables.length) {
                SourceVariable newSourceVariable = newSourceVariables[i3];
                newSourceVariable.addSelf((SourceElement)formalParameterList);
                ++i3;
            }
        }
        if ((newName = changeMethodCriteria.getNewMethodName()) != null) {
            sourceMethod.setName(newName);
        }
        if (newSourceTypeReference != null) {
            String qualifiedName = newSourceTypeReference.getQualifiedName();
            SourceTypeReference newSourceType = factory.createType(qualifiedName);
            sourceMethod.setSourceReturnType(newSourceType);
        }
        if ((newModifiers = changeMethodCriteria.getNewModifiers()) != null) {
            sourceMethod.removeModifiers(7);
            sourceMethod.addModifiers(newModifiers.intValue());
        }
    }

    private static void createTodoItem(SearchOperation searchOperation, RefactoringCommandSupport refactoringCommandSupport, ChangeMethodCriteria changeMethodCriteria, SourceElement sourceElement, String description) {
        if (changeMethodCriteria.isUseTasks()) {
            String message = MessageFormat.format(RefactoringArb.getString(14), description);
            refactoringCommandSupport.addToDo(sourceElement, message);
            searchOperation.setProperty(HAS_TASKS, Boolean.TRUE);
        }
    }

    private static boolean isAccessible(ChangeMethodCriteria changeMethodCriteria, SourceInvokeExpression sourceInvokeExpression) {
        boolean ret;
        Integer newModifiers = changeMethodCriteria.getNewModifiers();
        if (newModifiers != null) {
            int modifiers = newModifiers;
            if (BitField.isSet((int)modifiers, (int)1)) {
                ret = true;
            } else if (BitField.isSet((int)modifiers, (int)2)) {
                ret = false;
            } else {
                SourceClass callingClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceInvokeExpression);
                if (callingClass != null) {
                    SourceMethod sourceMethod = changeMethodCriteria.getSourceMethod();
                    JavaClass calledClass = sourceMethod.getOwningClass();
                    ret = BitField.isSet((int)modifiers, (int)4) && calledClass.isAssignableFrom((JavaType)callingClass) ? true : calledClass.getPackageName().equals(callingClass.getPackageName());
                } else {
                    ret = false;
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    static final class 1
    extends Visitor {
        private final /* synthetic */ String v$oldName;
        private final /* synthetic */ SourceVariable v$sourceVariable;
        private final /* synthetic */ String v$newName;
        private final /* synthetic */ SourceFactory v$factory;

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject;
            String expressionName = sourceSimpleNameExpression.getName();
            if (this.v$oldName.equals(expressionName) && this.v$sourceVariable.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
                sourceSimpleNameExpression.setName(this.v$newName);
            }
        }

        protected void whenEnterDocBlockTag(SourceDocBlockTag sourceDocBlockTag) {
            SourceFormalParameter resolvedParameter;
            SourceDocReference sourceDocReference;
            String tagName = sourceDocBlockTag.getName();
            if ("@param".equals(tagName) && (sourceDocReference = sourceDocBlockTag.getReference()) != null && this.v$sourceVariable.equals(resolvedParameter = sourceDocReference.getResolvedParameter())) {
                SourceDocReference newDocReference = this.v$factory.createDocReference(this.v$newName, null, null);
                sourceDocReference.removeSelf();
                newDocReference.addSelf((SourceElement)sourceDocBlockTag);
            }
        }

        public 1(String string, SourceVariable sourceVariable, String string2, SourceFactory sourceFactory) {
            this.v$factory = sourceFactory;
            this.v$newName = string2;
            this.v$sourceVariable = sourceVariable;
            this.v$oldName = string;
        }
    }
}

