/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigDialog;
import oracle.jdevimpl.refactoring.oprs.metsig.NameDocumentListener;
import oracle.jdevimpl.refactoring.oprs.metsig.TypeDocumentListener;

class ParamTable
extends NiceTable {
    private TypeDocumentListener _typeDocumentListener;
    private NameDocumentListener _nameDocumentListener;
    private JavaProvider _javaProvider;
    private CallerContext _callerContext;
    private SourceFile _owningSourceFile;

    public ParamTable(SourceMethod sourceMethod, TableModel tableModel) {
        super(tableModel);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._typeDocumentListener = new TypeDocumentListener(sourceMethod);
        this._nameDocumentListener = new NameDocumentListener(sourceMethod);
        SourceFile owningFile = this._owningSourceFile = sourceMethod.getOwningSourceFile();
        this._javaProvider = owningFile.getProvider();
        this._callerContext = CallerContext.createContext((SourceElement)sourceMethod);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor cellEditor = super.getCellEditor(row, column);
        this._typeDocumentListener.detachFromEditor(cellEditor);
        this._nameDocumentListener.detachFromEditor(cellEditor);
        switch (column) {
            case 0: {
                this._typeDocumentListener.attachToEditor(cellEditor);
                break;
            }
            case 1: {
                this._nameDocumentListener.attachToEditor(cellEditor);
                break;
            }
        }
        return cellEditor;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        switch (column) {
            case 0: {
                String tooltip;
                JLabel label = (JLabel)component;
                String typeName = label.getText();
                boolean isValid = false;
                if (MetSigDialog.isValidTypeName(typeName, this._owningSourceFile)) {
                    JavaType javaType = MetSigDialog.resolveType(this._javaProvider, this._callerContext, typeName);
                    if (javaType != null) {
                        isValid = true;
                        tooltip = javaType.getQualifiedName();
                    } else {
                        tooltip = typeName;
                    }
                } else {
                    tooltip = MessageFormat.format("Invalid type name: {0}", typeName);
                }
                this.setApparence(label, row, column, isValid, tooltip);
                break;
            }
            case 1: {
                String tooltip;
                JLabel label = (JLabel)component;
                String paramName = label.getText();
                boolean isValid = false;
                if (NamingUtil.isJavaIdentifier((String)paramName)) {
                    tooltip = paramName;
                    isValid = true;
                } else {
                    tooltip = RefactoringArb.getString(89);
                }
                this.setApparence(label, row, column, isValid, tooltip);
                break;
            }
            default: {
                if (!(component instanceof JComponent)) break;
                JComponent jComponent = (JComponent)component;
                jComponent.setToolTipText(null);
            }
        }
        return component;
    }

    private void setApparence(JLabel label, int row, int column, boolean valid, String tooltip) {
        boolean isSelected;
        Color cellForeground = valid ? ((isSelected = this.isCellSelected(row, column)) ? UIManager.getColor("Table.selectionForeground") : UIManager.getColor("Table.foreground")) : Color.RED;
        label.setToolTipText(tooltip);
        label.setForeground(cellForeground);
    }
}

