/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveSecondaryClassDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveSecondaryOperation;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberController;
import oracle.jdevimpl.refactoring.oprs.movemember.movestatic.MoveStaticOperation;
import oracle.jdevimpl.refactoring.oprs.rename.RenameController;

public class MoveController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            if (context.getView() instanceof NavigatorWindow) {
                return MoveController.updateFromNavigator(action, context);
            }
            ElementAt elementAt = ElementAt.findElementAt(context);
            int type = elementAt != null ? elementAt.getElementType() : -1;
            switch (type) {
                case 1: {
                    SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                    if (sourceClass == null) break;
                    canHandle = MoveController.canMoveClass(context, sourceClass);
                    break;
                }
                case 3: {
                    SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                    if (sourceMethod == null) break;
                    if (sourceMethod.isStatic()) {
                        canHandle = MoveController.canMoveStaticMember(context, (SourceMember)sourceMethod);
                        break;
                    }
                    canHandle = MoveInstanceMemberController.canMoveMember(context, sourceMethod);
                    break;
                }
                case 4: {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)elementAt.getSourceElement();
                    if (sourceFieldVariable == null) break;
                    canHandle = MoveController.canMoveStaticMember(context, (SourceMember)sourceFieldVariable);
                    break;
                }
                case 6: {
                    JavaPackage javaPackage = elementAt.getJavaPackage();
                    if (javaPackage == null) break;
                    canHandle = true;
                    break;
                }
                default: {
                    Context defaultContext = new Context(context);
                    defaultContext.setSelection(new Element[]{context.getNode()});
                    canHandle = MoveController.updateFromNavigator(action, defaultContext);
                    if (canHandle) break;
                    return false;
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    private static boolean canMoveSourceNode(Context context, JavaSourceNode javaSourceNode) {
        SourceClass sourceClass;
        boolean ret = false;
        Project project = context.getProject();
        URL url = javaSourceNode.getURL();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceFile sourceFile = javaManager.getSourceFile(url);
        if (sourceFile != null && (sourceClass = sourceFile.getSourcePrimaryClass()) != null) {
            ret = MoveController.canMoveClass(context, sourceClass);
        }
        return ret;
    }

    public static boolean canMoveClass(Context context, SourceClass sourceClass) {
        boolean ret = false;
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        URL url = sourceFile.getURL();
        if (sourceClass.getPackage() != null && Util.canRefactor(context, url)) {
            ret = true;
        }
        return ret;
    }

    private static boolean verifyMovePackage(JavaPackage javaPackage, Context context) {
        return MoveController.checkCanRefactorPackage(context, javaPackage, RefactoringArb.getString(18));
    }

    public static boolean checkCanRefactorPackage(Context context, JavaPackage javaPackage, String title) {
        boolean ret = true;
        Collection declaredClasses = javaPackage.getDeclaredClasses();
        Iterator iterator = declaredClasses.iterator();
        while (ret && iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
            if (sourceClass == null) continue;
            if (Util.isClassInSources(context.getWorkspace(), context.getProject(), sourceClass)) {
                SourceFile owningFile = sourceClass.getOwningSourceFile();
                URL url = owningFile.getURL();
                if (Util.canRefactor(url)) continue;
                String message = MessageFormat.format(RefactoringArb.getString(272), URLFileSystem.getPlatformPathName((URL)url));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                ret = false;
                continue;
            }
            String message = MessageFormat.format(RefactoringArb.getString(272), javaClass.getQualifiedName());
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
            ret = false;
        }
        Collection subPackages = javaPackage.getPackages();
        Iterator iterator2 = subPackages.iterator();
        while (ret && iterator2.hasNext()) {
            JavaPackage subPackage = (JavaPackage)iterator2.next();
            if (MoveController.verifyMovePackage(subPackage, context)) continue;
            ret = false;
        }
        return ret;
    }

    public static boolean canMoveStaticMember(Context context, SourceMember sourceMember) {
        SourceFile sourceFile;
        URL url;
        boolean ret = false;
        if (sourceMember.isStatic() && Util.canRefactor(context, url = (sourceFile = sourceMember.getOwningSourceFile()).getURL())) {
            ret = true;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(IdeAction action, Context context) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            ElementAt elementAt = ElementAt.findElementAt(context);
            int type = elementAt != null ? elementAt.getElementType() : -1;
            switch (type) {
                case 1: {
                    SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                    MoveController.whenMoveClass(context, sourceClass);
                    return true;
                }
                case 3: {
                    SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                    if (sourceMethod == null) return true;
                    if (sourceMethod.isStatic()) {
                        MoveController.whenMoveStaticMembers(context, (SourceMember)sourceMethod);
                        return true;
                    } else {
                        this.whenMoveInstanceMember(context, sourceMethod);
                    }
                    return true;
                }
                case 4: {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)elementAt.getSourceElement();
                    if (sourceFieldVariable == null) return true;
                    MoveController.whenMoveStaticMembers(context, (SourceMember)sourceFieldVariable);
                    return true;
                }
                case 6: {
                    JavaPackage javaPackage = elementAt.getJavaPackage();
                    if (javaPackage == null || !MoveController.verifyMovePackage(javaPackage, context)) return true;
                    MoveController.whenMovePackage(context, javaPackage);
                    return true;
                }
                default: {
                    Context defaultContext = new Context(context);
                    defaultContext.setSelection(new Element[]{context.getNode()});
                    if (!MoveController.updateFromNavigator(action, defaultContext)) return false;
                    MoveController.handleEventFromNavigator(defaultContext);
                    return true;
                }
            }
        }
        if (!MoveController.updateFromNavigator(action, context)) return false;
        MoveController.handleEventFromNavigator(context);
        return true;
    }

    private void whenMoveInstanceMember(Context context, SourceMethod sourceMethod) {
        MoveInstanceMemberController.whenMoveMembers(context, sourceMethod);
    }

    public static void whenMoveClass(Context context, SourceClass sourceClass) {
        if (!sourceClass.isMemberClass()) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            if (sourceClass == Patch.getMainClass(sourceFile)) {
                MoveController.whenMoveOuterClass(context, sourceClass);
            } else {
                MoveController.whenMovePrivateClass(context, sourceClass);
            }
        } else {
            MoveController.whenMoveInnerClass(context, sourceClass);
        }
    }

    private static void whenMoveOuterClass(Context context, SourceClass sourceClass) {
        boolean tryAgain;
        String oldFqClassName = sourceClass.getQualifiedName();
        String shortTitle = MessageFormat.format(RefactoringArb.getString(276), oldFqClassName);
        String oldPackageName = sourceClass.getPackageName();
        SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
        JavaProvider provider = owningSourceFile.getProvider();
        SourceClass sourceClassByName = provider.getSourceClass(sourceClass.getQualifiedName());
        boolean classAtWrongPlace = sourceClassByName == null;
        MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, shortTitle, oldPackageName);
        if (classAtWrongPlace) {
            moveClassesDialog.setAllowSamePackage();
        }
        do {
            tryAgain = false;
            if (!moveClassesDialog.runDialog() || !MoveController.isValidMove(sourceClass, shortTitle)) continue;
            String newPackageName = moveClassesDialog.getNewPackageName();
            boolean searchInComments = moveClassesDialog.isSearchInComments();
            boolean searchInNonJavaFiles = moveClassesDialog.isSearchInNonJavaFiles();
            ClassDescription classDescription = ClassDescription.createClassDescription((JavaClass)sourceClass);
            String className = classDescription.getClassName();
            String newFqClassName = Util.getFqClassName(newPackageName, className);
            String longTitle = MessageFormat.format(RefactoringArb.getString(133), oldFqClassName, newFqClassName);
            MoveClassesCriteria criteria = new MoveClassesCriteria(searchInComments, searchInNonJavaFiles, longTitle, shortTitle);
            if (classAtWrongPlace) {
                criteria.hintMisplacedFile(owningSourceFile);
            }
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            String patchedPackageName = newPackageName.replace('.', '/');
            URL packageUrl = PathsConfiguration.getURLForPackage((String)patchedPackageName, (Context)context);
            if (packageUrl != null) {
                criteria.setPreferredPackageUrl(newPackageName, packageUrl);
                criteria.addClassMove(javaManager, oldPackageName, className, newPackageName, className);
                URL overwrittenUrl = criteria.getOverwrittenUrl();
                if (overwrittenUrl == null) {
                    MoveClassesOperation searchOperation = new MoveClassesOperation(context, criteria);
                    boolean preview = moveClassesDialog.isPreview();
                    ((SearchOperationImpl)searchOperation).runRefactoring(preview);
                    continue;
                }
                String message = MessageFormat.format(RefactoringArb.getString(163), URLFileSystem.getPlatformPathName((URL)overwrittenUrl));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)criteria.getShortTitle(), null);
                tryAgain = true;
                continue;
            }
            tryAgain = true;
        } while (tryAgain);
    }

    private static boolean isValidMove(SourceClass sourceClass, String shortTitle) {
        String packageName = sourceClass.getPackageName();
        if (!ModelUtil.hasLength((String)packageName)) {
            List sourceElements = SourceElementAsList.asList((SourceElement)sourceClass.getOwningSourceFile(), (int[])new int[]{57, 27});
            int i = 0;
            while (i < sourceElements.size()) {
                JavaClass javaClass;
                JavaHasType resolvedObject;
                SourceElement sourceElement = (SourceElement)sourceElements.get(i);
                if (sourceElement.getSymbolKind() == 57) {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                } else {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    resolvedObject = sourceTypeReference.getResolvedType();
                }
                if (resolvedObject != null && resolvedObject.getElementKind() == 3 && !sourceClass.equals((Object)(javaClass = (JavaClass)resolvedObject)) && !ModelUtil.hasLength((String)javaClass.getPackageName())) {
                    String message = MessageFormat.format(RefactoringArb.getString(7), sourceClass.getName());
                    boolean confirm = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)shortTitle, null);
                    return confirm;
                }
                ++i;
            }
        }
        return true;
    }

    private static void whenMovePackage(Context context, JavaPackage javaPackage) {
        String name;
        String packageName = javaPackage.getName();
        String title = MessageFormat.format(RefactoringArb.getString(65), packageName);
        String prefix = "";
        JavaPackage owningPackage = javaPackage.getOwningPackage();
        if (owningPackage != null && (name = owningPackage.getName()) != null && name.length() != 0) {
            prefix = name;
        }
        MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, title, prefix);
        boolean tryAgain = false;
        do {
            if (!moveClassesDialog.runDialog()) continue;
            String oldPackageName = owningPackage.getName();
            String oldPrefix = oldPackageName.length() == 0 ? "" : oldPackageName + '.';
            String newPackageName = moveClassesDialog.getNewPackageName();
            String newPrefix = newPackageName.length() != 0 ? newPackageName + '.' : "";
            String shortTitle = MessageFormat.format(RefactoringArb.getString(276), oldPackageName);
            String longTitle = MessageFormat.format(RefactoringArb.getString(133), oldPackageName, newPackageName);
            MoveClassesCriteria criteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), longTitle, shortTitle);
            MoveController.addPackageMoves(context, criteria, packageName, oldPrefix, newPrefix);
            URL overwrittenUrl = criteria.getOverwrittenUrl();
            if (overwrittenUrl == null) {
                MoveClassesOperation searchOperation = new MoveClassesOperation(context, criteria);
                boolean preview = moveClassesDialog.isPreview();
                ((SearchOperationImpl)searchOperation).runRefactoring(preview);
                continue;
            }
            String message = MessageFormat.format(RefactoringArb.getString(163), URLFileSystem.getPlatformPathName((URL)overwrittenUrl));
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)criteria.getShortTitle(), null);
            tryAgain = true;
        } while (tryAgain);
    }

    public static void addPackageMoves(Context context, MoveClassesCriteria criteria, String oldPackageName, String owingPackagePrefix, String newPackagePrefix) {
        Project project = context.getProject();
        String packagePath = oldPackageName.replace('.', '/');
        String suffix = packagePath.substring(owingPackagePrefix.length());
        String newSuffix = newPackagePrefix.replace('.', '/') + suffix;
        ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
        URLPath javaRootDirs = projectContent.getJavaRootDirs();
        URL[] entries = javaRootDirs.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL entry = entries[i];
            URL sourceUrl = URLFactory.newDirURL((URL)entry, (String)packagePath);
            if (URLFileSystem.exists((URL)sourceUrl)) {
                criteria.addDirectoryMove(JavaManager.getJavaManager((Project)project), entry, packagePath, project, entry, newSuffix);
            }
            ++i;
        }
    }

    private static void whenMoveInnerClass(Context context, SourceClass sourceClass) {
        MoveInnerDialog moveInnerDialog = new MoveInnerDialog(context, sourceClass);
        if (moveInnerDialog.runDialog()) {
            String fieldName = moveInnerDialog.getFieldName();
            String variableName = moveInnerDialog.getParameterName();
            String className = moveInnerDialog.getClassName();
            MoveInnerOperation moveInnerOperation = new MoveInnerOperation(context, sourceClass, className, fieldName, variableName);
            moveInnerOperation.doRefactoring();
        }
    }

    private static void whenMovePrivateClass(Context context, SourceClass sourceClass) {
        MoveSecondaryClassDialog moveSecondaryClassDialog = new MoveSecondaryClassDialog(context, sourceClass);
        if (moveSecondaryClassDialog.runDialog()) {
            String className = moveSecondaryClassDialog.getClassName();
            MoveSecondaryOperation moveSecondaryOperation = new MoveSecondaryOperation(context, sourceClass, className);
            moveSecondaryOperation.doRefactoring();
        }
    }

    public static void whenMoveStaticMembers(Context context, SourceMember sourceMember) {
        MoveStaticOperation moveStaticOperation = new MoveStaticOperation();
        moveStaticOperation.whenMoveMembers(context, sourceMember);
    }

    private static boolean updateFromNavigator(IdeAction action, Context context) {
        Element[] selection = context.getSelection();
        if (selection.length <= 0) {
            action.setEnabled(false);
            return true;
        }
        Element firstElement = selection[0];
        if (firstElement instanceof RelativeDirectoryContextFolder) {
            RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)firstElement;
            boolean canHandle = false;
            String relativePath = relativeDirectoryContextFolder.getRelativePath();
            if (ModelUtil.hasLength((String)relativePath)) {
                canHandle = true;
            }
            action.setEnabled(canHandle);
            return true;
        }
        if (firstElement instanceof JavaSourceNode) {
            boolean canHandle = true;
            int i = 0;
            while (canHandle && i < selection.length) {
                Element element = selection[i];
                if (element instanceof JavaSourceNode) {
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    canHandle = MoveController.canMoveSourceNode(context, javaSourceNode);
                } else {
                    canHandle = false;
                }
                ++i;
            }
            action.setEnabled(canHandle);
            return true;
        }
        if (firstElement instanceof Node && selection.length == 1) {
            boolean canHandle = true;
            Node node = (Node)firstElement;
            canHandle = Util.canRefactor(node.getURL());
            action.setEnabled(canHandle);
            return true;
        }
        return false;
    }

    private static void handleEventFromNavigator(Context context) {
        String dialogTitle;
        MoveClassesDialog moveClassesDialog;
        Element[] selection = context.getSelection();
        if (selection.length == 1 && selection[0] instanceof Node && !(selection[0] instanceof JavaSourceNode)) {
            Node node = (Node)selection[0];
            RenameController.whenRenameUrl(context, node.getURL(), false);
            return;
        }
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        ArrayList<String> packageNames = new ArrayList<String>();
        ArrayList<JavaSourceNode> sourceNodes = new ArrayList<JavaSourceNode>();
        String commonPackageName = null;
        boolean canHandle = true;
        String moveWhatTitle = null;
        int moveCount = 0;
        int i = 0;
        while (canHandle && i < selection.length) {
            Element element = selection[i];
            String packageName = null;
            if (element instanceof RelativeDirectoryContextFolder) {
                RelativeDirectoryContextFolder contextFolder = (RelativeDirectoryContextFolder)element;
                String relativePath = contextFolder.getRelativePath();
                packageName = relativePath.replace('/', '.');
                JavaPackage javaPackage = javaManager.getPackage(packageName);
                canHandle = MoveController.verifyMovePackage(javaPackage, context);
                if (canHandle) {
                    packageNames.add(packageName);
                    moveWhatTitle = packageName;
                    ++moveCount;
                }
            } else if (element instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                sourceNodes.add(javaSourceNode);
                packageName = javaSourceNode.getPackage(project);
                if (moveCount == 0) {
                    String qualifiedName;
                    URL url = javaSourceNode.getURL();
                    SourceFile sourceFile = javaManager.getSourceFile(url);
                    JavaClass primaryClass = sourceFile.getPrimaryClass();
                    moveWhatTitle = qualifiedName = primaryClass.getQualifiedName();
                }
                ++moveCount;
            }
            if (commonPackageName == null) {
                commonPackageName = packageName;
            } else if (!commonPackageName.equals(packageName)) {
                commonPackageName = "";
            }
            ++i;
        }
        if (canHandle && (moveClassesDialog = new MoveClassesDialog(context, dialogTitle = moveCount == 1 ? MessageFormat.format(RefactoringArb.getString(276), moveWhatTitle) : RefactoringArb.getString(59), commonPackageName)).runDialog()) {
            String moveWhat;
            if (packageNames.size() == 1 && sourceNodes.size() == 0) {
                moveWhat = (String)packageNames.get(0);
            } else if (packageNames.size() == 0 && sourceNodes.size() == 1) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)sourceNodes.get(0);
                URL url = javaSourceNode.getURL();
                SourceFile sourceFile = javaManager.getSourceFile(url);
                SourceClass sourceClass = sourceFile.getSourcePrimaryClass();
                moveWhat = sourceClass.getQualifiedName();
            } else {
                moveWhat = RefactoringArb.getString(106);
            }
            String newPackageName = moveClassesDialog.getNewPackageName();
            String shortTitle = MessageFormat.format(RefactoringArb.getString(276), moveWhat);
            String longTitle = MessageFormat.format(RefactoringArb.getString(133), moveWhat, newPackageName);
            MoveClassesCriteria criteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), longTitle, shortTitle);
            int i2 = 0;
            while (i2 < packageNames.size()) {
                String packageName = (String)packageNames.get(i2);
                JavaPackage javaPackage = javaManager.getPackage(packageName);
                JavaPackage owningPackage = javaPackage.getOwningPackage();
                String oldPackageName = owningPackage.getName();
                String oldPrefix = oldPackageName.length() == 0 ? "" : oldPackageName + '.';
                String newPrefix = newPackageName.length() != 0 ? newPackageName + '.' : "";
                MoveController.addPackageMoves(context, criteria, packageName, oldPrefix, newPrefix);
                ++i2;
            }
            int i3 = 0;
            while (i3 < sourceNodes.size()) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)sourceNodes.get(i3);
                URL url = javaSourceNode.getURL();
                SourceFile sourceFile = javaManager.getSourceFile(url);
                if (sourceFile != null) {
                    JavaClass javaClass = sourceFile.getPrimaryClass();
                    SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                    String className = sourceClass.getName();
                    String oldPackageName = sourceClass.getPackageName();
                    String patchedPackageName = newPackageName.replace('.', '/');
                    if (criteria.getPreferredUrl(patchedPackageName) == null) {
                        URL packageUrl = MoveController.getSourcePath(url, oldPackageName, patchedPackageName);
                        criteria.setPreferredPackageUrl(newPackageName, packageUrl);
                    }
                    criteria.addClassMove(javaManager, oldPackageName, className, newPackageName, className);
                }
                ++i3;
            }
            MoveClassesOperation searchOperation = new MoveClassesOperation(context, criteria);
            boolean preview = moveClassesDialog.isPreview();
            ((SearchOperationImpl)searchOperation).runRefactoring(preview);
        }
    }

    public static boolean canMoveClasses(Context context, SourceClass[] sourceClasses) {
        switch (sourceClasses.length) {
            case 0: {
                return false;
            }
            case 1: {
                return MoveController.canMoveClass(context, sourceClasses[0]);
            }
        }
        int i = 0;
        while (i < sourceClasses.length) {
            SourceClass sourceClass = sourceClasses[i];
            SourceElement parent = sourceClass.getParent();
            if (parent.getSymbolKind() != 11) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sourceClasses.length) {
            SourceClass sourceClass = sourceClasses[i2];
            if (!MoveController.canMoveClass(context, sourceClass)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static void whenMoveClasses(Context context, SourceClass[] sourceClasses) {
        if (sourceClasses.length > 1) {
            int i = 0;
            while (i < sourceClasses.length) {
                SourceClass sourceClass = sourceClasses[i];
                SourceElement parent = sourceClass.getParent();
                if (parent.getSymbolKind() != 11) {
                    throw new IllegalArgumentException("Invalid class: " + sourceClass.getQualifiedName());
                }
                ++i;
            }
            String packageName = sourceClasses[0].getPackageName();
            int i2 = 1;
            while (i2 < sourceClasses.length) {
                SourceClass sourceClass = sourceClasses[i2];
                if (!packageName.equals(sourceClass.getPackageName())) {
                    packageName = "";
                    break;
                }
                ++i2;
            }
            String title = RefactoringArb.getString(59);
            MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, title, packageName);
            if (moveClassesDialog.runDialog()) {
                MoveClassesCriteria criteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), title, title);
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                String newPackageName = moveClassesDialog.getNewPackageName();
                int i3 = 0;
                while (i3 < sourceClasses.length) {
                    SourceClass sourceClass = sourceClasses[i3];
                    String className = sourceClass.getName();
                    String oldPackageName = sourceClass.getPackageName();
                    String patchedPackageName = newPackageName.replace('.', '/');
                    if (criteria.getPreferredUrl(patchedPackageName) == null) {
                        URL packageUrl = PathsConfiguration.getURLForPackage((String)patchedPackageName, (Context)context);
                        criteria.setPreferredPackageUrl(newPackageName, packageUrl);
                    }
                    criteria.addClassMove(javaManager, oldPackageName, className, newPackageName, className);
                    ++i3;
                }
                MoveClassesOperation searchOperation = new MoveClassesOperation(context, criteria);
                boolean preview = moveClassesDialog.isPreview();
                ((SearchOperationImpl)searchOperation).runRefactoring(preview);
            }
        } else {
            MoveController.whenMoveClass(context, sourceClasses[0]);
        }
    }

    private static URL getSourcePath(URL url, String oldPackageName, String patchedPackageName) {
        String oldSourceAbsoluteDir = URLFileSystem.getParent((URL)url).getPath().toString();
        String oldPackageRelativeDir = oldPackageName.replace('.', '/');
        String sourcePath = oldSourceAbsoluteDir.substring(0, oldSourceAbsoluteDir.length() - oldPackageRelativeDir.length() - 1);
        return URLFactory.newDirURL((URL)URLFactory.newDirURL((String)sourcePath), (String)patchedPackageName);
    }
}

