/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.refactoring.criteria.MoveFilesCriteria;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class MoveFilesOperation
extends SearchOperationImpl {
    public MoveFilesOperation(Context context, MoveFilesCriteria criteria) {
        super(context, criteria);
    }

    public boolean runRefactoring(boolean preview) {
        boolean ret = false;
        if (!this.urlsAlreadyExist()) {
            ret = super.runRefactoring(preview);
        }
        return ret;
    }

    private boolean urlsAlreadyExist() {
        boolean ret = false;
        MoveFilesCriteria moveFilesCriteria = (MoveFilesCriteria)this.getCriteria();
        URL overwrittenUrl = moveFilesCriteria.getOverwrittenUrl();
        if (overwrittenUrl != null) {
            if (Ide.isRunning()) {
                String message = MessageFormat.format(RefactoringArb.getString(163), URLFileSystem.getPlatformPathName((URL)overwrittenUrl));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)moveFilesCriteria.getShortTitle(), null);
            }
            ret = true;
        }
        return ret;
    }

    protected void applyResults() throws Exception {
        super.applyResults();
        MoveFilesCriteria moveClassesCriteria = (MoveFilesCriteria)this.getCriteria();
        MoveFilesCommand moveFilesCommand = new MoveFilesCommand(this.getContext(), moveClassesCriteria);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        int ret = commandProcessor.invoke((Command)moveFilesCommand);
        if (ret != 0) {
            throw new AbortedOperationException();
        }
    }

    Command createMoveFilesCommandForTest(MoveFilesCriteria moveClassesCriteria) {
        return new MoveFilesCommand(null, moveClassesCriteria);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveFilesCommand
    extends Command {
        private ArrayList<URL> _createDirectories;
        private LinkedList<Pair<URL, URL>> _movesSequence;
        private final String _shortTitle;

        public MoveFilesCommand(Context context, MoveFilesCriteria moveClassesCriteria) {
            super(-1, 3, "noname");
            this.context = context;
            List<Pair<URL, URL>> movesSequence = moveClassesCriteria.getMovesSequence();
            this._movesSequence = new LinkedList<Pair<URL, URL>>(movesSequence);
            this._shortTitle = moveClassesCriteria.getShortTitle();
        }

        private URL createParentDirectories(URL url) {
            URL parent = URLFileSystem.getParent((URL)url);
            if (URLFileSystem.exists((URL)parent)) {
                return null;
            }
            URL created = this.createParentDirectories(parent);
            URLFileSystem.mkdir((URL)parent);
            return created == null ? parent : created;
        }

        /*
         * Unable to fully structure code
         */
        public int doit() throws Exception {
            block11: {
                ret = 0;
                moved = new LinkedList<Pair<URL, URL>>();
                toMove = new LinkedList<Pair<URL, URL>>(this._movesSequence);
                try {
                    this._createDirectories = new ArrayList<E>();
                    while (!toMove.isEmpty()) {
                        pair = toMove.removeFirst();
                        oldUrl = (URL)pair.first;
                        newUrl = (URL)pair.second;
                        if (!URLFileSystem.exists((URL)oldUrl)) continue;
                        if (URLFileSystem.isDirectory((URL)newUrl) && URLFileSystem.isDirectory((URL)oldUrl)) {
                            this.split(oldUrl, newUrl, toMove);
                            continue;
                        }
                        createdRootDir = this.createParentDirectories(newUrl);
                        if (createdRootDir != null) {
                            this._createDirectories.add(createdRootDir);
                        }
                        try {
                            URLFileSystem.renameEx((URL)oldUrl, (URL)newUrl);
                        }
                        catch (IOException e) {
                            message = MessageFormat.format("Failed to move {0} to {1}:{2}", new Object[]{URLFileSystem.getPlatformPathName((URL)oldUrl), URLFileSystem.getPlatformPathName((URL)newUrl), e.getMessage()});
                            if (Ide.isRunning()) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)this._shortTitle, null);
                            } else {
                                System.err.println(message);
                            }
                            throw e;
                        }
                        moved.addLast(pair);
                    }
                    this._movesSequence = moved;
                    break block11;
                }
                catch (Exception e) {
                    ** while (!moved.isEmpty())
                }
lbl-1000:
                // 1 sources

                {
                    pair = (Pair)moved.removeLast();
                    oldUrl = (URL)pair.first;
                    newUrl = (URL)pair.second;
                    if (!URLFileSystem.exists((URL)newUrl) || URLFileSystem.exists((URL)oldUrl)) continue;
                    parent = URLFileSystem.getParent((URL)oldUrl);
                    URLFileSystem.mkdirs((URL)parent);
                    URLFileSystem.renameEx((URL)newUrl, (URL)oldUrl);
                    continue;
                }
lbl43:
                // 1 sources

                i = 0;
                while (i < this._createDirectories.size()) {
                    url = this._createDirectories.get(i);
                    URLFileSystem.delete((URL)url);
                    ++i;
                }
                ret = 1;
            }
            return ret;
        }

        private void split(URL oldUrl, URL newUrl, LinkedList<Pair<URL, URL>> movesSequence) {
            URL[] oldChildren;
            URL[] uRLArray = oldChildren = URLFileSystem.list((URL)oldUrl);
            int n = 0;
            while (n < uRLArray.length) {
                URL oldChild = uRLArray[n];
                String suffix = URLFileSystem.toRelativeSpec((URL)oldChild, (URL)oldUrl);
                URL newChild = URLFileSystem.isDirectory((URL)oldChild) ? URLFactory.newDirURL((URL)newUrl, (String)suffix) : URLFactory.newURL((URL)newUrl, (String)suffix);
                Pair newPair = new Pair((Object)oldChild, (Object)newChild);
                movesSequence.addFirst((Pair<URL, URL>)newPair);
                ++n;
            }
        }

        /*
         * Unable to fully structure code
         */
        public int undo() throws Exception {
            block12: {
                ret = 0;
                moved = new LinkedList<Pair<URL, URL>>();
                toMove = new LinkedList<Pair<URL, URL>>(this._movesSequence);
                try {
                    try {
                        while (!toMove.isEmpty()) {
                            pair = toMove.removeLast();
                            oldUrl = (URL)pair.first;
                            newUrl = (URL)pair.second;
                            try {
                                URLFileSystem.renameEx((URL)newUrl, (URL)oldUrl);
                            }
                            catch (IOException e) {
                                message = MessageFormat.format("Failed to move {0} to {1}:{2}", new Object[]{URLFileSystem.getPlatformPathName((URL)newUrl), URLFileSystem.getPlatformPathName((URL)oldUrl), e.getMessage()});
                                if (Ide.isRunning()) {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)this._shortTitle, null);
                                } else {
                                    System.err.println(message);
                                }
                                throw e;
                            }
                            moved.add(pair);
                        }
                        i = this._createDirectories.size() - 1;
                        while (i >= 0) {
                            url = this._createDirectories.get(i);
                            this.deleteDirectory(url);
                            --i;
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        ** while (!moved.isEmpty())
                    }
lbl-1000:
                    // 1 sources

                    {
                        pair = (Pair)moved.removeLast();
                        oldUrl = (URL)pair.first;
                        newUrl = (URL)pair.second;
                        if (!URLFileSystem.exists((URL)oldUrl) || URLFileSystem.exists((URL)newUrl)) continue;
                        parent = URLFileSystem.getParent((URL)oldUrl);
                        URLFileSystem.mkdirs((URL)parent);
                        URLFileSystem.renameTo((URL)newUrl, (URL)oldUrl);
                        continue;
                    }
lbl42:
                    // 1 sources

                    ret = 1;
                }
                finally {
                    this._createDirectories = null;
                }
            }
            return ret;
        }

        private void deleteDirectory(URL url) {
            block1: {
                URL[] children = URLFileSystem.list((URL)url);
                if (children == null) break block1;
                URL[] uRLArray = children;
                int n = 0;
                while (n < uRLArray.length) {
                    URL child = uRLArray[n];
                    this.deleteDirectory(child);
                    ++n;
                }
                URLFileSystem.delete((URL)url);
            }
        }

        public Node[] getAffectedNodes() {
            return new Node[0];
        }

        private boolean isNodeOpenedInEditor(Node oldNode) {
            EditorManager editorManager = EditorManager.getEditorManager();
            List editors = editorManager.getAllEditors();
            for (Editor editor : editors) {
                Node node = editor.getContext().getNode();
                if (!oldNode.equals((Object)node)) continue;
                return true;
            }
            return false;
        }
    }
}

