/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MoveInnerDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MOVE_INNER_DEFAULTS";
    private final SourceClass _innerClass;
    private final boolean _isStaticClass;
    private JComboBox _fieldNameComponent;
    private DefaultListComboBoxModel _fieldNameModel;
    private JComboBox _paramNameComponent;
    private DefaultListComboBoxModel _paramNameModel;
    private JTextField _classNameComponent;

    protected String getTitle() {
        return RefactoringArb.getString(270);
    }

    public MoveInnerDialog(Context context, SourceClass innerClass) {
        super(PREFERENCE_KEY, context);
        this._innerClass = innerClass;
        this._isStaticClass = this._innerClass.isStatic();
        this.init();
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._classNameComponent;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmoveinnerclass_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String className = this.getClassName();
            Project project = this.getContext().getProject();
            String packageName = this._innerClass.getPackageName();
            NameValidation classNameValidation = NameValidation.validateClassName(project, packageName, className, true);
            String message = classNameValidation.getMessage();
            boolean isValid = classNameValidation.isValid();
            if (!isValid) {
                this.setMessage(classNameValidation.getMessage(), false);
                this.setOKButtonEnabled(false);
            } else {
                String fieldName = this.getFieldName();
                if (fieldName != null) {
                    if (fieldName.length() == 0) {
                        isValid = false;
                    } else {
                        String canIntroduceVariable = this.canIntroduceVariable(fieldName);
                        if (canIntroduceVariable != null) {
                            message = canIntroduceVariable;
                            isValid = false;
                        } else if (Character.isUpperCase(fieldName.charAt(0))) {
                            message = RefactoringArb.getString(142);
                        }
                    }
                }
                this.setMessage(message, isValid);
                this.setOKButtonEnabled(isValid);
            }
        }
    }

    private String canIntroduceVariable(String variableName) {
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else if (NamingUtil.isJavaReservedWord((String)variableName)) {
            message = RefactoringArb.getString(89);
        } else {
            JavaField field = this._innerClass.getField("_" + variableName);
            if (field != null) {
                message = MessageFormat.format(RefactoringArb.getString(163), variableName);
            }
        }
        return message;
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        JLabel classNameLabel = new JLabel();
        this._classNameComponent = new JTextField();
        ResourceUtils.resLabel((JLabel)classNameLabel, (Component)this._classNameComponent, (String)RefactoringArb.getString(282));
        this.updateOnChanges(this._classNameComponent);
        JLabel fieldNameLabel = new JLabel();
        this._fieldNameModel = new DefaultListComboBoxModel();
        this._fieldNameComponent = new JComboBox(this._fieldNameModel);
        this._fieldNameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)fieldNameLabel, (Component)this._fieldNameComponent, (String)RefactoringArb.getString(141));
        JLabel paramNameLabel = new JLabel();
        this._paramNameModel = new DefaultListComboBoxModel();
        this._paramNameComponent = new JComboBox(this._paramNameModel);
        this._paramNameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)paramNameLabel, (Component)this._paramNameComponent, (String)RefactoringArb.getString(38));
        if (this._isStaticClass) {
            this._fieldNameComponent.setEnabled(false);
            this._paramNameComponent.setEnabled(false);
        } else {
            this.updateOnChanges(this._fieldNameComponent);
            this.updateOnChanges(this._paramNameComponent);
        }
        JLabel message = new JLabel();
        message.setPreferredSize(fieldNameLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)classNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._classNameComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)fieldNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._fieldNameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)paramNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._paramNameComponent, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this._classNameComponent.setText(this._innerClass.getName());
        if (!this._isStaticClass) {
            this.fillSuggestedNames();
        }
    }

    protected void fillSuggestedNames() {
        JavaClass owningClass = this._innerClass.getOwningClass();
        String typeName = owningClass.getName();
        List<String> names = VariableNaming.suggestNamesFromCamelWord(typeName);
        this._fieldNameModel.removeAllElements();
        this._paramNameModel.removeAllElements();
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            this._fieldNameModel.addElement((Object)VariableNaming.FIELD_FORMATER.toString(name));
            this._paramNameModel.addElement((Object)VariableNaming.VARIABLE_FORMATER.toString(name));
            ++i;
        }
    }

    public String getClassName() {
        String className = this._classNameComponent.getText();
        return className;
    }

    public String getFieldName() {
        String fieldName;
        if (!this._isStaticClass) {
            ComboBoxEditor editor = this._fieldNameComponent.getEditor();
            Object item = editor.getItem();
            fieldName = item.toString();
        } else {
            fieldName = null;
        }
        return fieldName;
    }

    public String getParameterName() {
        String parameterName;
        if (!this._isStaticClass) {
            ComboBoxEditor editor = this._paramNameComponent.getEditor();
            Object item = editor.getItem();
            parameterName = item.toString();
        } else {
            parameterName = null;
        }
        return parameterName;
    }
}

