/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.MemberAccess;
import oracle.jdevimpl.refactoring.util.Visitor;

class MoveInnerOperation {
    private final Context _context;
    private final SourceClass _sourceClass;
    private final String _className;
    private final String _fieldName;
    private final String _parameterName;
    private final URL _newURL;

    public MoveInnerOperation(Context context, SourceClass sourceClass, String className, String fieldName, String parameterName) {
        URL newUrl;
        this._context = context;
        this._sourceClass = sourceClass;
        this._className = className;
        this._fieldName = fieldName;
        this._parameterName = parameterName;
        SourceFile owningFile = this._sourceClass.getOwningSourceFile();
        URL url = owningFile.getURL();
        URL directory = URLFileSystem.getParent((URL)url);
        String newFileName = this._className + ".java";
        this._newURL = newUrl = URLFactory.newURL((URL)directory, (String)newFileName);
    }

    private String getName() {
        return RefactoringArb.getString(270);
    }

    public Context getContext() {
        return this._context;
    }

    protected boolean doRefactoring() {
        boolean ret = false;
        Collection membersToUpdate = this.getMembersToUpdate();
        if (membersToUpdate != null) {
            URL classUrl = this._sourceClass.getOwningSourceFile().getURL();
            Workspace workspace = this.getContext().getWorkspace();
            Project[] affectedProjects = Util.getAffectedProjects(workspace, classUrl);
            MultiMap urlHits = new MultiMap();
            HashSet allClasses = new HashSet();
            MoveInnerOperation.getAffectedFilesAndSubClasses(this._sourceClass, affectedProjects, allClasses, urlHits, true);
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                refactoringCommandSupport.setOpenCreatedFiles(true);
                MemberAccess.updateConfirmedMembers(refactoringCommandSupport, membersToUpdate);
                if (allClasses.size() == 1) {
                    Project project = this.getContext().getProject();
                    SourceFile newFile = refactoringCommandSupport.createSourceFile(project, this._newURL);
                    if (newFile != null) {
                        this.updateUsages(refactoringCommandSupport, urlHits);
                        this.updateClass(refactoringCommandSupport, newFile);
                        ret = refactoringCommandSupport.commit(this.getContext(), this.getName());
                    }
                } else {
                    allClasses.remove(this._sourceClass);
                    SourceClass extendingClass = (SourceClass)allClasses.iterator().next();
                    String message = MessageFormat.format(RefactoringArb.getString(144), this._sourceClass.getQualifiedName(), extendingClass.getQualifiedName());
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, this.getName(), 2);
                }
            }
            finally {
                if (!ret) {
                    refactoringCommandSupport.abort();
                }
            }
        }
        return ret;
    }

    private Collection getMembersToUpdate() {
        JavaClass owningClass;
        HashSet<Object> members = new HashSet<Object>();
        SourceFile owningSourceFile = this._sourceClass.getOwningSourceFile();
        if (this._fieldName != null && (owningClass = this._sourceClass.getOwningClass()).isPrivate()) {
            members.add(owningClass);
        }
        List movingClasses = SourceElementAsList.asList((SourceElement)this._sourceClass, (int)3);
        List stayingClasses = SourceElementAsList.asList((SourceElement)owningSourceFile, (int)3);
        stayingClasses.removeAll(movingClasses);
        List elements = SourceElementAsList.asList((SourceElement)owningSourceFile, (int[])new int[]{27, 55, 53, 49, 57});
        int i = 0;
        while (i < elements.size()) {
            SourceElement sourceElement = (SourceElement)elements.get(i);
            boolean isElementMoving = Patch.contains((SourceElement)this._sourceClass, sourceElement);
            int symbolKind = sourceElement.getSymbolKind();
            block0 : switch (symbolKind) {
                case 27: {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    JavaType resolvedType = sourceTypeReference.getResolvedType();
                    if (resolvedType == null || !resolvedType.isPrivate()) break;
                    if (resolvedType.isArray()) {
                        resolvedType = resolvedType.getComponentType();
                    }
                    resolvedType = resolvedType.getTypeErasure();
                    if ((!isElementMoving || !stayingClasses.contains(resolvedType)) && (isElementMoving || !movingClasses.contains(resolvedType))) break;
                    members.add(resolvedType);
                    break;
                }
                case 53: 
                case 55: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                    JavaMethod resolvedMethod = sourceInvokeExpression.getResolvedMethod();
                    if (resolvedMethod == null || !resolvedMethod.isPrivate()) break;
                    JavaClass owningClass2 = resolvedMethod.getOwningClass();
                    if ((!isElementMoving || !stayingClasses.contains(owningClass2)) && (isElementMoving || !movingClasses.contains(owningClass2))) break;
                    members.add(resolvedMethod);
                    break;
                }
                case 49: 
                case 57: {
                    SourceExpression sourceDotExpression = (SourceExpression)sourceElement;
                    JavaHasType resolvedObject = sourceDotExpression.getResolvedObject();
                    if (resolvedObject == null) break;
                    int elementKind = resolvedObject.getElementKind();
                    switch (elementKind) {
                        case 5: {
                            JavaField javaField = (JavaField)resolvedObject;
                            if (!javaField.isPrivate()) break block0;
                            JavaClass owningClass3 = javaField.getOwningClass();
                            if ((!isElementMoving || !stayingClasses.contains(owningClass3)) && (isElementMoving || !movingClasses.contains(owningClass3))) break block0;
                            members.add(javaField);
                            break block0;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        Collection ret = MemberAccess.confirmMembers(members);
        return ret;
    }

    private boolean updateClass(RefactoringCommandSupport refactoringCommandSupport, SourceFile newFile) {
        boolean ret = false;
        SourceFile oldFile = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)oldFile);
        JavaClass owningClass = this._sourceClass.getOwningClass();
        HashSet<JavaClass> owningClasses = new HashSet<JavaClass>(1);
        JavaClass javaClass = owningClass;
        while (javaClass != null) {
            owningClasses.add(javaClass);
            javaClass = javaClass.getOwningClass();
        }
        owningClasses.addAll(owningClass.getInterfaces());
        this.updateConstructors();
        if (this._fieldName != null) {
            SourceFactory factory = oldFile.getFactory();
            List elements = SourceElementAsList.asList((SourceElement)this._sourceClass, (int[])new int[]{27, 53, 57, 60});
            int i = 0;
            while (i < elements.size()) {
                SourceElement sourceElement = (SourceElement)elements.get(i);
                int symbolKind = sourceElement.getSymbolKind();
                switch (symbolKind) {
                    case 27: {
                        SourceTypeReference typeRef = (SourceTypeReference)sourceElement;
                        JavaType type = typeRef.getResolvedType();
                        if (!this._sourceClass.equals((Object)type)) break;
                        String newFqClassName = this._sourceClass.getPackage().getQualifiedName() + '.' + this._sourceClass.getName();
                        sourceElement.replaceSelf((SourceElement)factory.createType(newFqClassName));
                        break;
                    }
                    case 53: {
                        JavaClass methodOwningClass;
                        JavaMethod resolvedMethod;
                        SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                        SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
                        if (lhsOperand != null || (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) == null || !owningClasses.contains(methodOwningClass = resolvedMethod.getOwningClass())) break;
                        SourceExpression prefixExpr = !resolvedMethod.isStatic() ? this.createFieldAccess(factory, (SourceElement)sourceMethodCallExpression) : factory.createExpression(methodOwningClass.getQualifiedName());
                        List children = sourceMethodCallExpression.getChildren();
                        children.add(0, prefixExpr);
                        break;
                    }
                    case 57: {
                        JavaField javaField;
                        JavaClass fieldClass;
                        int elementKind;
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                        JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                        if (resolvedObject == null || (elementKind = resolvedObject.getElementKind()) != 5 || !owningClasses.contains(fieldClass = (javaField = (JavaField)resolvedObject).getOwningClass())) break;
                        SourceExpression prefixExpr = !javaField.isStatic() ? this.createFieldAccess(factory, (SourceElement)sourceSimpleNameExpression) : factory.createExpression(fieldClass.getQualifiedName());
                        SourceDotExpression dotExpression = factory.createDotReference(prefixExpr, javaField.getName());
                        sourceSimpleNameExpression.replaceSelf((SourceElement)dotExpression);
                        break;
                    }
                    case 60: {
                        JavaType resolvedType;
                        SourceTypeExpression sourceTypeExpression;
                        SourceTypeReference sourceType;
                        SourceUnaryExpression sourceUnaryExpression = (SourceUnaryExpression)sourceElement;
                        SourceExpression firstOperand = sourceUnaryExpression.getFirstOperand();
                        if (firstOperand == null || firstOperand.getSymbolKind() != 58 || (sourceType = (sourceTypeExpression = (SourceTypeExpression)firstOperand).getSourceType()) == null || !owningClasses.contains(resolvedType = sourceType.getResolvedType())) break;
                        SourceExpression fieldAccess = this.createFieldAccess(factory, (SourceElement)sourceUnaryExpression);
                        sourceUnaryExpression.replaceSelf((SourceElement)fieldAccess);
                        break;
                    }
                }
                ++i;
            }
            String owningClassQualifiedName = owningClass.getQualifiedName();
            SourceTypeReference fieldType = factory.createType(owningClassQualifiedName);
            SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(18, fieldType, this._fieldName);
            SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
            fieldDeclaration.addSelf((SourceElement)sourceClassBody);
        }
        refactoringCommandSupport.beginTransaction((SourceElement)newFile);
        SourceClass newClass = (SourceClass)this._sourceClass.cloneSelf(newFile);
        newClass.addSelf((SourceElement)newFile);
        newClass.removeModifiers(10);
        newFile.setPackageName(owningClass.getPackageName());
        newClass.setName(this._className);
        this._sourceClass.removeSelf();
        return ret;
    }

    private SourceExpression createFieldAccess(SourceFactory factory, SourceElement scope) {
        CallerContext callerContext = CallerContext.createContext((SourceElement)scope);
        JavaHasType resolvedExpression = callerContext.resolveExpressionName(this._fieldName);
        Object newLhs = resolvedExpression == null ? factory.createSimpleNameExpression(this._fieldName) : factory.createExpression("this." + this._fieldName);
        return newLhs;
    }

    private void updateConstructors() {
        SourceFile oldFile = this._sourceClass.getOwningSourceFile();
        String owningClassQualifiedName = this._sourceClass.getOwningClass().getQualifiedName();
        SourceFactory factory = oldFile.getFactory();
        Collection declaredConstructors = this._sourceClass.getDeclaredConstructors();
        boolean hasConstructor = false;
        for (JavaMethod javaMethod : declaredConstructors) {
            if (javaMethod.isSynthetic()) continue;
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            hasConstructor = true;
            if (this._fieldName != null) {
                SourceMethodCallExpression thisCall = null;
                List methodContent = SourceElementAsList.asList((SourceElement)sourceMethod, (int[])new int[]{53});
                int i = 0;
                if (i < methodContent.size()) {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)methodContent.get(i);
                    String calledMethodName = sourceMethodCallExpression.getName();
                    if ("this".equals(calledMethodName)) {
                        thisCall = sourceMethodCallExpression;
                    }
                }
                SourceTypeReference sourceType = factory.createType(owningClassQualifiedName);
                SourceLocalVariable parameter = factory.createLocalVariable(0, sourceType, this._parameterName);
                SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
                parameter.addSelf((SourceElement)formalParameterList);
                if (thisCall == null) {
                    Object lhs = this._fieldName.equals(this._parameterName) ? factory.createExpression("this." + this._fieldName) : factory.createSimpleNameExpression(this._fieldName);
                    SourceSimpleNameExpression rhs = factory.createSimpleNameExpression(this._parameterName);
                    SourceAssignmentExpression assignment = factory.createAssignment(6, (SourceExpression)lhs, (SourceExpression)rhs);
                    SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)assignment);
                    SourceBlock block = sourceMethod.getBlock();
                    List children = block.getChildren();
                    children.add(0, expressionStatement);
                } else {
                    SourceExpression paramExpression = factory.createExpression(this._parameterName);
                    SourceListExpression argumentList = thisCall.getArgumentList();
                    paramExpression.addSelf((SourceElement)argumentList);
                }
            }
            sourceMethod.setName(this._className);
        }
        if (!hasConstructor && this._fieldName != null) {
            Object lhs = this._fieldName.equals(this._parameterName) ? factory.createExpression("this." + this._fieldName) : factory.createSimpleNameExpression(this._fieldName);
            SourceSimpleNameExpression rhs = factory.createSimpleNameExpression(this._parameterName);
            SourceAssignmentExpression assignment = factory.createAssignment(6, (SourceExpression)lhs, (SourceExpression)rhs);
            SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)assignment);
            SourceElement[] blockElements = new SourceElement[]{expressionStatement};
            SourceBlock block = factory.createBlock(blockElements);
            SourceTypeReference sourceType = factory.createType(owningClassQualifiedName);
            SourceLocalVariable parameter = factory.createLocalVariable(0, sourceType, this._parameterName);
            SourceFormalParameterList formalParameterList = factory.createFormalParameterList(parameter);
            SourceMethod constructor = factory.createConstructor(formalParameterList, null, block);
            SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
            constructor.addSelf((SourceElement)sourceClassBody);
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, MultiMap urlHits) {
        Set projects = urlHits.keySet();
        for (Project project : projects) {
            List hits = urlHits.get((Object)project);
            int i = 0;
            while (i < hits.size()) {
                URL url = (URL)hits.get(i);
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                SourceFile sourceFile = javaManager.getSourceFile(url);
                this.updateUsages(refactoringCommandSupport, sourceFile);
                ++i;
            }
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceFactory factory = sourceFile.getFactory();
        String innerclassName = this._sourceClass.getName();
        1 visitor = new 1(this, innerclassName, factory);
        visitor.visit((SourceElement)sourceFile);
    }

    /*
     * Exception decompiling
     */
    protected static void getAffectedFilesAndSubClasses(SourceClass sourceClass, Project[] affectedProjects, HashSet allClasses, MultiMap urlHits, boolean stopAfterOneInheritance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String ra$_fieldName(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._fieldName;
    }

    static String ra$_className(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._className;
    }

    static SourceClass ra$_sourceClass(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._sourceClass;
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ String v$innerclassName;
        private final /* synthetic */ SourceFactory v$factory;
        final /* synthetic */ MoveInnerOperation this$0;

        private boolean isInnerClass(SourceTypeReference sourceType) {
            JavaType resolvedType;
            boolean ret = false;
            if (sourceType.getName().endsWith(this.v$innerclassName) && (resolvedType = sourceType.getResolvedType()) != null) {
                if (resolvedType.equals((Object)MoveInnerOperation.ra$_sourceClass(this.this$0))) {
                    ret = true;
                } else if (resolvedType.isArray()) {
                    JavaType baseType = resolvedType.getBaseComponentType();
                    if (MoveInnerOperation.ra$_sourceClass(this.this$0).equals((Object)baseType)) {
                        ret = true;
                    }
                }
            }
            return ret;
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceType) {
            if (this.isInnerClass(sourceType)) {
                sourceType.setName(MoveInnerOperation.ra$_className(this.this$0));
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
            SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
            if (this.isInnerClass(sourceType)) {
                if (MoveInnerOperation.ra$_fieldName(this.this$0) != null) {
                    SourceExpression newArg;
                    SourceExpression lhsOperand = sourceClassCreatorExpression.getLhsOperand();
                    if (lhsOperand == null) {
                        newArg = this.v$factory.createSimpleNameExpression("this");
                    } else {
                        lhsOperand.removeSelf();
                        newArg = lhsOperand;
                    }
                    SourceListExpression argumentList = sourceClassCreatorExpression.getArgumentList();
                    newArg.addSelf((SourceElement)argumentList);
                    sourceType.setName(MoveInnerOperation.ra$_className(this.this$0));
                } else {
                    SourceTypeReference newSourceType = this.v$factory.createType(MoveInnerOperation.ra$_className(this.this$0));
                    sourceType.replaceSelf((SourceElement)newSourceType);
                }
            }
        }

        public 1(MoveInnerOperation moveInnerOperation, String string, SourceFactory sourceFactory) {
            this.v$factory = sourceFactory;
            this.v$innerclassName = string;
            this.this$0 = moveInnerOperation;
        }
    }
}

