/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;

public class MovePackageDialog
extends BaseDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "MOVE_CLASS_PREF";
    private static final int PREF_COMMENTS = 1;
    private static final int PREF_NON_JAVA_FILES = 2;
    private static final int PREF_PREVIEW = 4;
    private JTextField _pkgField;
    private JCheckBox _searchInComments;
    private JCheckBox _searchNonJavaFiles;
    private JCheckBox _preview;
    private JButton _browsePackage;
    private JavaPackage _javaPackage;
    private String _prefix;
    private String _suffix;

    public MovePackageDialog(Context context, JavaPackage javaPackage) {
        super(PREFERENCE_KEY, context);
        String name;
        this._javaPackage = javaPackage;
        this._prefix = "";
        this._suffix = this._javaPackage.getName();
        JavaPackage owningPackage = this._javaPackage.getOwningPackage();
        if (owningPackage != null && (name = owningPackage.getName()) != null) {
            this._prefix = name;
            this._suffix = this._suffix.substring(name.length() + 1);
        }
        this.init();
    }

    protected String getTitle() {
        String packageName = this._javaPackage.getName();
        String title = MessageFormat.format(RefactoringArb.getString(65), packageName);
        return title;
    }

    protected int getDefaultPreferences() {
        return 2;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String newPackageName = this.getNewPackageName();
            if (this._prefix.equals(newPackageName)) {
                isValid = false;
            } else if (newPackageName.endsWith(".")) {
                isValid = false;
            } else if (!NamingUtil.isPackageIdentifier((String)newPackageName)) {
                message = RefactoringArb.getString(84);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)newPackageName)) {
                message = RefactoringArb.getString(84);
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.isSearchInComments());
        settings.setBit(2, this.isSearchInNonJavaFiles());
        settings.setBit(4, this.isPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._pkgField;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmovepkg_html";
    }

    private void init() {
        JLabel pkgLabel = new JLabel();
        String oldPkgName = this._javaPackage.getOwningPackage().getName();
        this._pkgField = new JTextField(oldPkgName);
        String pkgText = RefactoringArb.getString(82);
        ResourceUtils.resLabel((JLabel)pkgLabel, (Component)this._pkgField, (String)pkgText);
        this.updateOnChanges(this._pkgField);
        ClassPickerFactory.attach(this._pkgField, this.getContext(), 2);
        this._browsePackage = new JButton("...");
        this._browsePackage.addActionListener(this);
        String searchInComments = RefactoringArb.getString(337);
        this._searchInComments = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchInComments, (String)searchInComments);
        String searchInNonJavaFiles = RefactoringArb.getString(323);
        this._searchNonJavaFiles = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchNonJavaFiles, (String)searchInNonJavaFiles);
        String previewText = RefactoringArb.getString(41);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)previewText);
        JLabel message = new JLabel();
        message.setPreferredSize(this._preview.getPreferredSize());
        this.setMessageLabel(message);
        CopyableInteger data = this.getSettings();
        this._searchInComments.setSelected(data.isBitSet(1));
        this._searchNonJavaFiles.setSelected(data.isBitSet(2));
        this._preview.setSelected(data.isBitSet(4));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)pkgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._pkgField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._searchInComments, new GridBagConstraints(0, 1, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 2, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 9, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    private void whenBrowse() {
        Project project = this.getContext().getProject();
        String oldPkg = this._javaPackage.getOwningPackage().getName();
        1 filter = new 1();
        String[] newPkgName = ClassPackageBrowserV2.browseClassOrPackage(this, project, 1, 0, false, filter, new String[]{oldPkg});
        if (newPkgName.length == 1) {
            this._pkgField.setText(newPkgName[0]);
        }
    }

    public String getNewPackageName() {
        return this._pkgField.getText();
    }

    public boolean isPreview() {
        return this._preview.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchNonJavaFiles.isSelected();
    }

    public boolean isSearchInComments() {
        return this._searchInComments.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._browsePackage) {
            this.whenBrowse();
        }
    }

    final class 1
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String pkg) {
            return true;
        }

        public boolean acceptClass(JavaClass cls) {
            return false;
        }
    }
}

