/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MoveSecondaryClassDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MOVE_SEC_DEFAULTS";
    private SourceClass _sourceClass;
    private JTextField _classNameComponent;

    protected String getTitle() {
        return RefactoringArb.getString(327);
    }

    public MoveSecondaryClassDialog(Context context, SourceClass secondaryClass) {
        super(PREFERENCE_KEY, context);
        this._sourceClass = secondaryClass;
        this.init();
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._classNameComponent;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmovesecondaryclass_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String className = this.getClassName();
            Project project = this.getContext().getProject();
            String packageName = this._sourceClass.getPackageName();
            NameValidation classNameValidation = NameValidation.validateClassName(project, packageName, className, false);
            boolean isValid = classNameValidation.isValid();
            this.setMessage(classNameValidation.getMessage(), isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        JLabel classNameLabel = new JLabel();
        this._classNameComponent = new JTextField();
        ResourceUtils.resLabel((JLabel)classNameLabel, (Component)this._classNameComponent, (String)RefactoringArb.getString(282));
        this.updateOnChanges(this._classNameComponent);
        JLabel message = new JLabel();
        message.setPreferredSize(classNameLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)classNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._classNameComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this._classNameComponent.setText(this._sourceClass.getName());
    }

    public String getClassName() {
        String className = this._classNameComponent.getText();
        return className;
    }
}

