/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerOperation;

class MoveSecondaryOperation {
    private Context _context;
    private SourceClass _sourceClass;
    private String _newClassName;
    private URL _newURL;

    public MoveSecondaryOperation(Context context, SourceClass sourceClass, String className) {
        URL newUrl;
        this._context = context;
        this._sourceClass = sourceClass;
        this._newClassName = className;
        SourceFile owningFile = this._sourceClass.getOwningSourceFile();
        URL url = owningFile.getURL();
        URL directory = URLFileSystem.getParent((URL)url);
        String newFileName = this._newClassName + ".java";
        this._newURL = newUrl = URLFactory.newURL((URL)directory, (String)newFileName);
    }

    public Context getContext() {
        return this._context;
    }

    private String getName() {
        return RefactoringArb.getString(327);
    }

    boolean doRefactoring() {
        boolean ret = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            Workspace workspace = this.getContext().getWorkspace();
            URL oldUrl = this._sourceClass.getURL();
            Project[] affectedProjects = Util.getAffectedProjects(workspace, oldUrl);
            HashSet allClasses = new HashSet();
            MultiMap urlHits = new MultiMap();
            MoveInnerOperation.getAffectedFilesAndSubClasses(this._sourceClass, affectedProjects, allClasses, urlHits, true);
            Project project = this.getContext().getProject();
            SourceFile newFile = refactoringCommandSupport.createSourceFile(project, this._newURL);
            if (newFile != null) {
                this.updateUsages(refactoringCommandSupport, urlHits);
                this.updateClass(refactoringCommandSupport, newFile);
                ret = true;
            }
        }
        finally {
            if (ret) {
                refactoringCommandSupport.commit(this.getContext(), this.getName());
            } else {
                refactoringCommandSupport.abort();
            }
        }
        return ret;
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, MultiMap urlHits) {
        Set projects = urlHits.keySet();
        for (Project project : projects) {
            List hits = urlHits.get((Object)project);
            int i = 0;
            while (i < hits.size()) {
                URL url = (URL)hits.get(i);
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                SourceFile sourceFile = javaManager.getSourceFile(url);
                this.updateUsages(refactoringCommandSupport, sourceFile);
                ++i;
            }
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        String oldClassName = this._sourceClass.getName();
        List elements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{27});
        int i = 0;
        while (i < elements.size()) {
            JavaType resolvedType;
            SourceTypeReference sourceType = (SourceTypeReference)elements.get(i);
            String sourceTypeName = sourceType.getName();
            if (sourceTypeName != null && sourceTypeName.endsWith(oldClassName) && (resolvedType = sourceType.getResolvedType()) != null && resolvedType.equals((Object)this._sourceClass)) {
                sourceType.setName(this._newClassName);
            }
            ++i;
        }
    }

    private boolean updateClass(RefactoringCommandSupport refactoringCommandSupport, SourceFile newFile) {
        boolean ret = false;
        SourceFile oldFile = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)oldFile);
        this.updateConstructors();
        refactoringCommandSupport.beginTransaction((SourceElement)newFile);
        SourceClass newClass = (SourceClass)this._sourceClass.cloneSelf(newFile);
        newClass.addSelf((SourceElement)newFile);
        String packageName = oldFile.getPackageName();
        newFile.setPackageName(packageName);
        newClass.setName(this._newClassName);
        this._sourceClass.removeSelf();
        return ret;
    }

    private void updateConstructors() {
        Collection declaredConstructors = this._sourceClass.getDeclaredConstructors();
        for (JavaMethod javaMethod : declaredConstructors) {
            if (javaMethod.isSynthetic()) continue;
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            sourceMethod.setName(this._newClassName);
        }
    }
}

