/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.moveclasses;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.Scope;

public class MoveClassesURLHandler
extends URLRefactoringHandler {
    private static final String MEMBER_NAMES = "MEMBER_NAMES";
    private static final String PACKAGE_SUFFIXES = "PACKAGE_SUFFIXES";
    private static final int TYPE_C1 = 1;
    private static final int TYPE_C2 = 2;
    private static final int TYPE_C2_B = 3;
    private static final int TYPE_C3_A = 4;
    private static final int TYPE_C3_B = 5;
    private static final int TYPE_C4_A = 6;
    private static final int TYPE_C4_D = 7;
    private static final int TYPE_C5_A = 9;
    private static final int TYPE_C5_B = 10;
    private static final int TYPE_C5_C = 11;
    private static final int TYPE_C6 = 12;
    private static final int TYPE_C7 = 13;
    private static final int TYPE_C8 = 14;
    private static final int TYPE_C8_2 = 15;
    private static final int TYPE_C9 = 16;
    private static final int TYPE_M1 = 50;
    private static final int TYPE_M2 = 51;
    private static final int TYPE_M3 = 52;
    private static final int TYPE_D1 = 100;
    private static final int TYPE_D2 = 101;
    private static final int TYPE_D3 = 102;
    private static final String PACKAGE_PRIVATE_MEMBERS = "PPMEMBERS";

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        HashSet<Project> includedProjects = new HashSet<Project>();
        SearchCriteria criteria = searchOperation.getCriteria();
        if (criteria.getSearchType() == -2147483535) {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)criteria;
            Context context = searchOperation.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            String[] fqOldClassesNames = moveClassesCriteria.getFqOldClassesNames();
            includedProjects.add(project);
            String[] stringArray = fqOldClassesNames;
            int n = 0;
            while (n < stringArray.length) {
                String oldClassName = stringArray[n];
                SourceClass javaClass = moveClassesCriteria.findSourceClass(javaManager, oldClassName);
                if (!(javaClass == null || javaClass.isPrivate() && javaClass.isMemberClass())) {
                    includedProjects.addAll(Arrays.asList(MoveClassesURLHandler.getIncludedProjects(searchOperation, fqOldClassesNames)));
                    break;
                }
                ++n;
            }
            HashSet memberNames = MoveClassesURLHandler.getPPMemberNames(javaManager, moveClassesCriteria);
            if (!memberNames.isEmpty()) {
                String[] oldPackageNames = moveClassesCriteria.getOldPackageNames();
                HashSet<String> pkgSet = new HashSet<String>(Arrays.asList(oldPackageNames));
                searchOperation.setProperty(MEMBER_NAMES, memberNames);
                searchOperation.setProperty(PACKAGE_SUFFIXES, pkgSet);
            }
        }
        return includedProjects.toArray(new Project[includedProjects.size()]);
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet ret = null;
        SearchCriteria criteria = searchOperation.getCriteria();
        if (criteria.getSearchType() == -2147483535) {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)criteria;
            HashSet<String> keywordSet = new HashSet<String>();
            String[] oldClsNames = moveClassesCriteria.getOldClsNames();
            int i = 0;
            while (i < oldClsNames.length) {
                String oldClsName = oldClsNames[i];
                String dotlessName = oldClsName.substring(oldClsName.lastIndexOf(46) + 1);
                keywordSet.add(dotlessName);
                ++i;
            }
            HashSet memberNames = (HashSet)searchOperation.getProperty(MEMBER_NAMES);
            if (memberNames != null) {
                keywordSet.addAll(memberNames);
            }
            String[] keywords = keywordSet.toArray(new String[keywordSet.size()]);
            ret = JavaURLHelper.getJavaURLsContaining(searchOperation, project, keywords, false, false, Scope.createDummyScope(), progressIndicator);
        }
        return ret;
    }

    private static HashSet getPPMemberNames(JavaManager javaManager, MoveClassesCriteria moveClassesCriteria) {
        String[] fqOldClassesNames = moveClassesCriteria.getFqOldClassesNames();
        HashSet<String> memberNames = new HashSet<String>();
        int i = 0;
        while (i < fqOldClassesNames.length) {
            String fqOldClassesName = fqOldClassesNames[i];
            SourceClass javaClass = moveClassesCriteria.findSourceClass(javaManager, fqOldClassesName);
            if (javaClass != null) {
                Collection declaredFields = javaClass.getDeclaredFields();
                for (JavaField javaField : declaredFields) {
                    if (!javaField.isPackagePrivate()) continue;
                    String fieldName = javaField.getName();
                    memberNames.add(fieldName);
                }
                Collection declaredMethods = javaClass.getDeclaredMethods();
                for (JavaMethod javaMethod : declaredMethods) {
                    if (!javaMethod.isPackagePrivate()) continue;
                    String methodName = javaMethod.getName();
                    memberNames.add(methodName);
                }
                Collection declaredClasses = javaClass.getDeclaredClasses();
                for (JavaClass declaredClass : declaredClasses) {
                    JavaElement owner;
                    String className;
                    if (!declaredClass.isPackagePrivate() || (className = declaredClass.getName()) == null || !((owner = declaredClass.getOwner()) instanceof JavaClass)) continue;
                    memberNames.add(className);
                }
            } else {
                System.err.println("Cannot find " + fqOldClassesName);
            }
            ++i;
        }
        return memberNames;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        block73: {
            ret = null;
            criteria = searchOperation.getCriteria();
            if (criteria.getSearchType() != -2147483535) break block73;
            usageModel = new UsageModel();
            moveClassesCriteria = (MoveClassesCriteria)criteria;
            javaManager = JavaManager.getJavaManager((Project)project);
            cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                oldClsNames = moveClassesCriteria.getOldClsNames();
                oldClassNameSet = new HashSet<String>(oldClsNames.length);
                i = 0;
                while (i < oldClsNames.length) {
                    oldClsName = oldClsNames[i];
                    lastDot = oldClsName.lastIndexOf(46);
                    name = oldClsName.substring(lastDot + 1);
                    oldClassNameSet.add(name);
                    ++i;
                }
                oldPkgArray = moveClassesCriteria.getOldPackageNames();
                oldPackageNames = new HashSet<String>(Arrays.asList(oldPkgArray));
                notMovingClassNames = new HashSet<String>();
                i = 0;
                while (i < oldPkgArray.length) {
                    oldPkgName = oldPkgArray[i];
                    oldPkg = javaManager.getPackage(oldPkgName);
                    declaredClasses = oldPkg.getDeclaredClasses();
                    for (JavaClass declaredClass : declaredClasses) {
                        qualifiedName = declaredClass.getQualifiedName();
                        if (moveClassesCriteria.isMovedClass(qualifiedName)) continue;
                        notMovingClassName = declaredClass.getName();
                        notMovingClassNames.add(notMovingClassName);
                    }
                    ++i;
                }
                accessedPPMembers = (HashSet<Object>)searchOperation.getProperty("PPMEMBERS");
                if (accessedPPMembers == null) {
                    accessedPPMembers = new HashSet<Object>();
                }
                i = 0;
                while (i < urls.length && !searchOperation.isUserCancelled()) {
                    block75: {
                        block74: {
                            url = urls[i];
                            platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                            progressIndicator.setProgressStepText(platformPathName);
                            sourceFile = javaManager.getSourceFile(url);
                            if (sourceFile == null) break block74;
                            isCompiled = false;
                            memberNames = (HashSet)searchOperation.getProperty("MEMBER_NAMES");
                            pkgSet = (HashSet)searchOperation.getProperty("PACKAGE_SUFFIXES");
                            oldPrimPackageName = sourceFile.getPackageName();
                            primaryClass = sourceFile.getPrimaryClass();
                            if (primaryClass != null) {
                                oldPrimFqClsName = primaryClass.getQualifiedName();
                                newPrimFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldPrimFqClsName);
                                newPrimPkgName = newPrimFqClsName == null ? oldPrimPackageName : moveClassesCriteria.getNewPackageFromFqNewClassName(newPrimFqClsName);
                            } else {
                                newPrimPkgName = sourceFile.getPackageName();
                                newPrimFqClsName = null;
                            }
                            adaptPackPriv = pkgSet != null && pkgSet.contains(oldPrimPackageName) != false;
                            inAffectedClass = false;
                            starImportedPackages = new HashSet<String>();
                            importedClasses = new HashSet<String>();
                            foundPackageStatement = false;
                            sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{21, 14, 3, 1, 27, 57, 49, 6, 53, 68});
                            j = 0;
                            if (true) ** GOTO lbl355
                        }
                        Assert.println((String)("Failed to get the SourceFile for " + platformPathName));
                        break block75;
                        do {
                            block71: {
                                block76: {
                                    sourceElement = (SourceElement)sourceElements.get(j);
                                    switch (sourceElement.getSymbolKind()) {
                                        case 21: {
                                            if (newPrimFqClsName != null && !oldPrimPackageName.equals(newPrimPkgName)) {
                                                sourcePackage = (SourcePackage)sourceElement;
                                                nameElement = sourcePackage.getNameElement();
                                                this.addEntry(project, usageModel, (SourceElement)nameElement, newPrimPkgName, 14);
                                            }
                                            foundPackageStatement = true;
                                            break;
                                        }
                                        case 14: {
                                            sourceImport = (SourceImport)sourceElement;
                                            nameElement = sourceImport.getNameElement();
                                            name = nameElement.getName();
                                            if (sourceImport.isStatic()) ** GOTO lbl110
                                            if (!name.endsWith(".*")) ** GOTO lbl96
                                            importedPackage = name.substring(0, name.length() - 2);
                                            if (!oldPackageNames.contains(importedPackage)) break block71;
                                            if (!isCompiled) {
                                                sourceFile.compile();
                                                isCompiled = true;
                                            }
                                            importedElements = sourceImport.getImportedElements();
                                            leaveImports = new HashSet<String>(importedElements.size());
                                            iterator = importedElements.iterator();
                                            if (true) ** GOTO lbl285
lbl96:
                                            // 1 sources

                                            if (moveClassesCriteria.isMovedClass(name)) {
                                                newPackageName = moveClassesCriteria.getPackageFromFqClassName(name);
                                                if (newPackageName.equals(newPrimPkgName)) {
                                                    this.addEntry(project, usageModel, (SourceElement)nameElement, null, 1);
                                                    break;
                                                }
                                                importedClasses.add(name);
                                                this.addEntry(project, usageModel, (SourceElement)nameElement, null, 2);
                                                break;
                                            }
                                            lastDot = name.lastIndexOf(46);
                                            if (lastDot != -1 && (newPackageName = name.substring(0, lastDot)).equals(newPrimPkgName)) {
                                                this.addEntry(project, usageModel, (SourceElement)nameElement, null, 1);
                                                break;
                                            }
                                            break block71;
lbl110:
                                            // 1 sources

                                            qualifyingType = sourceImport.getQualifyingType();
                                            if (qualifyingType != null && moveClassesCriteria.isMovedClass(qualifiedName = qualifyingType.getQualifiedName())) {
                                                this.addEntry(project, usageModel, (SourceElement)nameElement, qualifiedName, 3);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 3: {
                                            sourceClass = (SourceClass)sourceElement;
                                            fqClassName = sourceClass.getQualifiedName();
                                            if (fqClassName == null || (oldClassName = moveClassesCriteria.getOldClsNameFromFqClassName(fqClassName)) == null) break block71;
                                            inAffectedClass = true;
                                            newClassName = moveClassesCriteria.getNewClsNameFromFqClassName(fqClassName);
                                            if (!oldClassName.equals(newClassName)) {
                                                oldDotlessClassName = oldClassName.substring(oldClassName.lastIndexOf(46) + 1);
                                                if (!oldDotlessClassName.equals(newDotlessClassName = newClassName.substring(newClassName.lastIndexOf(46) + 1))) {
                                                    this.addEntry(project, usageModel, (SourceElement)sourceClass.getNameElement(), null, 4);
                                                    break;
                                                }
                                                break block71;
                                            } else if (sourceClass.equals((Object)primaryClass)) {
                                                this.addEntry(project, usageModel, (SourceElement)sourceClass.getNameElement(), null, 5);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 1: {
                                            sourceAnnotation = (SourceAnnotation)sourceElement;
                                            nameElement = sourceAnnotation.getNameElement();
                                            if (nameElement != null && oldClassNameSet.contains(rightName = (typeName = nameElement.getName()).substring(typeName.lastIndexOf(46) + 1)) && (resolvedType = sourceAnnotation.getResolvedType()) != null && (newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(qualifiedName = resolvedType.getQualifiedName())) != null) {
                                                this.addEntry(project, usageModel, (SourceElement)sourceAnnotation, newFqClsName, 16);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 27: {
                                            sourceType = (SourceTypeReference)sourceElement;
                                            sourceTypeNameElement = sourceType.getNameElement();
                                            if (sourceTypeNameElement == null) break block71;
                                            typeName = sourceTypeNameElement.getName();
                                            rightName = typeName.substring(typeName.lastIndexOf(46) + 1);
                                            if (!oldClassNameSet.contains(rightName)) ** GOTO lbl158
                                            resolvedType = sourceType.getResolvedType();
                                            if (resolvedType == null || (newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldFqClsName = (javaClass = (componentType = resolvedType.isArray() != false ? resolvedType.getBaseComponentType() : resolvedType).getTypeErasure()).getQualifiedName())) == null) break block71;
                                            replaceWith = null;
                                            neededImport = null;
                                            cleanedSourceTypeName = typeName.replaceAll("\\[\\]<>", "");
                                            if (!cleanedSourceTypeName.equals(oldFqClsName)) ** GOTO lbl153
                                            replaceWith = newFqClsName;
                                            break block76;
lbl153:
                                            // 1 sources

                                            oldPackageName = javaClass.getPackageName();
                                            oldPkgPrefixLength = oldPackageName.length() == 0 ? 0 : oldPackageName.length() + 1;
                                            oldClsPart = oldFqClsName.substring(oldPkgPrefixLength);
                                            newClsPart = moveClassesCriteria.getNewClsNameFromFqNewClassName(newFqClsName);
                                            if (true) ** GOTO lbl298
lbl158:
                                            // 1 sources

                                            if (inAffectedClass && notMovingClassNames.contains(rightName) && (resolvedType = sourceType.getResolvedType()) != null && !newPrimPkgName.equals(referencedPackage = resolvedType.getPackageName())) {
                                                fqClasName = resolvedType.getQualifiedName();
                                                this.addEntry(project, usageModel, (SourceElement)sourceType, fqClasName, 7);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 57: {
                                            sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                                            name = sourceSimpleNameExpression.getName();
                                            if (!oldClassNameSet.contains(name)) ** GOTO lbl178
                                            resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                                            if (resolvedObject != null && (elementKind = resolvedObject.getElementKind()) == 3 && (newPackageName = moveClassesCriteria.getPackageFromFqClassName(oldFqClasName = (javaClass = (JavaClass)resolvedObject).getQualifiedName())) != null) {
                                                newClsName = moveClassesCriteria.getNewClsNameFromFqClassName(oldFqClasName);
                                                if (newPackageName.equals(newPrimPkgName)) {
                                                    this.addEntry(project, usageModel, sourceElement, newClsName, 9);
                                                    break;
                                                }
                                                newFqClassName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldFqClasName);
                                                userObjects = new Object[]{newClsName, newFqClassName};
                                                this.addEntry(project, usageModel, (SourceElement)sourceSimpleNameExpression, userObjects, 10);
                                                break;
                                            }
                                            break block71;
lbl178:
                                            // 1 sources

                                            if (!inAffectedClass || !notMovingClassNames.contains(name) || (resolvedObject = sourceSimpleNameExpression.getResolvedObject()) == null || (resolvedType = resolvedObject.getResolvedType()) == null) break block71;
                                            if (resolvedType.isArray()) {
                                                resolvedType = resolvedType.getBaseComponentType();
                                            }
                                            resolvedType = resolvedType.getTypeErasure();
                                            elementKind = resolvedObject.getElementKind();
                                            if (elementKind == 3 && !newPrimPkgName.equals(referencedPackage = (javaClass = (JavaClass)resolvedObject).getPackageName())) {
                                                fqClasName = resolvedType.getQualifiedName();
                                                this.addEntry(project, usageModel, (SourceElement)sourceSimpleNameExpression, fqClasName, 11);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 49: {
                                            sourceDotExpression = (SourceDotExpression)sourceElement;
                                            nameElement = sourceDotExpression.getNameElement();
                                            if (nameElement == null) break block71;
                                            name = nameElement.getName();
                                            if (oldClassNameSet.contains(name) && (resolvedObject = sourceDotExpression.getResolvedObject()) != null && (elementKind = resolvedObject.getElementKind()) == 3 && (BitField.isSet((int)(moveOrRename = this.getMoveOrRename(moveClassesCriteria, primaryClass, javaClass = (JavaClass)resolvedObject)), (int)1) || sourceDotExpression.getText().startsWith(javaClass.getPackageName()))) {
                                                this.addEntryWithNewFqName(project, moveClassesCriteria, usageModel, (SourceElement)sourceDotExpression, (JavaType)javaClass, 12);
                                            }
                                            if (adaptPackPriv && memberNames.contains(name) && (resolvedObject = sourceDotExpression.getResolvedObject()) != null && resolvedObject.getElementKind() == 5 && !accessedPPMembers.contains(javaField = (JavaField)resolvedObject) && javaField.isPackagePrivate() && (newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(qualifiedName = (owningClass = javaField.getOwningClass()).getQualifiedName())) != null && !newPrimPkgName.equals(newPackageFromFqNewClassName = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName))) {
                                                sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                                                accessedPPMembers.add(sourceFieldVariable);
                                                userObject = new SourceElementHandle((SourceElement)sourceFieldVariable);
                                                this.addEntry(project, usageModel, (SourceElement)sourceFieldVariable.getNameElement(), userObject, 50);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 6: {
                                            if (inAffectedClass && (newClsName = moveClassesCriteria.getNewClsNameFromFqClassName(qualifiedName = (javaClass = (sourceMethod = (SourceMethod)sourceElement).getOwningClass()).getQualifiedName())) != null && !(dotlessNewName = newClsName.substring(newClsName.lastIndexOf(46) + 1)).equals(dotlessOldName = (className = javaClass.getName()).substring(className.lastIndexOf(46) + 1))) {
                                                nameElement = sourceMethod.getNameElement();
                                                this.addEntry(project, usageModel, (SourceElement)nameElement, dotlessNewName, 13);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 53: {
                                            if (adaptPackPriv && (nameElement = (sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement).getNameElement()) != null && memberNames.contains(name = nameElement.getName()) && (javaMethod = (JavaMethod)sourceMethodCallExpression.getResolvedObject()) != null && !accessedPPMembers.contains(javaMethod) && javaMethod.isPackagePrivate() && (newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(qualifiedName = (owningClass = javaMethod.getOwningClass()).getQualifiedName())) != null && !newPrimPkgName.equals(newPackageFromFqNewClassName = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName))) {
                                                sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                                                accessedPPMembers.add(sourceMethod);
                                                userObject = new SourceElementHandle((SourceElement)sourceMethod);
                                                this.addEntry(project, usageModel, (SourceElement)sourceMethod.getNameElement(), userObject, 51);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 66: {
                                            sourceDocReference = (SourceDocReference)sourceElement;
                                            text = sourceDocReference.getText();
                                            tartine = text.indexOf(35);
                                            if (tartine != -1) {
                                                suffix = text.substring(tartine);
                                                text = text.substring(0, tartine);
                                            } else {
                                                suffix = "";
                                            }
                                            newFqClsNameFromFqOldClassName = null;
                                            if (oldClassNameSet.contains(text)) {
                                                resolvedObject = sourceDocReference.getResolvedObject();
                                                if (resolvedObject instanceof JavaMember && tartine != -1) {
                                                    javaMember = (JavaMember)resolvedObject;
                                                    resolvedObject = javaMember.getOwningClass();
                                                }
                                                if (resolvedObject != null && (resolvedType = resolvedObject.getResolvedType()) != null) {
                                                    oldFqClsName = resolvedType.getQualifiedName();
                                                    newFqClsNameFromFqOldClassName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldFqClsName);
                                                }
                                            } else {
                                                newFqClsNameFromFqOldClassName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(text);
                                            }
                                            if (newFqClsNameFromFqOldClassName != null) {
                                                newText = newFqClsNameFromFqOldClassName + suffix;
                                                this.addEntry(project, usageModel, (SourceElement)sourceDocReference, newText, 100);
                                                break;
                                            }
                                            break block71;
                                        }
                                        case 68: {
                                            if (!moveClassesCriteria.isSearchInComments()) break block71;
                                            sourceDocTextFragment = (SourceDocTextFragment)sourceElement;
                                            text = sourceDocTextFragment.getText();
                                            fqOldClassesNames = moveClassesCriteria.getFqOldClassesNames();
                                            fullyQualifiedHits = new ArrayList<SourceElementEntry>();
                                            k = 0;
                                            while (true) {
                                                if (k < fqOldClassesNames.length) ** GOTO lbl255
                                                nonQualified = new ArrayList<SourceElementEntry>();
                                                k = 0;
                                                if (true) ** GOTO lbl344
lbl255:
                                                // 1 sources

                                                fqOldClassesName = fqOldClassesNames[k];
                                                if (text.indexOf(fqOldClassesName) != -1) {
                                                    newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(fqOldClassesName);
                                                    pattern = Pattern.compile("\\b(" + fqOldClassesName + ")\\b");
                                                    matcher = pattern.matcher(text);
                                                    while (matcher.find()) {
                                                        from = matcher.start(1);
                                                        to = matcher.end(1);
                                                        usageEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 102);
                                                        sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                                        userObject = new Object[]{sourceElementHandle, new Integer(from), new Integer(to), newFqClsName};
                                                        usageEntry.setUserObject(userObject);
                                                        fullyQualifiedHits.add(usageEntry);
                                                    }
                                                }
                                                ++k;
                                            }
                                        }
                                    }
                                    break block71;
                                    do {
                                        importedElement = (JavaHasType)iterator.next();
                                        resolvedType = importedElement.getResolvedType();
                                        javaClass = resolvedType.getTypeErasure();
                                        fqOldClsName = javaClass.getQualifiedName();
                                        leaveImport = true;
                                        newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(fqOldClsName);
                                        if (newFqClsName != null && !importedPackage.equals(newPackage = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName))) {
                                            leaveImport = false;
                                        }
                                        if (!leaveImport) continue;
                                        leaveImports.add(fqOldClsName);
lbl285:
                                        // 3 sources

                                    } while (iterator.hasNext());
                                    if (leaveImports.isEmpty()) {
                                        this.addEntry(project, usageModel, (SourceElement)nameElement, null, 1);
                                        break block71;
                                    } else {
                                        starImportedPackages.add(importedPackage);
                                    }
                                    break block71;
                                    do {
                                        oldDotPos = oldClsPart.indexOf(46);
                                        newDotPos = newClsPart.indexOf(46);
                                        if (oldDotPos == -1 || newDotPos == -1) break;
                                        oldClsPart = oldClsPart.substring(oldDotPos + 1);
                                        newClsPart = newClsPart.substring(newDotPos + 1);
lbl298:
                                        // 2 sources

                                    } while (!cleanedSourceTypeName.equals(oldClsPart));
                                    if (!oldClsPart.equals(newClsPart)) {
                                        replaceWith = newClsPart;
                                    }
                                    c4b = false;
                                    if (oldPackageName.equals(oldPrimPackageName) && !newPrimPkgName.equals(newPackage = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName))) {
                                        c4b = true;
                                    }
                                    c4c = false;
                                    if (!(importedClasses.contains(oldFqClsName) || starImportedPackages.contains(newPackage = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName)) || newPrimPkgName.equals(newPackage))) {
                                        c4c = true;
                                    }
                                    if (c4b || c4c) {
                                        neededImport = newFqClsName;
                                    }
                                }
                                if (replaceWith != null || neededImport != null) {
                                    userObjects = new Object[]{replaceWith, neededImport};
                                    this.addEntry(project, usageModel, (SourceElement)sourceTypeNameElement, userObjects, 6);
                                }
                                if (accessedPPMembers.contains(newFqClsName) || !resolvedType.isPackagePrivate() || newPrimPkgName.equals(newPackageName = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName)) || (sourceClass = moveClassesCriteria.findSourceClass(javaManager, newFqClsName)) == null) break block71;
                                this.addEntry(project, usageModel, (SourceElement)sourceClass.getNameElement(), sourceClass, 52);
                                break block71;
                                do {
                                    if (oldPrimPackageName.equals(oldPackageName = moveClassesCriteria.getPackageFromFqClassName(fqOldClassesName = fqOldClassesNames[k])) && text.indexOf(oldClassName = moveClassesCriteria.getOldClsNameFromFqClassName(fqOldClassesName)) != -1) {
                                        pattern = Pattern.compile("\\b(" + oldClassName + ")\\b");
                                        matcher = pattern.matcher(text);
                                        while (matcher.find()) {
                                            from = matcher.start(1);
                                            to = matcher.end(1);
                                            hasFqUsage = false;
                                            l = 0;
                                            while (!hasFqUsage && l < fullyQualifiedHits.size()) {
                                                sourceElementEntry = (SourceElementEntry)fullyQualifiedHits.get(l);
                                                objects = (Object[])sourceElementEntry.getUserObject();
                                                fqFrom = (Integer)objects[1];
                                                fqTo = (Integer)objects[2];
                                                if (fqFrom <= from && to <= fqTo) {
                                                    hasFqUsage = true;
                                                }
                                                ++l;
                                            }
                                            if (hasFqUsage) continue;
                                            newClsName = moveClassesCriteria.getNewClsNameFromFqClassName(fqOldClassesName);
                                            usageEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 101);
                                            sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                            userObject = new Object[]{sourceElementHandle, new Integer(from), new Integer(to), newClsName};
                                            usageEntry.setUserObject(userObject);
                                            nonQualified.add(usageEntry);
                                        }
                                    }
                                    ++k;
lbl344:
                                    // 2 sources

                                } while (k < fqOldClassesNames.length);
                                fullyQualifiedHits.addAll(nonQualified);
                                k = 0;
                                while (k < fullyQualifiedHits.size()) {
                                    sourceElementEntry = (SourceElementEntry)fullyQualifiedHits.get(k);
                                    usageModel.addUsageEntry(sourceElementEntry);
                                    ++k;
                                }
                            }
                            ++j;
lbl355:
                            // 2 sources

                        } while (j < sourceElements.size());
                        if (!foundPackageStatement && ModelUtil.hasLength((String)newPrimPkgName) && (nameElement = (primarySourceClass = (SourceClass)primaryClass.getSourceElement()).getNameElement()) != null) {
                            this.addEntry(project, usageModel, (SourceElement)nameElement, newPrimPkgName, 15);
                        }
                    }
                    ++i;
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
            ret = usageModel;
            searchOperation.setProperty("PPMEMBERS", accessedPPMembers);
        }
        return ret;
    }

    private void addEntryWithNewFqName(Project project, MoveClassesCriteria moveClassesCriteria, UsageModel usageModel, SourceElement sourceElement, JavaType javaType, int usageType) {
        String oldFqClasName = javaType.getQualifiedName();
        String newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldFqClasName);
        this.addEntry(project, usageModel, sourceElement, newFqClsName, usageType);
    }

    private void addEntry(Project project, UsageModel usageModel, SourceElement sourceElement, Object userObject, int usageType) {
        SourceElementEntry entry = new SourceElementEntry(project, sourceElement, usageType);
        entry.setUserObject(userObject);
        usageModel.addUsageEntry(entry);
    }

    private int getMoveOrRename(MoveClassesCriteria moveClassesCriteria, JavaClass primaryClass, JavaClass javaClass) {
        int ret = 0;
        String fqOldName = javaClass.getQualifiedName();
        String newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(fqOldName);
        if (newFqClsName != null) {
            String newPackageName;
            String oldPackageName;
            String newClsName;
            String oldClsName = moveClassesCriteria.getOldClsNameFromFqClassName(fqOldName);
            if (!oldClsName.equals(newClsName = moveClassesCriteria.getNewClsNameFromFqClassName(fqOldName))) {
                ret |= 1;
            }
            if (!(oldPackageName = javaClass.getPackageName()).equals(newPackageName = moveClassesCriteria.getNewPackageFromFqNewClassName(newFqClsName))) {
                ret |= 2;
                String primPackageName = primaryClass.getPackageName();
                if (primPackageName.equals(oldPackageName)) {
                    String oldPrimFqName = primaryClass.getQualifiedName();
                    String newPrimFqName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldPrimFqName);
                    if (newPrimFqName != null) {
                        String newPrimPackage = moveClassesCriteria.getNewPackageFromFqNewClassName(newPrimFqName);
                        if (!newPackageName.equals(newPrimPackage)) {
                            ret |= 4;
                        }
                    } else {
                        ret |= 4;
                    }
                }
            }
        }
        return ret;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean ret = false;
        try {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchOperation.getCriteria();
            ArrayList usageEntries = usageModel.getUsageEntries();
            HashSet<String> invalidatedFqClassNames = new HashSet<String>();
            int i = 0;
            while (i < usageEntries.size()) {
                SourceElementEntry entry = (SourceElementEntry)usageEntries.get(i);
                if (entry.isIncluded()) {
                    switch (entry.getUsageType()) {
                        case 4: 
                        case 5: {
                            URL url = entry.getURL();
                            String[] classes = Helpers.getClasses(project, url);
                            invalidatedFqClassNames.addAll(Arrays.asList(classes));
                            break;
                        }
                    }
                }
                ++i;
            }
            MultiMap docTextFragments = new MultiMap();
            int i2 = 0;
            while (i2 < usageEntries.size()) {
                SourceElementEntry entry = (SourceElementEntry)usageEntries.get(i2);
                if (entry.isIncluded()) {
                    SourceElement sourceElement = entry.getSourceElementOrThrow();
                    switch (entry.getUsageType()) {
                        case 1: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceImport sourceImport = (SourceImport)sourceName.getParent();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceImport);
                            sourceImport.removeSelf();
                            break;
                        }
                        case 2: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceImport sourceImport = (SourceImport)sourceName.getParent();
                            String oldFqClassName = sourceImport.getName();
                            String newFqClsName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(oldFqClassName);
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceImport);
                            sourceImport.setName(newFqClsName);
                            break;
                        }
                        case 3: {
                            SourceName nameElement = (SourceName)sourceElement;
                            String qualifiedName = (String)entry.getUserObject();
                            String newClassName = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(qualifiedName);
                            String oldText = nameElement.getText();
                            String newImportText = newClassName + oldText.substring(qualifiedName.length());
                            refactoringCommandSupport.beginTransaction((SourceElement)nameElement);
                            nameElement.setText(newImportText);
                            break;
                        }
                        case 4: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceClass sourceClass = (SourceClass)sourceName.getParent();
                            String qualifiedName = sourceClass.getQualifiedName();
                            String newClsName = moveClassesCriteria.getNewClsNameFromFqClassName(qualifiedName);
                            String cleanClsName = newClsName.substring(newClsName.lastIndexOf(46) + 1);
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                            sourceClass.setName(cleanClsName);
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            SourceName sourceName = (SourceName)sourceElement;
                            Object[] userObjects = (Object[])entry.getUserObject();
                            String replaceWith = (String)userObjects[0];
                            String neededImport = (String)userObjects[1];
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            if (replaceWith != null) {
                                sourceName.setText(replaceWith);
                            }
                            if (neededImport == null) break;
                            SourceFile owningSourceFile = sourceName.getOwningSourceFile();
                            this.smartAddImport(owningSourceFile, neededImport);
                            break;
                        }
                        case 7: {
                            SourceTypeReference sourceType = (SourceTypeReference)sourceElement;
                            String newFqClsName = (String)entry.getUserObject();
                            SourceFile owningSourceFile = sourceType.getOwningSourceFile();
                            refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                            SourceFactory factory = owningSourceFile.getFactory();
                            SourceTypeReference newTypeReference = factory.createType(newFqClsName);
                            sourceType.replaceSelf((SourceElement)newTypeReference);
                            break;
                        }
                        case 10: {
                            Object[] userObjects = (Object[])entry.getUserObject();
                            String replaceWith = (String)userObjects[0];
                            String neededImport = (String)userObjects[1];
                            SourceExpression sourceExpression = (SourceExpression)sourceElement;
                            SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
                            refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                            this.smartAddImport(owningSourceFile, neededImport);
                            SourceFactory factory = owningSourceFile.getFactory();
                            SourceExpression newExpression = factory.createExpression(replaceWith);
                            sourceExpression.replaceSelf((SourceElement)newExpression);
                            break;
                        }
                        case 9: 
                        case 11: 
                        case 12: {
                            SourceExpression sourceExpression = (SourceExpression)sourceElement;
                            String newFqClsName = (String)entry.getUserObject();
                            SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
                            SourceFactory factory = owningSourceFile.getFactory();
                            SourceExpression newExpression = factory.createExpression(newFqClsName);
                            refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                            sourceExpression.replaceSelf((SourceElement)newExpression);
                            break;
                        }
                        case 13: {
                            SourceName nameElement = (SourceName)sourceElement;
                            String newName = (String)entry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)nameElement);
                            nameElement.setText(newName);
                            break;
                        }
                        case 14: 
                        case 15: {
                            SourceFile sourceFile = sourceElement.getOwningSourceFile();
                            String newPrimPkgName = (String)entry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                            String oldPackageName = sourceFile.getPackageName();
                            List classes = sourceFile.getSourceClasses();
                            for (SourceClass cls : classes) {
                                String clsName = cls.getName();
                                moveClassesCriteria.updateClassMap(oldPackageName + "." + clsName, newPrimPkgName + "." + clsName);
                            }
                            sourceFile.setPackageName(newPrimPkgName);
                            break;
                        }
                        case 16: {
                            SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                            String newFqName = (String)entry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceAnnotation);
                            String shortName = newFqName.substring(newFqName.lastIndexOf(46) + 1);
                            sourceAnnotation.setName(shortName);
                            break;
                        }
                        case 50: 
                        case 51: 
                        case 52: {
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)entry.getUserObject();
                            SourceHasModifiers sourceHasModifiers = (SourceHasModifiers)sourceElementHandle.getElement();
                            if (sourceHasModifiers == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceHasModifiers);
                            sourceHasModifiers.addModifiers(1);
                            break;
                        }
                        case 100: {
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String newText = (String)entry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocReference);
                            SourceFile owningSourceFile = sourceDocReference.getOwningSourceFile();
                            SourceFactory factory = owningSourceFile.getFactory();
                            int tartine = newText.indexOf(35);
                            SourceDocReference newSourceDocReference = tartine == -1 ? factory.createDocReference(newText, null, null) : factory.createDocMemberReferenceFromText(newText);
                            sourceDocReference.replaceSelf((SourceElement)newSourceDocReference);
                            break;
                        }
                        case 101: {
                            Object[] userObjects = (Object[])entry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)userObjects[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            docTextFragments.add((Object)sourceDocTextFragment, (Object)userObjects);
                            break;
                        }
                        case 102: {
                            Object[] userObjects = (Object[])entry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)userObjects[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            docTextFragments.add((Object)sourceDocTextFragment, (Object)userObjects);
                            break;
                        }
                    }
                }
                ++i2;
            }
            MoveClassesURLHandler.renameClassInComments(docTextFragments);
            Context context = searchOperation.getContext();
            refactoringCommandSupport.setSearchOperation(searchOperation);
            ret = refactoringCommandSupport.commit(context, RefactoringArb.getString(358));
            if (ret) {
                String[] classNames = invalidatedFqClassNames.toArray(new String[invalidatedFqClassNames.size()]);
                Helpers.removeClasses(project, classNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private void smartAddImport(SourceFile owningSourceFile, String neededImport) {
        boolean alreadyImported = false;
        List imports = SourceElementAsList.asList((SourceElement)owningSourceFile, (int)14);
        int j = 0;
        while (!alreadyImported && j < imports.size()) {
            SourceImport sourceImport = (SourceImport)imports.get(j);
            String importedName = sourceImport.getName();
            if (neededImport.equals(importedName)) {
                alreadyImported = true;
            }
            ++j;
        }
        if (!alreadyImported) {
            SourceFactory factory = owningSourceFile.getFactory();
            SourceImport importDeclaration = factory.createImportDeclaration(neededImport);
            importDeclaration.addSelf((SourceElement)owningSourceFile);
        }
    }

    private static void renameClassInComments(MultiMap docTextFragments) {
        Set keys = docTextFragments.keySet();
        for (SourceDocTextFragment sourceDocTextFragment : keys) {
            String oldText = sourceDocTextFragment.getText();
            StringBuffer newText = new StringBuffer(oldText);
            List userObjects = docTextFragments.get((Object)sourceDocTextFragment);
            Collections.sort(userObjects, new 1());
            int i = 0;
            while (i < userObjects.size()) {
                Object[] objects = (Object[])userObjects.get(i);
                int from = (Integer)objects[1];
                int to = (Integer)objects[2];
                String newName = (String)objects[3];
                newText.replace(from, to, newName);
                ++i;
            }
            SourceFile owningSourceFile = sourceDocTextFragment.getOwningSourceFile();
            SourceFactory factory = owningSourceFile.getFactory();
            SourceElement docTextFragmentParent = sourceDocTextFragment.getParent();
            if (docTextFragmentParent instanceof SourceDocReference) {
                SourceDocReference docReference = (SourceDocReference)docTextFragmentParent;
                docReference.replaceSelf((SourceElement)factory.createDocClassReference(newText.toString()));
                continue;
            }
            SourceDocTextFragment newDocTextFragment = factory.createDocTextFragment(newText.toString());
            sourceDocTextFragment.replaceSelf((SourceElement)newDocTextFragment);
        }
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Object[] objects1 = (Object[])o1;
            Object[] objects2 = (Object[])o2;
            int from1 = (Integer)objects1[1];
            int from2 = (Integer)objects2[1];
            return from2 - from1;
        }
    }
}

