/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberFieldEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTable;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTableModel;
import oracle.jdevimpl.refactoring.util.Visitor;

public abstract class MoveMemberDialog
extends BaseDialog
implements VetoableChangeListener {
    private SourceClass _sourceClass;
    protected JTable _members;
    private ArrayList existingSuperMembers;

    protected abstract Collection getMoveableFields();

    protected abstract Collection getMoveableMethods();

    protected abstract Collection getMoveableInterfaces();

    protected abstract String getDialogTitle();

    protected abstract MultiMap calculateDependencies(SourceClass var1);

    protected abstract boolean canClose();

    public MoveMemberDialog(String preferenceKey, Context context, SourceClass sourceClass) {
        super(preferenceKey, context);
        this._sourceClass = sourceClass;
    }

    protected JTable createTable() {
        MoveMemberTableModel moveMemberTableModel = this.createTableModel();
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        MoveMemberTable ret = new MoveMemberTable(moveMemberTableModel, tableColumnModel);
        this.updateTableColumns((JTable)((Object)ret));
        return ret;
    }

    protected void updateTableColumns(JTable jTable) {
        MoveMemberTableModel moveMemberTableModel = (MoveMemberTableModel)jTable.getModel();
        DefaultTableColumnModel tableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
        while (tableColumnModel.getColumnCount() > 0) {
            TableColumn column = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn(column);
        }
        int column = 0;
        while (column <= 3) {
            int columnWidth = MoveMemberTableModel.getColumnWidth(column);
            Class columnClass = moveMemberTableModel.getColumnClass(column);
            String columnName = moveMemberTableModel.getColumnName(column);
            TableColumn tableColumn = new TableColumn(column, columnWidth, jTable.getDefaultRenderer(columnClass), jTable.getDefaultEditor(columnClass));
            tableColumn.setHeaderValue(columnName);
            tableColumnModel.addColumn(tableColumn);
            ++column;
        }
    }

    protected MoveMemberTableModel createTableModel() {
        MoveMemberTableModel moveMemberTableModel = new MoveMemberTableModel();
        Collection interfaces = this.getMoveableInterfaces();
        Collection declaredMethods = this.getMoveableMethods();
        Collection declaredFields = this.getMoveableFields();
        MultiMap methodToItface = new MultiMap();
        for (JavaType itface : interfaces) {
            Collection itfaceMethods = itface.getDeclaredMethods();
            for (JavaMethod interfaceMethod : itfaceMethods) {
                JavaType[] parameterTypes = Patch.getParameterTypes(interfaceMethod);
                JavaMethod foundMethod = this._sourceClass.getMethod(interfaceMethod.getName(), parameterTypes);
                if (foundMethod == null) continue;
                methodToItface.add((Object)foundMethod, (Object)itface);
            }
        }
        MultiMap memberDependencies = this.calculateDependencies(this._sourceClass);
        int entryCount = interfaces.size() + declaredMethods.size() + declaredFields.size();
        ArrayList<MoveMemberEntry> entries = new ArrayList<MoveMemberEntry>(entryCount);
        HashMap<Object, MoveMemberEntry> elementToEntry = new HashMap<Object, MoveMemberEntry>(entryCount);
        for (JavaType itface : interfaces) {
            MoveMemberInterfaceEntry entry = new MoveMemberInterfaceEntry(itface);
            entries.add(entry);
            elementToEntry.put(itface, entry);
        }
        for (SourceMethod declaredMethod : declaredMethods) {
            MoveMemberMethodEntry entry = new MoveMemberMethodEntry(declaredMethod);
            entries.add(entry);
            elementToEntry.put(declaredMethod, entry);
        }
        for (SourceFieldVariable declaredField : declaredFields) {
            MoveMemberFieldEntry entry = new MoveMemberFieldEntry(declaredField);
            entries.add(entry);
            elementToEntry.put(declaredField, entry);
        }
        Collections.sort(entries, new 1());
        int i = 0;
        while (i < entries.size()) {
            MoveMemberEntry entry = (MoveMemberEntry)entries.get(i);
            if (entry instanceof MoveMemberMemberEntry) {
                MoveMemberMemberEntry pullUpMemberEntry = (MoveMemberMemberEntry)entry;
                SourceMember declaredElement = pullUpMemberEntry.getSourceMember();
                List usedBySourceElements = memberDependencies.get((Object)declaredElement);
                List usedByEntries = this.converToEntryList(usedBySourceElements, elementToEntry);
                pullUpMemberEntry.setUsedBy(usedByEntries);
                if (pullUpMemberEntry instanceof MoveMemberMethodEntry) {
                    MoveMemberMethodEntry methodEntry = (MoveMemberMethodEntry)pullUpMemberEntry;
                    List memberOfItfaceElements = methodToItface.get((Object)declaredElement);
                    List memberOfItfaceEntries = this.converToEntryList(memberOfItfaceElements, elementToEntry);
                    methodEntry.setItfaces(memberOfItfaceEntries);
                }
            }
            moveMemberTableModel.addEntry(entry);
            ++i;
        }
        moveMemberTableModel.addTableModelListener(new 2());
        return moveMemberTableModel;
    }

    private List converToEntryList(List sourceElementList, HashMap elementToEntry) {
        if (sourceElementList != null) {
            ArrayList<MoveMemberEntry> usedByEntries = new ArrayList<MoveMemberEntry>(sourceElementList.size());
            int j = 0;
            while (j < sourceElementList.size()) {
                Object usedBySourceElement = sourceElementList.get(j);
                MoveMemberEntry usedByEntry = (MoveMemberEntry)elementToEntry.get(usedBySourceElement);
                if (usedByEntry != null) {
                    usedByEntries.add(usedByEntry);
                }
                ++j;
            }
            return usedByEntries;
        }
        return Collections.EMPTY_LIST;
    }

    public MoveMemberMethodEntry[] getPulledMethodEntries() {
        ArrayList entries = this.getEntries(MoveMemberMethodEntry.class);
        return entries.toArray(new MoveMemberMethodEntry[entries.size()]);
    }

    protected MoveMemberInterfaceEntry[] getPulledInterfaceEntries() {
        ArrayList entries = this.getEntries(MoveMemberInterfaceEntry.class);
        return entries.toArray(new MoveMemberInterfaceEntry[entries.size()]);
    }

    public SourceMember[] getPulledMembers() {
        ArrayList entries = this.getEntries(MoveMemberMemberEntry.class);
        SourceMember[] ret = new SourceMember[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            SourceMember sourceMember;
            MoveMemberMemberEntry memberEntry = (MoveMemberMemberEntry)entries.get(i);
            ret[i] = sourceMember = memberEntry.getSourceMember();
            ++i;
        }
        Arrays.sort(ret, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return ret;
    }

    public SourceMethod[] getPulledMethods() {
        ArrayList entries = this.getEntries(MoveMemberMethodEntry.class);
        SourceMethod[] ret = new SourceMethod[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            SourceMethod sourceMethod;
            MoveMemberMethodEntry moveMemberMethodEntry = (MoveMemberMethodEntry)entries.get(i);
            ret[i] = sourceMethod = moveMemberMethodEntry.getMethod();
            ++i;
        }
        Arrays.sort(ret, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return ret;
    }

    public SourceFieldVariable[] getPulledFields() {
        ArrayList entries = this.getEntries(MoveMemberFieldEntry.class);
        SourceFieldVariable[] ret = new SourceFieldVariable[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            MoveMemberFieldEntry fieldEntry = (MoveMemberFieldEntry)entries.get(i);
            ret[i] = fieldEntry.getField();
            ++i;
        }
        Arrays.sort(ret, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return ret;
    }

    private ArrayList getEntries(Class pullUpClass) {
        ArrayList ret = new ArrayList();
        MoveMemberTableModel tableModel = (MoveMemberTableModel)this._members.getModel();
        ArrayList entries = tableModel.getEntries();
        int i = 0;
        while (i < entries.size()) {
            MoveMemberEntry moveMemberEntry;
            Object entry = entries.get(i);
            if (pullUpClass == entry.getClass() && entry instanceof MoveMemberEntry && (moveMemberEntry = (MoveMemberEntry)entry).isIncluded()) {
                ret.add(entry);
            }
            ++i;
        }
        return ret;
    }

    public SourceClass getSourceSourceClass() {
        return this._sourceClass;
    }

    protected final HashSet calculateDependencies(SourceClass sourceClass, SourceElement scope) {
        HashSet dependencies = new HashSet(0);
        3 visitor = new 3(this, sourceClass, dependencies);
        if (scope != null) {
            visitor.visit(scope);
        }
        return dependencies;
    }

    protected String getTitle() {
        return this.getDialogTitle();
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected void updateOKButton() {
        boolean hasSelection = this.hasSelection();
        this.setOKButtonEnabled(hasSelection);
    }

    protected boolean hasSelection() {
        boolean hasSelection = false;
        MoveMemberTableModel tableModel = (MoveMemberTableModel)this._members.getModel();
        ArrayList entries = tableModel.getEntries();
        int i = 0;
        while (!hasSelection && i < entries.size()) {
            MoveMemberEntry moveMemberEntry;
            Object entry = entries.get(i);
            if (entry instanceof MoveMemberEntry && (moveMemberEntry = (MoveMemberEntry)entry).isIncluded()) {
                hasSelection = true;
            }
            ++i;
        }
        return hasSelection;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._members;
    }

    public void setDlg(JEWTDialog dlg) {
        super.setDlg(dlg);
        dlg.addVetoableChangeListener((VetoableChangeListener)this);
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean canClose;
        if (evt.getPropertyName().equals("closed") && Boolean.TRUE.equals(evt.getNewValue()) && !(canClose = this.canClose())) {
            throw new PropertyVetoException("", evt);
        }
    }

    protected final ArrayList getExistingMembers(JavaClass target, boolean includeClassName) {
        ArrayList<String> memberNames = new ArrayList<String>(1);
        ArrayList<SourceMethod> pulledMethods = new ArrayList<SourceMethod>();
        MoveMemberMethodEntry[] pulledMethodEntries = this.getPulledMethodEntries();
        int i = 0;
        while (i < pulledMethodEntries.length) {
            MoveMemberMethodEntry pulledMethodEntry = pulledMethodEntries[i];
            SourceMethod method = pulledMethodEntry.getMethod();
            pulledMethods.add(method);
            ++i;
        }
        int i2 = 0;
        while (i2 < pulledMethods.size()) {
            SourceMethod sourceMethod = (SourceMethod)pulledMethods.get(i2);
            JavaType[] parameterTypes = Patch.getParameterTypes((JavaMethod)sourceMethod);
            SourceMethod targetMethod = (SourceMethod)target.getDeclaredMethod(sourceMethod.getName(), parameterTypes);
            if (targetMethod != null) {
                String methodName = Util.getFullMethodName((JavaMethod)sourceMethod, includeClassName, includeClassName, false);
                memberNames.add(methodName);
            }
            ++i2;
        }
        SourceFieldVariable[] pulledFields = this.getPulledFields();
        int i3 = 0;
        while (i3 < pulledFields.length) {
            SourceFieldVariable pulledField = pulledFields[i3];
            String fieldName = pulledField.getName();
            SourceFieldVariable targetField = (SourceFieldVariable)target.getDeclaredField(fieldName);
            if (targetField != null) {
                if (includeClassName) {
                    fieldName = target.getName() + "." + fieldName;
                }
                memberNames.add(fieldName);
            }
            ++i3;
        }
        return memberNames;
    }

    public void preselectMember(SourceMember sourceMember) {
        if (sourceMember != null) {
            MoveMemberTableModel tableModel = (MoveMemberTableModel)this._members.getModel();
            ArrayList entries = tableModel.getEntries();
            int i = 0;
            while (i < entries.size()) {
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)entries.get(i);
                if (moveMemberEntry.equals(sourceMember)) {
                    moveMemberEntry.setIncluded(true);
                }
                ++i;
            }
        }
    }

    protected boolean confirmCanProceedWithExistingMembers(JavaClass targetClass) {
        boolean canClose = true;
        this.existingSuperMembers = this.getExistingMembers(targetClass, false);
        if (!this.existingSuperMembers.isEmpty()) {
            String pattern = RefactoringArb.getString(247);
            Object[] arguments = new Object[]{targetClass.getName()};
            String message = MessageFormat.format(pattern, arguments);
            JLabel label = new JLabel();
            JList<Object> list = new JList<Object>(this.existingSuperMembers.toArray(new Object[this.existingSuperMembers.size()]));
            ResourceUtils.resLabel((JLabel)label, list, (String)message);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "North");
            panel.add((Component)new JScrollPane(list), "Center");
            IdeMainWindow mainWindow = Ide.getMainWindow();
            JEWTDialog dlg = new JEWTDialog((Frame)mainWindow, RefactoringArb.getString(42), 3);
            dlg.setOKButtonText(RefactoringArb.getString(27));
            dlg.setContent((Component)panel);
            dlg.setResizable(true);
            if (!WizardLauncher.runDialog((JDialog)dlg)) {
                canClose = false;
            }
        }
        return canClose;
    }

    protected MultiMap calculateDownDependencies(SourceClass sourceClass) {
        List sourceMethods = sourceClass.getSourceMethods();
        MultiMap memberDependencies = new MultiMap();
        int i = 0;
        while (i < sourceMethods.size()) {
            SourceMethod sourceMethod = (SourceMethod)sourceMethods.get(i);
            HashSet methodDependencies = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : methodDependencies) {
                memberDependencies.add((Object)sourceMethod, (Object)sourceElement);
            }
            ++i;
        }
        Collection sourceFieldVariables = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : sourceFieldVariables) {
            SourceExpression initializer = sourceFieldVariable.getInitializer();
            HashSet initializerDependencies = this.calculateDependencies(sourceClass, (SourceElement)initializer);
            for (SourceElement sourceElement : initializerDependencies) {
                memberDependencies.add((Object)sourceFieldVariable, (Object)sourceElement);
            }
        }
        return memberDependencies;
    }

    public ArrayList getExistingSuperMembers() {
        return this.existingSuperMembers;
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            MoveMemberEntry entry1 = (MoveMemberEntry)o1;
            MoveMemberEntry entry2 = (MoveMemberEntry)o2;
            return entry1.getStartOffset() - entry2.getStartOffset();
        }
    }

    final class 2
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            MoveMemberDialog.this.updateOKButton();
        }
    }

    final class 3
    extends Visitor {
        private final /* synthetic */ SourceClass v$sourceClass;
        private final /* synthetic */ HashSet v$dependencies;
        final /* synthetic */ MoveMemberDialog this$0;

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaClass owningClass;
            SourceMethod sourceMethod;
            JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
            if (resolvedMethod != null && (sourceMethod = (SourceMethod)resolvedMethod.getSourceElement()) != null && this.v$sourceClass.equals((Object)(owningClass = sourceMethod.getOwningClass()))) {
                this.v$dependencies.add(sourceMethod);
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaField javaField;
            SourceElement sourceElement;
            JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
            if (resolvedObject instanceof JavaField && (sourceElement = (javaField = (JavaField)resolvedObject).getSourceElement()) instanceof SourceFieldVariable) {
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                JavaClass declaringClass = javaField.getOwningClass();
                if (this.v$sourceClass.equals((Object)declaringClass)) {
                    this.v$dependencies.add(sourceFieldVariable);
                }
            }
        }

        public 3(MoveMemberDialog moveMemberDialog, SourceClass sourceClass, HashSet hashSet) {
            this.v$dependencies = hashSet;
            this.v$sourceClass = sourceClass;
            this.this$0 = moveMemberDialog;
        }
    }
}

