/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.awt.Color;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaType;

public abstract class MoveMemberEntry {
    private boolean _included;
    private String _text;
    private boolean _abstract;
    private boolean _includeDependencies;
    private int _enabledFields;

    private void $init$() {
        this._enabledFields = -1;
    }

    MoveMemberEntry() {
        this.$init$();
    }

    public MoveMemberEntry(String text) {
        this.$init$();
        this.setText(text);
    }

    Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.isIncluded();
            }
            case 1: {
                return this.getText();
            }
            case 2: {
                return this.isAbstract();
            }
            case 3: {
                return this.isIncludeDependencies();
            }
        }
        return null;
    }

    void setValueAt(int column, Object value) {
        switch (column) {
            case 0: {
                this.setIncluded(Boolean.TRUE.equals(value));
                break;
            }
            case 1: {
                this.setText((String)value);
                break;
            }
            case 2: {
                this.setAbstract(Boolean.TRUE.equals(value));
                break;
            }
            case 3: {
                this.setIncludeDependencies(Boolean.TRUE.equals(value));
                break;
            }
        }
    }

    boolean isIncluded() {
        return this._included;
    }

    void setIncluded(boolean included) {
        this._included = included;
    }

    String getText() {
        return this._text;
    }

    void setText(String text) {
        this._text = text;
    }

    boolean isAbstract() {
        return this._abstract;
    }

    void setAbstract(boolean anAbstract) {
        if (anAbstract) {
            this.setIncluded(true);
        }
        this._abstract = anAbstract;
    }

    boolean isIncludeDependencies() {
        return this._includeDependencies;
    }

    void setIncludeDependencies(boolean includeDependencies) {
        if (includeDependencies) {
            this.setIncluded(true);
        }
        this._includeDependencies = includeDependencies;
    }

    protected String getShortTypeName(JavaType jotType) {
        if (!jotType.isArray()) {
            return jotType.getName();
        }
        JavaType componentType = jotType.getComponentType();
        String componentTypeName = this.getShortTypeName(componentType);
        return componentTypeName + "[]";
    }

    boolean isCellEditable(int column) {
        if (!this.isEnabled(column)) {
            return false;
        }
        switch (column) {
            case 1: {
                return false;
            }
        }
        return true;
    }

    boolean isEnabled(int column) {
        return BitField.isSet((int)this._enabledFields, (int)(1 << column));
    }

    public void setEnabled(int column, boolean enabled) {
        this._enabledFields = enabled ? BitField.set((int)this._enabledFields, (int)(1 << column)) : BitField.unset((int)this._enabledFields, (int)(1 << column));
    }

    boolean isVisible(int column) {
        return true;
    }

    String getTooltipAt(int column) {
        return null;
    }

    Color getCellForeground(int column) {
        return null;
    }

    abstract int getStartOffset();
}

