/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;

public abstract class MoveMemberMemberEntry
extends MoveMemberEntry {
    private List _usedBy;
    private boolean _includedRecursion;
    private static final Color STATIC_MEMBER_COLOR = new Color(0, 128, 0);

    boolean isIncluded() {
        return super.isIncluded() || this.isIncludedThroughDependencies();
    }

    boolean isEnabled(int column) {
        if (column == 0 && this.isIncludedThroughDependencies()) {
            return false;
        }
        return super.isEnabled(column);
    }

    String getTooltipAt(int column) {
        MoveMemberMemberEntry memberEntry = this.shouldBeIncludedBecauseOf();
        if (memberEntry != null) {
            int key = this.getSourceMember().isStatic() ? 86 : 108;
            String memberName = memberEntry.getText();
            return MessageFormat.format(RefactoringArb.getString(key), memberName);
        }
        return super.getTooltipAt(column);
    }

    Color getCellForeground(int column) {
        if (!this.isIncluded()) {
            int i = 0;
            while (i < this._usedBy.size()) {
                MoveMemberEntry entry = (MoveMemberEntry)this._usedBy.get(i);
                if (entry.isIncluded() && !entry.isAbstract()) {
                    SourceMember thisSourceMember;
                    MoveMemberMemberEntry moveMemberMemberEntry;
                    SourceMember thatSourceMember;
                    boolean areBothStatic = false;
                    if (entry instanceof MoveMemberMemberEntry && (thatSourceMember = (moveMemberMemberEntry = (MoveMemberMemberEntry)entry).getSourceMember()).isStatic() && (thisSourceMember = this.getSourceMember()).isStatic()) {
                        areBothStatic = true;
                    }
                    if (areBothStatic) {
                        return STATIC_MEMBER_COLOR;
                    }
                    return Color.RED;
                }
                ++i;
            }
        }
        return super.getCellForeground(column);
    }

    int getStartOffset() {
        return this.getSourceMember().getStartOffset();
    }

    protected boolean shouldBeIncluded() {
        return this.shouldBeIncludedBecauseOf() != null;
    }

    private MoveMemberMemberEntry shouldBeIncludedBecauseOf() {
        if (!this.isIncluded()) {
            int i = 0;
            while (i < this._usedBy.size()) {
                MoveMemberMemberEntry memberEntry = (MoveMemberMemberEntry)this._usedBy.get(i);
                if (memberEntry.isIncluded()) {
                    return memberEntry;
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean isIncludedThroughDependencies() {
        return this.getIncludedThroughDependencies() != null;
    }

    protected MoveMemberMemberEntry getIncludedThroughDependencies() {
        if (!this._includedRecursion) {
            this._includedRecursion = true;
            try {
                int i = 0;
                while (i < this._usedBy.size()) {
                    MoveMemberEntry moveMemberEntry = (MoveMemberEntry)this._usedBy.get(i);
                    if (moveMemberEntry.isIncludeDependencies() && moveMemberEntry.isIncluded()) {
                        MoveMemberMemberEntry moveMemberMemberEntry = (MoveMemberMemberEntry)moveMemberEntry;
                        return moveMemberMemberEntry;
                    }
                    ++i;
                }
            }
            finally {
                this._includedRecursion = false;
            }
        }
        return null;
    }

    void setUsedBy(List usedBy) {
        this._usedBy = usedBy;
    }

    abstract SourceMember getSourceMember();

    public boolean equals(Object obj) {
        return obj == this || obj == this.getSourceMember();
    }
}

