/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.text.MessageFormat;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMemberEntry;

public class MoveMemberMethodEntry
extends MoveMemberMemberEntry {
    private SourceMethod _method;
    private List _itfaces;

    MoveMemberMethodEntry(SourceMethod method) {
        this._method = method;
        SourceTypeReference sourceReturnType = method.getSourceReturnType();
        JavaType returnType = sourceReturnType.getResolvedType();
        String returnTypeName = returnType != null ? this.getShortTypeName(returnType) : sourceReturnType.getName();
        String name = Util.getFullMethodName((JavaMethod)method, false, false, false) + ":" + returnTypeName;
        this.setText(name);
    }

    public SourceMethod getMethod() {
        return this._method;
    }

    boolean isIncluded() {
        return super.isIncluded() || this.isIncludedThroughInterface();
    }

    boolean isIncludeDependencies() {
        if (this.isAbstract()) {
            return false;
        }
        return super.isIncludeDependencies();
    }

    private boolean isIncludedThroughInterface() {
        return this.getIncludedThroughInterface() != null;
    }

    private MoveMemberInterfaceEntry getIncludedThroughInterface() {
        int i = 0;
        while (i < this._itfaces.size()) {
            MoveMemberEntry moveMemberEntry = (MoveMemberEntry)this._itfaces.get(i);
            if (moveMemberEntry.isIncluded()) {
                MoveMemberInterfaceEntry pullUpInterfaceEntry = (MoveMemberInterfaceEntry)moveMemberEntry;
                return pullUpInterfaceEntry;
            }
            ++i;
        }
        return null;
    }

    public boolean isAbstract() {
        return super.isAbstract() || this._method.isAbstract();
    }

    boolean isEnabled(int column) {
        switch (column) {
            case 0: {
                if (!this.isIncludedThroughInterface()) break;
                return false;
            }
            case 2: {
                if (!this._method.isAbstract() && !this._method.isStatic()) break;
                return false;
            }
            case 3: {
                if (!this.isAbstract()) break;
                return false;
            }
        }
        return super.isEnabled(column);
    }

    String getTooltipAt(int column) {
        switch (column) {
            case 0: {
                MoveMemberMemberEntry includedThroughDependencies = this.getIncludedThroughDependencies();
                if (includedThroughDependencies != null) {
                    return MessageFormat.format(RefactoringArb.getString(279), includedThroughDependencies.getText());
                }
                MoveMemberInterfaceEntry includedThroughInterface = this.getIncludedThroughInterface();
                if (includedThroughInterface == null) break;
                return MessageFormat.format(RefactoringArb.getString(279), includedThroughInterface.getInterfaceClass().getName());
            }
            case 2: {
                if (!this._method.isAbstract()) break;
                return RefactoringArb.getString(74);
            }
            case 3: {
                if (!this.isAbstract()) break;
                return RefactoringArb.getString(10);
            }
        }
        return super.getTooltipAt(column);
    }

    void setItfaces(List itfaces) {
        this._itfaces = itfaces;
    }

    SourceMember getSourceMember() {
        return this.getMethod();
    }
}

