/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.ExtractSuperclassCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.util.Visitor;

public class ExtractSuperclassCommand {
    private Context _context;
    private ExtractSuperclassCriteria _criteria;
    private URL _superClassUrl;
    private HashSet _abstractMethodDescriptions;

    private ExtractSuperclassCommand(Context context, SourceClass subClass, String pkgName, String supertypeName, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields, HashSet abstractMethods) {
        this._context = context;
        this._superClassUrl = Util.createTypeURL(this._context, pkgName, supertypeName);
        ClassDescription[] interfaceDescriptions = new ClassDescription[selectedInterfaces.length];
        int i = 0;
        while (i < selectedInterfaces.length) {
            ClassDescription interfaceDescription;
            JavaType selectedInterface = selectedInterfaces[i];
            JavaClass closestClass = selectedInterface.getTypeErasure();
            interfaceDescriptions[i] = interfaceDescription = ClassDescription.createClassDescription(closestClass);
            ++i;
        }
        HashSet<MethodDescription> methodDescriptions = new HashSet<MethodDescription>();
        int i2 = 0;
        while (i2 < selectedInterfaces.length) {
            JavaType selectedInterface = selectedInterfaces[i2];
            Collection interfaceMethods = selectedInterface.getMethods();
            for (JavaMethod javaMethod : interfaceMethods) {
                MethodDescription methodDescription = new MethodDescription(javaMethod);
                methodDescriptions.add(methodDescription);
            }
            ++i2;
        }
        this._abstractMethodDescriptions = new HashSet();
        int i3 = 0;
        while (i3 < selectedMethods.length) {
            SourceMethod selectedMethod = selectedMethods[i3];
            MethodDescription methodDescription = new MethodDescription((JavaMethod)selectedMethod);
            methodDescriptions.add(methodDescription);
            if (abstractMethods.contains(selectedMethod)) {
                this._abstractMethodDescriptions.add(methodDescription);
            }
            ++i3;
        }
        ArrayList<FieldDescription> fieldDescriptions = new ArrayList<FieldDescription>(selectedFields.length);
        int i4 = 0;
        while (i4 < selectedFields.length) {
            SourceFieldVariable selectedField = selectedFields[i4];
            FieldDescription fieldDescription = new FieldDescription((JavaField)selectedField);
            fieldDescriptions.add(fieldDescription);
            ++i4;
        }
        this._criteria = new ExtractSuperclassCriteria(ClassDescription.createClassDescription(pkgName, supertypeName, false), ClassDescription.createClassDescription((JavaClass)subClass), interfaceDescriptions, methodDescriptions.toArray(new MethodDescription[methodDescriptions.size()]), fieldDescriptions.toArray(new FieldDescription[fieldDescriptions.size()]));
    }

    public static boolean doit(Context context, SourceClass subClass, String pkgName, String supertypeName, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields, HashSet abstractMethods) {
        boolean ret = false;
        ExtractSuperclassCommand command = new ExtractSuperclassCommand(context, subClass, pkgName, supertypeName, selectedInterfaces, selectedMethods, selectedFields, abstractMethods);
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.setOpenCreatedFiles(true);
        try {
            BasicOperation basicOperation = new BasicOperation(command._context, command._criteria);
            refactoringCommandSupport.setSearchOperation(basicOperation);
            Project project = command._context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            JavaClass subJavaClass = command.getSubClassDescription().getJavaClass((JavaProvider)javaManager);
            SourceClass subSourceClass = (SourceClass)subJavaClass.getSourceElement();
            SourceTransaction subSourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)subSourceClass);
            ExtractSuperclassCommand extractSuperclassCommand = command;
            extractSuperclassCommand.getClass();
            MethodsVisitor methodsVisitor = extractSuperclassCommand.new MethodsVisitor(subSourceClass);
            methodsVisitor.visit((SourceElement)subSourceClass);
            subSourceTransaction.savepoint();
            SourceFile superSourceFile = refactoringCommandSupport.createSourceFile(project, command._superClassUrl);
            SourceClass superSourceClass = command.createSuperclass(refactoringCommandSupport, javaManager, superSourceFile);
            if (superSourceClass != null) {
                command.removeSubclassParts(javaManager, superSourceClass);
            }
            refactoringCommandSupport.setOpenCreatedFiles(true);
            refactoringCommandSupport.commit(command._context, RefactoringArb.getString(333));
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private void removeSubclassParts(JavaManager javaManager, SourceClass superSourceClass) {
        JavaClass subJavaClass = this.getSubClassDescription().getJavaClass((JavaProvider)javaManager);
        SourceClass subSourceClass = (SourceClass)subJavaClass.getSourceElement();
        SourceFile subSourceFile = subSourceClass.getOwningSourceFile();
        int i = 0;
        while (i < this.getMethodDescriptions().length) {
            JavaMethod javaMethod;
            JavaClass owningClass;
            MethodDescription methodDescription = this.getMethodDescriptions()[i];
            if (!this._abstractMethodDescriptions.contains(methodDescription) && subJavaClass.equals((Object)(owningClass = (javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager)).getOwningClass()))) {
                SourceElement sourceMethod = javaMethod.getSourceElement();
                sourceMethod.removeSelf();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getFieldDescriptions().length) {
            FieldDescription fieldDescription = this.getFieldDescriptions()[i2];
            JavaField javaField = fieldDescription.getJavaField((JavaProvider)javaManager);
            if (subJavaClass.equals((Object)javaField.getOwningClass())) {
                SourceElement sourceField = javaField.getSourceElement();
                sourceField.removeSelf();
            }
            ++i2;
        }
        SourceFactory subSourceFactory = subSourceFile.getFactory();
        if (!subSourceClass.isAnonymous()) {
            String superQualifiedName = superSourceClass.getName();
            SourceTypeReference superSourceType = subSourceFactory.createType(superQualifiedName);
            subSourceClass.setSourceSuperclass(superSourceType);
            List sourceInterfaces = subSourceClass.getSourceInterfaces();
            int i3 = sourceInterfaces.size() - 1;
            while (i3 >= 0) {
                SourceTypeReference sourceInterface = (SourceTypeReference)sourceInterfaces.get(i3);
                JavaType resolvedType = sourceInterface.getResolvedType();
                int j = 0;
                while (j < this.getInterfaceDescriptions().length) {
                    ClassDescription classDescription = this.getInterfaceDescriptions()[j];
                    JavaClass exportedInterface = classDescription.getJavaClass((JavaProvider)javaManager);
                    if (resolvedType.equals((Object)exportedInterface)) {
                        sourceInterface.removeSelf();
                        break;
                    }
                    ++j;
                }
                --i3;
            }
        } else {
            SourceElement parent = subSourceClass.getParent();
            if (parent.getSymbolKind() == 55) {
                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)parent;
                SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
                String superQualifiedName = superSourceClass.getQualifiedName();
                SourceTypeReference superSourceType = subSourceFactory.createType(superQualifiedName);
                sourceType.replaceSelf((SourceElement)superSourceType);
            }
        }
    }

    private SourceClass createSuperclass(RefactoringCommandSupport refactoringCommandSupport, JavaManager javaManager, SourceFile superSourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)superSourceFile);
        String superPackageName = this.getSuperclassDescription().getPackageName();
        String superClassName = this.getSuperclassDescription().getClassName();
        SourceFactory factory = superSourceFile.getFactory();
        superSourceFile.setPackageName(superPackageName);
        SourceMember[] memberArray = this.createMembers(javaManager, superSourceFile, factory);
        SourceClassBody classBody = factory.createClassBody(memberArray);
        SourceClass superClass = factory.createClass(0, superClassName, null, null, null, classBody);
        superClass.setModifiers(1);
        this.createSuperClause(javaManager, factory, superClass);
        if (this.superIsAbstract(javaManager)) {
            superClass.addModifiers(1024);
        }
        Patch.add((SourceElement)superSourceFile, (SourceElement)superClass);
        return superClass;
    }

    private boolean superIsAbstract(JavaManager javaManager) {
        if (!this._abstractMethodDescriptions.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.getMethodDescriptions().length) {
            MethodDescription methodDescription = this.getMethodDescriptions()[i];
            JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
            if (javaMethod.isAbstract()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createSuperClause(JavaManager javaManager, SourceFactory factory, SourceClass newSourceClass) {
        ClassDescription subClassDescription = this.getSubClassDescription();
        JavaClass subJavaClass = subClassDescription.getJavaClass((JavaProvider)javaManager);
        SourceClass subSourceClass = (SourceClass)subJavaClass.getSourceElement();
        SourceTypeReference currentSuperType = null;
        if (!subSourceClass.isAnonymous()) {
            SourceTypeReference sourceSuperclass = subSourceClass.getSourceSuperclass();
            if (sourceSuperclass != null) {
                String qualifiedSuperName;
                JavaType resolvedSuperType = sourceSuperclass.getResolvedType();
                String sourceSuperclassName = resolvedSuperType != null ? (qualifiedSuperName = resolvedSuperType.getQualifiedName()) : sourceSuperclass.getName();
                currentSuperType = factory.createType(sourceSuperclassName);
            }
        } else {
            SourceElement classParent = subSourceClass.getParent();
            if (classParent.getSymbolKind() == 55) {
                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)classParent;
                SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
                JavaType resolvedType = sourceType.getResolvedType();
                String qualifiedName = resolvedType.getQualifiedName();
                currentSuperType = factory.createType(qualifiedName);
            }
        }
        if (currentSuperType != null) {
            newSourceClass.setSourceSuperclass(currentSuperType);
        }
        int i = 0;
        while (i < this.getInterfaceDescriptions().length) {
            ClassDescription interfaceDescription = this.getInterfaceDescriptions()[i];
            String qualifiedName = interfaceDescription.getQualifiedName();
            SourceTypeReference selectedSourceType = factory.createType(qualifiedName);
            newSourceClass.getSourceInterfaces().add(selectedSourceType);
            ++i;
        }
    }

    private SourceMember[] createMembers(JavaManager javaManager, SourceFile superSourceFile, SourceFactory factory) {
        ClassDescription subClassDescription = this.getSubClassDescription();
        JavaClass subClass = subClassDescription.getJavaClass((JavaProvider)javaManager);
        MethodDescription[] methodDescriptions = this.getMethodDescriptions();
        ArrayList<Object> members = new ArrayList<Object>(methodDescriptions.length + this.getFieldDescriptions().length);
        int i = 0;
        while (i < methodDescriptions.length) {
            JavaClass owningClass;
            MethodDescription methodDescription = methodDescriptions[i];
            JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            if (sourceMethod != null && subClass.equals((Object)(owningClass = sourceMethod.getOwningClass()))) {
                SourceMethod newMethod = (SourceMethod)sourceMethod.cloneSelf(superSourceFile);
                if (this._abstractMethodDescriptions.contains(methodDescription) && !sourceMethod.isAbstract()) {
                    newMethod.addModifiers(1024);
                    SourceBlock block = newMethod.getBlock();
                    block.removeSelf();
                }
                members.add(newMethod);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getFieldDescriptions().length) {
            FieldDescription fieldDescription = this.getFieldDescriptions()[i2];
            JavaField javaField = fieldDescription.getJavaField((JavaProvider)javaManager);
            SourceFieldVariable sourceField = (SourceFieldVariable)javaField.getSourceElement();
            SourceFieldVariable newSourceField = (SourceFieldVariable)sourceField.cloneSelf(superSourceFile);
            SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(newSourceField);
            members.add(fieldDeclaration);
            ++i2;
        }
        SourceMember[] memberArray = members.toArray(new SourceMember[members.size()]);
        return memberArray;
    }

    public String getName() {
        return this._criteria.getShortTitle();
    }

    public ClassDescription getSuperclassDescription() {
        return this._criteria.getSuperclassDescription();
    }

    public ClassDescription getSubClassDescription() {
        return this._criteria.getSubClassDescription();
    }

    public MethodDescription[] getMethodDescriptions() {
        return this._criteria.getMethodDescriptions();
    }

    public FieldDescription[] getFieldDescriptions() {
        return this._criteria.getFieldDescriptions();
    }

    public ClassDescription[] getInterfaceDescriptions() {
        return this._criteria.getInterfaceDescriptions();
    }

    static HashSet ra$_abstractMethodDescriptions(ExtractSuperclassCommand extractSuperclassCommand) {
        return extractSuperclassCommand._abstractMethodDescriptions;
    }

    private class MethodsVisitor
    extends Visitor {
        private int _inMovingCode;
        private final SourceFile _subClassFile;
        boolean _superNeedsToImportSub;
        private SourceClass _subSourceClass;

        public MethodsVisitor(SourceClass subSourceClass) {
            this._subSourceClass = subSourceClass;
            this._subClassFile = subSourceClass.getOwningSourceFile();
        }

        private boolean isInMovingCode() {
            return this._inMovingCode > 0;
        }

        private boolean isMovingMethod(JavaMethod javaMethod) {
            MethodDescription enteredMethod = new MethodDescription(javaMethod);
            int i = 0;
            while (i < ExtractSuperclassCommand.this.getMethodDescriptions().length) {
                MethodDescription methodDescription = ExtractSuperclassCommand.this.getMethodDescriptions()[i];
                if (!ExtractSuperclassCommand.ra$_abstractMethodDescriptions(ExtractSuperclassCommand.this).contains(methodDescription) && enteredMethod.equals(methodDescription)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isMovingField(JavaField javaField) {
            String variableName;
            boolean ret = false;
            JavaClass owningClass = javaField.getOwningClass();
            String subQualifiedName = ExtractSuperclassCommand.this.getSubClassDescription().getQualifiedName();
            if (subQualifiedName.equals(owningClass.getQualifiedName()) && this.isNameOfMovingField(variableName = javaField.getName())) {
                ret = true;
            }
            return ret;
        }

        private boolean isNameOfMovingField(String name) {
            int i = 0;
            while (i < ExtractSuperclassCommand.this.getFieldDescriptions().length) {
                FieldDescription fieldDescription = ExtractSuperclassCommand.this.getFieldDescriptions()[i];
                String movingFieldName = fieldDescription.getMemberName();
                if (name.equals(movingFieldName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void changeAccessModifier(JavaMethod javaMethod, int newModifier) {
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            if (sourceMethod != null) {
                sourceMethod.removeModifiers(7);
                sourceMethod.addModifiers(newModifier);
            }
        }

        private void changeAccessModifier(JavaField javaField, int newModifier) {
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)sourceFieldVariable.getParent();
            int modifiers = BitField.unset((int)sourceFieldDeclaration.getModifiers(), (int)7);
            sourceFieldDeclaration.setModifiers(modifiers | newModifier);
        }

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            if (this.isMovingMethod((JavaMethod)sourceMethod)) {
                ++this._inMovingCode;
            }
            super.whenEnterMethodDeclaration(sourceMethod);
        }

        protected void whenExitMethodDeclaration(SourceMethod sourceMethod) {
            if (this.isMovingMethod((JavaMethod)sourceMethod)) {
                --this._inMovingCode;
            }
        }

        protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
            if (this.isMovingField((JavaField)sourceFieldVariable)) {
                ++this._inMovingCode;
            }
            super.whenEnterFieldVariable(sourceFieldVariable);
        }

        protected void whenExitFieldVariable(SourceFieldVariable sourceFieldVariable) {
            if (this.isMovingField((JavaField)sourceFieldVariable)) {
                --this._inMovingCode;
            }
            super.whenExitFieldVariable(sourceFieldVariable);
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
            if (resolvedMethod != null) {
                if (this.isInMovingCode()) {
                    if (!this.isMovingMethod(resolvedMethod)) {
                        JavaClass owningClass = resolvedMethod.getOwningClass();
                        if (owningClass.equals((Object)this._subSourceClass)) {
                            if (resolvedMethod.isStatic()) {
                                SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
                                if (lhsOperand == null) {
                                    SourceFactory factory = this._subClassFile.getFactory();
                                    String subClassName = ExtractSuperclassCommand.this.getSubClassDescription().getClassName();
                                    SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(subClassName);
                                    sourceMethodCallExpression.getChildren().add(0, simpleNameExpression);
                                    this._superNeedsToImportSub = true;
                                }
                                if (resolvedMethod.isPrivate() || resolvedMethod.isProtected()) {
                                    this.changeAccessModifier(resolvedMethod, 1);
                                }
                            }
                        } else if (resolvedMethod.isPackagePrivate()) {
                            this.changeAccessModifier(resolvedMethod, 4);
                        }
                    }
                } else if (this.isMovingMethod(resolvedMethod) && resolvedMethod.isPrivate()) {
                    this.changeAccessModifier(resolvedMethod, 4);
                }
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
            if (resolvedObject instanceof JavaField) {
                JavaField resolvedField = (JavaField)resolvedObject;
                if (this.isInMovingCode()) {
                    if (!this.isMovingField(resolvedField)) {
                        SourceFactory factory = this._subClassFile.getFactory();
                        String subClassName = ExtractSuperclassCommand.this.getSubClassDescription().getClassName();
                        SourceSimpleNameExpression lhsExpression = factory.createSimpleNameExpression(subClassName);
                        SourceDotExpression dotExpression = factory.createDotReference((SourceExpression)lhsExpression, resolvedField.getName());
                        SourceElement parent = sourceSimpleNameExpression.getParent();
                        List children = parent.getChildren();
                        int insertionPos = children.indexOf(sourceSimpleNameExpression);
                        children.add(insertionPos, dotExpression);
                        sourceSimpleNameExpression.removeSelf();
                        if (resolvedField.isPrivate() || resolvedField.isProtected()) {
                            this.changeAccessModifier(resolvedField, 1);
                        }
                    }
                } else if (this.isMovingField(resolvedField) && resolvedField.isPrivate()) {
                    this.changeAccessModifier(resolvedField, 4);
                }
            }
        }
    }
}

