/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass.ExtractSuperclassCommand;
import oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass.ExtractSuperclassDialog;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeController;

public class ExtractSuperclassController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            if (sourceClass != null) {
                canHandle = ExtractSuperclassController.handle(context, sourceClass, doit);
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                        canHandle = ExtractSuperclassController.handle(context, sourceSourceClass, doit);
                    }
                }
            }
        }
        return canHandle;
    }

    public static boolean canExtract(Context context, SourceClass sourceClass) {
        return ExtractSuperclassController.handle(context, sourceClass, false);
    }

    private static boolean handle(Context context, SourceClass sourceClass, boolean doit) {
        SourceFile containingSourceFile;
        URL url;
        boolean ret = false;
        if (sourceClass != null && !sourceClass.isAnnotation() && Util.canRefactor(context, url = (containingSourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            ret = true;
            if (doit) {
                String message = null;
                if (ExtractSuperclassController.hasMembersToExtract(sourceClass)) {
                    ExtractSuperclassController.whenExtract(context, sourceClass);
                } else {
                    message = RefactoringArb.getString(81);
                }
                if (message != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)RefactoringArb.getString(333), null);
                }
            }
        }
        return ret;
    }

    public static void whenExtract(Context context, SourceClass sourceClass) {
        ExtractSuperclassDialog extractSuperclassDialog = new ExtractSuperclassDialog(context, sourceClass);
        if (extractSuperclassDialog.init() && extractSuperclassDialog.runDialog()) {
            String interfaceName = extractSuperclassDialog.getSuperClassName();
            String pkgName = extractSuperclassDialog.getPackage();
            JavaType[] selectedInterfaces = extractSuperclassDialog.getPulledInterfaces();
            HashSet<SourceMethod> abstractMethods = new HashSet<SourceMethod>();
            MoveMemberMethodEntry[] pulledMethodEntries = extractSuperclassDialog.getPulledMethodEntries();
            int i = 0;
            while (i < pulledMethodEntries.length) {
                MoveMemberMethodEntry pulledMethodEntry = pulledMethodEntries[i];
                if (pulledMethodEntry.isAbstract()) {
                    SourceMethod sourceMethod = pulledMethodEntry.getMethod();
                    abstractMethods.add(sourceMethod);
                }
                ++i;
            }
            SourceMethod[] selectedMethods = extractSuperclassDialog.getPulledMethods();
            SourceFieldVariable[] selectedFields = extractSuperclassDialog.getPulledFields();
            boolean replaceUsages = extractSuperclassDialog.hasReplaceUsages();
            boolean preview = extractSuperclassDialog.hasPreview();
            ExtractSuperclassController.whenExtract(context, selectedInterfaces, selectedMethods, selectedFields, pkgName, interfaceName, sourceClass, abstractMethods, replaceUsages, preview);
        }
    }

    private static void whenExtract(Context context, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields, String pkgName, String supertypeName, SourceClass sourceClass, HashSet abstractMethods, boolean replaceUsages, boolean preview) {
        boolean success = ExtractSuperclassCommand.doit(context, sourceClass, pkgName, supertypeName, selectedInterfaces, selectedMethods, selectedFields, abstractMethods);
        if (success && replaceUsages) {
            String superClassFqName = pkgName == null || pkgName.length() == 0 ? supertypeName : pkgName + '.' + supertypeName;
            JavaManager javaManager = JavaManager.getJavaManager((Project)context.getProject());
            SourceClass superSourceClass = javaManager.getSourceClass(superClassFqName);
            UseSupertypeController.whenUseSupertype(context, sourceClass, superSourceClass, preview);
        }
    }

    private static boolean hasMembersToExtract(SourceClass sourceClass) {
        boolean ret = false;
        List sourceMethods = sourceClass.getSourceMethods();
        if (!sourceMethods.isEmpty()) {
            ret = true;
        } else {
            Collection declaredFields = sourceClass.getDeclaredFields();
            if (!declaredFields.isEmpty()) {
                ret = true;
            }
        }
        return ret;
    }
}

