/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveUpDownDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenamePackageDialog;

public class ExtractSuperclassDialog
extends MoveUpDownDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "EXTRACT_SUPER_PREF_KEY";
    private JTextField _pkgName;
    private JTextField _className;
    private JCheckBox _replaceUsages;
    private JCheckBox _preview;
    private JButton _browsePackage;

    public ExtractSuperclassDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
    }

    public boolean init() {
        this.setPreferredSize(new Dimension(420, 240));
        JLabel pkgLabel = new JLabel();
        String subPackageName = this.getSourceSourceClass().getPackageName();
        this._pkgName = new JTextField(subPackageName);
        ResourceUtils.resLabel((JLabel)pkgLabel, (Component)this._pkgName, (String)RefactoringArb.getString(0));
        this.updateOnChanges(this._pkgName);
        ClassPickerFactory.attach(this._pkgName, this.getContext(), 2);
        this._browsePackage = new JButton("...");
        this._browsePackage.addActionListener(this);
        JLabel classNameLabel = new JLabel();
        this._className = new JTextField();
        ResourceUtils.resLabel((JLabel)classNameLabel, (Component)this._className, (String)RefactoringArb.getString(35));
        this.updateOnChanges(this._className);
        this._members = this.createTable();
        JScrollPane scrollPane = new JScrollPane(this._members);
        scrollPane.getViewport().setBackground(this._members.getBackground());
        JLabel membersLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)membersLabel, (Component)this._members, (String)RefactoringArb.getString(175));
        this._replaceUsages = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._replaceUsages, (String)RefactoringArb.getString(61));
        this._replaceUsages.addActionListener(this);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(260));
        this._preview.setEnabled(false);
        this._replaceUsages.setSelected(false);
        JLabel message = new JLabel();
        message.setPreferredSize(this._pkgName.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)pkgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._pkgName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)classNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._className, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)membersLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._replaceUsages, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 13, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        return true;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String warningMessage = null;
            String errorMessage = null;
            boolean isValid = true;
            String packageName = this.getPackage();
            String superClassName = this.getSuperClassName();
            if (packageName.endsWith(".")) {
                isValid = false;
            } else if (!NamingUtil.isPackageIdentifier((String)packageName)) {
                errorMessage = RefactoringArb.getString(84);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)packageName)) {
                errorMessage = RefactoringArb.getString(84);
                isValid = false;
            } else if (RenamePackageDialog.hasUpperCase(packageName)) {
                warningMessage = RefactoringArb.getString(131);
            }
            if (errorMessage == null) {
                if (superClassName.length() == 0) {
                    isValid = false;
                } else if (!NamingUtil.isJavaIdentifier((String)superClassName)) {
                    errorMessage = RefactoringArb.getString(164);
                    isValid = false;
                } else if (superClassName.lastIndexOf(36) >= 0) {
                    errorMessage = RefactoringArb.getString(164);
                    isValid = false;
                } else if (NamingUtil.isJavaReservedWord((String)superClassName)) {
                    errorMessage = RefactoringArb.getString(164);
                    isValid = false;
                } else if (this.isClassAlreadyPresent(superClassName)) {
                    errorMessage = MessageFormat.format(RefactoringArb.getString(163), superClassName);
                    isValid = false;
                } else if (!Character.isUpperCase(superClassName.charAt(0))) {
                    warningMessage = RefactoringArb.getString(23);
                }
            }
            if (!this.hasSelection()) {
                isValid = false;
            }
            if (errorMessage != null) {
                this.setMessage(errorMessage, false);
            } else {
                this.setMessage(warningMessage, true);
            }
            this.setOKButtonEnabled(isValid);
        }
    }

    private boolean isClassAlreadyPresent(String text) {
        SourceClass sourceSourceClass = this.getSourceSourceClass();
        JavaProvider javaProvider = sourceSourceClass.getOwningSourceFile().getProvider();
        String pkg = this.getPackage();
        String fqName = pkg.length() == 0 ? text : pkg + "." + text;
        SourceClass newClass = javaProvider.getSourceClass(fqName);
        return newClass != null;
    }

    protected boolean canClose() {
        return true;
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(347);
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._className;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dextractsuperclass_html";
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        List sourceMethods = sourceClass.getSourceMethods();
        MultiMap memberDependencies = new MultiMap();
        int i = 0;
        while (i < sourceMethods.size()) {
            SourceMethod sourceMethod = (SourceMethod)sourceMethods.get(i);
            HashSet methodDependencies = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : methodDependencies) {
                memberDependencies.add((Object)sourceElement, (Object)sourceMethod);
            }
            ++i;
        }
        Collection sourceFieldVariables = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : sourceFieldVariables) {
            SourceExpression initializer = sourceFieldVariable.getInitializer();
            HashSet initializerDependencies = this.calculateDependencies(sourceClass, (SourceElement)initializer);
            for (SourceElement sourceElement : initializerDependencies) {
                memberDependencies.add((Object)sourceElement, (Object)sourceFieldVariable);
            }
        }
        return memberDependencies;
    }

    public String getSuperClassName() {
        return this._className.getText();
    }

    public String getPackage() {
        return this._pkgName.getText();
    }

    public JavaType[] getPulledInterfaces() {
        MoveMemberInterfaceEntry[] pulledInterfaceEntries = this.getPulledInterfaceEntries();
        JavaType[] ret = new JavaType[pulledInterfaceEntries.length];
        int i = 0;
        while (i < pulledInterfaceEntries.length) {
            JavaType interfaceClass;
            MoveMemberInterfaceEntry pulledInterfaceEntry = pulledInterfaceEntries[i];
            ret[i] = interfaceClass = pulledInterfaceEntry.getInterfaceClass();
            ++i;
        }
        return ret;
    }

    public boolean hasReplaceUsages() {
        return this._replaceUsages.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._replaceUsages) {
            this._preview.setEnabled(this._replaceUsages.isSelected());
        } else if (source == this._browsePackage) {
            this.whenBrowse();
        }
    }

    private void whenBrowse() {
        String oldPkg;
        Project project = this.getContext().getProject();
        String[] newPkgName = ClassPackageBrowserV2.browseClassOrPackage((Component)this, project, 1, false, null, oldPkg = this._pkgName.getText());
        if (newPkgName.length == 1) {
            this._pkgName.setText(newPkgName[0]);
        }
    }
}

