/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceDataSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberDialog;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;
import oracle.jdevimpl.refactoring.util.MemberAccess;
import oracle.jdevimpl.refactoring.util.Visitor;

public class MoveInstanceMemberController {
    private static final boolean HAS_BUG_CANNOT_MOVE_MOD_BLOCK = true;
    private static final String OPR_TITLE = RefactoringArb.getString(158);

    public static boolean canMoveMember(Context context, SourceMethod sourceMethod) {
        return MoveInstanceMemberController.handle(context, sourceMethod, false);
    }

    public static void whenMoveMembers(Context context, SourceMethod sourceMethod) {
        MoveInstanceMemberController.handle(context, sourceMethod, true);
    }

    private static boolean handle(Context context, SourceMethod sourceMethod, boolean doit) {
        SourceClass sourceClass;
        JavaClass owningClass;
        boolean ret = false;
        if (!sourceMethod.isAbstract() && (owningClass = sourceMethod.getOwningClass()) != null && (sourceClass = (SourceClass)owningClass.getSourceElement()) != null && Util.canRefactor((SourceElement)sourceClass)) {
            ret = true;
            if (doit) {
                MoveInstanceMemberController.initiateMoveMember(context, sourceClass, sourceMethod);
            }
        }
        return ret;
    }

    private static void initiateMoveMember(Context context, SourceClass owningSourceClass, SourceMethod sourceMethod) {
        String message = null;
        ArrayList dataSources = new ArrayList();
        dataSources.addAll(MoveInstanceMemberController.getAvailableFields(owningSourceClass));
        dataSources.addAll(MoveInstanceMemberController.getAvailableGetters(owningSourceClass));
        dataSources.addAll(MoveInstanceMemberController.getAvailableParameters(sourceMethod));
        if (dataSources.isEmpty()) {
            message = RefactoringArb.getString(240);
        } else if (MoveInstanceMemberController.referencesSuper(sourceMethod)) {
            message = RefactoringArb.getString(298);
        } else {
            Collection overriddenMethods = sourceMethod.getOverriddenMethods();
            if (!overriddenMethods.isEmpty()) {
                JavaMethod firstMethod = (JavaMethod)overriddenMethods.toArray()[0];
                message = MessageFormat.format(RefactoringArb.getString(102), Util.getFullMethodName(firstMethod, true, true, false));
            }
        }
        if (message == null) {
            String defaultParamName;
            if (!owningSourceClass.isAnonymous()) {
                String paramClassName = owningSourceClass.getName();
                defaultParamName = Character.toLowerCase(paramClassName.charAt(0)) + paramClassName.substring(1);
            } else {
                defaultParamName = "p";
            }
            MoveInstanceMemberDialog dialog = new MoveInstanceMemberDialog(context, dataSources, defaultParamName, sourceMethod);
            if (dialog.runDialog()) {
                String paramName = dialog.getParamName();
                MoveInstanceDataSource selectedData = dialog.getSelectedData();
                boolean useDelegate = dialog.isUseDelegate();
                String targetMethodName = dialog.getMethodName();
                MoveInstanceMemberController.doMoveMember(context, sourceMethod, paramName, selectedData, useDelegate, targetMethodName);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, OPR_TITLE, 2);
        }
    }

    private static ArrayList getAvailableFields(SourceClass owningSourceClass) {
        ArrayList<SourceFieldVariable> availableFields = new ArrayList<SourceFieldVariable>();
        Collection declaredFields = owningSourceClass.getDeclaredFields();
        for (JavaField javaField : declaredFields) {
            SourceFieldVariable sourceFieldVariable;
            SourceClass fieldClass;
            JavaType resolvedType = javaField.getResolvedType();
            if (resolvedType == null || !MoveInstanceMemberController.isUsableType(resolvedType) || !Util.canRefactor((SourceElement)(fieldClass = (SourceClass)resolvedType.getSourceElement())) || (sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement()) == null) continue;
            availableFields.add(sourceFieldVariable);
        }
        return availableFields;
    }

    private static ArrayList getAvailableGetters(SourceClass owningSourceClass) {
        ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
        Collection declaredMethods = owningSourceClass.getDeclaredMethods();
        for (JavaMethod javaMethod : declaredMethods) {
            SourceMethod sourceMethod;
            SourceClass targetSourceClass;
            JavaType returnType;
            if (!javaMethod.getParameters().isEmpty() || !MoveInstanceMemberController.isUsableType(returnType = javaMethod.getReturnType()) || !Util.canRefactor((SourceElement)(targetSourceClass = (SourceClass)returnType.getSourceElement())) || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null || !MoveInstanceMemberController.isConstMethod(sourceMethod)) continue;
            javaMethods.add(javaMethod);
        }
        return javaMethods;
    }

    private static boolean isConstMethod(SourceMethod sourceMethod) {
        1 visitor = new 1();
        visitor.visit((SourceElement)sourceMethod);
        return visitor.isCanceled() ^ true;
    }

    private static ArrayList getAvailableParameters(SourceMethod sourceMethod) {
        ArrayList<SourceElement> sourceLocalVariables = new ArrayList<SourceElement>();
        Collection parameters = sourceMethod.getParameters();
        for (JavaLocalVariable javaLocalVariable : parameters) {
            SourceElement paramClass;
            JavaType resolvedType = javaLocalVariable.getResolvedType();
            if (!MoveInstanceMemberController.isUsableType(resolvedType) || !Util.canRefactor(paramClass = resolvedType.getSourceElement())) continue;
            sourceLocalVariables.add(javaLocalVariable.getSourceElement());
        }
        return sourceLocalVariables;
    }

    private static boolean referencesSuper(SourceMethod sourceMethod) {
        List list = SourceElementAsList.asList((SourceElement)sourceMethod, (int[])new int[]{57});
        int i = 0;
        while (i < list.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(i);
            if ("super".equals(sourceSimpleNameExpression.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isUsableType(JavaType resolvedType) {
        if (resolvedType.isPrimitive() || resolvedType.isArray() || resolvedType.isInterface() || resolvedType.isDeprecated() || resolvedType.isEnum() || !resolvedType.isExported() || resolvedType.isHidden() || resolvedType.isAnnotation()) {
            return false;
        }
        return !"void".equals(resolvedType.getName());
    }

    private static void doMoveMember(Context context, SourceMethod sourceMethod, String paramName, MoveInstanceDataSource selectedData, boolean useDelegate, String targetMethodName) {
        MultiMap sourceInvokeExpressions = MoveInstanceMemberController.getUsages(context, sourceMethod);
        JavaClass srcOwingClass = sourceMethod.getOwningClass();
        SourceClass srcSourceClass = (SourceClass)srcOwingClass.getSourceElement();
        SourceFile srcSourceFile = srcSourceClass.getOwningSourceFile();
        JavaType resolvedType = selectedData.getJavaType();
        SourceClass targetSourceClass = (SourceClass)resolvedType.getSourceElement();
        SourceFile targetSourceFile = targetSourceClass.getOwningSourceFile();
        SourceFactory srcFactory = srcSourceFile.getFactory();
        SourceFactory targetFactory = targetSourceFile.getFactory();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            refactoringCommandSupport.beginTransaction((SourceElement)srcSourceFile);
            refactoringCommandSupport.beginTransaction((SourceElement)targetSourceFile);
            if (!MemberAccess.updateAccessModifiers(refactoringCommandSupport, (SourceElement)sourceMethod, targetSourceClass)) {
                throw new AbortedOperationException();
            }
            SrcMethodVisitor references = MoveInstanceMemberController.getReferences(selectedData, sourceMethod);
            boolean needsAdditionalParam = references.needsAdditionalParam();
            SourceTypeReference targetReturnSourceType = Util.createSourceType(sourceMethod.getSourceReturnType(), targetSourceFile);
            SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
            SourceFormalParameterList targetFormalParameterList = (SourceFormalParameterList)sourceFormalParameterList.cloneSelf(targetSourceFile);
            if (needsAdditionalParam) {
                String qualifiedName = srcOwingClass.getQualifiedName();
                SourceTypeReference sourceType = targetFactory.createType(qualifiedName);
                SourceLocalVariable srcParam = targetFactory.createLocalVariable(sourceType, paramName);
                srcParam.addSelf((SourceElement)targetFormalParameterList);
            }
            SourceThrowsClause targetThrowsClause = (SourceThrowsClause)sourceMethod.getThrowsClause().cloneSelf(targetSourceFile);
            SourceBlock targetSourceBlock = MoveInstanceMemberController.createTargetSourceBlock(refactoringCommandSupport, references, sourceMethod, paramName, targetSourceFile);
            SourceMethod targetSourceMethod = selectedData.createMethod(targetFactory, targetReturnSourceType, targetMethodName, targetFormalParameterList, targetThrowsClause, targetSourceBlock);
            targetSourceMethod.setModifiers(sourceMethod.getModifiers());
            SourceClassBody targetClassBody = targetSourceClass.getSourceBody();
            targetSourceMethod.addSelf((SourceElement)targetClassBody);
            if (useDelegate) {
                SourceBlock newSrcBlock = srcFactory.createBlock();
                SourceMethodCallExpression methodCall = selectedData.createDelegate(srcFactory, references, sourceMethod, targetMethodName, needsAdditionalParam);
                Object sourceStatement = "void".equals(sourceMethod.getSourceReturnType().getName()) ? srcFactory.createExpressionStatement((SourceExpression)methodCall) : srcFactory.createReturnStatement((SourceExpression)methodCall);
                sourceStatement.addSelf((SourceElement)newSrcBlock);
                sourceMethod.getBlock().replaceSelf((SourceElement)newSrcBlock);
            } else {
                sourceMethod.removeSelf();
                HashSet handledUrls = new HashSet();
                Set projects = sourceInvokeExpressions.keySet();
                for (Project project : projects) {
                    List thisInvokeExpressions = sourceInvokeExpressions.get((Object)project);
                    MoveInstanceMemberController.replaceCallers(handledUrls, needsAdditionalParam, thisInvokeExpressions, refactoringCommandSupport, selectedData, targetMethodName);
                }
            }
            refactoringCommandSupport.commit(context, OPR_TITLE);
        }
        catch (AbortedOperationException e) {
            refactoringCommandSupport.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static MultiMap getUsages(Context context, SourceMethod sourceMethod) {
        1MyRunnable myRunnable = new 1MyRunnable((Component)Ide.getMainWindow(), context, sourceMethod);
        return myRunnable.start();
    }

    private static void replaceCallers(HashSet handledUrls, boolean needsAdditionalParam, List sourceInvokeExpressions, RefactoringCommandSupport refactoringCommandSupport, MoveInstanceDataSource selectedField, String targetMethodName) {
        int i = 0;
        while (i < sourceInvokeExpressions.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceInvokeExpressions.get(i);
            SourceFile owningSourceFile = sourceMethodCallExpression.getOwningSourceFile();
            URL url = owningSourceFile.getURL();
            if (!handledUrls.contains(url)) {
                handledUrls.add(url);
                SourceFactory factory = owningSourceFile.getFactory();
                refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                selectedField.transformMethodCall(factory, needsAdditionalParam, sourceMethodCallExpression);
                sourceMethodCallExpression.setName(targetMethodName);
            }
            ++i;
        }
    }

    private static SourceBlock createTargetSourceBlock(RefactoringCommandSupport refactoringCommandSupport, SrcMethodVisitor references, SourceMethod sourceMethod, String paramName, SourceFile targetSourceFile) {
        SourceBlock srcBlock = sourceMethod.getBlock();
        HashSet<String> knownFieldNames = new HashSet<String>();
        JavaClass srcOwingClass = sourceMethod.getOwningClass();
        SourceClass srcSourceClass = (SourceClass)srcOwingClass.getSourceElement();
        SourceFile srcSourceFile = srcSourceClass.getOwningSourceFile();
        Collection srcFields = srcSourceClass.getFields();
        for (JavaField javaField : srcFields) {
            String fieldName = javaField.getName();
            knownFieldNames.add(fieldName);
        }
        ArrayList replaceWithParam = references.getReplaceWithParam();
        ArrayList dotExpressWithParam = references.getDotExpressWithParam();
        ArrayList lhsMethodCallWithParam = references.getLhsMethodCallWithParam();
        ArrayList newInnerClass = references.getNewInnerClass();
        ArrayList classRefMethod = references.getClassRefMethod();
        ArrayList classRefInner = references.getClassRefInner();
        ArrayList unrefMethodCall = references.getUnrefMethodCall();
        ArrayList unrefDotExpr = references.getUnrefDotExpr();
        ArrayList replaceWithThis = references.getReplaceWithThis();
        SourceFactory srcFactory = srcSourceClass.getOwningSourceFile().getFactory();
        int i = 0;
        while (i < replaceWithParam.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)replaceWithParam.get(i);
            SourceSimpleNameExpression paramAccess = srcFactory.createSimpleNameExpression(paramName);
            sourceSimpleNameExpression.replaceSelf((SourceElement)paramAccess);
            ++i;
        }
        int i2 = 0;
        while (i2 < dotExpressWithParam.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)dotExpressWithParam.get(i2);
            SourceSimpleNameExpression paramAccess = srcFactory.createSimpleNameExpression(paramName);
            SourceDotExpression dotExpression = srcFactory.createDotReference((SourceExpression)paramAccess, sourceSimpleNameExpression.getName());
            sourceSimpleNameExpression.replaceSelf((SourceElement)dotExpression);
            ++i2;
        }
        int i3 = 0;
        while (i3 < lhsMethodCallWithParam.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)lhsMethodCallWithParam.get(i3);
            SourceSimpleNameExpression paramAccess = srcFactory.createSimpleNameExpression(paramName);
            sourceMethodCallExpression.setLhsOperand((SourceExpression)paramAccess);
            ++i3;
        }
        int i4 = 0;
        while (i4 < newInnerClass.size()) {
            SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)newInnerClass.get(i4);
            SourceSimpleNameExpression paramAccess = srcFactory.createSimpleNameExpression(paramName);
            sourceClassCreatorExpression.setLhsOperand((SourceExpression)paramAccess);
            ++i4;
        }
        int i5 = 0;
        while (i5 < classRefMethod.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)classRefMethod.get(i5);
            SourceSimpleNameExpression simpleNameExpression = srcFactory.createSimpleNameExpression(srcOwingClass.getQualifiedName());
            sourceMethodCallExpression.setLhsOperand((SourceExpression)simpleNameExpression);
            ++i5;
        }
        int i6 = 0;
        while (i6 < classRefInner.size()) {
            Object[] pair = (Object[])classRefInner.get(i6);
            SourceTypeReference sourceType = (SourceTypeReference)pair[0];
            String fqName = (String)pair[1];
            SourceTypeReference fqType = srcFactory.createType(fqName);
            sourceType.replaceSelf((SourceElement)fqType);
            ++i6;
        }
        int i7 = 0;
        while (i7 < unrefMethodCall.size()) {
            SourceExpression sourceExpression = (SourceExpression)unrefMethodCall.get(i7);
            sourceExpression.removeSelf();
            ++i7;
        }
        int i8 = 0;
        while (i8 < unrefDotExpr.size()) {
            SourceDotExpression dotExpression = (SourceDotExpression)unrefDotExpr.get(i8);
            String fieldName = dotExpression.getName();
            SourceSimpleNameExpression simpleNameExpression = srcFactory.createSimpleNameExpression(fieldName);
            dotExpression.replaceSelf((SourceElement)simpleNameExpression);
            ++i8;
        }
        int i9 = 0;
        while (i9 < replaceWithThis.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)replaceWithThis.get(i9);
            SourceSimpleNameExpression thisAccess = srcFactory.createSimpleNameExpression("this");
            sourceSimpleNameExpression.replaceSelf((SourceElement)thisAccess);
            ++i9;
        }
        SourceTransaction sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)srcSourceFile);
        sourceTransaction.savepoint();
        SourceBlock ret = (SourceBlock)srcBlock.cloneSelf(targetSourceFile);
        return ret;
    }

    static SrcMethodVisitor getReferences(MoveInstanceDataSource selectedData, SourceMethod sourceMethod) {
        HashSet<String> knownFieldNames = new HashSet<String>();
        JavaClass srcOwingClass = sourceMethod.getOwningClass();
        SourceClass srcSourceClass = (SourceClass)srcOwingClass.getSourceElement();
        Collection srcFields = srcSourceClass.getFields();
        for (JavaField javaField : srcFields) {
            String fieldName = javaField.getName();
            knownFieldNames.add(fieldName);
        }
        SrcMethodVisitor srcMethodVisitor = new SrcMethodVisitor(selectedData, srcSourceClass, knownFieldNames);
        srcMethodVisitor.visit((SourceElement)sourceMethod.getBlock());
        return srcMethodVisitor;
    }

    static String ra$OPR_TITLE() {
        return OPR_TITLE;
    }

    static final class 1
    extends Visitor {
        protected void whenEnterAssignmentExpression(SourceAssignmentExpression sourceAssignmentExpression) {
            int elementKind;
            JavaHasType resolvedObject;
            boolean isOk = false;
            SourceExpression firstOperand = sourceAssignmentExpression.getFirstOperand();
            if (firstOperand != null && (resolvedObject = firstOperand.getResolvedObject()) != null && (elementKind = resolvedObject.getElementKind()) != 5) {
                isOk = true;
            }
            if (!isOk) {
                this.cancel();
            }
        }

        protected void whenEnterUnaryExpression(SourceUnaryExpression sourceUnaryExpression) {
            int operatorCode = sourceUnaryExpression.getOperatorCode();
            switch (operatorCode) {
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    this.cancel();
                }
            }
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            this.cancel();
        }
    }

    static class 1MyRunnable
    implements Runnable {
        ProgressBar _progressBar;
        final MultiMap _sourceInvokeExpressions;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ SourceMethod v$sourceMethod;

        private void $init$() {
            this._sourceInvokeExpressions = new MultiMap();
        }

        public 1MyRunnable(Component parent, Context context, SourceMethod sourceMethod) {
            this.v$sourceMethod = sourceMethod;
            this.v$context = context;
            this.$init$();
            this._progressBar = new ProgressBar(parent, MoveInstanceMemberController.ra$OPR_TITLE(), (Runnable)this, false);
        }

        public MultiMap start() {
            this._progressBar.start(RefactoringArb.getString(255), "");
            return this._sourceInvokeExpressions;
        }

        public void run() {
            Project definingProject = Util.getDefiningProject(this.v$context, this.v$sourceMethod.getOwningSourceFile().getURL());
            HashSet dependentProjects = Util.getDependentProjects(this.v$context.getWorkspace(), definingProject);
            int progress = 0;
            int totalProgress = dependentProjects.size();
            for (Project project : dependentProjects) {
                this._progressBar.updateProgress(100 * progress++ / totalProgress, RefactoringArb.getString(223), project.getShortLabel());
                List thisInvokeExpressions = this._sourceInvokeExpressions.getOrCreate((Object)project);
                FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)this.v$sourceMethod);
                findMemberUsages.findMemberUsages(project, new FindMemberUsages.FillListsUsageListener(null, thisInvokeExpressions, null));
            }
            this._progressBar.setDoneStatus();
        }
    }

    static class SrcMethodVisitor
    extends Visitor {
        private final MoveInstanceDataSource _selectedData;
        private SourceClass _sourceClass;
        private final HashSet _knownFieldNames;
        private final ArrayList _lhsMethodCallWithParam;
        private final ArrayList _newInnerClass;
        private final ArrayList _classRefMethod;
        private final ArrayList _classRefInner;
        private final ArrayList _unrefMethodCall;
        private final ArrayList _unrefDotExpr;
        private final ArrayList _replaceWithParam;
        private final ArrayList _replaceWithThis;
        private final ArrayList _dotExpressWithParam;

        private void $init$() {
            this._lhsMethodCallWithParam = new ArrayList();
            this._newInnerClass = new ArrayList();
            this._classRefMethod = new ArrayList();
            this._classRefInner = new ArrayList();
            this._unrefMethodCall = new ArrayList();
            this._unrefDotExpr = new ArrayList();
            this._replaceWithParam = new ArrayList();
            this._replaceWithThis = new ArrayList();
            this._dotExpressWithParam = new ArrayList();
        }

        public SrcMethodVisitor(MoveInstanceDataSource selectedData, SourceClass srcSourceClass, HashSet knownFieldNames) {
            this.$init$();
            this._selectedData = selectedData;
            this._sourceClass = srcSourceClass;
            this._knownFieldNames = knownFieldNames;
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            SourceExpression lhsOperand = sourceMethodCallExpression.getLhsOperand();
            if (lhsOperand == null || "this".equals(lhsOperand.getText())) {
                boolean isStatic;
                JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                boolean bl = isStatic = resolvedMethod == null || resolvedMethod.isStatic();
                if (isStatic) {
                    this._classRefMethod.add(sourceMethodCallExpression);
                } else {
                    this._lhsMethodCallWithParam.add(sourceMethodCallExpression);
                }
            } else if (this._selectedData.matches(lhsOperand)) {
                this._unrefMethodCall.add(lhsOperand);
                this.visitChildren((SourceElement)sourceMethodCallExpression.getArgumentList());
                this.skipChildren();
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
            JavaClass ctorOwningOwningClass;
            JavaClass ctorClass;
            JavaMethod resolvedMethod;
            SourceExpression lhsOperand = sourceClassCreatorExpression.getLhsOperand();
            if ((lhsOperand == null || "this".equals(lhsOperand.getText())) && (resolvedMethod = sourceClassCreatorExpression.getResolvedMethod()) != null && (ctorClass = resolvedMethod.getOwningClass()) != null && (ctorOwningOwningClass = ctorClass.getOwningClass()) != null && this._sourceClass.equals((Object)ctorOwningOwningClass) && !ctorClass.isStatic()) {
                SourceListExpression argumentList = sourceClassCreatorExpression.getArgumentList();
                this.visitChildren((SourceElement)argumentList);
                this.skipChildren();
                this._newInnerClass.add(sourceClassCreatorExpression);
            }
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            SourceExpression lhsOperand = sourceDotExpression.getLhsOperand();
            if (this._selectedData.matches(lhsOperand)) {
                this._unrefDotExpr.add(sourceDotExpression);
                this.skipChildren();
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            String expressionName = sourceSimpleNameExpression.getName();
            if ("this".equals(expressionName)) {
                this._replaceWithParam.add(sourceSimpleNameExpression);
            } else if (this._knownFieldNames.contains(expressionName)) {
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                switch (resolvedObject.getElementKind()) {
                    case 5: {
                        if (this._selectedData.equals(resolvedObject)) {
                            this._replaceWithThis.add(sourceSimpleNameExpression);
                            break;
                        }
                        this._dotExpressWithParam.add(sourceSimpleNameExpression);
                        break;
                    }
                }
            } else if (this._selectedData.matches((SourceExpression)sourceSimpleNameExpression)) {
                this._replaceWithThis.add(sourceSimpleNameExpression);
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceType) {
            JavaType resolvedType = sourceType.getResolvedType();
            if (resolvedType != null) {
                boolean needsFq = false;
                JavaClass closestClass = resolvedType.getTypeErasure();
                while (closestClass != null && !needsFq) {
                    if (this._sourceClass.equals((Object)closestClass)) {
                        needsFq = true;
                    }
                    closestClass = closestClass.getOwningClass();
                }
                if (needsFq) {
                    this._classRefInner.add(new Object[]{sourceType, resolvedType.getQualifiedName()});
                }
            }
        }

        public ArrayList getDotExpressWithParam() {
            return this._dotExpressWithParam;
        }

        public ArrayList getLhsMethodCallWithParam() {
            return this._lhsMethodCallWithParam;
        }

        public ArrayList getNewInnerClass() {
            return this._newInnerClass;
        }

        public ArrayList getClassRefMethod() {
            return this._classRefMethod;
        }

        public ArrayList getClassRefInner() {
            return this._classRefInner;
        }

        public ArrayList getReplaceWithParam() {
            return this._replaceWithParam;
        }

        public ArrayList getReplaceWithThis() {
            return this._replaceWithThis;
        }

        public ArrayList getUnrefDotExpr() {
            return this._unrefDotExpr;
        }

        public ArrayList getUnrefMethodCall() {
            return this._unrefMethodCall;
        }

        public boolean needsAdditionalParam() {
            return !this._dotExpressWithParam.isEmpty() || !this._lhsMethodCallWithParam.isEmpty() || !this._newInnerClass.isEmpty() || !this._replaceWithParam.isEmpty();
        }
    }
}

