/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controls.RadioKeyController;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceDataSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceFieldSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberController;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMethodSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceParamSource;
import oracle.jdevimpl.refactoring.util.JotTreeCellRenderer;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MoveInstanceMemberDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MOVE_MEMBER_PREFS";
    private JTextField _paramName;
    private JRadioButton _radioUseDelegate;
    private JTree _targets;
    private JTextField _methodName;
    private SourceMethod _sourceMethod;
    private DefaultMutableTreeNode _root;
    private TreePath _lastSelectedPath;
    private boolean _needsParam;

    public MoveInstanceMemberDialog(Context context, List dataSources, String defaultParamName, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        this.init(dataSources, defaultParamName);
    }

    private void init(List dataSources, String defaultParamName) {
        this._root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode firstNode = null;
        int i = 0;
        while (i < dataSources.size()) {
            JavaHasType javaHasType = (JavaHasType)dataSources.get(i);
            DefaultMutableTreeNode node = this.addNode(javaHasType);
            if (firstNode == null) {
                firstNode = node;
            }
            ++i;
        }
        JLabel fieldLabel = new JLabel();
        this._targets = new JTree(this._root);
        this._targets.setCellRenderer(new JotTreeCellRenderer());
        this._targets.setRootVisible(false);
        IdeUtil.expandAllTreeRows((JTree)this._targets);
        ResourceUtils.resLabel((JLabel)fieldLabel, (Component)this._targets, (String)RefactoringArb.getString(366));
        JScrollPane targetsSp = new JScrollPane(this._targets);
        this.updateOnSelectionChange(this._targets);
        JLabel methodLabel = new JLabel();
        this._methodName = new JTextField(30);
        ResourceUtils.resLabel((JLabel)methodLabel, (Component)this._methodName, (String)RefactoringArb.getString(117));
        this.updateOnChanges(this._methodName);
        JLabel paramNameLabel = new JLabel();
        this._paramName = new JTextField();
        ResourceUtils.resLabel((JLabel)paramNameLabel, (Component)this._paramName, (String)RefactoringArb.getString(38));
        this.updateOnChanges(this._paramName);
        this._radioUseDelegate = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._radioUseDelegate, (String)RefactoringArb.getString(181));
        JRadioButton radioReplace = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)radioReplace, (String)RefactoringArb.getString(182));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._radioUseDelegate);
        buttonGroup.add(radioReplace);
        RadioKeyController.attach((ButtonGroup)buttonGroup);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(303)));
        box.add(this._radioUseDelegate);
        box.add(radioReplace);
        JLabel message = new JLabel();
        message.setPreferredSize(paramNameLabel.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)fieldLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)targetsSp, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)methodLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._methodName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)paramNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._paramName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)box, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (firstNode != null) {
            Object[] path = firstNode.getPath();
            this._targets.setSelectionPath(new TreePath(path));
        }
        this._methodName.setText(this._sourceMethod.getName());
        this._paramName.setText(defaultParamName);
        this._radioUseDelegate.setSelected(true);
    }

    private DefaultMutableTreeNode addNode(JavaHasType javaHasType) {
        JavaType resolvedType = javaHasType.getResolvedType();
        JavaClass javaClass = resolvedType.getTypeErasure();
        DefaultMutableTreeNode parentNode = null;
        Enumeration<TreeNode> children = this._root.children();
        while (parentNode == null && children.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)children.nextElement();
            if (!javaClass.equals(treeNode.getUserObject())) continue;
            parentNode = treeNode;
        }
        if (parentNode == null) {
            parentNode = new DefaultMutableTreeNode(javaClass);
            this._root.add(parentNode);
        }
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(javaHasType);
        parentNode.add(childNode);
        return childNode;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._targets;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dchangemethodreplace_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(98);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            boolean isWarning = true;
            String message = null;
            boolean isValidParamName = false;
            if (this._paramName.isEnabled()) {
                String paramName = this._paramName.getText();
                if (paramName.length() != 0 && NamingUtil.isJavaIdentifier((String)paramName)) {
                    isValidParamName = true;
                }
            } else {
                isValidParamName = true;
            }
            if (!isValidParamName) {
                message = RefactoringArb.getString(63);
                isWarning = false;
            } else {
                TreePath selectionPath = this._targets.getSelectionPath();
                if (selectionPath == null || selectionPath.getPathCount() <= 2) {
                    message = null;
                    isWarning = false;
                } else {
                    String targetMethodName;
                    JavaType resolvedType;
                    Collection methods;
                    MoveInstanceDataSource selectedData = this.getSelectedData();
                    if (!selectionPath.equals(this._lastSelectedPath)) {
                        this._lastSelectedPath = selectionPath;
                        MoveInstanceMemberController.SrcMethodVisitor references = MoveInstanceMemberController.getReferences(selectedData, this._sourceMethod);
                        this._needsParam = references.needsAdditionalParam();
                        this._paramName.setEnabled(this._needsParam);
                    }
                    NameValidation nameValidation = NameValidation.validateMethodName(this.getMethodName(), false);
                    message = nameValidation.getMessage();
                    isWarning = nameValidation.isValid();
                    if (message == null && !(methods = (resolvedType = selectedData.getJavaType()).getMethods(targetMethodName = this.getMethodName())).isEmpty()) {
                        JavaType[] targetParamTypes;
                        JavaMethod existingTargetMethod;
                        ArrayList<JavaType> paramTypes = new ArrayList<JavaType>(Arrays.asList(this._sourceMethod.getParameterTypes()));
                        Object selectedUserObject = this.getSelectedUserObject();
                        if (selectedUserObject instanceof SourceLocalVariable || selectedUserObject instanceof SourceFormalParameter) {
                            SourceVariable param = (SourceVariable)selectedUserObject;
                            SourceElement parent = param.getParent();
                            int paramPos = parent.getChildren().indexOf(param);
                            paramTypes.remove(paramPos);
                        }
                        if (this._needsParam) {
                            JavaClass owningClass = this._sourceMethod.getOwningClass();
                            paramTypes.add((JavaType)owningClass);
                        }
                        if ((existingTargetMethod = resolvedType.getMethod(targetMethodName, targetParamTypes = paramTypes.toArray(new JavaType[paramTypes.size()]))) != null) {
                            isWarning = false;
                            message = MessageFormat.format(RefactoringArb.getString(307), resolvedType.getName());
                        }
                    }
                }
            }
            this.setMessage(message, isWarning);
            this.setOKButtonEnabled(isWarning);
        }
    }

    public String getMethodName() {
        return this._methodName.getText();
    }

    public String getParamName() {
        return this._paramName.getText();
    }

    public MoveInstanceDataSource getSelectedData() {
        MoveInstanceDataSource ret = null;
        Object userObject = this.getSelectedUserObject();
        if (userObject instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)userObject;
            ret = new MoveInstanceMethodSource(javaMethod);
        } else if (userObject instanceof SourceLocalVariable || userObject instanceof SourceFormalParameter) {
            SourceVariable sourceLocalVariable = (SourceVariable)userObject;
            ret = new MoveInstanceParamSource(sourceLocalVariable);
        } else if (userObject instanceof JavaField) {
            JavaField javaField = (JavaField)userObject;
            ret = new MoveInstanceFieldSource(javaField);
        }
        return ret;
    }

    private Object getSelectedUserObject() {
        TreePath selectionPath = this._targets.getSelectionPath();
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object userObject = lastPathComponent.getUserObject();
        return userObject;
    }

    public boolean isUseDelegate() {
        return this._radioUseDelegate.isSelected();
    }
}

