/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.movestatic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.controls.classpick.Filter;
import oracle.jdeveloper.controls.classpick.TextFieldAdapter;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberDialog;

public class MoveStaticDialog
extends MoveMemberDialog
implements Filter {
    public static final String PREFERENCE_KEY = "MOVE_STAT_PREF_KEY";
    private JTextField _targetClassField;

    public MoveStaticDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
        this.init();
    }

    public boolean init() {
        this.setPreferredSize(new Dimension(420, 240));
        JComponent targetComponent = this.createTargetComponent();
        JLabel targetLabel = null;
        if (targetComponent != null) {
            targetLabel = new JLabel();
            JComponent focusableComponent = GraphicsUtils.getFocusableComponentOrChild((Component)targetComponent, (boolean)true);
            ResourceUtils.resLabel((JLabel)targetLabel, (Component)focusableComponent, (String)RefactoringArb.getString(344));
        }
        this._members = this.createTable();
        JScrollPane scrollPane = new JScrollPane(this._members);
        scrollPane.getViewport().setBackground(this._members.getBackground());
        JLabel membersLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)membersLabel, (Component)this._members, (String)RefactoringArb.getString(175));
        Insets insets = new Insets(2, 2, 2, 2);
        if (targetComponent != null) {
            this.add((Component)targetLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)targetComponent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        }
        this.add((Component)membersLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        return true;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmovemembers_html";
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(287);
    }

    protected JComponent createTargetComponent() {
        1MyListeners myListeners = new 1MyListeners();
        this._targetClassField = new JTextField();
        this.updateOnChanges(this._targetClassField);
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(myListeners);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this._targetClassField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        panel.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        TextFieldAdapter textFieldAdapter = ClassPickerFactory.attach(this._targetClassField, this.getContext(), 26);
        textFieldAdapter.setFilter(this);
        return panel;
    }

    protected boolean canClose() {
        SourceClass targetClass = this.getTargetClass();
        return this.confirmCanProceedWithExistingMembers((JavaClass)targetClass);
    }

    protected JTable createTable() {
        JTable table = super.createTable();
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(2);
        table.removeColumn(column);
        return table;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._targetClassField;
    }

    SourceClass getTargetClass() {
        JavaProvider provider = this.getProvider();
        String targetClassName = this.getTargetClassName();
        SourceClass targetClass = provider.getSourceClass(targetClassName);
        return targetClass;
    }

    public String getTargetClassName() {
        return this._targetClassField.getText();
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        return this.calculateDownDependencies(sourceClass);
    }

    protected void updateOKButton() {
        SourceClass targetClass;
        boolean canOk = false;
        if (this.hasSelection() && (targetClass = this.getTargetClass()) != null && this.getSourceSourceClass() != targetClass) {
            canOk = true;
        }
        this.setOKButtonEnabled(canOk);
    }

    private JavaProvider getProvider() {
        SourceClass sourceClass = this.getSourceSourceClass();
        SourceFile owningFile = sourceClass.getOwningSourceFile();
        JavaProvider provider = owningFile.getProvider();
        return provider;
    }

    private void whenBrowse() {
        SourceClass sourceClass;
        String oldPkg;
        1 filter;
        Project project = this.getContext().getProject();
        String[] targetClassName = ClassPackageBrowserV2.browseClassOrPackage(this, project, 2, 0, false, filter = new 1(), new String[]{oldPkg = (sourceClass = this.getSourceSourceClass()).getPackageName()});
        if (targetClassName != null && targetClassName.length == 1) {
            String fqName = targetClassName[0];
            JavaProvider javaProvider = sourceClass.getOwningSourceFile().getProvider();
            SourceClass targetClass = javaProvider.getSourceClass(fqName);
            if (targetClass != null) {
                this._targetClassField.setText(fqName);
            }
        }
    }

    protected Collection getMoveableFields() {
        SourceClass sourceClass = this.getSourceSourceClass();
        Collection declaredFields = sourceClass.getDeclaredFields();
        ArrayList<SourceFieldVariable> ret = new ArrayList<SourceFieldVariable>(declaredFields.size());
        for (SourceFieldVariable sourceFieldVariable : declaredFields) {
            if (!sourceFieldVariable.isStatic()) continue;
            ret.add(sourceFieldVariable);
        }
        return ret;
    }

    protected Collection getMoveableMethods() {
        ArrayList<SourceMethod> ret = new ArrayList<SourceMethod>();
        List sourceMethods = this.getSourceSourceClass().getSourceMethods();
        int i = 0;
        while (i < sourceMethods.size()) {
            SourceMethod sourceMethod = (SourceMethod)sourceMethods.get(i);
            if (sourceMethod.isStatic()) {
                ret.add(sourceMethod);
            }
            ++i;
        }
        return ret;
    }

    protected Collection getMoveableInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public boolean acceptPackageName(String packageName) {
        return true;
    }

    public boolean acceptClassName(String packageName, String className) {
        if (packageName.length() > 0) {
            className = packageName + '.' + className;
        }
        SourceClass sourceClass = this.getProvider().getSourceClass(className);
        return !this.getSourceSourceClass().equals((Object)sourceClass);
    }

    static void mav$whenBrowse(MoveStaticDialog moveStaticDialog) {
        moveStaticDialog.whenBrowse();
    }

    class 1MyListeners
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MoveStaticDialog.mav$whenBrowse(MoveStaticDialog.this);
        }

        1MyListeners() {
        }
    }

    final class 1
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String pkg) {
            return true;
        }

        public boolean acceptClass(JavaClass cls) {
            String sourceClassName = MoveStaticDialog.this.getSourceSourceClass().getQualifiedName();
            String targetClassName = cls.getName();
            return !targetClassName.equals(sourceClassName);
        }
    }
}

