/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.movestatic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.movestatic.MoveStaticDialog;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class MoveStaticOperation {
    private static final int NEEDS_PUBLIC = 1;
    private static final int NEEDS_PROTECTED = 2;
    private static final int NEEDS_PPRIVATE = 4;
    private HashMap _memberAccessNeeds;
    private ArrayList _methodCalls;
    private ArrayList _fieldAccesses;
    private static final boolean HAS_BUG_NEEDS_SAVEPOINT_FOR_MODIFIERS = true;

    private void $init$() {
        this._memberAccessNeeds = new HashMap();
    }

    public void whenMoveMembers(Context context, SourceMember sourceMember) {
        SourceClass sourceClass = sourceMember.getEnclosingClass();
        MoveStaticDialog moveStaticDialog = new MoveStaticDialog(context, sourceClass);
        moveStaticDialog.preselectMember(sourceMember);
        if (moveStaticDialog.runDialog()) {
            SourceClass targetClass = moveStaticDialog.getTargetClass();
            SourceClassBody targetSourceClassBody = targetClass.getSourceBody();
            SourceFieldVariable[] pulledFields = moveStaticDialog.getPulledFields();
            MoveMemberMethodEntry[] pulledMethodEntries = moveStaticDialog.getPulledMethodEntries();
            this.populateCallers(context.getProject(), pulledFields, pulledMethodEntries);
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                SourceTransaction sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)targetClass);
                this.adaptCallers(refactoringCommandSupport, targetClass);
                this.moveFields(targetSourceClassBody, pulledFields);
                this.moveMethods(sourceTransaction, targetSourceClassBody, pulledMethodEntries);
                refactoringCommandSupport.commit(context, RefactoringArb.getString(287));
            }
            catch (Exception e) {
                e.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
    }

    private void populateCallers(Project project, SourceFieldVariable[] pulledFields, MoveMemberMethodEntry[] pulledMethodEntries) {
        ArrayList<Object> members = new ArrayList<Object>(pulledFields.length + pulledMethodEntries.length);
        members.addAll(Arrays.asList(pulledFields));
        int i = 0;
        while (i < pulledMethodEntries.length) {
            MoveMemberMethodEntry pulledMethodEntry = pulledMethodEntries[i];
            SourceMethod sourceMethod = pulledMethodEntry.getMethod();
            members.add(sourceMethod);
            ++i;
        }
        SourceMember[] sourceMembers = members.toArray(new SourceMember[members.size()]);
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember[])sourceMembers);
        this._methodCalls = new ArrayList();
        this._fieldAccesses = new ArrayList();
        FindMemberUsages.FillListsUsageListener usageListener = new FindMemberUsages.FillListsUsageListener(null, this._methodCalls, this._fieldAccesses);
        findMemberUsages.findMemberUsages(project, usageListener);
    }

    private void moveMethods(SourceTransaction sourceTransaction, SourceClassBody targetSourceClassBody, MoveMemberMethodEntry[] pulledMethodEntries) {
        SourceFile targetSourceFile = targetSourceClassBody.getOwningSourceFile();
        int i = 0;
        while (i < pulledMethodEntries.length) {
            MoveMemberMethodEntry pulledMethodEntry = pulledMethodEntries[i];
            SourceMethod pulledMethod = pulledMethodEntry.getMethod();
            int fixedModifiers = this.getFixedModifiers((SourceMember)pulledMethod);
            SourceMethod clonedSourceMethod = (SourceMethod)pulledMethod.cloneSelf(targetSourceFile);
            clonedSourceMethod.addSelf((SourceElement)targetSourceClassBody);
            pulledMethod.removeSelf();
            sourceTransaction.savepoint();
            clonedSourceMethod.setModifiers(fixedModifiers);
            ++i;
        }
    }

    private void moveFields(SourceClassBody targetSourceClassBody, SourceFieldVariable[] pulledFields) {
        SourceFile targetSourceFile = targetSourceClassBody.getOwningSourceFile();
        int i = 0;
        while (i < pulledFields.length) {
            SourceFieldVariable pulledField = pulledFields[i];
            int fixedModifiers = this.getFixedModifiers((SourceMember)pulledField);
            SourceTypeReference clonedSourceType = (SourceTypeReference)pulledField.getSourceType().cloneSelf(targetSourceFile);
            SourceExpression initializer = pulledField.getInitializer();
            SourceExpression clonedInitializer = initializer == null ? null : (SourceExpression)initializer.cloneSelf(targetSourceFile);
            String fieldName = pulledField.getName();
            SourceFactory factory = targetSourceFile.getFactory();
            SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(fixedModifiers, clonedSourceType, fieldName, clonedInitializer);
            fieldDeclaration.addSelf((SourceElement)targetSourceClassBody);
            pulledField.removeSelf();
            ++i;
        }
    }

    private void adaptCallers(RefactoringCommandSupport refactoringCommandSupport, SourceClass targetClass) {
        int i = 0;
        while (i < this._methodCalls.size()) {
            SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)this._methodCalls.get(i);
            SourceFile owningSourceFile = sourceInvokeExpression.getOwningSourceFile();
            refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
            SourceFactory factory = owningSourceFile.getFactory();
            JavaMethod resolvedMethod = sourceInvokeExpression.getResolvedMethod();
            SourceClass invokingClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceInvokeExpression);
            boolean isInherited = targetClass.isAssignableFrom((JavaType)invokingClass);
            boolean isSamePackage = targetClass.getPackageName().equals(invokingClass.getPackageName());
            this.addMemberAccessNeeds((JavaMember)resolvedMethod, isInherited, isSamePackage);
            SourceExpression lhsOperand = sourceInvokeExpression.getLhsOperand();
            if (lhsOperand == null) {
                if (!isInherited) {
                    SourceExpression newLhs = factory.createExpression(targetClass.getQualifiedName());
                    sourceInvokeExpression.setLhsOperand(newLhs);
                }
            } else if (isInherited) {
                lhsOperand.removeSelf();
            } else {
                lhsOperand.removeSelf();
                SourceExpression newLhs = factory.createExpression(targetClass.getQualifiedName());
                sourceInvokeExpression.setLhsOperand(newLhs);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._fieldAccesses.size()) {
            SourceExpression sourceExpression = (SourceExpression)this._fieldAccesses.get(i2);
            SourceClass invokingClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression);
            boolean isInherited = targetClass.isAssignableFrom((JavaType)invokingClass);
            boolean isSamePackage = targetClass.getPackageName().equals(invokingClass.getPackageName());
            this.addMemberAccessNeeds((JavaMember)sourceExpression.getResolvedObject(), isInherited, isSamePackage);
            SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
            refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
            SourceFactory factory = owningSourceFile.getFactory();
            switch (sourceExpression.getSymbolKind()) {
                case 57: {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression;
                    if (isInherited) break;
                    String expressionText = targetClass.getQualifiedName() + '.' + sourceSimpleNameExpression.getName();
                    SourceExpression newLhs = factory.createExpression(expressionText);
                    sourceSimpleNameExpression.replaceSelf((SourceElement)newLhs);
                    break;
                }
                case 49: {
                    SourceDotExpression dotExpression = (SourceDotExpression)sourceExpression;
                    SourceExpression lhsOperand = dotExpression.getLhsOperand();
                    if (lhsOperand == null) break;
                    if (isInherited) {
                        SourceSimpleNameExpression newLhs = factory.createSimpleNameExpression(dotExpression.getName());
                        dotExpression.replaceSelf((SourceElement)newLhs);
                        break;
                    }
                    String expressionText = targetClass.getQualifiedName() + '.' + dotExpression.getName();
                    SourceExpression newLhs = factory.createExpression(expressionText);
                    dotExpression.replaceSelf((SourceElement)newLhs);
                    break;
                }
            }
            ++i2;
        }
    }

    private int getFixedModifiers(SourceMember sourceMember) {
        int modifiers = sourceMember.getModifiers();
        Integer integer = (Integer)this._memberAccessNeeds.get(sourceMember);
        if (integer != null) {
            int needs = integer;
            if (!sourceMember.isPublic()) {
                if (BitField.isSet((int)needs, (int)1)) {
                    modifiers = BitField.unset((int)modifiers, (int)6);
                    modifiers = BitField.set((int)modifiers, (int)1);
                } else if (BitField.isSet((int)needs, (int)2)) {
                    if (!sourceMember.isProtected()) {
                        modifiers = BitField.unset((int)modifiers, (int)3);
                        modifiers = BitField.set((int)modifiers, (int)4);
                    }
                } else if (BitField.isSet((int)needs, (int)4) && !sourceMember.isProtected()) {
                    modifiers = BitField.unset((int)modifiers, (int)7);
                }
            }
        }
        return modifiers;
    }

    private void addMemberAccessNeeds(JavaMember member, boolean isInherited, boolean isSamePackage) {
        int needs = !isInherited ? (isSamePackage ? 4 : 1) : 2;
        Integer integer = (Integer)this._memberAccessNeeds.get(member);
        int wasNeeds = integer != null ? integer : 0;
        this._memberAccessNeeds.put(member, new Integer(wasNeeds | needs));
    }

    public MoveStaticOperation() {
        this.$init$();
    }
}

