/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pullup;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpDialog;
import oracle.jdevimpl.refactoring.util.Visitor;

public class PullUpController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = PullUpController.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        PullUpController.handle(context, true);
        return true;
    }

    public static boolean canPullUp(SourceClass sourceClass) {
        return PullUpController.canPullUp(null, sourceClass, false);
    }

    private static boolean handle(Context context, boolean doit) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            if (sourceClass != null) {
                canHandle = PullUpController.canPullUp(context, sourceClass, doit);
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                        canHandle = PullUpController.canPullUp(context, sourceSourceClass, doit);
                    }
                }
            }
        }
        return canHandle;
    }

    private static boolean canPullUp(Context context, SourceClass sourceClass, boolean doit) {
        boolean ret = false;
        SourceFile containingSourceFile = sourceClass.getOwningSourceFile();
        URL url = containingSourceFile.getURL();
        if (Util.canRefactor(url) && (sourceClass.getSourceSuperclass() != null || !sourceClass.getSourceInterfaces().isEmpty())) {
            ret = true;
            if (doit) {
                ArrayList possibleTargets = PullUpController.getPossibleTargets(context, sourceClass);
                if (!possibleTargets.isEmpty()) {
                    if (PullUpController.hasMembersToMove(sourceClass)) {
                        SourceMember preselectMember = PullUpController.getEnclosingMember(context);
                        PullUpController.whenPullUp(context, sourceClass, preselectMember);
                    } else {
                        Util.showRefactoringErrorMessage(RefactoringArb.getString(42), RefactoringArb.getString(161));
                    }
                } else {
                    Util.showRefactoringErrorMessage(RefactoringArb.getString(42), RefactoringArb.getString(313));
                }
            }
        }
        return ret;
    }

    public static void whenPullUp(Context context, SourceClass srcSourceClass, SourceMember preselectMember) {
        PullUpDialog pullUpDialog = new PullUpDialog(context, srcSourceClass);
        if (pullUpDialog.init()) {
            pullUpDialog.preselectMember(preselectMember);
            if (pullUpDialog.runDialog()) {
                try {
                    PullUpController.whenPullUp(context, srcSourceClass, pullUpDialog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static SourceMember getEnclosingMember(Context context) {
        SourceMember sourceMember = null;
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            int caretPosition = codeEditor.getCaretPosition();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            Node node = context.getNode();
            URL url = node.getURL();
            SourceFile sourceFile = javaManager.getSourceFile(url);
            1 visitor = new 1(caretPosition);
            visitor.visit((SourceElement)sourceFile);
            Object userData = visitor.getUserData();
            if (userData != null) {
                sourceMember = (SourceMember)userData;
            }
        } else {
            ElementAt elementAt = ElementAt.findElementAt(context);
            switch (elementAt.getElementType()) {
                case 3: 
                case 4: {
                    sourceMember = (SourceMember)elementAt.getSourceElement();
                    break;
                }
            }
        }
        return sourceMember;
    }

    private static void whenPullUp(Context context, SourceClass srcSourceClass, PullUpDialog pullUpDialog) {
        SourceClass targetSourceClass = pullUpDialog.getTarget();
        SourceFile targetSourceFile = targetSourceClass.getOwningSourceFile();
        MoveMemberMethodEntry[] methodEntries = pullUpDialog.getPulledMethodEntries();
        SourceFieldVariable[] fields = pullUpDialog.getPulledFields();
        ArrayList existingSuperMembers = pullUpDialog.getExistingSuperMembers();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.beginTransaction((SourceElement)targetSourceClass);
        try {
            SourceClassBody targetBody = targetSourceClass.getSourceBody();
            boolean targetIsInterface = targetSourceClass.isInterface();
            boolean isTargetAbstract = false;
            int i = 0;
            while (i < methodEntries.length) {
                SourceBlock sourceBlock;
                MoveMemberMethodEntry methodEntry = methodEntries[i];
                SourceMethod srcMethod = methodEntry.getMethod();
                SourceMethod targetMethod = (SourceMethod)srcMethod.cloneSelf(targetSourceFile);
                if ((targetIsInterface || methodEntry.isAbstract()) && (sourceBlock = targetMethod.getBlock()) != null) {
                    sourceBlock.removeSelf();
                }
                if (!targetIsInterface && methodEntry.isAbstract()) {
                    targetMethod.addModifiers(1024);
                    isTargetAbstract = true;
                }
                if (targetIsInterface) {
                    targetMethod.removeModifiers(1025);
                } else {
                    PullUpController.adaptModifiers(refactoringCommandSupport, (SourceMember)srcMethod, (SourceMember)targetMethod);
                }
                String fullMethodName = Util.getFullMethodName((JavaMethod)srcMethod, false, false, false);
                if (!existingSuperMembers.contains(fullMethodName)) {
                    targetMethod.addSelf((SourceElement)targetBody);
                }
                if (!methodEntry.isAbstract() && !targetIsInterface || pullUpDialog.isUseSuperMembers()) {
                    refactoringCommandSupport.beginTransaction((SourceElement)srcMethod);
                    srcMethod.removeSelf();
                }
                ++i;
            }
            if (isTargetAbstract) {
                targetSourceClass.addModifiers(1024);
            }
            SourceFactory targetFactory = targetSourceFile.getFactory();
            int i2 = 0;
            while (i2 < fields.length) {
                SourceFieldVariable srcField = fields[i2];
                if (existingSuperMembers.contains(srcField.getName())) {
                    refactoringCommandSupport.beginTransaction((SourceElement)srcSourceClass);
                    srcField.removeSelf();
                } else {
                    SourceFieldVariable targetField = (SourceFieldVariable)srcField.cloneSelf(targetSourceFile);
                    PullUpController.adaptModifiers(refactoringCommandSupport, (SourceMember)srcField, (SourceMember)targetField);
                    SourceFieldDeclaration fieldDeclaration = targetFactory.createFieldDeclaration(targetField);
                    fieldDeclaration.addSelf((SourceElement)targetBody);
                    fieldDeclaration.setDocComment((SourceDocComment)srcField.getDocComment().cloneSelf(targetSourceFile));
                    refactoringCommandSupport.beginTransaction((SourceElement)srcSourceClass);
                    srcField.removeSelf();
                }
                ++i2;
            }
            refactoringCommandSupport.commit(context, RefactoringArb.getString(42));
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void adaptModifiers(RefactoringCommandSupport refactoringCommandSupport, SourceMember srcMember, SourceMember targetMember) {
        String targetPackageName;
        String srcPackageName;
        SourceFile srcSourceFile = srcMember.getOwningSourceFile();
        SourceFile targetSourceFile = targetMember.getOwningSourceFile();
        boolean makeProtected = false;
        if (targetMember.isPrivate()) {
            makeProtected = true;
        } else if (targetMember.isPackagePrivate() && !(srcPackageName = srcSourceFile.getPackageName()).equals(targetPackageName = targetSourceFile.getPackageName())) {
            makeProtected = true;
        }
        if (makeProtected) {
            refactoringCommandSupport.beginTransaction((SourceElement)srcMember);
            srcMember.removeModifiers(2);
            srcMember.addModifiers(4);
            targetMember.removeModifiers(2);
            targetMember.addModifiers(4);
        }
    }

    public static boolean hasMembersToMove(SourceClass sourceClass) {
        Collection declaredMethods = sourceClass.getDeclaredMethods();
        if (declaredMethods.size() > 0) {
            return true;
        }
        Collection declaredFields = sourceClass.getDeclaredFields();
        return declaredFields.size() > 0;
    }

    static ArrayList getPossibleTargets(Context context, SourceClass sourceSourceClass) {
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        ArrayList<SourceElement> classes = new ArrayList<SourceElement>();
        ArrayList<JavaType> parents = new ArrayList<JavaType>();
        parents.add(sourceSourceClass.getSuperclass());
        parents.addAll(sourceSourceClass.getInterfaces());
        while (!parents.isEmpty()) {
            SourceElement sourceElement;
            SourceClass sourceClass;
            JavaType javaType = (JavaType)parents.remove(0);
            if (javaType == null) continue;
            parents.add(javaType.getSuperclass());
            parents.addAll(javaType.getInterfaces());
            JavaClass javaClass = javaType.getTypeErasure();
            if (javaClass == null || !PullUpController.isValidTarget(workspace, project, sourceClass = (SourceClass)javaClass.getSourceElement()) || classes.contains(sourceElement = javaClass.getSourceElement())) continue;
            classes.add(sourceElement);
        }
        return classes;
    }

    static boolean isValidTarget(Workspace workspace, Project project, SourceClass sourceClass) {
        boolean ret = false;
        if (sourceClass != null && Util.isClassInSources(workspace, project, sourceClass) && Util.canRefactor((SourceElement)sourceClass)) {
            ret = true;
        }
        return ret;
    }

    static final class 1
    extends Visitor {
        private final /* synthetic */ int v$caretPosition;

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            this.whenEnter((SourceMember)sourceMethod);
        }

        protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
            this.whenEnter((SourceMember)sourceFieldVariable);
        }

        private void whenEnter(SourceMember sourceMember) {
            if (sourceMember.getStartOffset() <= this.v$caretPosition && this.v$caretPosition <= sourceMember.getEndOffset()) {
                this.setUserData(sourceMember);
            }
        }

        protected void whenEnterFieldDeclaration(SourceFieldDeclaration sourceFieldDeclaration) {
            List variables = sourceFieldDeclaration.getVariables();
            if (variables.size() == 1) {
                SourceFieldVariable firstVariable = (SourceFieldVariable)variables.get(0);
                this.whenEnter((SourceMember)firstVariable);
            }
        }

        public 1(int n) {
            this.v$caretPosition = n;
        }
    }
}

